global_settings {
  charset  utf8
}

#declare xm=10;
#declare zm=10;
#declare hauteur=4;          
#declare epais=.5;
#declare li=.3;
#declare dec=2;
#declare grille=0;
#declare support=1;
#declare lum=<xm/2,hauteur*1/2,zm/2>;
#declare g1=seed(1);

#declare cami=camera {location <9.15,.5,2.15> direction z look_at <0,3/4*hauteur,zm>};
#declare camm=camera {location <xm-epais-.1,hauteur/3+.5,epais+.1> direction z look_at <xm*2/6,hauteur/3,zm*4/6>};
#declare camt=camera {location <xm-epais-.1,hauteur/3+.5,epais+.1> direction z*2 look_at <xm*2/6,hauteur/4*3,zm*4/6>};
#declare camh=camera {location <xm-epais-.1,hauteur/2,epais+.1> direction z look_at <xm*2/6,0,zm*4/6>};
#declare came=camera {location <15,35,-15> direction z*4 look_at <xm/2,hauteur/2,zm/2>};
camera {camm} 

light_source {lum rgb <1,1,1> * li *2 }
light_source {<(epais+dec),hauteur-.2,(epais+dec)> rgb <1,1,1> * li }
light_source {<(epais+dec),hauteur-.2,zm-(epais+dec)> rgb <1,1,1> * li }
light_source {<xm-(epais+dec),hauteur-.2,(epais+dec)> rgb <1,1,1> * li }
light_source {<xm-(epais+dec),hauteur-.2,zm-(epais+dec)> rgb <1,1,1> *li }

background {rgb <.8,.8,1>}
#declare Pigmur=pigment {rgbf <1,1,.7,0>}
#declare Pigplafond=pigment {rgbf <3,3,2,0>}
#declare Pigsol=pigment {checker 
    color rgb <.7,.7,1> color rgb <.9,.9,1> scale .2}

box {<0,0,0>,<xm,hauteur,epais> pigment{Pigmur} no_shadow}             // mur sud
box {<0,0,0>,<epais,hauteur,zm> pigment{Pigmur} no_shadow}             // mur ouest
box {<0,0,zm>,<xm,hauteur,zm-epais> pigment{Pigmur} no_shadow}         // mur nord
box {<xm,0,0>,<xm-epais,hauteur,zm> pigment{Pigmur} no_shadow}         // mur sud
box {<0,hauteur,0>,<xm,hauteur+.5,zm> pigment{Pigplafond}  no_shadow}  // plafond
plane {y,0 pigment {Pigsol}}

text {ttf "arial.ttf","Mus\u00E9e JM JuliaMake",.1, 0 pigment {rgb <1,.5,0>} rotate <0,-90,0> scale <.2,.2,.2> translate <epais+.02,hauteur-.3,zm-2.8>}

#if (support=1)
 #declare i=2;
 #declare ra=.05;
 #declare X=1;
 #while (X<xm)
  #declare Z=1;
  #while (Z<zm) 
   box {<0,0,0>,<.5,1,.5> pigment {rgb <1,1,1>} translate <X*.9,0,Z*.9>}
   julia_fractal { <rand(g1)*.5+.5,rand(g1)*.5+.5,rand(g1)*.5+.5,rand(g1)*.5+.05> quaternion sqr 
   max_iteration 4 precision 20 pigment {rgb <rand(g1)*.5+.5,rand(g1)*.5+.5,rand(g1)*.5+.5>}
   rotate <rand(g1)*360,rand(g1)*360,rand(g1)*360>
   scale <.2,.2,.2>
   translate <X*.9+.25,1.2,Z*.9+.25>}
   #declare Z=Z+i;
  #end           
  #declare X=X+i;
 #end
#end




