// Persistence of Vision Ray Tracer Scene Description File
// File: kosciol.pov
// Vers: 3.6
// Desc: Church - museum of faith
// Date: 12/06/04
// Auth: Nunas - Adam Druzd
// povray +Ikosciol.pov +Okosciol.png +W512 +H384  -D +X +A0.3


/*
 === MAPS ===
 
        jezus.jpg 
        jezus_bump.jpg 
        maria.jpg 
        maria_bump.jpg 
        maria_czarna.jpg 
        maria_czarna_bump.jpg 
        krzyz.jpg 
        krzyz_bump.jpg 
        krzyz2.jpg 
        krzyz2_bump.jpg 
        lastsupp.jpg 
        entomb.jpg 
        oltarz_crop.jpg 
        oltarz_bump.jpg 
        
*/

#version 3.5;



#include "colors.inc"
#include "stones.inc"
#include "finish.inc"
#include "glass.inc"
#include "textures.inc"


// different adjustment of light
#declare _swiatlo_=1; // 1 render // 2 radiosity // 3 light on wall // 4 light in middle // 5 -- 3 and 4 // 6 radiosity with light form one side // 7 red light in high altar // 8 like 7 with media // 9 with altar but without radiosity


#declare _podloga_=on; 			// floor
#declare _podest_=on;  			// resting 
#declare _lawki_=on;	  		// pews 
#declare _lawki_boczne_=on; 	        // pew on wall
#declare _okna_=on; 			// windows
#declare _sciany_=on; 			// walls
#declare _kolumny_=on; 			// pillars
#declare _luki_=on;			// arches
#declare _knfesjnal_=on; 		// confessional
#declare _kink_=on;			// brackets
#declare _bua_=on;			// wood wall
#declare _obrazy_=on;			// painting
#declare _zylan_=on;			// lamp in middle
#declare _palmy_=on;			// palms
#declare _drzwi_=on;			// doors
#declare _taber_=on;			// altar

#include "kosciol_materialy.inc"
#include "kosciol_kolumny.inc"
#include "kosciol_luki.inc"
#include "kosciol_podloga.inc"
#include "kosciol_scia_okno.inc"
#include "kosciol_lawki_podest.inc"
#include "kosciol_konfesjonal.inc"
#include "kosciol_elementy.inc"
#include "kosciol_ustawienia.inc"



    


#declare c_na_oltarz_y=camera {
  location  <0.0, 1000, 2750>
  look_at   <0.0, 180, 2750>
  //angle 20
}

#declare c_na_oltarz_xyz=camera {
  location  <.0, 480, 1800>
  look_at   <.0, 280, 2400>
  angle 40
}


#declare c_na_oltarz_z=camera {
  location  <-25.0, 180, 2000>
  look_at   <-25.0, 180, 2400>
  //angle 20
}

#declare c_na_kolumne=camera {
  location  <-800.0, 300, -560>
  look_at   <-800.0, 300,  3000>
  angle 15
}

#declare c_ladna=camera {
  location  <400,       170,-300 >
  look_at   <-940.0,     270,  1645>
  //angle 20
  
}
#declare c_ladna1=camera {
  location  <500,       120,50 >
  look_at   <-940.0,     270,  1645>
  angle 90
  
}

#declare c_z_kon=camera {
  location  <-978, 120, 320>
  look_at   <940.0,     270,  645>
  //angle 90
  
}

#declare c_animacja=camera {
  location  <490.0, 185, -500+clock>
  look_at   <-800.0,800, 2400>
  //angle 30
  
}
#declare c_przez_palme=camera {
  location  <600,300,250>
  look_at   <-940.0,     270,  1645>
  //angle 50
}

#declare c_na_lawki=camera {
  location  <0.0, 150, 0>
  look_at   <-220.0, 50, 50>
  angle 50
}
#declare c_na_oltarz=camera {
  location  <0.0, 1000, 2750>
  look_at   <0.0, 180, 2750>
  //angle 20
}
#declare c_na_okno=camera {
  location  <990.0, 700,500>
  look_at   <-600.0, 700,500>
  //angle 40
}
#declare c_przez_srodek=camera {
  location  <200.0, 160, 0>
  look_at   <-600.0, 400,  3000>
  //angle 20
}
#declare c_przez_srodek1=camera {
  location  <200.0, 160, -300>
  look_at   <-600.0, 400,  3000>
  angle 20
}
#declare c_na_organy=camera {
  location  <0.0, 180, 1500>
  look_at   <0.0, 800, -1000>
  //angle 40
}
#declare c_nawa_lewa=camera {
  location  <-800.0, 150, -560>
  look_at   <-800.0, 1000,  3000>
  //angle 30
}
#declare c_nawa_prawa=camera {
  location  <800.0, 200, -500>
  look_at   <800.0, 600,  3000>
  angle 20
}
#declare c_luk_czer=camera {
  location  <0.0, 200, 0>
  look_at   <-600, 1200,  0>
}
#declare c_luk_ziel=camera {
  location  <0.0, 200, 650>
  look_at   <600, 1200,  650>
}
#declare c_z_gory=camera {
  location  <0.0, 6000, 1000>
  look_at   <0.0, 0,  1000>
  angle 20
}
#declare c_do_gory=camera {
  location  <0.0, 5, 1000>
  look_at   <0.0, 1600,  1000>
  angle 100
}




plane 
{
        y, -1
        pigment { color Gray }
}


camera { c_przez_srodek }
//camera { c_na_oltarz_xyz }
//camera { c_ladna }
//camera { c_przez_palme }
//camera { c_na_kolumne }
//camera { c_animacja }
//camera { c_na_lawki }
//camera { c_na_okno }
//camera { c_przez_srodek }
//camera { c_ladna1 }
//camera { c_na_organy }
//camera { c_nawa_lewa }
//camera { c_nawa_prawa }
//camera { c_luk_czer }
//camera { c_luk_ziel }
//camera { c_z_gory }
//camera { c_do_gory }

