// Persistence of Vision Ray Tracer Scene Description File
// File: museum.pov
// Vers: 3.5
// Desc: Museum
// Date: 11.08.2004
// Auth: D.Rossi

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "museum_textures.inc"
#include "venus-d.inc"             




#declare r1 = seed(0); 
                                 
// ====== RENDERING PARAMETERS                                 
#declare With_Fog = yes;
#declare Ambient_Light = no;         
#declare With_Statues = yes;  
#declare With_Spheres = yes;  
#declare With_Images = yes;          
#declare With_Ballustrades = yes;
#declare With_Mirror = yes;
#declare With_Focal_Blur = no;   
#declare With_Reflection = yes;   
#declare With_Stairs = yes;

// ====== SCENE PARAMETERS
#declare Largeur_Couloirs = 8;
#declare Dimension_Segment_Mur = 5;
#declare Diameter_Central_Min = 15;
#declare Diameter_Central_Max = 18;    
#declare Diameter_Central_Offset = 8;
#declare Hauteur_Etage = 15;                                      
#declare Horizon_H = Diameter_Central_Max+Diameter_Central_Offset+Dimension_Segment_Mur*4;
#declare Diameter_Column = 0.2;
#declare Nbre_Etages_Sup = 8;
#declare Nbre_Etages_Inf = 2;
#declare Horizon_V = (Nbre_Etages_Sup + Nbre_Etages_Inf)* Hauteur_Etage;

#declare Color_Columns = rgb <0.4,0.6,0.7>;
         
         
global_settings {
  #if ( Ambient_Light = yes )
    ambient_light color rgb <1,1,1>
  #end   
}


#declare Jpg_file = array[1000];   
#declare temp="";
#declare cpt = 0;
#fopen MyFile "jpg_files.txt" read
#while (defined(MyFile))
  #read (MyFile,temp)
  #declare Jpg_file[cpt] = temp;
  #declare cpt = cpt + 1;
#end         


#macro Cadre(num)  
  union {
    box {
      0 <1,1,0.01>
      texture {
        pigment {
          image_map {
            jpeg Jpg_file[num] 
            interpolate 2            
          }
        }
        finish {
          ambient 1  
        }            
      } 
    }
    box {<-.1,-.1,.01> <1.1,1.1,.02> pigment { color Black } }              
    difference {
      box {<-.2,-.2,.01> <1.2,1.2,.04> }              
      box {<-.1,-.1,.0> <1.1,1.1,1> }
      texture { Gold_Texture }              
    }
  }  
#end  


// ======== camera =================
camera {
  location  <2.0, 2.0, -12.0>
  look_at   <-5, 9.0, 0.0>
  angle 100
  sky <-1,2,-1>
  #if ( With_Focal_Blur )
    aperture .1         
    blur_samples 4
    focal_point 0
  #end  
}


// =============== lights ==============
#declare L_Lustre1 = 
  light_source {
    0              // light's position (translated below)
    color rgb 0.2   // light's color 
    fade_distance 30
    fade_power 2
  }

#declare cpt = -Nbre_Etages_Inf;
#while ( cpt < Nbre_Etages_Sup )
  light_source { L_Lustre1 translate Hauteur_Etage*y*cpt translate <rand(r1),rand(r1),rand(r1)>}
  light_source { L_Lustre1 translate Hauteur_Etage*y*cpt translate Horizon_H*x translate <rand(r1),rand(r1),rand(r1)>}
  light_source { L_Lustre1 translate Hauteur_Etage*y*cpt translate Horizon_H*x rotate 45*y translate <rand(r1),rand(r1),rand(r1)>}
  light_source { L_Lustre1 translate Hauteur_Etage*y*cpt translate Horizon_H*x rotate 90*y translate <rand(r1),rand(r1),rand(r1)>}
  light_source { L_Lustre1 translate Hauteur_Etage*y*cpt translate Horizon_H*x rotate 135*y translate <rand(r1),rand(r1),rand(r1)>}
  #declare cpt = cpt + 1;
#end
//  light_source { L_Lustre1 translate <5,Hauteur_Etage*0.,0> }




// ============ Fog =======================
#if ( With_Fog )
  fog {
    fog_type 1
    distance Horizon_H*4
    color White * 0.7
  }               
#end              

// ============ Textures ====================

#declare T_Metal = 
  texture { 
    pigment { color  Color_Columns }                    
    finish { 
      metallic      
      #if ( With_Reflection )
        reflection 0.2
      #end  
    }
  }
                    
#declare T_Mur = 
  texture {                                                  
    pigment {
      brick color rgb 0.9,          // color of mortar
          color White            // color of brick
          brick_size <2,1,1>   // size of brick    (optional)
          mortar     0.02       // width of mortar  (optional)
    }                   
    finish {
      ambient 0.3
    }
    normal {
      agate 0.01 scale 10
    }
  }

#declare T_Sol = 
  texture {
    pigment {          // (---surface color---)
      gradient y
      pigment_map {
        [0.2 checker color rgb 1, color rgb 0.5]
        [0.2 color rgb 1]        
      }           
      translate -.1*y
    }
    normal {           // (---surface bumpiness---)
      marble 0.3       // some pattern (and intensity)
      turbulence 0.5   // some turbulence
      scale <1,.4,1>    // transformations
    }
    finish {           // (---surface finish---)
      ambient 0.2 
    }
  }   
  
#declare T_Arche = 
  texture {
    pigment { 
      brick      
      color rgb 0.5,          // color of mortar
      color <0.7,0.5,0.2>            // color of brick
      brick_size <1,.3,1>
      mortar     0.1

    }        
    finish {
      ambient 0.4
    }
  }
#declare Mur =
  difference {
    box { -1 1 scale <Horizon_H,Horizon_V,Horizon_H> }

    // suppression partie centrale
    cylinder { -y*(Horizon_V+1), y*(Horizon_V+1), Diameter_Central_Max}
    
    // Evidements latraux
    #local cpt = -Nbre_Etages_Inf;   
    #while ( cpt < Nbre_Etages_Sup ) 
      cylinder { 
        0, 
        (Hauteur_Etage - Diameter_Central_Offset)*y, 
        Diameter_Central_Max + Diameter_Central_Offset  
        translate Hauteur_Etage*cpt*y
      }
      torus { 
        Diameter_Central_Max, 
        Diameter_Central_Offset 
        translate (Hauteur_Etage*cpt + Diameter_Central_Offset)*y
      }
      #local cpt = cpt + 1;
    #end   

    // suppression couloirs    
    box { <-Largeur_Couloirs, -Horizon_V-1, -Horizon_H-1> <Largeur_Couloirs, Horizon_V+1, Horizon_H+1> }
    box { <-Largeur_Couloirs, -Horizon_V-1, -Horizon_H-1> <Largeur_Couloirs, Horizon_V+1, Horizon_H+1> rotate 90*y}
    box { <-Largeur_Couloirs, -Horizon_V-1, -Horizon_H-1> <Largeur_Couloirs, Horizon_V+1, Horizon_H+1> rotate 45*y}
    box { <-Largeur_Couloirs, -Horizon_V-1, -Horizon_H-1> <Largeur_Couloirs, Horizon_V+1, Horizon_H+1> rotate -45*y}
    
    texture { T_Mur }
  }

// Sol 2
#declare Sol2 = 
  difference {
    box { <-Horizon_H, -.3, -Horizon_H> < Horizon_H,   0,  Horizon_H> }
    cylinder { -y , y , Diameter_Central_Min }          
    difference {
      union {
        box { <Largeur_Couloirs/2,-1,-Horizon_H-1> <-Largeur_Couloirs/2,1, Horizon_H+1>}
        box { <Largeur_Couloirs/2,-1,-Horizon_H-1> <-Largeur_Couloirs/2,1, Horizon_H+1> rotate 45*y}
        box { <Largeur_Couloirs/2,-1,-Horizon_H-1> <-Largeur_Couloirs/2,1, Horizon_H+1> rotate 90*y}
        box { <Largeur_Couloirs/2,-1,-Horizon_H-1> <-Largeur_Couloirs/2,1, Horizon_H+1> rotate 135*y}
      }
      cylinder { -y,y,Diameter_Central_Max }
    }        
    texture { T_Sol }
  }
  
#macro Column1() 
  // Grande column
  union {
    cylinder { 0*y,  Hauteur_Etage*y, Diameter_Column }
    torus { Diameter_Column, 0.2 translate -0.2*y }  
    torus { Diameter_Column, 0.1 translate 0.1*y }  
    torus { Diameter_Column, 0.1 translate Hauteur_Etage*0.8*y }  
    //object {Cadre(num) translate -.5*x scale <1.33,1,1.33> translate 2*y rotate -90*y }
    texture {
      T_Metal
    }
  }                      
#end  
  
#macro Column2() 
  // Petite column pour ballustre
  union {
    cylinder { 0, y, .02 }
    sphere { 0, 0.04 scale <1,0.1,1> translate y}
    texture { T_Metal }
  }              
#end  
                         
// longueur = longueur bustrade de <0,0,0> direction x
// Dfinition d'une ballallustrade 
// espace = espace max entre 2 ballustres
#macro Ballustrade(Longueur,Espace)  
  union {  
    #local n = div(Longueur,Espace) + 1;
    #local vect = Longueur/n ;
    #local cpt = 0;

    #while ( cpt < n )     
      object { Column2()  translate x*cpt*vect}
      #local cpt = cpt + 1;
    #end                                    
    // grillage                       
    cylinder { 0, Longueur*x, 0.1  scale <1,3,1> translate -.15*y }
    cylinder { 0, Longueur*x, 0.01  scale <1,10,1> translate 0.9*y }                
    cylinder { 0, Longueur*x, 0.01  translate 0.65*y }                
    cylinder { 0, Longueur*x, 0.01  translate 0.50*y }                
    cylinder { 0, Longueur*x, 0.01  translate 0.35*y }                
    cylinder { 0, Longueur*x, 0.01  translate 0.20*y }                
    texture { T_Metal }
  }  
#end            

#macro Segment_Mur()                                       
  #local Rayon = (Dimension_Segment_Mur-2)/2;
  union {
    difference {         
      box { <0,0,-0.1> <Dimension_Segment_Mur,Hauteur_Etage, 0> }
      box { <1,0,-0.2> <Dimension_Segment_Mur-1, Hauteur_Etage-1-Rayon, 0.1> }
      cylinder { <Dimension_Segment_Mur/2,Hauteur_Etage-1-Rayon,-0.2>, <Dimension_Segment_Mur/2,Hauteur_Etage-1-Rayon,0.1>, Rayon }     
      translate Largeur_Couloirs*z
      texture { T_Arche }
    }
    #if ( With_Images )                              
      object { Column1() translate <0,0,-Largeur_Couloirs/2> }
      object { Cadre(rand(r1)*100) scale 2 translate <Dimension_Segment_Mur*0.3, 2, -0.1> translate Largeur_Couloirs*z}
      object { Cadre(rand(r1)*100) scale 2 translate <Dimension_Segment_Mur*0.3, 5, -0.1> translate Largeur_Couloirs*z}
      object { Cadre(rand(r1)*100) scale 2 translate <Dimension_Segment_Mur*0.3, 8, -0.1> translate Largeur_Couloirs*z}
    #end    



  }
#end

// ================== STAIR =================
#declare Largeur_Marche = 0.35;
#declare Hauteur_Marche = 0.20;               
#declare Epaisseur_Marche = 0.06;
#macro Marche(P1) 
  union {
    box { <0,0,0> , <2,Epaisseur_Marche,Largeur_Marche> }
    #if ( With_Ballustrades )
      object { Column2() translate <0, 0, Largeur_Marche>}
      object { Column2() translate <2, 0, Largeur_Marche> }
      cylinder { <0, 1, Largeur_Marche>, <0, 1 - P1, 0 >, 0.01}
      cylinder { <2, 1, Largeur_Marche>, <2, 1 - P1, 0 >, 0.01}
    #end  
  }            
#end  
#declare Stair = 
  union {           
    // 1ere marche
    #local Angle = Largeur_Marche/Diameter_Central_Min*360/(2*pi);
    #local Cpt_Stair=0;
    #local Alt = 0;
    
    #while ( Alt < Hauteur_Etage )          
      #if ( Cpt_Stair > 13)                                    
        #local Pente = Hauteur_Marche;                         
      #else
        #local Pente = 0;                         
      #end
    
      object {
        Marche(Pente) 
        translate -Diameter_Central_Min*x 
        translate Alt*y 
        rotate Cpt_Stair*y*Angle   
      }                      
      #local Alt = Alt + Pente;                         
      #local Cpt_Stair = Cpt_Stair + 1;
      
    #end
              
    texture {T_Metal}
  }


#macro Allee()
  union {
    #local cpt = 0;
    #while ( cpt < (Horizon_H-Diameter_Central_Max - Diameter_Central_Offset)/Dimension_Segment_Mur ) 
      object { Segment_Mur()
        translate <Diameter_Central_Max + Diameter_Central_Offset + Dimension_Segment_Mur * cpt, 0, 0>
      }  
      object { Segment_Mur()
        scale <1,1,-1>
        translate <Diameter_Central_Max + Diameter_Central_Offset + Dimension_Segment_Mur * cpt, 0, 0>
      }  
      #local cpt = cpt + 1;
    #end  
    #if ( With_Ballustrades )
      object { Ballustrade(Horizon_H-Diameter_Central_Max,1) 
        translate Diameter_Central_Max*x 
        translate Largeur_Couloirs/2*z    
      }
      object { Ballustrade(Horizon_H-Diameter_Central_Max,1) 
        translate Diameter_Central_Max*x 
        translate -Largeur_Couloirs/2*z    
      }                        
    #end

  }


#end

#macro Statue() 
  object { 
    Venus 
    scale 0.07 
    rotate 90*x 
    rotate 180*z 
    rotate 90*y
    texture { 
      pigment { color rgbt<rand(r1),rand(r1),rand(r1),0.7>  
      }
      finish {
        #if ( With_Reflection )
          reflection 0.4 
        #end  
      }
      
    }  
    interior { ior 1.5
    }
  }            
#end    
      

// ================== ETAGE ====================
#macro Etage() 
  union {                                        
    object {Sol2}
    object { Allee() }  
    object { Allee() rotate 45*y  }  
    object { Allee() rotate 90*y  }
    object { Allee() rotate 135*y }
    object { Allee() rotate 180*y }
    object { Allee() rotate 225*y }                      
    object { Allee() rotate 270*y }
    object { Allee() rotate 315*y }

      
    #if (With_Statues) 
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 22.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 67.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 112.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 157.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 202.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 247.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 292.5*y }              
      object { Statue() translate <-Diameter_Central_Max,1,0> rotate 337.5*y }              
    #end                        
      
    // ====== ballustrade interieure
    #if ( With_Ballustrades )
      // colonnettes
      #local cpt = 0;
      #while ( cpt < 360 ) 
        object { Column2() 
          translate -Diameter_Central_Min*x
          rotate cpt*y
        }
        #local cpt = cpt + 2.5;
      #end
      // grillage                       
      union {                 
        torus { Diameter_Central_Min , 0.1  scale <1,3,1> translate -.15*y }
        torus { Diameter_Central_Min , 0.01  scale <1,10,1> translate 0.9*y }                
        torus { Diameter_Central_Min , 0.01  translate 0.65*y }                
        torus { Diameter_Central_Min , 0.01  translate 0.50*y }                
        torus { Diameter_Central_Min , 0.01  translate 0.35*y }                
        torus { Diameter_Central_Min , 0.01  translate 0.20*y }                
        texture { T_Metal }
      }
            
    #end                 
    
    // colonnade interieure
    #local cpt = 0;
    #while ( cpt < 360 ) 
      object { Column1() 
        translate -Diameter_Central_Min*x
        rotate cpt*y
      }
      #local cpt = cpt + 22.5;
    #end

    // Ballustrade             
    #if ( With_Ballustrades )
      object {            
        Ballustrade(Horizon_H,1)
        rotate 90*y
        translate <-Largeur_Couloirs/2,0,-Diameter_Central_Max>      
      }
    #end                     

    // Stair intrieur     
    #if ( With_Stairs )
      object { Stair rotate 60*y}
      object { Stair rotate 180*y}
      object { Stair rotate 300*y}
    #end
  }            
#end     





#local Cpt_Etage = -Nbre_Etages_Inf;   
union {
  object { Mur }
  #while ( Cpt_Etage <= Nbre_Etages_Sup ) 
    object { Etage() translate Hauteur_Etage*y*Cpt_Etage}
    #local Cpt_Etage = Cpt_Etage + 1;
  #end   
}                                 


             

#macro Sph()
  sphere {0, 1 
    texture {
      pigment {                                       
        #switch ( rand(r1) )                            
          #range( 0, 0.2)
            color rgb <rand(r1),rand(r1),rand(r1)>
          #break
          #range( 0.2, 0.4)
            agate
            color_map {
              [0.00 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.33 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.66 color rgb <rand(r1),rand(r1),rand(r1)>]
              [1.00 color rgb <rand(r1),rand(r1),rand(r1)>]
            }
          #break
          #range( 0.4, 0.6)
            checker 
              color rgb <rand(r1),rand(r1),rand(r1)> ,
              color rgb <rand(r1),rand(r1),rand(r1)>  
              scale 0.2
          #break
          #range( 0.6, 0.7)
            granite
            color_map {
              [0.00 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.33 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.66 color rgb <rand(r1),rand(r1),rand(r1)>]
              [1.00 color rgb <rand(r1),rand(r1),rand(r1)>]
            }
          #break
          #range( 0.7, 0.8)
            wood
            color_map {
              [0.00 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.33 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.66 color rgb <rand(r1),rand(r1),rand(r1)>]
              [1.00 color rgb <rand(r1),rand(r1),rand(r1)>]
            }
          #break
          #range( 0.8, 1)
            bozo           
            color_map {
              [0.00 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.33 color rgb <rand(r1),rand(r1),rand(r1)>]
              [0.66 color rgb <rand(r1),rand(r1),rand(r1)>]
              [1.00 color rgb <rand(r1),rand(r1),rand(r1)>]
            }
          #break
        #end    
        turbulence rand(r1)
      }
      normal {
        #switch ( rand(r1) )                            
          #range( 0, 0.2)
            crackle  3*rand(r1)
          #break
          #range( 0.2, 0.4)
            bumps rand(r1) scale 0.1 + rand(r1)
          #break
          #range( 0.4, 1.0)
            waves 2 scale 0.1 + rand(r1)
          #break
        #end  
        turbulence rand(r1)      
      }                  
      #if ( With_Reflection )
  
        finish {
          #switch ( rand(r1) )                            
            #range( 0, 0.2)
              reflection 0.3
              phong 0.3
            #break
            #range( 0.2, 0.4)
              reflection 0.7
              phong 0.3
            #break
            #range( 0.4, 0.6)
              reflection 1.0
              phong 0.3
            #break
            #range( 0.6, 0.8)
              reflection 0.8
              metallic
              phong 0.1
            #break
            #range( 0.8, 1.0)
              reflection 0.0
              ambient 0.4
              phong 0.2
            #break
          #end         
        }                  
      #end  //if reflection
        
    }                            
  }
#end

#if ( With_Spheres )
  #local Cpt_Sphere = -Nbre_Etages_Inf*Hauteur_Etage;
  #while ( Cpt_Sphere < Nbre_Etages_Sup*Hauteur_Etage ) 
      object { 
        Sph()
        translate <Diameter_Central_Min*0.5, Cpt_Sphere ,0>
        rotate Cpt_Sphere*10*y
      }  
      object { 
        Sph()
        translate <Diameter_Central_Min*0.5, Cpt_Sphere ,0>
        rotate Cpt_Sphere*10*y + 120*y
      }  
      object { 
        Sph()
        translate <Diameter_Central_Min*0.5, Cpt_Sphere ,0>
        rotate Cpt_Sphere*10*y - 120*y
      }  
                 
    #local Cpt_Sphere = Cpt_Sphere + Hauteur_Etage / 8;                                  
  #end  
                                                     
#end                                                     

// =================== MIRROIR AUTOUR DE LA SCENE =======================

#if ( With_Mirror = yes )     
  intersection {
    box { -1, 1 rotate 45*y }
    box { -1.01, 1.01 }
    scale <Horizon_H,Nbre_Etages_Sup* Hauteur_Etage,Horizon_H>
    //pigment { rgb 0.2 }
    finish { 
      reflection 1  
        
    }
    hollow
  } 
#end

