// Mega Persistence of Vision Ray Tracer Incude File
// File: pbit.inc
// Version: MegaPOV 1.1
// Description: My entry for Nov-Dec IRTC (Topic: Museum)
// Date: 11/16/04
// Author: Paolo Brasolin
// Title: It

// First set Work to 1 and render, then run with the parameters "-j +kff10"

//--------------------------------------------------------------------------------------------------Version

#version unofficial MegaPOV 1.1;

//--------------------------------------------------------------------------------------------------Seed

#declare MyStream=seed(26011988);

//--------------------------------------------------------------------------------------------------Switches

#declare Work=0;

//--------------------------------------------------------------------------------------------------Macros

#local N = 3;
#local W = 4*N;
#local H = 6*N;
#local D = 6/H-0.01;

#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht)
  #debug "\nWriting new .cth file\n"
  #fopen file nomfile write
  #write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")
  #local l1 = nlng*(n1-1);
  #local l2 = nlng*(n2-1);
  #local i=0;
  #while (i<n1)
    #local j=0;
    #while (j<n2)
      #local tempx = -l1/2 + i*nlng;
      #local tempy = -l2/2 + j*nlng;
      #local tempz = ht + (-1+2*rand(MyStream))*nlng*0.01;
      #write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0,\n")
      #set j=j+1;
    #end
    #set i=i+1;
  #end
  #fclose file
#end

#macro WriteInitialDrapeau()
  WriteClothFile("drapeau.cth", W, H, D, 60, 0)
  #fopen file "drapeau.cth" append
    #write(file, H-1, ", 0, 0, 0,\n")
    #write(file, (W/3*1)*H-1, ", 0, 0, 0,\n")
    #write(file, (W/3*2)*H-1, ", 0, 0, 0,\n")
    #write(file, W*H-1, ", 0, 0, 0,\n")
  #fclose file
#end

//--------------------------------------------------------------------------------------------------Simulation

#if(clock_on=off & Work=1)
  WriteInitialDrapeau()
#end

#if(Work=1) 
  simcloth {
    environment        plane {y,-3}
    wind               {bozo scale <1,6,2>}
    viscosity          1
    gravity            -1*y
    neighbors          1
    internal_collision off
    damping            0.3
    intervals          0.04
    iterations         #if(clock_on=0) 0 #else 100 #end
    input              "drapeau.cth"
    output             "drapeau.cth"
    mesh_output        "drapeau.msh"
    smooth_mesh        on
    uv_mesh            on
  }
#end

//--------------------------------------------------------------------------------------------------Scene

#declare Drapeau = union {
  mesh {
    #include "drapeau.msh"
    uv_mapping
    texture {
      pigment {
        checker rgb <0.5,0,0> rgb <0.4,0,0>
        translate z*0.5
        scale <0.1,10,10>
      }
      finish {
        phong 0.5
        phong_size 4
      }
    }
  }
  union {
    cylinder {
      <-3,2.8,0>,<3,2.8,0>,0.05
      pigment {color rgb <0.7,0.5,0.1>}
      finish {
        ambient 0.3
        brilliance 5
        diffuse 0.3
        metallic
        specular 0.80
        roughness 0.02
        reflection 0.35
      }
    }
    union {
      torus {0.1,0.02 rotate <rand(MyStream),0,rand(MyStream)>*60 rotate z*90 translate <-1.8,2.8,0> }
      torus {0.1,0.02 rotate <rand(MyStream),0,rand(MyStream)>*60 rotate z*90 translate <-0.8,2.8,0> }
      torus {0.1,0.02 rotate <rand(MyStream),0,rand(MyStream)>*60 rotate z*90 translate <0.5,2.8,0> }
      torus {0.1,0.02 rotate <rand(MyStream),0,rand(MyStream)>*60 rotate z*90 translate <1.8,2.8,0> }
      pigment {color rgb <0.5,0.2,0>}
      finish {
        ambient 0.3
        brilliance 5
        diffuse 0.3
        metallic
        specular 0.80
        roughness 0.02
        reflection 0.35
      }
    }
  }
}


#if(Work=1)
  camera {location <2,4,-8> look_at <0,0,0>}
  light_source {<10,5,-5>, color rgb 1.2}
  object { Drapeau }
#end
