// Mega Persistence of Vision Ray Tracer Scene Description File
// File: pbvstrs.pov
// Version: MegaPOV 1.1
// Description: My second entry for Nov-Dec IRTC (Topic: Museum)
// Date: 11/24/04
// Author: Paolo Brasolin
// Title: Visitors

//To be rendered at 800x600, AA 0.3

//------------------------------------------------------------------------------General

#version unofficial MegaPOV 1.1;

#include "math.inc"
#include "metals.inc"
#include "woods.inc"
#include "pprocess.inc"

global_settings{
  radiosity {normal on media on}
  post_process{PP_Find_Edges(0.1,30,0.2,1,3,pigment{rgb 0})save_file concat("pp_",output_filename(0))}
  exposure 1
  exposure_gain 1.5
  motion_blur 8,1
}

//------------------------------------------------------------------------------Camera

camera {location <-7,2,-3> look_at y*0.5 angle 70}

//------------------------------------------------------------------------------Sky sphere

#declare P1 = pigment{planar color_map {[0 rgb 0.5][1 rgb 0]}}
#declare P2 = pigment{bozo color_map {[0 rgb 0][1 rgb 0.05]} scale 0.001}
#declare P3 = pigment{bozo color_map {[0.6 rgb 0][0.6 rgb 0.05]} scale <0.2,1,0.2>}
#declare P4 = pigment{bozo color_map {[0.6 rgb 0][0.6 rgb 0.02]} scale <0.1,0.5,0.1>}

sky_sphere {
  pigment {
    average
    pigment_map{
      [1 P1]
      [1 P2]
      [1 P3]
      [1 P4]
    }
  }
}

//------------------------------------------------------------------------------Rope

#macro RopeSeg(n,dx,g,r,sca,rot,tra)
  union {
    sphere_sweep {
      b_spline n+3,
      #declare m=-dx/2-dx/n;
      #while (m<dx/2+2*dx/n)
        <m, sin(m)*r+m*m*g-((dx/2+2*dx/n)*(dx/2+2*dx/n)*g/2), cos(m)*r>, r
        #declare m=m+(dx/n);
      #end
    }
    sphere_sweep {
      b_spline n+3,
      #declare m=-dx/2-dx/n;
      #while (m<dx/2+2*dx/n)
        <m, -sin(m)*r+m*m*g-((dx/2+2*dx/n)*(dx/2+2*dx/n)*g/2), -cos(m)*r>, r
        #declare m=m+(dx/n);
      #end
    }
    scale sca
    rotate rot
    translate tra
 
  }
#end

#macro Rope(sca,rot,tra)
  #declare n=20;
  #declare dx=40;
  #declare g=1/60;
  #declare r=0.5;
  union {
    RopeSeg(n,dx,g,r,1,0,z*-dx/2)
    RopeSeg(n,dx,g,r,1,0,z*dx/2)
    RopeSeg(n,dx,g,r,1,y*90,x*-dx/2)
    RopeSeg(n,dx,g,r,1,y*90,x*dx/2)
    scale sca
    rotate rot
    translate tra
  }
#end

#macro FurTexA(Color)
  texture {
    aoi
    texture_map {
      [ 0
        pigment {Color*0.05}
        finish {ambient 0 diffuse 0 phong 0.5*2 phong_size 2 metallic}
      ]
      [ 0.75
        pigment {bozo color_map {[0 Color*0.9][1 Color*1.1]} scale 0.001}
        normal {
          aoi
          normal_map {
            [ 0 bumps 0.2*3 warp {turbulence 0.5} scale 0.001 ]
            [ 0.5 bumps 0.3*3 warp {turbulence 1} scale 0.2 ]
          }
        }
        finish {ambient 0.2 diffuse 1.2 brilliance 0.6}
      ]
    }
  }
#end

#macro FurTexB(Color)
  pigment {color rgbf 1}
  hollow
  interior {
    media {
      method 1
      samples 1,100
      absorption 8
      scattering { 
        6,
        rgb 1
        diffuse 6 
        reflection 0.5
        reflection_exponent 1
        ratio 1
        frequency 50 
        waves 20,0
        falloff 0.8
        structure { sphere { 0, 4 } }
        pigment { Color }
        force -10*y
      }
    }
  }
#end

union {
  Rope(0.25,0,0)
  FurTexA(color <1,0,0.5>)
  translate y*1.2
}

union {
  torus {0.4,0.1 rotate <90,-45,0> translate <5,0.4,5>}
  torus {0.4,0.1 rotate <90,45,0> translate <-5,0.4,5>}
  torus {0.4,0.1 rotate <90,-45,0> translate <-5,0.4,-5>}
  torus {0.4,0.1 rotate <90,45,0> translate <5,0.4,-5>}
  sphere {< 5,0, 5>,0.2}
  sphere {<-5,0, 5>,0.2}
  sphere {<-5,0,-5>,0.2}
  sphere {< 5,0,-5>,0.2}
  cylinder {< 5,-20, 5>,< 5,0, 5>,0.15}
  cylinder {<-5,-20, 5>,<-5,0, 5>,0.15}
  cylinder {<-5,-20,-5>,<-5,0,-5>,0.15}
  cylinder {< 5,-20,-5>,< 5,0,-5>,0.15}
  texture {T_Gold_1A}
  translate y*1.2
}

//------------------------------------------------------------------------------Pedestal

difference {
  box {<-3,-10,-3>,<3,0,3> }
  torus {1,0.5 rotate x*90 translate <-3,0,2> pigment {rgb 0} }
  pigment {bozo color_map {[0 rgb 0.9][1 rgb 1]}}
  normal {bozo 0.3 scale 0.01}
  finish {phong 1 phong_size 16}
}

#declare Filter = union {
  torus {0.5,0.05}
  intersection {
    cylinder {y*-1,y*1,0.5}
    union {
      cylinder {<-1,0, 0.4>,<1,0, 0.4>,0.01}
      cylinder {<-1,0, 0.3>,<1,0, 0.3>,0.01}
      cylinder {<-1,0, 0.2>,<1,0, 0.2>,0.01}
      cylinder {<-1,0, 0.1>,<1,0, 0.1>,0.01}
      cylinder {<-1,0, 0.0>,<1,0, 0.0>,0.01}
      cylinder {<-1,0,-0.1>,<1,0,-0.1>,0.01}
      cylinder {<-1,0,-0.2>,<1,0,-0.2>,0.01}
      cylinder {<-1,0,-0.3>,<1,0,-0.3>,0.01}
      cylinder {<-1,0,-0.4>,<1,0,-0.4>,0.01}
    }
  }
  motion_blur {
    type 1
    union {
      sphere {0,0.4 scale <0.3,0.01,1> rotate z*30 translate y*-0.05}
      sphere {0,0.4 scale <1,0.01,0.3> rotate x*30 translate y*-0.05}
      rotate y*clock*30
      texture {T_Chrome_5A}
    }
  }
  texture {T_Chrome_4D}
}

object {
  Filter
  rotate z*90
  translate <-3,-1,2>
}

object {
  Filter
  translate <-2,0,2>
}

union {
  box {<-3.1,-0.35,-0.8>,<-2.9,-0.65,-1.2>}
  box {<-3.1,-0.35,0.8>,<-2.9,-0.65,1.2>}
  texture {T_Chrome_5A}
}

union {
  cylinder {<-3,-0.4,-1>,<-3,-0.6,-1>,0.2}
  cylinder {x*-0.4,0,0.1 rotate y*-30 translate <-3,-0.5,-1>}
  cylinder {<-3,-0.4,1>,<-3,-0.6,1>,0.2}
  cylinder {x*-0.4,0,0.1 rotate y*-30 translate <-3,-0.5,1>}
  texture {T_Chrome_4D}
}

union {
  cylinder {x*-0.41,0,0.05 rotate y*-30 translate <-3,-0.5,-1>}
  cylinder {x*-0.41,0,0.05 rotate y*-30 translate <-3,-0.5,1>}
  pigment {color green 8}
}

union {
  sphere_sweep {
    cubic_spline
    12,
    <0, 3, 0>, 0.02
    <0, 3, 0>, 0.02
    <0, 3.5, 0>, 0.02
    <-1, 3.4, 0.2>, 0.02
    <-2, 3.1, -0.1>, 0.02
    <-2.9, 3.2, 0>, 0.02
    <-3.2, 2.8, 0.1>, 0.02
    <-3.5, 1, 0>, 0.02
    <-3.4, -0.5, 0>, 0.02
    <-3.3, -1, 0>, 0.02
    <-3.1, -1, 0>, 0.02
    <-3.1, -1, 0>, 0.02
  }
  sphere {<-3,-1,0>,0.1}
  cylinder {<0,2.7,0>,<0,3,0>,0.02}
  cylinder {<2.6,2.7,-2.6>,<-2.6,2.7,2.6>,0.02}
  cylinder {<-2.6,2.7,-2.6>,<2.6,2.7,2.6>,0.02}
  pigment {color rgb 0}
  finish {specular 0.5}
}


light_source {< 2.7,2.7, 2.7> rgb 0.3}
light_source {< 2.7,2.7,-2.7> rgb 0.3}
light_source {<-2.7,2.7,-2.7> rgb 0.3}
light_source {<-2.7,2.7, 2.7> rgb 0.3}
sphere {< 2.7,2.7, 2.7>,0.1 pigment {color rgb 1} finish {ambient 2} no_shadow}
sphere {< 2.7,2.7,-2.7>,0.1 pigment {color rgb 1} finish {ambient 2} no_shadow}
sphere {<-2.7,2.7,-2.7>,0.1 pigment {color rgb 1} finish {ambient 2} no_shadow}
sphere {<-2.7,2.7, 2.7>,0.1 pigment {color rgb 1} finish {ambient 2} no_shadow}

difference {
  superellipsoid {<0.2,0.2> scale <0.01,0.7,2> translate <-3,-0.9,0.65>}
  torus {1,0.5 rotate x*90 translate <-3,0,2>}
  texture {T_Chrome_3C normal {bozo 0.5 scale 0.2}}
}

//------------------------------------------------------------------------------Glass

union {
  #declare d=0.15;
  #declare l=3;
  #declare h=3;
  box {<-l,0,-l>,<l-d,h-d,-l+d>}
  box {<l-d,0,-l>,<l,h-d,l-d>}
  box {<l,0,l>,<-l+d,h-d,l-d>}
  box {<-l+d,0,l>,<-l,h-d,-l+d>}
  box {<-l,h-d,-l>,<l,h,l>}

  pigment {color rgbf <0.97, 0.99, 0.98, 0.9>}
  finish {
    specular 0.6
    roughness 0.005
    ambient 0
    diffuse 0.2
    brilliance 4
    reflection {
      0, 0.1
      fresnel on
    }
    conserve_energy
    irid {
      0.05
      thickness 1
      turbulence 0.1
    }
  }
  interior {
    ior 1.5
    fade_distance 4
    fade_power 2
  }

}

//------------------------------------------------------------------------------Sign

#declare Paint=texture {
  pigment {color rgb 1}
  finish {phong 1 phong_size 3}
}
union {

  union {
    isosurface {
      function {f_rounded_box(x,y,z,0.1,2,0.5,1)-f_noise3d(x*0.5,y*10,z)}
      contained_by {box{-5,5}}
      threshold 0.2                 
      accuracy 0.05                 
      scale z*0.1
      texture  {
        projection {
          object {
            union{
              text {
                ttf "comicbd.ttf","Museum",1,0
                rotate z*-2
                translate <-2,0.5,-5>
              }
              text {
                ttf "wingding.ttf","\u00E7",1,0
                rotate z*95
                scale 1.5
                translate <0,-1.1,-5>
              }
            }
          }
          parallel z*-20
          blur 0.01,1
        }  
        texture_map {
        [0 T_Wood7 rotate y*90]
        [1 Paint]
        }
      }
      rotate z*2
    }
    
    isosurface {
      function {sqrt(x*x+z*z)+0.1-f_noise3d(x,y,z)/5}
      contained_by {box{-6,2}}
      threshold 0.2                 
      accuracy 0.05                 
      texture  {T_Wood7 rotate x*90}
      rotate z*5
      translate <-2,0,0.2>
    }
    
    isosurface {
      function {sqrt(x*x+z*z)+0.1-f_noise3d(x,y,z)/5}
      contained_by {box{-6,1.8}}
      threshold 0.2                 
      accuracy 0.05                 
      texture  {T_Wood7 rotate x*90}
      rotate <0,30,-3>
      translate <2,0,0.2>
    }
    rotate y*-10
    scale 0.3
    translate <0,1.5,0>
  }
  
  union {                          
    difference {
      superellipsoid {<0.3,0.2> rotate x*90 scale <1,0.2,0.4>}
      superellipsoid {<0.3,0.2> rotate x*90 scale <0.9,0.2,0.3> translate y*0.05}
      pigment {bozo color_map {[0 rgb 0][1 rgb 1]} scale 0.01}
      normal {bozo 5 scale 0.01}
    }
    union {
      intersection {
        superellipsoid {<0.3,0.2> rotate x*90 scale <0.9,0.2,0.3> translate y*0.05}
        isosurface {function{y-f_noise3d(x*5,y*5,z*5)} scale y*0.2}
      }
      isosurface {function{sqrt(x*x+y*y+z*z)-f_noise3d(x*3,y*3,z*3)} scale 0.4 translate <0.6,0,0.2>}
      isosurface {function{sqrt(x*x+y*y+z*z)-f_noise3d(x*3,y*3,z*3)} scale 0.4 translate <-0.6,0,0>}
      pigment {bozo color_map {[0 rgb <0.5,0.4,0.2>][1 rgb <0.2,0.1,0>]} scale 0.01}
      normal {bozo 10 scale 0.01}
    }
    translate y*0.2
  }
  
  rotate y*10
  translate <-0.1,0,2>
}

//------------------------------------------------------------------------------Green Dummy

union {
  blob {
    threshold 1.25
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,1,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1,1}
    sphere {<-1,-3,0>,1,1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-20 rotate <0,40,40>}      
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}           
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}          
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-160 rotate z*5}    
    FurTexA(color rgb <0.5,1,0.5>)
  }
  
  blob {
    threshold 1
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,1,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1,1}
    sphere {<-1,-3,0>,1,1}
    sphere {<0,0,0>,1,1.2 scale x*2 translate x*2 rotate z*-20 rotate <0,40,40>}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,0.9 scale x*2 translate x*2 rotate z*-160 rotate z*5}
    FurTexB(color rgb <0.5,1,0.5>)
  }
  
  union {
    union {sphere {<0.2,1.2,-0.15>,0.25} sphere {<-0.2,1.2,-0.15>,0.25} pigment {color rgb 1}}
    union {sphere {<0.3,1.2,-0.25>,0.15} sphere {<-0.3,1.2,-0.25>,0.15} pigment {color green 0.7}}
    union {sphere {<0.35,1.2,-0.3>,0.1} sphere {<-0.35,1.2,-0.3>,0.1} pigment {color rgb 0}}
    finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
    translate y*-1.2
    rotate <20,-10,0>
    translate y*1.2
  }
  
  sphere_sweep {
    cubic_spline         
    7,                     
    <0.4,0.2,0>, 0.02
    <0,0.3,0.3>, 0.02         
    <-0.4,0.2,0>, 0.02          
    <0,0.1,-0.6>, 0.02
    <0.4,0.2,0>, 0.02
    <0,0.3,0.3>, 0.02
    <-0.4,0.2,0>, 0.02          
    pigment {color red 1}
  }

  union{
    box {<-0.3,0,-0.2>,<0.3,0.2,0.2>}
    cylinder {y*0.2,y*0.4,0.20}
    cylinder {y*0.4,y*0.5,0.17}
    cylinder {y*0.5,y*0.7,0.14}
    sphere {0,0.12 scale y*0.2 translate y*0.7 pigment {color blue 0.1} finish {specular 1 roughness 0.03}}
    rotate <-70,4,8>
    translate z*-0.55
    pigment {color rgb 0.1}
    finish {phong 1 phong_size 8}
    normal {bozo 0.2 scale 0.001}
  }
  
  text {
    ttf "comic.ttf","!",0.1,0
    translate y*2.2
    pigment {color green 1}
  }
  
  scale 0.4
  translate y*1.4
  translate <0.9,0,-1.6>
  rotate y*30
}

//------------------------------------------------------------------------------Blue Dummy

union{
  blob {
    threshold 1.25
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,2,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1.5,1}
    sphere {<-1,-3,0>,1.5,1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-40}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
    FurTexA(color rgb <0.5,0.5,1>)
  }
  
  blob {
    threshold 1
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,2,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1.5,1}
    sphere {<-1,-3,0>,1.5,1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-40}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
    FurTexB(color rgb <0.5,0.5,1>)
  }
  
  union {
    union {sphere {<0.3,1.2,-0.3>,0.2} sphere {<-0.3,1.2,-0.3>,0.2} pigment {color rgb 1}}
    union {sphere {<0.4,1.2,-0.4>,0.1} sphere {<-0.4,1.2,-0.4>,0.1} pigment {color blue 0.7}}
    union {sphere {<0.45,1.2,-0.45>,0.05} sphere {<-0.45,1.2,-0.45>,0.05} pigment {color rgb 0}}
    finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
    translate y*-1.2
    rotate <10,-20,0>
    translate y*1.2
  }          

  text {
    ttf "comic.ttf","?",0.1,0
    translate y*2.2
    pigment {color blue 1}
  }

  scale 0.4
  translate y*1.5
  translate <-0.8,0,-1.5>
  rotate y*20
}

//------------------------------------------------------------------------------Red Dummy

union {
  blob {
    threshold 0.85
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,1,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1,1}
    sphere {<-1,-3,0>,1,1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*35+y*10}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
    FurTexA(color rgb <1,0.5,0.5>)
  }
  
  blob {
    threshold 0.6
    sphere {<0,1.2,0>,0.8,2}
    sphere {<0,0,0>,1,1}
    sphere {<0,-1,0>,2,1}
    sphere {<1,-3,0>,1,1}
    sphere {<-1,-3,0>,1,1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*35+y*10}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-70 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-110 translate y*-1}
    sphere {<0,0,0>,1,1 scale x*2 translate x*2 rotate z*-140}
    FurTexB(color rgb <1,0.5,0.5>)
  }
  
  union {
    union {sphere {<0.25,1.2,-0.25>,0.2} sphere {<-0.25,1.2,-0.25>,0.2} pigment {color rgb 1}}
    union {sphere {<0.35,1.2,-0.35>,0.1} sphere {<-0.35,1.2,-0.35>,0.1} pigment {color red 0.7}}
    union {sphere {<0.4,1.2,-0.4>,0.05} sphere {<-0.4,1.2,-0.4>,0.05} pigment {color rgb 0}}
    finish { specular 1 roughness 0.1 irid { 1 thickness 0.2 turbulence 2 } }
  }
  
  text {
    ttf "comic.ttf","...",0.1,0
    translate y*2.2
    pigment {color red 1}
  }
  
  union {
    disc {0 y,1.5,0}
    intersection {
      sphere {0,0.55}
      box {<-1,0,-1>,1}
    }
    torus {1.5,0.01 pigment {color red 1}}
    torus {0.55,0.02 translate y*0.1 pigment {color red 1}}
    rotate <10,2,7>
    translate y*1.4

    pigment {spiral2 4 scale 0.1 color_map{[0 color rgb <0.6,0.4,0.1>][1 color rgb <0.9,0.8,0.1>]}}
    normal {spiral2 16,0.5 scale 0.1}
  }

  scale 0.4
  scale x*-1
  translate y*1.5
  rotate y*120
  translate <0.2,0,0.5>
}

//------------------------------------------------------------------------------EOF
