#include "rand.inc"
#include "shapes.inc"
#include "transforms.inc"
#include "colors.inc"   // don't use this myself, but at least "woods.inc" needs it 
#include "woods.inc"
#include "metals.inc"

/*
    switch between
    draft quality (no area_light, no radiosity, no tinted fill-light, some objects and textures simpler)
    and
    competition quality (all gimmicks on)
*/

#declare Draft = false; 


/*
    textures
*/

/* default textures; just to work with in draft quality in first approximation */

// just white color for solid things
#declare DefaultTexture = texture{pigment{color rgb 1}};

// simple transparent texture for transparent things
#declare DefaultTransparentTexture = texture{pigment{color rgbf .9}};

/* "wall & ceiling"-textures */

#declare WallTexture =
    texture
    {
        pigment{color rgb <1,1,1>}
        normal
        {
            average
            normal_map
            {
                [.5 wrinkles    .1                          ]
                [1  crackle     .25 scale .03 turbulence .5 ]
            }
        }
    }

/* "metal"-textures */

// simple texture for draft quality
#declare MetalTextureSimple =
    texture{T_Brass_3C}
    
// texture for metal grating of the dome
#declare MetalTextureSimple = texture{T_Chrome_3A}

#declare MetalTexture =
    texture
    {
        bozo
        turbulence .5
        scale .05
        
        texture_map
        {
            [.66    T_Chrome_4A ]
            [1      T_Chrome_3A ]
        }   
    }

/* "glass"-texture */
#declare GlassMaterial =
    material
    {
        texture
        {
            pigment{color rgbf <1,1,1,.925>}
            finish
            {
                specular 1
                roughness .001
                diffuse 0
                reflection .1
            }
        }
        interior{ior 1.55}
    }

/* "wooden floor"-textures */

// simple texture for draft quality
#declare WoodTextureSimple = texture{T_Wood10}

// texture for the wooden floor
// done as macro to be able to orient the grain and randomize the offset for every call 
#macro Wood(Orientation)
    texture
    {
        T_Wood10
        rotate (vlength((90*Orientation)*<1,0,0>))*<0,1,0>
        translate 10*VRand_In_Sphere(RdmA)
    }
#end 

/* "marble pedestal" textures */

// simple texture for draft quality
#declare BlackMarbleTextureSimple = texture{pigment{color rgb <0,0,0>}}

// texture for the pedestals
#declare BlackMarbleTexture =
    texture
    {
        pigment
        {
            marble
            turbulence .5
            color_map
            {
                [0,.41      color rgb <0,0,0>       color rgb <0,0,0>           ]
                [.42        color rgb <.33,.33,.33>                             ]
                [0.43,.88   color rgb <0,0,0>       color rgb <.165,.165,.165>  ]
                [.975       color rgb <.22,.22,.22>                             ]
                [.9875      color rgb <.44,.44,.44>                             ]
                [1          color rgb <.66,.66,.66>                             ]
            }
            scale .75
            rotate <22.5,22.5,0>
        }
        finish
        {
            specular .5
            roughness .001
            reflection .15
        }
    }

/* "blue velvet"-texture */

// simple texture
#declare BlueVelvetTextureSimple =
    texture{pigment{color rgb <0,0,.5>}}

// texture for the cushion in the display case 
#declare BlueVelvetTexture =
    texture
    {
        pigment
        {
            bozo
            color_map
            {
                [.2 color rgb <0,0,1>   ]
                [1  color rgb <0,0,.5>  ]
            }
            scale .1
        }
        normal
        {
            bozo .05
            scale .1
        }
        finish
        {
            diffuse .9
        }
    }

/* "laser"-textures */    

// simple texture for draft quality
#declare LaserTextureSimple = texture{pigment{color rgbt <5,0,0,.5>}}

// texture for the lasers
// Tried to emulate the looks of red laserbeams falling through some smoke without actually using a lightsource or ambient.
// Resorted to overshot colours.
#declare LaserTexture = 
    texture
    {
        pigment
        {
            bozo
            pigment_map
            {
                [0  rgbt   <50,0,0,1>    ]
                [1  rgbt   <100,0,0,.99> ]
            }
            scale .1
        }    
    }

/* "green agate"-textures */

// simple texture for draft quality
#declare AgateTextureSimple = texture{pigment{color rgb <.25,.55,.25>}}

// texture for the body of the cactus

#declare AgateTexture =
    texture
    {
        pigment
        {
            agate
            agate_turb .9
            pigment_map
            {
                [0      rgb <.25,.55,.25>   ]
                [.2     rgb <.25,.55,.25>   ]
                [.225   rgb <.75,.75,.75>   ]
                [.25    rgb <.25,.55,.25>   ]
                [.495   rgb <.35,.35,.35>   ]
                [.5     rgb <.25,.35,.25>   ]
                [.75    rgb <.25,.55,.25>   ]
                [1      rgb <.25,.75,.25>   ]
            }
        }
        finish
        {
            specular .5
            roughness .001
            reflection .15
        }
    }

/* "brass"-texture */
    
// simple texture for draft quality
#declare BrassTextureSimple = texture{T_Brass_3C}

// texture for peaks of the cactus
#declare BrassTexture =
    texture
    {
        bozo
        turbulence .75
        scale .05
        
        texture_map
        {
            [.33    T_Brass_3C  ]
            [.66    T_Brass_4C  ]
            [1      T_Brass_5C  ]
        }   
    }
    
/*
    radiosity & global photons for competion quality; strictly no ambient light
*/

#if(!Draft)
    // radiosity (global illumination) settings
    global_settings
    {
        ambient_light 0
        radiosity
        {
            pretrace_start 8            // start pretrace at this size
            pretrace_end   0.02         // end pretrace at this size
            count 100                   // higher -> higher quality (1..1600) [35]
            nearest_count 7             // higher -> higher quality (1..10) [5]
            error_bound 1.8             // higher -> smoother, less accurate [1.8]
            recursion_limit 3           // how much interreflections are calculated (1..5+) [3]
            low_error_factor .5         // reduce error_bound during last pretrace step
            gray_threshold 0.0          // increase for weakening colors (0..1) [0]
            minimum_reuse 0.015         // reuse of old radiosity samples [0.015]
            brightness 2                // brightness of radiosity effects (0..1) [1]
        
            adc_bailout 0.01/2
            //save_file "stole_ag.rad"  // save radiosity data
            //load_file "stole_ag.rad"  // load saved radiosity data
        }
    
        // photons also need to be adjusted for light sources and objects.
        photons
        {
            //spacing 0.001             // specify the density of photons
            count 10000000              
            jitter 1.0                  // jitter phor photon rays
            
            //max_trace_level 5         // optional separate max_trace_level
            //adc_bailout 1/255         // see global adc_bailout
            
            //save_file "stole_ag.ph"   // save photons to file
            //load_file "stole_ag.ph"   // load photons from file
            
            autostop 0                  // photon autostop option
        }

    }
#end

/*
    camera; from about the view of an adult
*/
camera
{
    location    <4,2.1,-3.5>
    look_at     <-1,2,0>
}

/*
    most abstract approximation of a sky, a dark-blueish sphere; made an effort to emulate clouds, don't know about the result.
    Anyway, you don't see too much of it :-)
*/

sky_sphere
{
    pigment
    {
        bozo
        turbulence .5
        pigment_map
        {
            [.1 rgb <0,0,.5>    ]
            [.2 rgb <0,0,.35>   ]
            [.5 rgb <0,0,.35>   ]
            [.8 rgb <0,0,.1>    ]
            [1  rgb <0,0,0>     ]
        }
    }
}

/*
    lights
*/

// main light, should emulate the moon
light_source
{
    vrotate(<0,75,0>,<-55.5,0,-7.5>),
    rgb <.75,.75,1>
    
    #if(!Draft)
        area_light
        vnormalize(vrotate(vrotate(75*y,<-55.5,0,-7.5>),90*x))*5,
        vnormalize(vrotate(vrotate(75*y,<-55.5,0,-7.5>),90*z))*5,
        10,10
        circular
        orient
        jitter
    
        // photon block for a light source
        photons
        {
            refraction on
            reflection on
            area_light
        }

    
    #end
}

// white "work light" to check the appearance of things in draft quality
#if(Draft)
    light_source
    {
        <0,3.99,5>,
        rgb 1
        shadowless
    }
#end

// dark-blueish fill-light to make "the night visible" - no reference to reality whatsoever!
#if(!Draft)
    light_source
    {
        <0,3.99,5>,
        rgb<.1,.1,.2>
        shadowless
    }
#end

/*
    modelling & composition
*/

// the room as such
difference
{
    box
    {
        <-11,-1,-11>,
        <11,4.25,1>
    }
    
    box
    {
        <-10,0,-10>,
        <10,4,0>
    }
    
    cylinder
    {
        <0,3.999,-5>,
        <0,4.251,-5>,
        2.5
    }
    
    #if(Draft)
        texture{DefaultTexture}
    #else
        texture{WallTexture}
    #end
}

//base
union
{
    //basestrip
    union
    {
        union
        {
            cylinder
            {
                <-10,.07,0>,
                <10,.07,0>,
                .02  
            }
            box
            {
                <-10,0,-.02>,
                <10,.07,0>
            }
            #if(Draft)
                texture{DefaultTexture}
            #else
                Wood(x)
                texture{pigment{color rgbft <1,1,1,.2,.2>}}
            #end    
        }
        
        union
        {
            cylinder
            {
                <-10,.07,-4>,
                <-10,.07,0>,
                .02
            }
            box
            {
                <-10,0,-4>,
                <-9.98,.07,0>
            }
            
            #if(Draft)
                texture{DefaultTexture}
            #else
                Wood(z)
                texture{pigment{color rgbft <1,1,1,.2,.2>}}
            #end 
        }
    }
    
    //quarterrod
    cylinder
    {
        <-10,0,-.02>,
        <10,0,-.02>,
        .02
        
        #if(Draft)
            texture{WoodTextureSimple}
        #else
            Wood(x)
        #end
    }
    cylinder
    {
        <-9.98,0,-4>,
        <-9.98,0,0>,
        .02
        
        #if(Draft)
            texture{WoodTextureSimple}
        #else
            Wood(z)
        #end
    }
    
}

//window in the ceiling

union
{
    difference
    {
        union
        {
            #declare I = 0;
            #while(I<4)
                torus
                {
                    2.55,.05
                    rotate <90,0,0>       
                    rotate 180*(I/4)*<0,1,0>
                }
                #declare I = I+1;
            #end
            
            torus{2.55,.05}
            torus
            {
                3*vlength((vrotate(<1,0,0>,45*z))*<1,0,0>),.05
                translate((2*vlength((vrotate(<1,0,0>,45*z))*<0,1,0>)*<0,1,0>))
            }
        }
        
        
        box
        {
            <-2.61,0,-2.61>,
            <2.61,-2.61,2.61>
        }
        
        #if(Draft)
            texture{MetalTextureSimple}
        #else
            texture{MetalTexture}
        #end    
    }
    
    // glass-dome
    difference
    {
        sphere{0,2.545}
        sphere{0,2.555}
        box
        {
            <-2.61,0,-2.61>,
            <2.61,-2.61,2.61>
        }
        
        #if(Draft)
            texture{DefaultTransparentTexture}
        #else
            material{GlassMaterial}
        #end
    
        photons
        {
            refraction off
            reflection off
            pass_through on
        }
    }
    
    translate <0,4.25,-5>
}

//floor

// single square of floor; macro!
#macro FloorTile()
    union
    {
        #declare I1 = 0;
        #while (I1<5)
            box
            {
                <(I1*.1),0,0>,<(I1*.1)+.1,.001,.5>
                
                #if(Draft)
                    texture{WoodTextureSimple}
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #else
                    Wood(z)
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #end
            }
            #declare I1 = I1+1;
        #end
        
        #declare I1 = 0;
        #while (I1<5)
            box
            {
                <(I1*.1)+.5,0,.5>,<(I1*.1)+.6,.001,1>
                            
               #if(Draft)
                    texture{WoodTextureSimple}
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #else
                    Wood(z)
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #end
            }
            #declare I1 = I1+1;
        #end
        
        #declare I1 = 0;
        #while (I1<5)
            box
            {
                <.5,0,(I1*.1)>,<1,.001,(I1*.1)+.1>
                
                #if(Draft)
                    texture{WoodTextureSimple}
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #else
                    Wood(x)
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #end
            }
            #declare I1 = I1+1;
        #end
        
        #declare I1 = 0;
        #while (I1<5)
            box
            {
                <0,0,(I1*.1)+.5>,<.5,.001,(I1*.1)+.6>
                
                #if(Draft)
                    texture{WoodTextureSimple}
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #else
                    Wood(x)
                    texture{pigment{color rgbft <.25,.1,.1,.05,.75>}}
                #end
            }
            #declare I1 = I1+1;
        #end
    }
#end

// filling the floor

#declare I = -10;
#while (I<10)
    #declare J = -10;
    #while (J<0)
        
        object
        {
            FloorTile()
            translate <I,0,J>    
        }
        #declare J = J+1;
    #end
    #declare I = I+1;
#end
    
//pedestal for display case
box
{
    <-.6,0,0>,<.6,1.2,-1.2>
    #if(Draft)
        texture{BlackMarbleTextureSimple}
    #else
        texture{BlackMarbleTexture}
    #end
}    

//display case
union
{
    difference
    {
        box
        {
            <-.45,1.2,0>,
            <.45,2.0,-.95>
        }
        
        box
        {
            <-.44,1.19,-.01>
            <.44,1.99,-.94>
        }
        
        cylinder
        {
            <0,1.6,-.96>,
            <0,1.6,-.93>,
            .25
        }
           
        #if(Draft)
           texture{DefaultTransparentTexture}
        #else
           material{GlassMaterial}
        #end
    }
    
    //metal-frame
       
    difference
    {
        box
        {
            <-.46,1.2,0.01>,
            <.46,2.01,-.96>
        }
        
        box
        {
            <-.45,1.199,0>,
            <.45,2.0,-.95>
        }
        
        box
        {
            <-.47,1.25,-.05>,
            <.47,1.95,-.9>
        }
        
        box
        {
            <-.4,1.25,0.05>,
            <.4,1.95,-1>
        }
        
        box
        {
            <-.4,1.95,-.05>,
            <.4,2.05,-.9>
        }
        
        #if(Draft)
            texture{BrassTextureSimple}
        #else
            texture{BrassTexture}
        #end
    } 
    
    photons
    {
       target on
       refraction on
       reflection on
    }
    
    translate -.1*z
}

//cushion in the display case
object
{    
    Round_Box(<-.40,1.2,-.05>, <.40,1.3,-.90>, .1, false) // HATE! Wish I found something better, e.g. a modelling-tool that suits me!
    
    #if(Draft)
       texture{BlueVelvetTextureSimple}
    #else
       texture{BlueVelvetTexture}
    #end
    
    translate -.1*z
   
}

//laser detector
union
{
    // laser beams
    merge
    { 
        #declare I = 1;
        #while(I<26)
        
            cylinder
            {
                <0,-.5,-1.45>,<0,4.1,-1.45>,.005
                rotate (((I/25)*170)-85)*y
            }
            #declare I = I+1;
        
        #end
                
        #if(Draft)
            texture{LaserTextureSimple}
        #else
            texture{LaserTexture}
        #end
                
        double_illuminate
        no_shadow // of course; these are beams of light! 
        no_reflection
    
        photons
        {
            refraction off
            reflection off
            pass_through on
        }
    }       
    
    // emitter/collector
    difference
    {
        cylinder
        {
            <0,-.1,0>,<0,4.1,0>,1.5
        }
        cylinder
        {
            <0,-.1,0>,<0,4.1,0>,1.4
        }
        cylinder
        {
            <0,.01,0>,<0,3.99,0>,1.51
        } 
        
        #declare I = 1;
        #while(I<26)
        
            cylinder
            {
                <0,.05,-1.45>,<0,3.95,-1.45>,.0075
                rotate (((I/25)*170)-85)*y
            }
            #declare I = I+1;
        
        #end
        
        #if(Draft)
           texture{MetalTextureSimple}
        #else
           texture{MetalTexture}
        #end    
    }
}


// The Cactus from ag_des2 + a pedestal! Recycling!
union
{
    union
    {
        #local CactusBody = DefaultTexture;
        #local PeaksTex = DefaultTexture;
        
        #if(Draft)
           #local NumPeaks = 100;
        #else
           #local NumPeaks = 250;
        #end
        
        union
        {
            sphere
            {
                0,5
                scale<.25,1,.25>
            }
            #local I = 0;
            #while(I<5)
                
                sphere
                {
                    0,5.5
                    scale<.1,(5/5.5),.25>
                    rotate I*(360/5)*<0,1,0>
                }
                
                #local I = I+1;
            #end
            
            // cactus body
            #if(Draft)
                texture{AgateTextureSimple}
            #else
                texture{AgateTexture}
            #end            
        }
        union
        {
            #local I = 0;
            #while(I<5)
                #local Peaks = NumPeaks;
                #while (Peaks>0)
                    #local PeakRotate = RRand(-180,45,RdmA);
                    #local PeakJitter = RRand(-7.5,7.5,RdmA);
                    #local PeakHead = vrotate(6.5*z,PeakRotate*x);
                    #local PeakHead = vrotate(PeakHead,PeakJitter*y);
                    cone
                    {
                        0,.35
                        PeakHead,0
                        
                        scale<.25,(5/5.5),.25>
                        rotate I*(360/5)*y 
                    }
                    
                    #local Peaks = Peaks-1;
                #end
                #local I = I+1;
            #end
            
            // peaks
            #if(Draft)
                texture{BrassTextureSimple}
            #else
                texture{BrassTexture}
            #end
        }
        
        scale .5
        rotate <-11.25,120,0>
        translate<-5,1,-2>
    }        
    
    // pedestal
    cylinder
    {
        <-5,0,-2>,<-5,.5,-2>,1
        #if(Draft)
            texture{BlackMarbleTextureSimple}
        #else
            texture{BlackMarbleTexture}
        #end
    }
}