//*PMRawBegin
#declare maxDetail=true;
#if (maxDetail)
#declare Particles=60000;
#declare nbfleurs=1000;
#declare nbherbes=10000;
#else
#declare Particles=30;
#declare nbfleurs=10;
#declare nbherbes=300;
#end
//*PMRawEnd

#declare fleur = union {
   cylinder {
      <0, 0, 0>, <0, 15, 0>, 0.5
      
      pigment {
         color rgb <0.145098, 0.745098, 0.184314>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   intersection {
      sphere {
         <0, 0, 0>, 5
         scale <1, 1.5, 1>
         rotate <0, 0, 0>
      }
      
      box {
         <-6, 0, -6>, <6, -10, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgb <1, 0, 0>
      }
      translate y*22.5
   }
   scale 3
}

#declare masquePeint = union {
   difference {
      sphere {
         <0, 0, 0>, 0.5
         scale <1, 1.5, 0.6>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.48
         scale <1, 1.5, 0.6>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName arriere
         <-1, -1, 0>, <1, 1, 0.5>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
}

#declare gdPalais = union {
   box {
      <-7500, 0, -2500>, <7500, 4000, 2500>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-7500, 0, -2500>, <7500, 4000, 2500>
      scale 1
      rotate y*90
      translate <0, 0, 0>
   }
}

#declare T_Stone21 = texture {
}

#declare Maroon = pigment {
   color rgb <0.556863, 0.137255, 0.419608>
}

#declare Tan = pigment {
   color rgb <0.360784, 0.239216, 0.184314>
}

#declare Tan_0 = pigment {
   color rgb <0.45098, 0.301961, 0.231373>
}

#declare terre = texture {
   pigment {
      Tan
   }
   
   normal {
      bozo
      1
   }
   scale 1
}

#declare T_StoneV = texture {
   pigment {
      color rgb <0, 0, 0>
   }
}

#declare T_StoneVnoir = texture {
}

#declare boisInt = texture {
   //*PMRawBegin
   
              pigment {color rgb <0,1,0>
                }
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               scale 0.07
               rotate <0, 0, 0>
               //translate y*2
               
   //*PMRawEnd
   scale 1000
}

#declare boisExt = texture {
   //*PMRawBegin
   
              pigment {color rgb <0,1,0>
                }
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               scale 0.07
               rotate <0, 0, 0>
               //translate y*2
               
   //*PMRawEnd
   scale 1000
}

#declare tachesParquet = texture {
   pigment {
      bozo
      
      pigment_map {
         [ 0 color rgbf <0.9, 0.9, 0.9, 0.8>
         ]
         [ 0.4 color rgbt <0.8, 0.8, 0.8, 1>
         ]
      }
   }
}

#declare T_Copper_1C = texture {
}

#declare vitre = material {
   //*PMRawBegin
   texture {
    pigment {rgbf <1.0, 1.0, 1.0, 0.9>}
    finish { specular 0.9
       roughness 0.001
       ambient 0
       diffuse 0
       reflection {
         0.0, 0.7
         fresnel on
       }
       conserve_energy
      }
    }
    interior {
       ior 1.5
      
      }
   //*PMRawEnd
}

#declare tx_borneIncendie = texture {
   pigment {
      color rgb <0.980392, 0, 0>
   }
}
//*PMRawBegin
#include "textures.inc"
#include "colors.inc"
#include "woods.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones1.inc"

#include "mesPierres.inc"
#include "masque.inc"
#include "plancher.inc"
#include "fleurs.inc"
#include "boiserie.inc"
#include "echardes.inc"

#fopen dbg "debug.txt" write
//*PMRawEnd

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 50
   noise_generator 1
}

light_source {
   //*PMName interieur
   <35.253, 372.01, 39.002>, rgb <1.5, 1.5, 1.4>
   shadowless
}

light_source {
   //*PMName soleil
   <6132.2, 12092, 2636.3>, rgb <1, 1, 1>
}

camera {
   //*PMName flou
   perspective
   location <0, 170, -188.62>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <2, 0, 0>
   up <0, 1.5, 0>
   look_at <0, 170, 200>
   angle 90
   aperture 0.4
   blur_samples 10
   focal_point <0, 0, 1000>
   confidence 0.9
   variance 0.008
}

camera {
   //*PMName loin
   perspective
   location <-124.57, 170, -68.571>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <2, 0, 0>
   up <0, 1.5, 0>
   look_at <-147.08, 170, 1586.8>
   angle 80
}

camera {
   //*PMName procheTrou
   perspective
   location <-309.401, 101.218, 344.808>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <2, 0, 0>
   up <0, 1.5, 0>
   look_at <-355.227, 17.8596, 983.81>
   angle 90
}

camera {
   perspective
   location <-142.86, 170, 68.6156>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <2, 0, 0>
   up <0, 1.5, 0>
   look_at <-147.08, 170, 1586.8>
   angle 90
}

#declare bleuK = pigment {
   color rgb <0.129412, 0.0901961, 0.490196>
}

#declare T_Grnt0 = texture {
   pigment {
      granite
      turbulence <0.4, 0.4, 0.4>
      
      color_map {
         [ 0 color rgb <0.729, 0.502, 0.451>
         ]
         [ 0.153 color rgb <0.769, 0.686, 0.592>
         ]
         [ 0.398 color rgb <0.843, 0.753, 0.718>
         ]
         [ 0.559 color rgb <0.78, 0.667, 0.561>
         ]
         [ 0.729 color rgb <0.741, 0.659, 0.576>
         ]
         [ 1.001 color rgb <0.729, 0.502, 0.451>
         ]
      }
   }
   
   normal {
      granite
      0.1
      turbulence <0.4, 0.4, 0.4>
   }
   scale 20
}

#declare taches = texture {
   pigment {
      bozo
      turbulence <0, 0, 0>
      
      pigment_map {
         [ 0 color rgbt <0, 0, 0, 1>
         ]
         [ 0.7 color rgbt <0, 0, 0, 1>
         ]
         [ 0.8 color rgbt <0.61176, 0.61176, 0.61176, 0.7>
         ]
         [ 0.9 color rgbt <0.61176, 0.61176, 0.61176, 0.8>
         ]
         [ 1 color rgbt <0.61176, 0.61176, 0.61176, 0.8>
         ]
      }
   }
   scale 100
}

#declare taches_Grande = texture {
   pigment {
      bozo
      turbulence <0, 0, 0>
      
      pigment_map {
         [ 0 color rgbt <0, 0, 0, 0.9>
         ]
         [ 1 color rgbt <0.61176, 0.61176, 0.61176, 1>
         ]
      }
   }
   scale 200
}

#declare tx_herbes = material {
   texture {
      pigment {
         crackle
         turbulence <1, 1.5, 1>
         
         color_map {
            [ 0.01 color rgb <0.30588, 0.58431, 0.1882>
            ]
            [ 0.4 color rgb <0.443137, 0.584314, 0.188235>
            ]
            [ 0.8 color rgb <0.678431, 0.678431, 0.219608>
            ]
         }
      }
   }
   scale 0.1
}

#declare vitreImmeuble = material {
   //*PMRawBegin
   texture {
    pigment {rgbf <1.0, 1.0, 1.0, 0.9>}
    finish { specular 0.9
       roughness 0.001
       ambient 0
       diffuse 0
       reflection {
         0.8, 1.0
         fresnel on
       }
       conserve_energy
      }
    }
    interior {
       ior 1.5
      
      }
   //*PMRawEnd
}

#declare bois = texture {
   //*PMRawBegin
   
               T_Wood21
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               rotate <0, 0, 0>
               //translate y*2
               
   //*PMRawEnd
   scale 300
}

#declare bois_0 = texture {
   //*PMRawBegin
   
               T_Wood14
               finish { specular 0.35 roughness 0.05 ambient 0.3 }
               //translate x*1
               rotate <0, 0, 0>
               //translate y*2
               
   //*PMRawEnd
   scale 300
}

#declare boisTableau = texture {
   //*PMRawBegin
    //*PMRawBegin
      
                  T_Wood7//T_Wood21
                  finish { specular 0.35 roughness 0.05 ambient 0.3 }
                  //translate x*1
                  scale 0.07
                  rotate <0, 90, 90>
                  //translate y*2
                  
      //*PMRawEnd
      scale 1000
   //*PMRawEnd
}

#declare immeubleRosePale = texture {
   pigment {
      color rgb <0.819608, 0.2, 0.321569>
   }
}

#declare immeubleRosePale_0 = texture {
   pigment {
      color rgb <0.909804, 0.490196, 0.568627>
   }
}

#declare immeubleRoseFonce = texture {
   pigment {
      color rgb <0.819608, 0.419608, 0.501961>
   }
}

#declare immeubleRoseFonce_0 = texture {
   pigment {
      color rgb <0.819608, 0.419608, 0.501961>
   }
}

#declare zinc = texture {
   pigment {
      color rgb <0.733333, 0.733333, 0.733333>
   }
}

#declare betonImmeuble = texture {
   pigment {
      color rgb <0.823529, 0.823529, 0.803922>
   }
}

#declare betonBlancImmeuble = texture {
   pigment {
      color rgb <1, 1, 0.992157>
   }
}

#declare noirPoteauImmeuble = texture {
   pigment {
      color rgb <0.0705882, 0.0705882, 0.0705882>
   }
}

#declare fenetreGauche = union {
   box {
      <0, 120, 5>, <150, 280, 6>
      
      material {
         vitre
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      box {
         <0, 120, 4>, <10, 280, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <140, 120, 4>, <150, 280, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0, 120, 4>, <150, 130, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0, 280, 4>, <150, 270, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   
   union {
      box {
         <0, 110, -10>, <-10, 290, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <160, 110, 0>, <150, 290, -10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-10, 120, 0>, <160, 110, -10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-10, 280, 0>, <160, 290, -10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         immeubleRosePale
      }
   }
}

union {
   //*PMName ciel
   //*PMRawBegin
   #include "sky.inc"
   //*PMRawEnd
}

#declare colonne_dorique = union {
   box {
      //*PMName socle
      <-0.118421, 0, -0.118421>, <0.118421, 0.421053, 0.118421>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName corniche1
      <-0.15789, 0.368421, -0.15789>, <0.15789, 0.342105, 0.15789>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName corniche2
      <-0.13684, 0.3421, -0.13684>, <0.13684, 0.315789, 0.13684>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName cornicheb2
      <-0.13684, 0.0526, -0.13684>, <0.13684, 0.0263, 0.13684>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName cornicheb1
      <-0.15789, 0.0263, -0.15789>, <0.15789, 0, 0.15789>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      torus {
         0.10263, 0.013158
         scale 1
         rotate <0, 0, 0>
         translate y*0.013158
      }
      
      cylinder {
         //*PMName centreTore
         <0, 0.026316, 0>, <0, 0, 0>, 0.10263
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName prem
         <0, 0.034317, 0>, <0, 0, 0>, 0.094855
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName deux
         <0, 0.0437513, 0>, <0, 0, 0>, 0.0872099
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName fut 1/3 bas
         <0, 0.421053, 0>, <0, 0, 0>, 0.078947
         scale 1
         rotate <0, 0, 0>
      }
      
      cone {
         //*PMName fut haut
         <0, 1.26316, 0>, 0.0657895,
         <0, 0.421053, 0>, 0.0789474
         scale 1
         rotate <0, 0, 0>
      }
      translate y*0.421053
      
      texture {
         T_StoneV
         scale 0.05
      }
   }
   
   cone {
      <0, 1.8, 0>, 0.15,
      <0, 1.6849, 0>, 0.06579
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      T_StoneVnoir
      scale 0.05
   }
}

#declare colonne_dorique_Rouge = union {
   box {
      //*PMName socle
      <-0.118421, 0, -0.118421>, <0.118421, 0.421053, 0.118421>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName corniche1
      <-0.15789, 0.368421, -0.15789>, <0.15789, 0.342105, 0.15789>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName corniche2
      <-0.13684, 0.3421, -0.13684>, <0.13684, 0.315789, 0.13684>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName cornicheb2
      <-0.13684, 0.0526, -0.13684>, <0.13684, 0.0263, 0.13684>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName cornicheb1
      <-0.15789, 0.0263, -0.15789>, <0.15789, 0, 0.15789>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      torus {
         0.10263, 0.013158
         scale 1
         rotate <0, 0, 0>
         translate y*0.013158
      }
      
      cylinder {
         //*PMName centreTore
         <0, 0.026316, 0>, <0, 0, 0>, 0.10263
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName prem
         <0, 0.034317, 0>, <0, 0, 0>, 0.094855
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName deux
         <0, 0.0437513, 0>, <0, 0, 0>, 0.0872099
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName fut 1/3 bas
         <0, 0.421053, 0>, <0, 0, 0>, 0.078947
         scale 1
         rotate <0, 0, 0>
      }
      
      cone {
         //*PMName fut haut
         <0, 1.26316, 0>, 0.0657895,
         <0, 0.421053, 0>, 0.0789474
         scale 1
         rotate <0, 0, 0>
      }
      translate y*0.421053
      
      texture {
         T_Stone21
         scale 0.05
      }
   }
   
   cone {
      <0, 1.8, 0>, 0.15,
      <0, 1.6849, 0>, 0.06579
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      T_StoneVnoir
      scale 0.05
   }
}
//*PMRawBegin
#include "gdPalais.inc"
#include "fenetreMaisonRose.inc"
//*PMRawEnd

#declare tableau = union {
   union {
      box {
         <-76.5, 0, 0>, <76.5, 199, -2>
         
         pigment {
            bleuK
         }
      }
      
      box {
         <-76.5, 0, 0>, <76.5, 199, 2>
         
         pigment {
            color rgb <1, 1, 1>
         }
      }
      
      union {
         box {
            <-80, 0, -6>, <80, -8, 2>
            
            texture {
               boisTableau
               rotate z*90
            }
         }
         
         box {
            <-2, 0, 8>, <2, -320.13, 2>
            scale 1
            rotate z*15
            translate <1, 250, 0>
         }
         
         box {
            <-2, 0, 8>, <2, -320.13, 2>
            scale 1
            rotate z*(-15)
            translate <-1, 250, 0>
         }
         
         texture {
            boisTableau
         }
      }
      translate <0, -250, -3>
      rotate x*5
      translate y*300
   }
   
   box {
      <-2, 0, -2>, <2, -310.32, 2>
      
      texture {
         boisTableau
      }
      scale 1
      rotate x*(-15)
      translate <-1, 300, 0>
   }
}

object {
   //*PMName tableauDedans
   tableau
   rotate y*0.3
   translate <17.3126, 0, 416.168>
}

object {
   //*PMName msque
   masquePeint
   scale 70
   rotate <0, 0, -0>
   translate <330.522, 512.73, 596.766>
}

#declare batiment = union {
   object {
      //*PMName colonne
      colonne_dorique
      scale 400
      rotate <0, 0, 0>
      translate <-600.197, 0, 549.262>
   }
   
   union {
      //*PMName murs
      
      box {
         <-760, 0, 610>, <-400, 800, 601>
      }
      
      box {
         <-100, 0, 610>, <800, 800, 601>
      }
      
      box {
         <-650, 0, 610>, <-651, 800, 0>
      }
      
      box {
         <650, 0, 610>, <651, 800, 0>
      }
      
      box {
         <-800, 799, 610>, <800, 800, 0>
      }
      
      texture {
         T_Grnt0
         scale 1
         rotate x*90
      }
      
      texture {
         taches_Grande
      }
      
      texture {
         taches
      }
   }
   
   union {
      //*PMName plinthe
      
      box {
         <-750, 0, 599>, <750, 10, 600>
      }
      
      texture {
         T_StoneVnoir
      }
      scale 1
      rotate <0, 0, 0>
   }
   
   difference {
      //*PMName vitres
      
      box {
         <-410, 800, 609.5>, <-90, 200, 609>
         
         material {
            vitre
         }
      }
      
      prism {
         linear_spline
         linear_sweep
         -0.1, 0.6,
         20,
         <1.33976, 4.94769>, <1.6467, 1.2312>, <1.8765, -0.3061>, <2.6507, -1.3347>, <0.36054, 0.36667>, <0.4208, -0.45144>, <-0.40338, 0.049469>, <0.14676, -1.5482>, <-1.00673, 0.465257>, <-1.00459, -0.961918>, <-1.4368, -0.10254>, <-1.5737, -2.3316>, <-2.0822, -0.32638>, <-2.6582, -0.46956>, <-2.3615, 0.70575>, <-3.2144, 0.52293>, <-2.3757, 1.2472>, <-3.4143, 1.2072>, <-2.91474, 5.00788>, <1.33976, 4.94769>
         scale <100, 1, 100>
         rotate x*90
         translate <-154.44, 393.6, 609>
      }
   }
   
   union {
      //*PMName porte
      //*PMRawBegin
      object {
        plancheSimple(700,20)
        texture {boisBoiserieFoncee}
        rotate x*(-90)
        translate <-400,0,605>
        }
      object {
        plancheSimple(700,20)
        texture {boisBoiserieFoncee}
        rotate x*(-90)
        translate <-120,0,605>
        }
      //*PMRawEnd
      //*PMRawBegin
      object {
         planche1echardes(350,20,1)
         rotate z*(-90)
         translate <-380, 700, 605>
      }
      object {
         planche1echardes(450,20,1)
         rotate z*(-90)
         translate <-140, 700, 605>
      }
      // planche1echardes(longueur,hauteur,epaisseur)
      object {
            planche1echardes(50,20,2)
            rotate <90, 36.5, -0>
            translate <-92.0381, 0.5, 355.095>
         }
         
         object {
            planche1echardes(100,20,2)
            
            rotate <90, 64.4, 0>
            translate <-290.89, 0.5, 417.467>
         }
         
         object {
           planche1echardes(100,20,2)
            rotate <-90, 69.5, 180>
            translate <-413.418, 0.5, 554.698>
         }
      /*
      object {
         planche1echardes(100,20,2)
         rotate <-84.3, 63.4, 161.7>
         translate <-337.246, 60.6055, 547.503>
      }*/
      
      object { //porte bas gauche
         planche1echardes(200,20,2)
         rotate <-0, 19, 90>
         translate <-360, 12.603, 605>
      }
      
      object { //porte bas droite
         planche1echardes(200,20,2)
         rotate <-0, 30, 70>
         translate <-140, 12.603, 605>
      }
      //*PMRawEnd
   }
   
   union {
      //*PMName parquet
      //*PMRawBegin
      object {
        plancherCentre(1300,1000)
        translate z*(-400)
        }
      //*PMRawEnd
      
      box {
         <-650, -0.5, -400>, <650, 0.01, 600>
         
         texture {
            tachesParquet
            scale 100
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   //*PMRawBegin
   #declare largeurplanche= 20;
   #declare longueurplanche=50;
   #declare jointplanche=0.1; //demi-largeur du joint
   #declare rdBoiserie=seed(57);
   fondBoiserie(-760,-400,600)
   object {
     panneau()
     translate z*600
     translate x*(-550)
     }
   object {
     panneau()
     translate <-700,0,600>
     }
   fondBoiserie(-100,800,600)
   
   #declare xtr=-100;
   #while (xtr < (800-150))
   object {
     panneau()
     translate z*600
     translate x*xtr
     }
   #declare xtr=xtr+150;
   #end
   //*PMRawEnd
}

#declare encocheBorne = union {
   sphere {
      <0, 30, 0>, 2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 60, 0>, 2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 30, 0>, <0, 60, 0>, 2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   translate x*15
}

#declare tuyauBorne = union {
   cylinder {
      <0, 0, 0>, <20, 0, 0>, 8
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <20, 0, 0>, <25, 0, 0>, 10
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare borneIncendie = union {
   union {
      cylinder {
         <0, 20, 0>, <0, 10, 0>, 18
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 80, 0>, <0, 70, 0>, 18
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      sphere {
         <0, 80, 0>, 15
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         cylinder {
            <0, 70, 0>, <0, 20, 0>, 15
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         //*PMRawBegin
         #declare dTh=30;
         #declare thet=0;
         #while (thet <360)
         object {
            encocheBorne
            scale 1
            rotate y*thet
         }
         #declare thet=thet+dTh;
         #end
         //*PMRawEnd
      }
      
      object {
         tuyauBorne
         scale 1
         rotate z*(-22.2)
         translate <9.8022, 55.453, 0>
      }
      
      texture {
         tx_borneIncendie
      }
   }
   
   box {
      //*PMName support
      <-25, 0, -25>, <25, 10, 25>
      
      texture {
         betonImmeuble
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare boutCorde = union {
   cylinder {
      <0, 0, 0>, <0, 0, 10>, 4
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0, 0>, 4
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   torus {
      3, 0.5
      scale 1
      rotate <0, 0, 0>
      translate z*(-6)
   }
   
   texture {
      T_Copper_1C
   }
}

#declare supportCorde = union {
   cylinder {
      <0, 112, 0>, <0, 0, 0>, 4
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      //*PMName haut
      <0, 0, 0>, 4
      scale <1, 0.6, 1>
      rotate <0, 0, 0>
      translate y*112
   }
   
   intersection {
      sphere {
         //*PMName bas
         <0, 0.6, 0>, 15
         scale <1, 0.6, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-16, 0, -16>, <16, 15, 16>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   torus {
      3, 0.5
      scale 1
      rotate x*90
      translate <4, 108.5, 0>
   }
   
   texture {
      T_Copper_1C
   }
}

#declare corde = union {
   union {
      //*PMName corde
      //*PMRawBegin
       #include "cordett.inc"
      //*PMRawEnd
      
      pigment {
         color rgb <0.682353, 0, 0>
      }
   }
   
   object {
      //*PMName supportcouche
      supportCorde
      scale 1
      rotate y*(-120)
      rotate <-71.2, 6.1, -124.9>
      translate <-137.654, 15.1968, 305.466>
   }
   
   object {
      //*PMName supportDebout
      supportCorde
      scale 1
      rotate <180, 51, 180>
      translate <157.2, 0, 328.495>
   }
   
   object {
      //*PMName boutCorde1
      boutCorde
      rotate z*90
      rotate y*119.52
      translate <-90, 3.5, 200>
   }
   
   object {
      //*PMName boutCorde2
      boutCorde
      rotate <-126.8, -39.8, 174.3>
      translate <150, 100, 320>
   }
}

object {
   //*PMName appCorde
   corde
   scale 1
   rotate y*28.1
   translate <-187.545, 0, 129.341>
}

#declare tasTerre = union {
   height_field {
      png "/home/vincent/Documents/kpov/museum/terre6.png"
      scale <840, 120, 840>
      rotate <0, 0, 0>
      translate <-660, -0.2, 220>
   }
   
   texture {
      terre
   }
}

#declare tasTerre2 = union {
   object {
      tasTerre
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   //*PMRawBegin
   #include "makeTerre.inc"
   
   
   #declare Size=2; // size of the largest snow particle
   //       Sizes between 2 and 100 should be OK for objects whose size is expressed in centimetres
   
   #declare Thickness=1; // thickness of the particles
   //     
   #declare MinHeight=0; // snow starts falling from this height ( 1 = max height of the object)
   #declare MaxHeight=1.1; // snow stops falling from this height  ( 1 = max height of the object)
   //       Using MinHeight < 1 makes it possible to have snow on lower parts of the object that are protected 
   //       by overhangs, higher branches and such, but it may requires more particles to get a proper effect
   
   #declare Size=2; // size of the largest snow particle
   //       Sizes between 2 and 100 should be OK for objects whose size is expressed in centimetres
   
   #declare Thickness=0.5; // thickness of the particles
   //     
   
   #declare Direction=-y; 
   MakeSnow(tasTerre,Particles,Size,Thickness,MinHeight,MaxHeight,Direction)
   //*PMRawEnd
}

object {
   //*PMName terre
   tasTerre2
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare macro_fleurs = union {
   //*PMRawBegin
   
   #declare xmin=-650;
   #declare xmax=xmin+840;
   #declare zmin=210;
   #declare zmax=1000;
   #declare stdRotation=30;
   
   fleurs(xmin,xmax,zmin,zmax,nbfleurs,tasTerre)
   
   herbes(xmin,xmax,zmin,zmax,nbherbes,tasTerre)
   //*PMRawEnd
}

object {
   //*PMName app_macro_fleurs
   macro_fleurs
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

object {
   //*PMName batiment principal
   batiment
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare poteauImmVerre = union {
   box {
      <1480, 0, 20>, <1500, 6000, 30>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      box {
         <-53.7705, -12.732, 20>, <0, 295.84, 30>
         scale 1
         rotate z*2.2
         translate <1508.66, -5.11223e-06, 0>
      }
      
      box {
         <1480, 0, 20>, <1400, 6000, 30>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
}

#declare immeubleVerre = union {
   difference {
      box {
         <0, 0, 0>, <1500, 6000, 1500>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-10, 50, 20>, <1550, 6000, 1480>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         betonImmeuble
      }
   }
   
   union {
      //*PMName planchers
      //*PMRawBegin
      #declare hauteur=500;
      #while (hauteur<6000)
      box {
         <0, 0, -1>, <1490, 30, 1490>
         scale 1
         rotate <0, 0, 0>
         translate <0, hauteur, 0>
      }
      #declare hauteur=hauteur+300;
      #end
      //*PMRawEnd
      
      texture {
         betonBlancImmeuble
      }
   }
   
   box {
      //*PMName vitre
      <1495, 0, 20>, <1488, 6000, 1480>
      
      material {
         vitreImmeuble
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      //*PMName poteaux
      
      object {
         poteauImmVerre
         scale 1
         rotate <0, 0, 0>
         translate z*150
      }
      
      object {
         poteauImmVerre
         scale 1
         rotate <0, 0, 0>
         translate z*450
      }
      
      object {
         poteauImmVerre
         scale 1
         rotate <0, 0, 0>
         translate z*750
      }
      
      object {
         poteauImmVerre
         scale 1
         rotate <0, 0, 0>
         translate z*1050
      }
      
      object {
         poteauImmVerre
         scale 1
         rotate <0, 0, 0>
         translate z*1350
      }
   }
   translate y*(-200)
}

#declare fenetreDroite = union {
   box {
      <0, 0, 5>, <200, 100, 6>
      
      material {
         vitre
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      box {
         <0, 0, 4>, <10, 100, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <190, 0, 4>, <200, 100, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0, 0, 4>, <200, 10, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0, 100, 4>, <200, 90, 6>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
}

#declare immeubleRose = union {
   difference {
      //*PMName droite
      
      box {
         <1000, 0, 0>, <1500, 1000, 100>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName tourporte
         <1150, 0, -1>, <1350, 300, 10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName fenetre1
         <1150, 400, -1>, <1350, 500, 10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName fenetre1
         <1150, 850, -1>, <1350, 750, 10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         immeubleRosePale
      }
   }
   
   box {
      //*PMName gaucheBas
      <0, 0, -5>, <1100, 100, 150>
      
      texture {
         immeubleRosePale
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName porte
      <1200, 0, 8>, <1300, 220, 11>
      
      texture {
         boisInt
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      box {
         <0, 0, 0>, <1000, 1000, 200>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <150, 120, -0.5>, <300, 350, 10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <150, 120, -0.5>, <300, 350, 10>
         scale 1
         rotate <0, 0, 0>
         translate y*450
      }
      
      box {
         <650, 120, -0.5>, <800, 350, 10>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <650, 120, -0.5>, <800, 350, 10>
         scale 1
         rotate <0, 0, 0>
         translate y*450
      }
      
      texture {
         immeubleRoseFonce
      }
   }
   
   object {
      fenetreGauche
      scale 1
      rotate <0, 0, 0>
      translate x*150
   }
   
   object {
      fenetreGauche
      scale 1
      rotate <0, 0, 0>
      translate <150, 450, 0>
   }
   
   object {
      fenetreGauche
      scale 1
      rotate <0, 0, 0>
      translate x*650
   }
   
   object {
      fenetreGauche
      scale 1
      rotate <0, 0, 0>
      translate <650, 450, 0>
   }
   
   object {
      fenetreDroite
      scale 1
      rotate <0, 0, 0>
      translate <1150, 400, 0>
   }
   
   object {
      fenetreDroite
      scale 1
      rotate <0, 0, 0>
      translate <1150, 750, 0>
   }
   
   box {
      <0, 0, -10>, <1000, 10, 1>
      
      texture {
         immeubleRosePale
      }
      scale 1
      rotate <0, 0, 0>
      translate y*450
   }
   
   union {
      cylinder {
         <0, 0, 0>, <1500, 0, 0>, 10
         scale 1
         rotate <0, 0, 0>
         translate <0, 1000, -5>
      }
      
      cylinder {
         <0, 0, 0>, <0, 1000, 0>, 10
         scale 1
         rotate <0, 0, 0>
         translate <1490, 0, -5>
      }
      
      texture {
         zinc
      }
   }
   
   union {
      box {
         //*PMName toit
         <0, 0, 0>, <1500, 500, 500>
         scale 1
      }
      //*PMRawBegin
      #declare decal=250;
      #while (decal<1600)
      box {
         <0, 0, -20>, <20, 500, 0.5>
         scale 1
         rotate <0, 0, 0>
         translate <decal, 0, 0>
      }
      #declare decal=decal+250;
      #end
      //*PMRawEnd
      
      box {
         <0, 0, -20>, <20, 500, 0.5>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*39.8
      translate y*1000
      
      texture {
         zinc
      }
   }
   translate y*(-200)
}

#declare laGrandeFamille = box {
   <0, 0, 0>, <1, 1, 0.0001>
   
   pigment {
      image_map {
         png
         "lagrandefamilleSilhouette.png"
         map_type 0
      }
   }
   scale 4000
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

union {
   //*PMName trottoir
   
   box {
      <-1500, 0, 2050>, <-1300, 20, 6620>
      scale 1
      rotate <0, 0, 0>
   }
   
   box {
      //*PMName avdroite
      <-1450, 0, 2100>, <-2000, 20, 2050>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName avdroite
      <-350, 0, 2100>, <100, 20, 2050>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName avdroite
      <-350, 0, 2100>, <-300, 20, 15000>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName avdroite
      <30000, 0, 2100>, <-300, 20, 15000>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      //*PMName ligneBlanche
      <-850, 0, 2100>, <-830, 1, 15000>
      
      pigment {
         color rgb <1, 1, 1>
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   translate y*(-200)
   
   pigment {
      color rgb <0.784314, 0.784314, 0.74902>
   }
}

object {
   //*PMName GdeFamille
   laGrandeFamille
   scale 1
   rotate <0, 0, 0>
   translate <-3690.73, 2044.54, 20347.3>
}

union {
   //*PMName appImmeuble
   
   object {
      //*PMName imm1
      immeubleVerre
      scale 1
      rotate <0, 0, 0>
      translate <-3000, 0, 2500>
   }
   
   object {
      //*PMName imm1
      immeubleRose
      scale 1
      rotate y*(-90)
      translate <-1500, 0, 4000>
   }
   
   object {
      //*PMName imm1
      immeubleVerre
      scale 1
      rotate <0, 0, 0>
      translate <-3000, 0, 5500>
   }
   
   object {
      //*PMName imm1
      immeubleVerre
      scale 1
      rotate <0, 0, 0>
      translate <-3000, 0, 7000>
   }
   
   object {
      //*PMName palais
      gdPalais
      scale 1
      rotate y*20
      translate <-2122.53, -200, 25494.2>
   }
   
   object {
      //*PMName borne
      borneIncendie
      scale 1
      rotate <0, 0, 0>
      translate <-1448.91, -200, 4025.68>
   }
}

#declare coulArc = pigment {
   color rgb <1, 0, 0>
}

#declare arc = union {
   difference {
      cylinder {
         <0, 0, -0.5>, <0, 0, 0.5>, 100
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, -1>, <0, 0, 1>, 80
         scale <1, 0.8, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      //*PMName sup
      
      cylinder {
         <0, 0, -10>, <0, 0, 10>, 101
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, -11>, <0, 0, 11>, 100
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      //*PMName inf
      
      cylinder {
         <0, 0, -10>, <0, 0, 10>, 80
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0, -11>, <0, 0, 11>, 79
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      scale <1, 0.8, 1>
   }
   
   pigment {
      coulArc
   }
}

#declare sculture = union {
   object {
      //*PMName principal
      arc
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   intersection {
      object {
         arc
         scale 0.6
         rotate y*(-66.5)
         translate <-65.661, 0, -2.62644>
      }
      
      box {
         <-150, 0, 100>, <0, 100, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   intersection {
      object {
         arc
         scale 1
         rotate <-180, -81.7, 180>
         translate <0, 0, 0>
      }
      
      box {
         <-150, 0, -150>, <150, 150, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
}

object {
   //*PMName appSculture
   sculture
   scale <3, 4, 3>
   rotate y*33.7
   translate <0.588386, -200, 4530.18>
}

#declare chaussure = difference {
   union {
      prism {
         quadratic_spline
         linear_sweep
         0, 0.2,
         8,
         <1.3666, 0>, <0.5, 0>, <-0.4, 0.033333>, <-0.799997, 1.4667>, <-0.46666, 2.9334>, <0.43333, 3.03337>, <0.63333, 1.16667>, <0.5, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      prism {
         bezier_spline
         linear_sweep
         0, 0.2,
         12,
         <0.514349, -0.242223>, <0.104966, -0.237432>, <-0.0853664, -0.24461>, <-0.348056, -0.233844>, <-0.348056, -0.233844>, <-0.361861, -0.50068>, <-0.388953, -1.08106>, <0.0254696, -1.11846>, <0.0254696, -1.11846>, <0.64462, -1.11811>, <0.513092, -0.414731>, <0.514349, -0.242223>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      scale <1.2, 1, 1>
   }
   
   box {
      <-1, 0.1, 0.1>, <1, 0.3, 0>
      scale 1
      rotate <0, 0, 0>
      translate <-0.014017, 0, -0.9>
   }
   //*PMRawBegin
   #declare cranSemelle=2.6;
   #while (cranSemelle >0.1)
   box {
      <-1, 0.1, 0.2>, <1, 0.3, 0>
      translate <0, 0, cranSemelle>
   }
   #declare cranSemelle=cranSemelle-0.4;
   #end
   //*PMRawEnd
   scale <10, 1, 10>
   
   texture {
      terre
   }
}

object {
   chaussure
   scale 1
   rotate <0, 0, 0>
   translate <25.4592, 0, 303.206>
}

object {
   chaussure
   scale <-1, 1, 1>
   rotate <0, 0, 0>
   translate <50.9403, 0, 314.986>
}

plane {
   //*PMName sol
   <0, 1, 0>, -200
   
   texture {
      pigment {
         color rgb <0.235294, 0.235294, 0.235294>
      }
   }
}
//*PMRawBegin
#fclose dbg
//*PMRawEnd