

#declare coulPetale = pigment {
   color rgbft <1, 0, 0, 0.4, 0.4>
}

#declare coulTige = pigment {
   color rgbf <0.1451, 0.7451, 0.18431, 0.1>
}

#declare coulFeuille = pigment {
   color rgbf <0.113725, 0.584314, 0.145098, 0.1>
}

#declare coulHerbe = pigment {
   color rgb <0.337255, 0.745098, 0.133333>
}

#declare demiFeuille = intersection {
   cylinder {
      <0, 7.5, -0.05>, <0, 7.5, 0.05>, 15
      scale <0.9, 1.2, 1>
      rotate <0, 0, 0>
      translate <-9.21923, 5.00921, 0>
   }
   
   box {
      <0, 0, -0.5>, <6, 30, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare feuille = union {
   object {
      demiFeuille
      scale 1
      rotate y*30
      translate <0, 0, 0>
   }
   
   object {
      demiFeuille
      scale 1
      rotate y*130
      translate <0, 0, 0>
   }
   scale 0.6
   rotate x*19.5
   
   pigment {
      coulFeuille
   }
}

#declare petale = intersection {
   difference {
      sphere {
         <0, 0, 0>, 5
         scale <1, 1.5, 1>
         rotate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 5
         scale <1, 1.5, 1>
         scale 0.98
      }
   }
   
   union {
      prism {
         quadratic_spline
         linear_sweep
         -6, 1,
         14,
         <-0.37768, 8.6446>, <-0.12768, 8.1113>, <2.4548, 6.0306>, <4.21, 2.7046>, <4.09908, -1.9899>, <3.11932, -0.861862>, <1.24658, -1.98181>, <0.61332, -0.674583>, <-1.13958, -1.7309>, <-1.68629, -0.493751>, <-3.8506, -1.5333>, <-4.0684, 0.78631>, <-2.6708, 5.4387>, <-0.12768, 8.1113>
         scale 1
         rotate x*90
         translate <0, 0, 0>
         hollow false
      }
   }
   
   pigment {
      coulPetale
   }
   translate x*1
   rotate y*10
   translate <-0.98463, 7.5, 0.17366>
}

#declare corolle = union {
   object {
      petale
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      petale
      rotate y*60
   }
   
   object {
      petale
      rotate y*120
   }
   
   object {
      petale
      rotate y*180
   }
   
   object {
      petale
      rotate y*240
   }
   
   object {
      petale
      scale 1.05
      rotate y*300
   }
}

#declare tige = intersection {
   torus {
      60, 0.5
      scale 1
      rotate x*90
      translate x*60
   }
   
   box {
      <-1, 0, -1>, <10, 20, 1>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   pigment {
      coulTige
   }
}

#declare fleur = union {
   object {
      tige
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName f1
      feuille
      scale 1
      rotate y*(-45.2)
      translate <0, 0, 0>
   }
   
   object {
      //*PMName f2
      feuille
      scale 0.8
      rotate <180, 1.2, -180>
      translate <0.883985, 3.4822, -0.556675>
   }
   
   object {
      corolle
      scale 1
      rotate <8.9, 0.4, -5.6>
      translate <4.63659, 20.0478, -0.0982205>
   }
   rotate y*57.8
}

#declare brin_herbe = sphere_sweep {
   linear_spline,
   4,
   <0, 0, 0>,0.3
   <0, 2.66729, -0.101048>,0.2
   <0, 6, -0.707334>,0.1
   <0, 10.101, -1.97043>,0.01
   
   pigment {
      coulHerbe
   }
   scale 1
   rotate y*(-90)
}

#declare xmin=-650;
#declare xmax=xmin+840;
#declare zmin=200;
#declare zmax=600;
#declare stdRotation=30;

#macro fleurs(xmin,xmax,zmin,zmax,nbmax,surface)
#local rd=seed(24);
#local Orientation = <0,1,0>;
#local Normale_du_Point = <0,0,0>;
#declare i=0;
#declare j=0;
#while (i<nbmax & j < 4*nbmax)
  #local posx=xmin+rand(rd)*(xmax-xmin);
  #local posz=zmin+rand(rd)*(zmax-zmin);

     #local Point_Depart = <posx,-1,posz> ; 
    // #write(dbg," point ",posx," ",posz,"\n")
     #local Point_Intersection = trace (surface, Point_Depart, Orientation,Normale_du_Point);
     #if (Normale_du_Point.x != 0 | Normale_du_Point.y != 0 | Normale_du_Point.z != 0) 
      #write(dbg," fleurs point intersec ",Point_Intersection.x," ",Point_Intersection.y," ",Point_Intersection.z,"\n")
       #if (Point_Intersection.y >0.2)
        #local rotation=stdRotation*(rand(rd)-0.5);
        object {
           //*PMName apFleur
          fleur
          scale 1
          rotate <0, rotation, 0>
          translate Point_Intersection
          }
      #end
  #declare i=i+1;
  #end
  #if (mod(j,1000)=0)
    #write(dbg," fleurs intermediare points ok ",i," sur total ",j,"\n")
    #end
  #declare j=j+1;
#end 
#write(dbg," fleurs points ok ",i," sur total ",j,"\n")
#end

#macro herbes(xmin,xmax,zmin,zmax,nbmax,surface)
#local rd=seed(325);
#local Orientation = <0,1,0>;
#local Normale_du_Point = <0,0,0>;
#declare i=0;
#declare j=0;
#while (i<nbmax & j < 4*nbmax)
  #local posx=xmin+rand(rd)*(xmax-xmin);
  #local posz=zmin+rand(rd)*(zmax-zmin);

     #local Point_Depart = <posx,-1,posz> ; 
    // #write(dbg," point ",posx," ",posz,"\n")
     #local Point_Intersection = trace (surface, Point_Depart, Orientation,Normale_du_Point);
     #if (Normale_du_Point.x != 0 | Normale_du_Point.y != 0 | Normale_du_Point.z != 0) 
      
       #if (Point_Intersection.y >0.2)
        #local rotation=stdRotation*(rand(rd)-0.5);
	#write(dbg," herbes point intersec ",Point_Intersection.x," ",Point_Intersection.y," ",Point_Intersection.z,"\n")
        object {
          brin_herbe
          scale 1
          rotate <0, rotation, 0>
          translate Point_Intersection
          }
      #declare i=i+1;
      #end
  
  #end
  #if (mod(j,1000)=0)
    #write(dbg," herbes intermediare points ok ",i," sur total ",j,"\n")
    #end
  #declare j=j+1;
#end 
#write(dbg," herbes points ok ",i," sur total ",j,"\n")
#end
