#include "colors.inc"

#declare IW_ISOmaxgrad = 2.14;
#declare IW_ISOmax_trace = 2;
#declare GammaFact = 2.0;

#include "isowood3.inc"
#include "iw_textures.inc"

#declare p_rd = seed (12);
#declare b_rd = seed (7);
#declare br_rd = seed (8);
#declare be_rd = seed (5);

#declare P_Pier = pigment {
  P_IW_03
  color_map { CM_IW_Sycamore_04a }
}

#declare O_Pier_Post = object {
  IW_Cylinder_Post_Round (rand (p_rd) * 10, 0.2, 2.2, 4, 2, 0.004, 0.02, P_Pier, Fin_W, Norm_W)
  rotate x*-90
  translate y*-0.2
}

#declare O_Pier_Brace = object {
  IW_Box_Round (rand (br_rd) * 10, <-0.04, -0.125, -2.9>, <0.04, 0.125, 2.9>, 4, 2, 0.02, 0.004, P_Pier, Fin_W , Norm_W)
}

#declare O_Pier_Posts_Pair = union {
  object {
    O_Pier_Post
    translate x*-2.8
  }
  object {
    O_Pier_Post
    translate x*2.8
  }
  object {
    O_Pier_Brace
    rotate <0, 90, -12>
    translate <0, 0.6, 0.24>
  }
  object {
    O_Pier_Brace
    rotate <0, 90, 12>
    translate <0, 0.6, -0.24>
  }
}

#declare O_Pier_Bearer = object {
  IW_Box_Round (rand (be_rd) * 10, <-0.08, -0.15, -1>, <0.08, 0.15, 10.2>, 4, 2, 0.02, 0.004, P_Pier, Fin_W , Norm_W)
}

#declare O_Pier_Boards = union {
#declare boards = 1;
#while (boards < 29)
  object {
    IW_Plank_Round (rand (b_rd) * 10, 0.4, 0.08, 5.2, 4, 2, 0.02, 0.004, P_Pier, Fin_W , Norm_W)
    //IW_Plank_Round (rand (b_rd) * 10, 0.8, 0.16, 10.4, 8, 4, 0.04, 0.008, P_Pier, Fin_W , Norm_W)
    //scale 0.5
    rotate y*90
    translate <-2.6, 1.7, -1 + (0.42 * boards)>
  }
  #declare boards = boards + 1;
#end
}
