#ifdef(ChessBoard_Inc_Temp)
// do nothing
#else
#declare ChessBoard_Inc_Temp = version;

#ifdef(View_POV_Include_Stack)
#   debug "including chessboard.inc\n"
#end
                    
#include "colors.inc"         
#include "stones.inc"
#include "textures.inc"      
#include "woods.inc"         

#include "ChessPieces.inc"
#include "CheckerPieces.inc"

#declare Rod = mesh {
  //bottom
  triangle {< 0, 0, -1>     < 0, 0, 0>      <18, 0, 0>}
  triangle {< 0, 0, -1>     <18, 0, 0>      <18, 0, -1>}
  //front     
  triangle {< 0, 0, 0>      < 0, 0.4, 0>    <18, 0.4, 0>}
  triangle {< 0, 0, 0>      <17, 0, 0>      <18, 0.4, 0>}
  //front-top 
  triangle {< 0, 0.4, 0>    < 0, 0.5, -0.1> <18, 0.5, -0.1>}
  triangle {< 0, 0.4, 0>    <18, 0.4, 0>    <18, 0.5, -0.1>}
  //top       
  triangle {< 0, 0.5, -0.1> <18, 0.5, -0.1> <18, 0.5, -1>}
  triangle {< 0, 0.5, -0.1> < 0, 0.5, -1>   <18, 0.5, -1.0>}
  //back      
  triangle {< 0, 0.5, -1>   < 0, 0.0, -1>   <18, 0.0, -1>}
  triangle {< 0, 0.5, -1>   <18, 0.5, -1>   <18, 0.0, -1>}
  //left 
  triangle {< 0, 0, 0>      < 0, 0, -1>     < 0, 0.4, -1>}
  triangle {< 0, 0, 0>      < 0, 0.4, 0>    < 0, 0.4, -1>}
  triangle {< 0, 0.4, 0>    < 0, 0.4, -0.1> < 0, 0.5, -0.1>}
  triangle {< 0, 0.4, -0.1> < 0, 0.5, -0.1> < 0, 0.5, -1>}
  triangle {< 0, 0.4, -0.1> < 0, 0.4, -1>   < 0, 0.5, -1>}
  //right
  triangle {<18, 0, 0>      <18, 0, -1>     <18, 0.4, -1>}
  triangle {<18, 0, 0>      <18, 0.4, 0>    <18, 0.4, -1>}
  triangle {<18, 0.4, 0>    <18, 0.4, -0.1> <18, 0.5, -0.1>}
  triangle {<18, 0.4, -0.1> <18, 0.5, -0.1> <18, 0.5, -1>}
  triangle {<18, 0.4, -0.1> <18, 0.4, -1>   <18, 0.5, -1>}
  }
                   
#declare Border = union {                      
  object {
    Rod
    translate <-1, 0, 0>
    }
  object {
    Rod
    rotate <0, 90, 0>
    translate <0, 0, 17>
    }                  
  object {
    Rod
    rotate <0, 180, 0>
    translate <17, 0, 16>
    }                   
  object {
    Rod
    rotate <0, 270, 0>
    translate <16, 0, -1>
    }
  pigment {
    Jade
    scale 0.5
    }
  finish {
    ambient 0.1
    diffuse 0.6
    phong 0.6
    phong_size 7
    reflection 0.9
    }
  }
          

#declare White_Square = box {
  < 0, 0, 0>, <2, 0.5, 2>
  }
  
#declare Black_Square = box {
  < 0, 0, 0>, <2, 0.5, 2>
  }
  
#declare White_Squares = union {
  object {White_Square translate < 2, 0,  0>}
  object {White_Square translate < 6, 0,  0>}
  object {White_Square translate <10, 0,  0>}
  object {White_Square translate <14, 0,  0>}
  object {White_Square translate < 0, 0,  2>}  
  object {White_Square translate < 4, 0,  2>}
  object {White_Square translate < 8, 0,  2>}
  object {White_Square translate <12, 0,  2>}
  object {White_Square translate < 2, 0,  4>}
  object {White_Square translate < 6, 0,  4>}
  object {White_Square translate <10, 0,  4>}
  object {White_Square translate <14, 0,  4>}
  object {White_Square translate < 0, 0,  6>}  
  object {White_Square translate < 4, 0,  6>}
  object {White_Square translate < 8, 0,  6>}
  object {White_Square translate <12, 0,  6>}
  object {White_Square translate < 2, 0,  8>}
  object {White_Square translate < 6, 0,  8>}
  object {White_Square translate <10, 0,  8>}
  object {White_Square translate <14, 0,  8>}
  object {White_Square translate < 0, 0, 10>}  
  object {White_Square translate < 4, 0, 10>}
  object {White_Square translate < 8, 0, 10>}
  object {White_Square translate <12, 0, 10>}
  object {White_Square translate < 2, 0, 12>}
  object {White_Square translate < 6, 0, 12>}
  object {White_Square translate <10, 0, 12>}
  object {White_Square translate <14, 0, 12>}
  object {White_Square translate < 0, 0, 14>}  
  object {White_Square translate < 4, 0, 14>}
  object {White_Square translate < 8, 0, 14>}
  object {White_Square translate <12, 0, 14>}
//  pigment {color White}
  texture {
    T_Wood9 
    scale 1.0
    }
  finish {
    ambient 0.1
    diffuse 0.6
    phong 0.6
    phong_size 7
    reflection 0.5
    }
  }

#declare Black_Squares = union {
  object {Black_Square translate < 0, 0,  0>}
  object {Black_Square translate < 4, 0,  0>}
  object {Black_Square translate < 8, 0,  0>}
  object {Black_Square translate <12, 0,  0>}
  object {Black_Square translate < 2, 0,  2>}
  object {Black_Square translate < 6, 0,  2>}
  object {Black_Square translate <10, 0,  2>}
  object {Black_Square translate <14, 0,  2>}
  object {Black_Square translate < 0, 0,  4>}
  object {Black_Square translate < 4, 0,  4>}
  object {Black_Square translate < 8, 0,  4>}
  object {Black_Square translate <12, 0,  4>}
  object {Black_Square translate < 2, 0,  6>}
  object {Black_Square translate < 6, 0,  6>}
  object {Black_Square translate <10, 0,  6>}
  object {Black_Square translate <14, 0,  6>}
  object {Black_Square translate < 0, 0,  8>}
  object {Black_Square translate < 4, 0,  8>}
  object {Black_Square translate < 8, 0,  8>}
  object {Black_Square translate <12, 0,  8>}
  object {Black_Square translate < 2, 0, 10>}
  object {Black_Square translate < 6, 0, 10>}
  object {Black_Square translate <10, 0, 10>}
  object {Black_Square translate <14, 0, 10>}
  object {Black_Square translate < 0, 0, 12>}
  object {Black_Square translate < 4, 0, 12>}
  object {Black_Square translate < 8, 0, 12>}
  object {Black_Square translate <12, 0, 12>}
  object {Black_Square translate < 2, 0, 14>}
  object {Black_Square translate < 6, 0, 14>}
  object {Black_Square translate <10, 0, 14>}
  object {Black_Square translate <14, 0, 14>}
//  pigment {color Black}
  texture {
    T_Wood32
    scale 1.0
    }    
  finish {
    ambient 0.1
    diffuse 0.6
    phong 0.6
    phong_size 7
    reflection 0.5
    }        
  }
  
#declare Board = union {
  object {
    Border
    translate <-5, 0, -1>
    }          
  object {
    White_Squares
    translate <-5, 0, -1>
    }
  object {
    Black_Squares
    translate <-5, 0, -1>
    }
  }
           
#declare Blank_Piece = sphere{<0,0,0> 0}                  
                
#macro ChessBoard(pieces)
  object {Board}
  #local i = 0;
              
  #while (i < 8)
    #local j = 0;
    #while ( j < 8) 
      #switch (pieces[i][j])
        #case (B_PAWN)
          #object {Black_Pawn translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_PAWN)
          #object {White_Pawn translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_ROOK)
          #object {Black_Rook translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_ROOK)
          #object {White_Rook translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_KNIGHT)
          #object {Black_Knight translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_KNIGHT)
          #object {White_Knight translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_BISHOP)
          #object {Black_Bishop translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_BISHOP)
          #object {White_Bishop translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_QUEEN)
          #object {Black_Queen translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_QUEEN)
          #object {White_Queen translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_KING)
          #object {Black_King translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (W_KING)
          #object {White_King translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (B_CHECKER)
          #object {Black_Checker translate <(i * 2) - 4,.5,(j * 2)>}
        #break
        #case (R_CHECKER)
          #object {Red_Checker translate <(i * 2) - 4,.5,(j * 2)>}
        #break
      #end
    
      #local j = j + 1;
    #end
    #local i = i + 1;
  #end                
#end                
                   
                 
#version ChessBoard_Inc_Temp;
#end
                  