// tables.inc

// This file describes various types of tables
                
#include "Woods.inc"     
#include "Stones.inc"           
                     
#local table_width = 20;                     

#local Leg2 = union
  {
  box
    {
    <2,36,2><-2,30,-2>
    }
  lathe
    {
    cubic_spline
    10
    <0.00,30.00>
    <1.75,30.00>
    <2.00,18.00>
    <1.50,11.00>
    <2.00,10.50>
    <1.50,10.00>
    <1.50, 8.00>
    <1.70, 7.50>
    <1.25, 6.00>
    <0.00, 6.00>    
    }
  box
    {
    <2,6,2><-2,2,-2>
    }                 
         
         
  intersection
    {         
    difference
      {   
      union
        {           
        box
          {
          <-15,0,-0.5> <15,5,0.5>
          }                      
         
        box
          {
          <-0.5,0,-15> <0.5,5,15>
          }  
        }
      sphere {<0,-6,0> 9}
      }
    sphere {<0,-10,0> 15}
    }
             
  texture {
    T_Wood13
    scale 1.0
    }    
  }
                                                                  
#local Leg1 = union
  {                  
  box 
    {
    <2,0,2><-2,-6,-2>
    }
  
  lathe
    {
    cubic_spline
    // quadratic_spline
    // linear_spline   
    10
    <0.00,   0.00>
    <1.75,   0.00>
    <2.00, -15.00>
    <1.50, -32.00>
    <2.00, -32.50>
    <1.50, -33.00>
    <1.50, -35.00>
    <1.70, -35.50>
    <1.25, -36.00>
    <0.00, -36.00>    
    }       
    
  cone
    {
    <0.00, -36.00, 0.00> 1.25
    <0.00, -35.00, 0.00> 1.00
    }
  
  texture {
    T_Wood13
    scale 1.0
    }    
  
  }
  
  
#local TableBox = union
  {   
  box
    {
    <0.0,0.0,0.5><table_width, -5.0, -0.5>
    texture 
      {
      T_Wood13
      scale 1.0  
      rotate <0,90,0>
      }
    }  
  box
    {
    <0.0,0.0,table_width + 0.5><table_width, -5.0, table_width - 0.5>
    texture 
      {
      T_Wood13
      scale 1.0  
      rotate <0,90,0>
      }
    }         
  box
    {
    <0.5, 0.0, 0.0> <-0.5, -5.0, table_width>
    texture 
      {
      T_Wood13
      scale 1.0  
      }
    }
  box
    {
    <table_width + 0.5, 0.0, 0.0> <table_width - 0.5, -5.0, table_width>
    texture 
      {
      T_Wood13
      scale 1.0  
      }
    }
  }             
  
#local TableTop1 = cone
  {
  <0,0,0> table_width * .95
  <0,-0.75,0> table_width * .95 
  texture
    {
    T_Grnt2
    }
  }             
        
#local TableTop2 = cone
  {
  <0,36,0> 12
  <0,36.75,0> 12
  texture
    {
    T_Grnt2
    }
  }        
             
             
#declare Table = union
  {
  object 
    {
    TableBox
    translate <- table_width / 2,-0.75,- table_width / 2>
    }             
  object
    {
    TableTop1
    }
  object
    {
    Leg1    
    translate <- table_width / 2,-0.75,- table_width / 2>
    }
  object
    {
    Leg1
    translate <table_width,0,0>
    translate <- table_width / 2,-0.75,- table_width / 2>
    }
  object
    {
    Leg1
    translate <table_width,0,table_width>
    translate <- table_width / 2,-0.75,- table_width / 2>
    }
  object
    {
    Leg1
    translate <0,0,table_width>
    translate <- table_width / 2,-0.75,- table_width / 2>
    }

  }             
  
  
        
#declare small_table = union
  {
  object
    {
    Leg2
    }
  object
    {  
    TableTop2
    }
  }        