//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//      Easter Finest
//      
//  (C) 2005, M Daugherty
//  gromit@ix.netcom.com
//  
//  Submitted for the IRTC Ray Tracing Competition
//  January - February 2005, "Out of Place"
//    
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  Primary scene file 
//  Feb 28, 2005
//
//  Requires 
//      Moai.inc    - Std moai
//      Moai_S.inc  - Smiling moai
//      Base.inc    - Moai base (used for collision detection
//      Blades.inc  - Grass blades
//      Shades.inc  - sunglasses
//
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  You are free to use this for 
//  non-commercial purposes as long as 
//  you include attribution to original author.
//  All other rights reserved.
//                          
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                            

//%%%%%%%%%%%%% Declarations & Options %%%%%%%%%%%%%%%%%%%
//

                                            
#version 3.6;                                            

#include "colors.inc"
#include "math.inc"
#include "skies.inc"


// Option Settings
//

#declare Include_Fog    = 1;  
#declare Include_Moai   = 1;
#declare Lights_Num     = 2;
#declare Camera_Num     = 1;
#declare Rugged_Hill    = 1; 
#declare Grass_On       = 1;
#declare Grass_Dense    = 1;   // 0 for test, 1 for final


// Global Settings and Radiosity
//
global_settings {   
    assumed_gamma 1.0
    
}


// Lights
//
#switch (Lights_Num)
    
    // Test light
    #case (1)
    light_source { 
         <30, 40, 50> 
         color rgb<1.7,1.5,1.2*.8>
         parallel point_at 0
    }
    #break
    
    // Light used for final render
    #case (2)
    light_source { 
         <25, 80, 40> * 100
         color rgb<1.7,1.5,1.2>
         parallel point_at 0
    }
   
    #break
    
#end // switch (Lights_Num)


// Camera
//

#switch (Camera_Num)
    
    // Camera used for final render
    #case (1)
    camera {
        //
        //location <1.5,1,4-.0001>
        location <1.6,1.1,4-.0001>
        look_at <-6.2,2.3,0>
        angle 48
    }
    # break
 
    
    // Birds Eye
    #case (2)
    camera {
        
        location <-12,35,-5>
        look_at  <-12,5,-5>

    }
    # break
    
    // Birds Eye 2
    #case (3)
    camera {
        
        location <-3,15,0>
        look_at  <-3,5,0>
        angle 30
    }
    # break
    
#end


//%%%%%%%%%%%%% Start Scene  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//

// Sky Sphere
sky_sphere {
    pigment {
        gradient y color_map {
            [0.0 White]
            [0.45 rgb <0.02, 0.02, 0.5568>]
            
        }
    }                
}


// Plane with clouds
plane {y,1500 hollow texture {T_Cloud1 translate <15,0,35> scale 75} scale 4 no_shadow}



// Ocean 
// 
#declare SeaLevel = -20;
#declare t_Ocean =
texture {
    pigment { Blue }
}    


plane {y,SeaLevel pigment {Blue} } 



// Ground Haze
//
#if (Include_Fog)

fog {
    distance 1000
    color rgbf <0.8, 0.8, 0.8, .6>
    fog_type 2
    fog_offset SeaLevel // constant below
    fog_alt 5
    up y
}

#end // if (Include_Fog)


// Sloped Hillside
//
#declare t_SlopedHill = 
texture {
    pigment {
        granite color_map {
            [0.00 color rgb <0.45, 0.40, 0.35>]
            [0.10 color rgb <0.40, 0.35, 0.20>]
            [0.25 color rgb <0.200, 0.20, 0.10>]
            [0.40 color rgb <0.12, 0.12, 0.03>]
            [0.80 color rgb <0.02, 0.02, 0.00>]
        }
        scale 1
        turbulence 0.24    
    
    }
    normal {crackle 0.5}
    
}    

#declare t_SlopedHill = texture{pigment{rgb <0.07,.04,.02>}}

#declare Funct = function {
    sqrt(pow(x,2) + pow(z,2)) + y  
    
    #if (Rugged_Hill)  // Adds some roughness (and render time)
    +f_bumps(x*3.3,0,z*3.3)*f_granite(x*.70,0,z*.75)*.20
    #end // if (Rugged_Peak)
}


#declare Iso = isosurface {
    function {Funct(x,y-1,z) }
        
    contained_by { box { <-1,0,-1>, <1,1,1> } }
    max_gradient 2
  
    scale <300,130,300> 
    texture {t_SlopedHill}
    translate <-10,-4.30,-280>
}

object{Iso }


// %%%%%%%%%%%%%%%%%%%% Place the Moai %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 


// Position for each Moai
#declare Moai_pos1 =  < -2.75, 0.15, 0>;
#declare Moai_pos2 =  < -5.50, 0.15, 0>;
#declare Moai_pos3 =  <-10.00, 0.15, 0.085>;
#declare Moai_pos4 =  <-16.25, 0.15, 0>;

#if (Include_Moai)

#declare t_Moai1 =    
texture {
        pigment{
            granite color_map {
                [0.0 Gray15]
                [0.6 Gray05]
                [0.85 Gray05]
                [0.9 Black]
            }    
            scale .2
            turbulence 0.58
        }
      normal {granite 1.25 scale 0.10}
      finish {ambient 0.05 diffuse 0.7}
    }
    

#declare t_Moai2 =
texture{
    pigment {
        bozo pigment_map {
            [0.0 
                agate color_map {
                        [0.0 White transmit 1.00]
                        [0.5 Gray45 transmit 0.65]
                     }
                scale 1
            ]
            [0.5 White transmit 1.00]
            [0.7 
                agate color_map {
                        [0.0 White transmit 1.00]
                        [0.5 Black transmit 0.65]
                     }
                scale 1
            ] 
        }    
        scale .15
    }    
    normal {granite 1.25 scale 0.10}
}
   
   
#declare t_Moai3 =
texture {
    pigment {
        agate pigment_map {
                [0.0 
                    spotted
                     color_map {
                        [0.0 rgb <0.55, 0.651, 0.42> transmit 0.5]
                        [0.4 rgb <0.5, 0.51, 0.38> transmit 0.75]
                        [0.9 Gray35 transmit 1.00]
                     }
                     scale 0.015]
                [0.5 Gray25 transmit 1.00]
                [0.85 Green transmit 1.00]
                //[0.7 rgb <.5,.25,.25>]
            }
            turbulence 0.12
    } 
    
}

#declare t_Moai =  // Declare texture for mesh
texture
{t_Moai1
}
texture
{t_Moai2
}
texture
{t_Moai3
} 

#declare t_Moai =  // Declare texture for mesh
texture
{t_Moai 
scale 10
translate <-.5,.75,30>
}


#declare Moai = 
union {
    #include "Moai.inc"  // Read from include
    object {Nose}
    object {Ears}
    object {Base}
    object {Head}
    scale .10
}

// First moai on the Left
object{Moai
    rotate 3*x
    translate Moai_pos1
}                


// Redeclare texture to allow a shift in coords
#declare t_Moai =  // Declare texture for mesh
texture
{t_Moai
translate <1,2,3>
}

#declare Moai = 
union {
    #include "Moai.inc"  // Read from include
    object {Nose}
    object {Ears}
    object {Base}
    object {Head}
    scale .10
}


// Second moai
object{Moai
    rotate 3*x
    translate Moai_pos2
}

// Redeclare texture to allow a shift in coords
#declare t_Moai =  // Declare texture for mesh
texture
{t_Moai
translate <-45,2,13>
}

#declare Moai = 
union {
    #include "Moai.inc"  // Read from include
    object {Nose}
    object {Ears}
    object {Base}
    object {Head}
    scale .10
}


// Fourth moai
object{Moai
    rotate 3*x
    translate Moai_pos4
}


// Redeclare texture to allow a shift in coords
#declare t_Moai =  // Declare texture for mesh
texture
{t_Moai
translate <12,2,23>
}

#declare MoaiS = 
union {
    #include "Moai_S.inc"  // Read from include
    object {Nose}
    object {Ears}
    object {Base}
    object {Head}
    scale 0.10
}


// The shades

#declare t_Lens = texture {
    gradient y texture_map {
        // Bottom of lens

        [0.3 pigment {rgb <0.05,.05,.03> transmit 0.25} 
           finish { specular 0.9 roughness 0.02 } 
        ]   
        
        // Top of lens
        [0.6 pigment {rgb <.2,.2,.2> transmit 0.35}   
           finish { reflection {rgb <0,0,0>*.25} ambient 0 diffuse 0.2}//  } 
        ]    
        }
    translate -1.5*y
    scale 0.76    
}


#declare t_Frame = texture{
    pigment {Black}
    finish { specular 0.9 roughness 0.02 }
}


#declare Shades = 
union {    
    #include "Shades.inc"
    object{Lens}
    object{FrontFrame}
    object{SideFrame}
    scale 0.10
}


// The Outsider!
union {
    object{MoaiS}
    object{Shades 
        translate  <0,0,-0.085>
    }
    rotate 12*y
    rotate 0*x
    translate Moai_pos3
}
                   

#end // if (Include_Moai) 



// %%%%%%%%%%%%%%%%%%%% Grass on Hillside %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


#if (Grass_On)

#declare BBlade1 = array[11]; // Temps used for copying mesh
#declare BBlade2 = array[11]; //
#declare BBlade3 = array[11]; //


// Declare array of grass textures
#declare t_Blade = array[11];
#declare f_Grass = finish {ambient 0.05 diffuse 0.7 specular 0.9 roughness 0.08}

#declare t_Blade[0]  = texture{pigment{ rgb<0.980, 0.620, 0.200>} finish { f_Grass}}
#declare t_Blade[1]  = texture{pigment{ rgb<0.974, 0.656, 0.170>} finish { f_Grass}}
#declare t_Blade[2]  = texture{pigment{ rgb<0.968, 0.692, 0.140>} finish { f_Grass}}
#declare t_Blade[3]  = texture{pigment{ rgb<0.962, 0.728, 0.110>} finish { f_Grass}}
#declare t_Blade[4]  = texture{pigment{ rgb<0.956, 0.764, 0.080>} finish { f_Grass}}

#declare t_Blade[5]  = texture{pigment{ rgb<0.950, 0.900, 0.050>} finish { f_Grass}}
#declare t_Blade[6]  = texture{pigment{ rgb<0.840, 0.880, 0.050>} finish { f_Grass}}
#declare t_Blade[7]  = texture{pigment{ rgb<0.730, 0.860, 0.050>} finish { f_Grass}}
#declare t_Blade[8]  = texture{pigment{ rgb<0.620, 0.840, 0.050>} finish { f_Grass}}
#declare t_Blade[9]  = texture{pigment{ rgb<0.510, 0.820, 0.050>} finish { f_Grass}}
#declare t_Blade[10] = texture{pigment{ rgb<0.400, 0.800, 0.050>} finish { f_Grass}}


// Lookup table for grass color - weighted, but with some "turbulent" entries

#declare GrassColor = array[22] {0,1,1,0,2, 5,3,2,4,6, 5,5,6,4,5, 7,6,8,10,9, 9,10}
 

light_group {
    light_source{    
         <5, 8, 4>  
         color rgb<1.7,1.5,1.2>*0.225
         shadowless
    }
    
    #declare Index = 0;
    #while (Index < 11)
        #declare t_Blade1 = t_Blade[Index];
        #declare t_Blade2 = t_Blade1;
        #declare t_Blade3 = t_Blade1;
         
        #include "Blades.inc"
        
        #declare BBlade1[Index] = object{Blade1 scale <.05, .025, .05> scale 2}; //<.07,.10*.67,.07>};
        #declare BBlade2[Index] = object{Blade2 scale <.05, .025, .05> scale 2}; //<.07,.10*.67,.07>};
        #declare BBlade3[Index] = object{Blade3 scale <.05, .025, .05> scale 2}; //<.07,.10*.67,.07>};
        
        #declare Index = Index + 1;
    #end    
    
    #declare fn_Pigm=function {
        pigment {
            //leopard
            bozo
            color_map {
                [0 color rgb 0]
                [1 color rgb 1]
            }
            scale 1.0
        }
    }
    
    #declare fn_Pigm2=function {
        pigment {
            bozo
            color_map {
                [0 color rgb 0]
                [1 color rgb 1]
            }
            scale 0.15
            turbulence 0.15
        }  
    }
    
    
    // Declare copy of Moai bases for checking grass placement
    
    #declare t_Base = texture {pigment {Red}}
    #include "Base.inc"
    
    #declare BaseCheck = 
    union {
        object {Base scale 0.105 translate Moai_pos1}
        object {Base scale 0.105 translate Moai_pos2}
        object {Base scale 0.105 translate Moai_pos3}
        object {Base scale 0.105 translate Moai_pos4}

    }    
    
    //object{BaseCheck}
    
    // Set X,Z parameters for placing grass
    #declare XMin = -50; // was -48
    #declare XMax = 2;  // was 2
    #declare ZMin = -36;// was -36
    #declare ZMax = 4;  // was 4
    
    #declare Mesh = .5;  // default interval between steps
    
    #declare R1 = seed(1343);
    #declare R2 = seed(36236);
    #declare R3 = seed(14);
    
    #declare XCount = XMin;
    #while (XCount < XMax)
        #declare ZCount = ZMin;
        #while (ZCount < ZMax)
            
            #if (Grass_Dense)
                // Adjust mesh size by location
                #switch (XCount + ZCount)
                #range (0,100)
                    #declare Mesh = .05; // was .05
                #break
                #range (-10,0)
                    #declare Mesh = .08; // was .08
                #break
                #range (-20,-10)
                    #declare Mesh = .10; // was .10
                #break
                #range (-30,-20)
                    #declare Mesh = .10; // was .12
                #break
                #else 
                    #declare Mesh = .12; // was .15
                #break
                #end     
            
            #else    // if (Grass_Dense)
                // use a standard mesh
                #declare Mesh = .12;  // was 0.15
            #end    // if (Grass_Dense)
            
            // Find intersection of vertical ray and hillside 
            #declare Norm = <0, 0, 0>; 
            #declare Start = <XCount, 200, ZCount>; 
            #declare Inter = trace ( Iso, Start, -y, Norm ); 
            
            #if (vlength(Norm)!=0)   // Test for valid intersection
                
                // Check for intersection with base of Moai
                #declare Norm2 = <0,0,0>;
                #declare Inter2 = trace (BaseCheck,Start,-y, Norm2);
                
                #if (vlength(Norm2) = 0)
                    #declare Index1 = int(fn_Pigm(XCount,0,ZCount).gray*21);  // Was 10
                    #declare Index = GrassColor[Index1];
                    #declare Height = 1 * (0.5*fn_Pigm(XCount,0,ZCount).gray + 0.2*fn_Pigm2(XCount,0,ZCount).gray);
                    
                    //sphere{0,.015 texture{t_Blade[Index]} translate Inter+<rand(R1)*.10, 1.2*(Height+0.2)+0.25*(rand(R2)-.5), rand(R3)*.10> }

                            
                    object {BBlade1[Index] rotate <45*rand(R2),rand(R1)*360,0> translate Inter+<rand(R1)*.10, 1.2*(Height+0)+0.05*(rand(R2)-.5), rand(R3)*.10> }
                    object {BBlade2[Index] rotate <45*rand(R2),rand(R1)*360,0> translate Inter+<rand(R1)*.10, 1.2*(Height+0)+0.05*(rand(R2)-.5), rand(R3)*.10> }
                    object {BBlade3[Index] rotate <45*rand(R2),rand(R1)*360,0> translate Inter+<rand(R1)*.10, 1.2*(Height+0)+0.05*(rand(R2)-.5), rand(R3)*.10> }
                #end   // If (vlength(Norm2) = 0)    
    
                
            #end // if (vlength(Norm)!=0)
            
            #declare ZCount = ZCount + Mesh;
        #end // while (ZCount <ZMax)
        
        #declare XCount = XCount + Mesh;
    #end // while (ZCount <ZMax)

}  // light_group

#end // If (Grass_On)           