// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1

#include "colors.inc"
#include "functions.inc"
#include "textures.inc"	// Standard Texture definitions
#include "SKIES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODS.INC"
#include "GLASS.INC"  
#include "tree20010426031646_12.inc"


global_settings
{
  assumed_gamma 1.0 
  radiosity{}
  max_trace_level 20
}

sky_sphere
{
S_Cloud4
}

fog
{
  fog_type   2
  distance   200 
  fog_offset 0
  fog_alt    4
  color      rgb <0.5, 0.5, 1>
  turbulence 1.5
}


camera
{
  location  <0.0, 1.7, 20>
  direction z
  right     4/3*x
  look_at   <0.0, 0.0,  50.0>
}


light_source
{
  0*x
  color rgb< 1.5, 1.5, 1.2>
  translate <-30000, 10000, 5000>
}


#declare wetrust = texture{
        pigment{granite 
              color_map {
                      [0.0, 0.7   color rgb <0., 0.0, 0.>
                                      color rgb <0.1, 0.05, 0.02>]
                      [0.7, 0.9   color rgb <0.2, 0.1, 0.05>
                                      color rgb <0.25, 0.15, 0.1> ]
                      [0.9, 1.0 color rgb <0.3, 0.2, 0.2>
                                      color rgb <0.3, 0.2, 0.2>]
              }
        }
        normal{bumps 0.1 scale 0.001}
        scale 0.05        
}

#declare peelredpaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.6   color rgb <1, 0.3, 0.3>
                                      color rgb <1, 0.3, 0.3>]
                      [0.6, 1   color rgbt <0, 0, 0, 1>
                                      color rgbt <0, 0, 0, 1> ]
              }
              scale 8
        }
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}

#declare Fgranite = function { 
    pigment { granite color_map { [0 rgb 1] [1 rgb 0] }}
} 

#declare isowaves = isosurface {
  function{y - Fgranite(x,0,z).gray - 0.01*Fgranite(100*x, 0, 100*z).gray} 
  threshold 0  
  max_gradient 500
  texture{ 
        pigment{
                agate
                color_map {
                        [0.0, 0.01   color rgb <1.5, 1.5, 1.5>
                                        color rgb <1.5, 1.5, 1.5>]
                        [0.01, 0.1   color rgbf <0.7, 0.7, 0.7, 0.1>
                                        color rgbf <0.1, 0.2, 0.1, 0.1> ]
                        [0.1, 1.0    color rgbf <0.1, 0.2, 0.1, 0.1>
                                        color rgbf <0.0, 0.1, 0.0, 0.1>]
                }
                turbulence 2
                scale 0.01
        
        } 
        finish{reflection 0.2}
  }
}

#declare foam = sphere {<0, 0, 0> 1 scale<1, 0.5, 1> 
  texture{pigment{
          agate            // any pattern
          color_map {
                        [0.0, 0.1   color rgb <2, 2, 2>
                                        color rgb <0.9, 0.9, 0.9>]
                        [0.1, 0.3   color rgbt <0.9, 0.9, 0.9, 0.5>
                                        color rgbt <0.5, 0.5, 0.5, 0.5> ]
                        [0.3, 1.0    color rgbt <0.5, 0.5, 0.5, 1>
                                        color rgbt <0.0, 0.0, 0.0, 1>]
           }
           turbulence 1
           scale 0.2
          }
  }
}



object{isowaves  scale <1000, 8, 1000> translate<0, -4, 900>}
object{tree20010426031646_12 rotate <0, 40, 0> translate<0, -1.8, 50>}
object{foam scale 0.6 translate <0, -1.7, 50>}
text {
  ttf "times.ttf", "Henze 2005", 0.1, 0 
  scale 0.15  
  rotate <10, 0, 0>
  translate <-2, 0, 23.2>
  texture{pigment{
          agate            // any pattern
          color_map {
                        [0.0, 0.1   color rgb <2, 2, 2>
                                        color rgb <0.9, 0.9, 0.9>]
                        [0.1, 0.3   color rgbt <0.9, 0.9, 0.9, 0.5>
                                        color rgbt <0.5, 0.5, 0.5, 0.5> ]
                        [0.3, 1.0    color rgbt <0.5, 0.5, 0.5, 1>
                                        color rgbt <0.0, 0.0, 0.0, 1>]
           }
           turbulence 1
           scale 0.02
          }
  }
}
