// Persistence of Vision Ray Tracer Scene Description File
// File: rm_tma.pov
// Vers: 3.6
// Desc: The Misused Aquarium
// Date: 21st February 2005
// Auth: Roland Muenger

#include "tma_textures.inc"
#include "tma_palm.inc"
#include "tma_tomtree.inc" 
#include "tma_furniture.inc"
#include "tma_heli.inc"
#include "tma_head.inc"
#include "tma_aquarium.inc"

global_settings {assumed_gamma 1.0}
global_settings {charset utf8 }
global_settings {ambient_light 1.0} 

camera {location <0,0,-40> look_at <0,0,0> right 0.3333}

light_source {<3000,10000,-7000> color<1,1,1>*1.75}

//Himmel
sky_sphere { 
        pigment {Himmel}      
        pigment {Wolken}
        translate -0.9 scale 1.515}

//Berge
difference{
        height_field {tga "Berge.tga"
                smooth
                pigment{Berge}
                translate <-.5, -.5, -.5> scale <17, 1.75, 17>*700 rotate<-30,0,10>
                translate<0,-2400,4000> rotate<0,0,4> translate<150,1000,0>}
        plane{y,-1}
        plane{x,-1000}}

//Terrasse 
union{
        box{<-2.7,-100,-50><10,-12,-5>} 
        box{<-3,-100,-50><-2.7,-10.15,-5>}
        box{<-3,-100,-5><50,-10.15,-4.7>}
        difference{
                cylinder{<-3,-12,-5>,<-3,-10.75,-5>,2.8 }
                plane{x,-3.1} 
                plane{z,-5.1} translate<3,0,5> rotate<0,90,0> translate<-3,0,-5>}
        texture {pigment {Terrasse} finish{Stein}}}

//Palme        
object{Tree scale 6 rotate<0,330,0> translate<0.75,-10.75,-5.8>}        

//Topf
union{
        sor {
                6,
                <4.75, 0.0>
                <5.0, 0.0>
                <5.1, 1.9>
                <4.6, 4.8>
                <4.10,6.8>
                <4.0,6.8>
                open
                rotate<180,0,0> translate<0,3,0> scale <1,1.333,1>}
        torus{4.75,0.275 translate<0,4.2,0> }
        disc { <0, 0, 0>, y, 4.75, 0 translate<0,3.6,0> pigment{Erde}}
        rotate<0,0,0> scale 0.16 translate <0.7,0-11.1,-5.8> pigment{Topf}}

//Terrassenboden
#declare Tile =
superellipsoid{<0.05,0.05> texture{Boden} 
                           rotate <90,0,0> scale 0.5 scale <1,1,0.25>*0.99 }          
#declare BTile = 0;
#while (BTile < 27)
#declare ATile = 0;
#while (ATile < 27)
        object{Tile translate<-5+(1*BTile),-5+(1*ATile),0> rotate<90,0,0> scale 0.5
                                                           translate<0,-12,-15> }  
#declare ATile = ATile+1;   
#end    
#declare BTile = BTile+1;   
#end

//----------------------------------------------------------------------------------------------------             

//Rundhaus
difference{ 
        cylinder{<0,-100,0>,<0,15,0>,6} 
#declare ACount = 0;
#while (ACount < 6)
        box{<-6.25,-101,-0.25><-5.25,16,0.25> rotate<0,(ACount*-45)-22.5,0> }
#declare ACount = ACount+1;
#end
 
#declare CCount = 0;
#while (CCount < 9)    
    #declare BCount = 0;
    #while (BCount < 5)
        box{<-6.25,(CCount*-1)+13.70,-0.32><-5.99,(CCount*-1)+14.55,0.32> rotate<0, 15+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)+ 3.65,-0.32><-5.99,(CCount*-1)+4.50,0.32> rotate<0, 15+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)- 6.40,-0.32><-5.99,(CCount*-1)-5.55,0.32> rotate<0, 15+(BCount*-7.5),0>
        texture{Fensterglas}} 

        box{<-6.25,(CCount*-1)+13.70,-0.32><-5.99,(CCount*-1)+14.55,0.32> rotate<0,-30+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)+ 3.65,-0.32><-5.99,(CCount*-1)+4.50,0.32> rotate<0,-30+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)- 6.40,-0.32><-5.99,(CCount*-1)-5.55,0.32> rotate<0,-30+(BCount*-7.5),0>
        texture{Fensterglas}}
    
        box{<-6.25,(CCount*-1)+13.70,-0.32><-5.99,(CCount*-1)+14.55,0.32> rotate<0,-75+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)+ 3.65,-0.32><-5.99,(CCount*-1)+4.50,0.32> rotate<0,-75+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)- 6.40,-0.32><-5.99,(CCount*-1)-5.55,0.32> rotate<0,-75+(BCount*-7.5),0>
        texture{Fensterglas}} 

        box{<-6.25,(CCount*-1)+13.70,-0.32><-5.99,(CCount*-1)+14.55,0.32> rotate<0,-120+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)+ 3.65,-0.32><-5.99,(CCount*-1)+4.50,0.32> rotate<0,-120+(BCount*-7.5),0>
        texture{Fensterglas}}
        box{<-6.25,(CCount*-1)- 6.40,-0.32><-5.99,(CCount*-1)-5.55,0.32> rotate<0,-120+(BCount*-7.5),0>
        texture{Fensterglas}}    
    #declare BCount = BCount+1;
    #end
#declare CCount = CCount+1;
#end

        difference{
                cylinder{<0,4.85,0>,<0,5.25,0>,6.1 }
                cylinder{<0,4.95,0>,<0,5.35,0>,5.25 }} 
        difference{
                cylinder{<0,-5.10,0>,<0,-4.70,0>,6.10 }
                cylinder{<0,-5.20,0>,<0,-4.80,0>,5.25 }}                   
        rotate<0,1,0> translate <5.25,0,6> texture{ pigment{Weiss} finish{Stein}}}
        
// Rundhausaufbauten
//Kanzel
cylinder{<0,14.9,0>,<0,15.75,0>,5 translate <5.25,0,6> 
         texture{ pigment{Weiss} finish{Stein}}}

//Gelaender
torus{4.9,0.01 translate <5.25,16,6> texture{Metallrohr}}

//Gelaenderstangen
#declare GStange = 0;
#while (GStange < 60)
cylinder{<0,14.9,0>,<0,16,0>,0.01 translate<4.9,0,0> rotate<0,GStange*6,0> 
                                  translate <5.25,0,6> texture{Metallrohr}}
#declare GStange = GStange+1;
#end  

//Geruest
#declare LStange = 0;
#while (LStange < 4)
cylinder{<0,14.9,0>,<0,25,0>,0.02 translate<0.3,0,0> rotate<0,LStange*90+30,0> 
                                  translate <5.25,0,6> texture{Metallrohr}} 
#declare LStange = LStange+1;
#end

#declare Karo =
union{
cylinder{<0,17,-0.24>,<0,17,0.24>,0.015 translate<0.2,0,0> rotate<0,45,0>}
cylinder{<0,17,-0.24>,<0,17,0.24>,0.015 translate<0.2,0,0> rotate<0,-45,0>} 
cylinder{<0,17,-0.24>,<0,17,0.24>,0.015 translate<-0.2,0,0> rotate<0,45,0>}
cylinder{<0,17,-0.24>,<0,17,0.24>,0.015 translate<-0.2,0,0> rotate<0,-45,0>} 
rotate<0,30,0> translate <5.25,0,6> texture{Metallrohr}}

#declare Karofolge = 0;
#while (Karofolge < 20)
        object{Karo translate<0,0.35*Karofolge,0>}
#declare Karofolge = Karofolge+1;
#end

//Plattformen
#declare Scheibe =
difference{
        cylinder{<0,17.008,0>,<0,17.023,0>,0.6 translate <0,2.1,0> translate <5.25,0,6> }
        cylinder{<0,17.007,0>,<0,17.024,0>,0.2 translate <0,2.1,0> translate <5.25,0,6> }
        texture{Metallrohr}}

object{Scheibe}
object{Scheibe translate<0,2.45,0>}   
object{Scheibe translate<0,4.55,0>}

//Mast
cylinder{<0,14.9,0>,<0,25,0>,0.08 translate <5.25,0,6> texture{Mast}}
                                                  
//Schutzseile
#declare Dreh = 0;
#while (Dreh < 4)
        cylinder{<4.75,15,0>,<0,32,0>,0.01 rotate<0,Dreh*90+30,0> 
                                   translate <5.25,0,6> pigment{Schutzseile}}
#declare Dreh = Dreh+1;
#end

//-----------------------------------------------------------------------------------------------------         
//Haus rechts
          
difference{
        box{<12.75,-100,0.25><50,4,35> pigment{Weiss}}
        box{<12.7,0,1><12.8,3,36> texture {Fensterglas}} 
        box{<12.7,-4,1><12.8,-1,36>texture {Fensterglas}}
        box{<12.7,-8,1><12.8,-5,36>texture {Fensterglas}}
        box{<12.7,-12,1><12.8,-9,36>texture {Fensterglas}}
        box{<12.7,-16,1><12.8,-13,36>texture {Fensterglas}}}

union{
        box{<12.75,-100,3.9><50,4,4>}
        box{<12.75,-100,5.9><50,4,6>}
        box{<12.75,-100,7.9><50,4,8>}
        box{<12.75,-100,9.9><50,4,10>}
        box{<12.75,-100,11.9><50,4,12>} pigment {Weiss}}

#declare Zweier = 0;
#while (Zweier < 5)
        box{<12.75,1.4,0><50,1.6,15> translate<0,-(Zweier*4),0> pigment {Weiss}}
#declare Zweier = Zweier+1;
#end

//----------------------------------------------------------------------------------------------------
//Haus 1 (links von vorn nach hinten)

difference{    
        box{<-57.0,-100,-50><-8.4, 20,-5> texture{Haus1}} 
#declare BZahl = 0;                                                                 
#while (BZahl < 8)         
#declare AZahl = 0;
#while (AZahl < 40)        
        box{<-8.50,19.05+(AZahl*-1),-6.05+(BZahl*-1)><-8.3, 20+(AZahl*-1),-5.10+(BZahl*-1)>
                        texture {Fensterglas}} 
#declare AZahl = AZahl+1;
#end
#declare BZahl = BZahl+1;
#end
}        

//----------------------------------------------------------------------------------------------------
//Haus 2 (links von vorn nach hinten)
union{  
        difference{
                difference{
                        box{<-20,-100,-15><0,0,15>}
                        #declare BWhite = 0;
                        #while (BWhite < 2)
                        #declare AWhite = 0;
                        #while (AWhite < 4)
                        box{<-0.025,-9+(AWhite*-9),-13+(BWhite*19)><0.025,-2+(AWhite*-9),-6+(BWhite*19)>
                        texture {Fensterglas}}
                        #declare AWhite = AWhite+1;
                        #end
                        #declare BWhite = BWhite+1;
                        #end
                        }                                       
                box{<-0.5,-101,-4><0.001,0.001,4> texture{ pigment{Gelb} finish{Stein}}}
                translate<-1.75,0,0> texture {pigment{Hellgelb} finish{Stein}}}   
        difference{
                cylinder{<-20,0,0>,<0,0,0>,15 texture{ pigment{Hellgelb} finish{Stein}}}
                difference{
                        cylinder{<-1,0,0>,<0.001,0,0>,13.5} 
                        cylinder{<0,0,-15>,<0,0,15>,0.05} 
                        plane{y,1.5} texture{ pigment{Gelb} finish{Stein}}}
#declare ABlack = 0;
#while (ABlack < 7)
                torus{15,0.05 rotate<-90,-90,0> texture{Dachmetall} 
                              translate<-1+(ABlack*-1),0,0>}   
#declare ABlack = ABlack+1;
#end    
                plane{y,0}}
        
        union{   
                cylinder{<0,0,-15>,<0,0,15>,0.03}                                 
                cylinder{<-20,0,-15>,<0,0,-15>,0.03}
                difference{
                        torus{15,0.03 rotate<-90,-90,0>}
                        plane{y,-0.015}}
                texture {Dachmetall}}

#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-2+(BBlack*-1),-13>,<0,-2+(BBlack*-1),-6>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-2,-13+(CBlack*1)>,<0,-9,-13+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end          

#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-11+(BBlack*-1),-13>,<0,-11+(BBlack*-1),-6>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-11,-13+(CBlack*1)>,<0,-18,-13+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end 
     
#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-20+(BBlack*-1),-13>,<0,-20+(BBlack*-1),-6>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-20,-13+(CBlack*1)>,<0,-27,-13+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end         
        
#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-29+(BBlack*-1),-13>,<0,-29+(BBlack*-1),-6>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-29,-13+(CBlack*1)>,<0,-36,-13+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end                 

#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-2+(BBlack*-1),6>,<0,-2+(BBlack*-1),13>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-2,6+(CBlack*1)>,<0,-9,6+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end          

#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-11+(BBlack*-1),6>,<0,-11+(BBlack*-1),13>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-11,6+(CBlack*1)>,<0,-18,6+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end 
     
#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-20+(BBlack*-1),6>,<0,-20+(BBlack*-1),13>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-20,6+(CBlack*1)>,<0,-27,6+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end         
        
#declare CBlack = 0;
#while (CBlack < 8)        
#declare BBlack = 0;
#while (BBlack < 8)
        cylinder{<0,-29+(BBlack*-1),6>,<0,-29+(BBlack*-1),13>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
        cylinder{<0,-29,6+(CBlack*1)>,<0,-36,6+(CBlack*1)>,0.03 
                texture{Dachmetall} translate<-1.75,0,0>}
#declare BBlack = BBlack+1;
#end        
#declare CBlack = CBlack+1;
#end                         
             
        translate<-7,3.55,20>}    

//---------------------------------------------------------------------------------------------------
//Haus 3 (links von vorn nach hinten)
#declare HausMitKerben =
difference{
        box{<-59,-100,60><-9,4,110>}

        box{<-9.5,- 6.5,50><-8,- 5,120>}  
        box{<-9.5,-17.0,50><-8,-15.5,120>}
        box{<-9.5,-27.5,50><-8,-26,120>}
        box{<-9.5,-38.0,50><-8,-36.5,120>}   

        box{<-59,- 6.5,59><-8,- 5,119>}  
        box{<-59,-17,59><-8,-15.5,119>}
        box{<-59,-27.5,59><-8,-26,119>}
        box{<-59,-38.0,59><-8,-36.5,119>}  

#declare DreiCount1 = 0;
#while (DreiCount1 < 5)
        union{
                box{<-12,2.1,59.5><-9.5,3.3,61>}
                box{<-12,0.5,59.5><-9.5,1.7,61>}
                box{<-12,-1.1,59.5><-9.5,0.1,61>}
                box{<-12,-2.7,59.5><-9.5,-1.5,61>}
                box{<-12,-4.3,59.5><-9.5,-3.1,61>} pigment{Innenraum} translate<0,0-(DreiCount1*10.5),0>}
#declare DreiCount1 = DreiCount1+1;
#end

        texture {pigment{Haus3} finish{Stein}}}  

#declare AlleFensterscheiben = union{

#declare DreiCount2 = 0;
#while (DreiCount2 < 4)
        box{<-12.1,-4.4,60.10><-9.4,3.4,60.11> translate<0,0-(DreiCount2*10.5),0>} 
#declare DreiCount2 = DreiCount2+1;
#end 

texture {Fensterglas}}

#declare HausMitKerben2 = union{
        object{HausMitKerben}
        object{AlleFensterscheiben}}

        object{HausMitKerben2}

//--------------------------------------------------------------------------------------------------
//Haus 4 (links von vorn nach hinten)

difference{
        box{<-47,-200,140.001><-7,40,180> translate<27,-40,-160> }   
        plane{-y,0 rotate<0,0,60>}
        plane{-y,0 rotate<0,0,-60>}
        plane{-y,0 rotate<60,0,0>}
        plane{-y,0 rotate<-60,0,0>}
        translate<-27,55,160> texture{ pigment{Haus4} finish{Hausmetall}}}

#declare Fenster = union{
        triangle {<-46.3,4.5,140>,<-45.4,4.5,140>,<-46.3,3,140>}   
        triangle {<-46.3,3,140>,<-45.4,4.5,140>,<-45.4,3,140>} 
        translate <0,15,0> texture {Fensterglas}}

cylinder{<0,0,0>,<0,44.5,0>,0.12 rotate<0,0,-140.75> rotate<0, 45,0> translate<-27,55,160>
                               texture{ pigment{Stangen4} finish{Hausmetall}}} 
cylinder{<0,0,0>,<0,44.5,0>,0.12 rotate<0,0,-140.75> rotate<0,135,0> translate<-27,55,160>
                               texture{ pigment{Stangen4} finish{Hausmetall}}}

cylinder{<-47,20.5,140>,<-7,20.5,140>,0.12 texture{ pigment{Stangen4} finish{Hausmetall}}}   
cylinder{<-7,20.5,140>,<-7,20.5,180>,0.12 texture{ pigment{Stangen4} finish{Hausmetall}}}

cylinder{<-7,-200,140>,<-7,20.5,140>,0.12 texture{ pigment{Stangen4} finish{Hausmetall}}}  
cylinder{<-7,-200,180>,<-7,20.5,180>,0.12 texture{ pigment{Stangen4} finish{Hausmetall}}} 

//Spitze
cone{<-27,79,160>,0.1,<-27,50,160>,0.8 texture{Metallrohr}}

#declare APyr = 0;
#while (APyr < 138)
#declare BPyr = 0;
#while (BPyr < 30)  
        object{Fenster translate<1.3*BPyr,-2.0*APyr>}        
#declare BPyr = BPyr+1;
#end
#declare APyr = APyr+1;
#end    

//--------------------------------------------------------------------------------------------------
//Haus 5 (links von vorn nach hinten)
difference{
        box{<-47,-200,200.001><-7,40,240> translate <27,-40,-220> }
        plane{-y,0 rotate<0,0,60>}
        plane{-y,0 rotate<0,0,-60>}
        plane{-y,0 rotate<60,0,0>}
        plane{-y,0 rotate<-60,0,0>}
        translate<-27,105,220> texture{ pigment{Haus5} finish{Hausmetall}}}

cylinder{<0,0,0>,<0,44.5,0>,0.12 rotate<0,0,-140.75> rotate<0, 45,0> translate<-27,105,220>
                               texture{ pigment{Stangen5} finish{Hausmetall}}} 
cylinder{<0,0,0>,<0,44.5,0>,0.12 rotate<0,0,-140.75> rotate<0,135,0> translate<-27,105,220>
                               texture{ pigment{Stangen5} finish{Hausmetall}}}

cylinder{<-47,70.5,200>,<-7,70.5,200>,0.12 texture{ pigment{Stangen5} finish{Hausmetall}}}   
cylinder{<-7,70.5,200>,<-7,70.5,240>,0.12 texture{ pigment{Stangen5} finish{Hausmetall}}}

cylinder{<-7,-200,200>,<-7,70.5,200>,0.12 texture{ pigment{Stangen5} finish{Hausmetall}}}  
cylinder{<-7,-200,240>,<-7,70.5,240>,0.12 texture{ pigment{Stangen5} finish{Hausmetall}}} 

//Spitze
cone{<-27,129,220>,0.1,<-27,100,220>,0.8 texture{Metallrohr}}

#declare Fenster = union{
        triangle {<-46.3,4.5,200>,<-45.4,4.5,200>,<-46.3,3,200>}   
        triangle {<-46.3,3,200>,<-45.4,4.5,200>,<-45.4,3,200>} 
        translate <0,65,0> texture {Fensterglas}}

#declare APyr = 0;
#while (APyr < 138)
#declare BPyr = 0;
#while (BPyr < 30)  
        object{Fenster translate<1.3*BPyr,-2.0*APyr>}        
#declare BPyr = BPyr+1;
#end
#declare APyr = APyr+1;
#end

//-------------------------------------------------------------------------------------------------
//Haus 6 (links von vorn nach hinten)

box{<-47,-200,460><-7,-25,520> texture{ pigment{Haus6} finish{Stein}}}

//-------------------------------------------------------------------------------------------------
//Haus 7 (links von vorn nach hinten)  

box{<-47,-200,550><-7,30,600>texture{pigment{Haus7} finish{Stein}}}

//-------------------------------------------------------------------------------------------------
// Heli

object {Heli texture {Rotphong} scale 0.6 translate <0,4,-4.5> rotate<0,-10,10>
                                      translate<-0.15,0,-5.85> translate<2.45,2.5,5.3>} 
                                      
object {Heli2}

//-------------------------------------------------------------------------------------------------
// Pilot

object {Pilot scale 0.035 translate<-1.3,6.11,-6.28>}  
                                      
//-------------------------------------------------------------------------------------------------
// Aquarium                                      

object {Aquarium scale 0.75 rotate<0,25,0> translate<-2.05,-3,0> translate<2.35,0,-5.65>} 

//-------------------------------------------------------------------------------------------------
//Moebel

//Tisch mit 4 Stuehlen
object{Tischensemble scale 0.7 translate<0,-10.53,0> translate<5.5,0,-9.75>}

//Rundtisch mit 3 Stuehlen
object{Rundtischensemble scale 0.6 translate<1.10,-4.74,-26>}

//Aschenbecher
object{Aschenbecher}

//-------------------------------------------------------------------------------------------------
//Copyright
                                        
text {ttf "arialn.ttf","\u00A9 Roland M\u00FCnger",0.1,0 no_shadow pigment {CR} 
                                        translate<0,0,-0.05> scale 0.275 translate<-1.6,-0.1,0> 
                                        translate<6.6,-11.75,-16>}                                        
                                        
                                                                          
                                        
                                        
                                        
                                        
                                        
       
