/*
camera {
  location <0, 5, -40>
  look_at 0
  angle 40
}
*/
#declare SnowSeed = seed(343);

#declare snowflake = sphere {
  0, .5
  hollow    
  pigment { rgbf 1 }
  interior {
    media {
      emission 1
      density {
        spherical
        density_map {
          [0.0 rgbt <0,0,0,1>]
          [0.5 rgbt <0,0,0,1>]
          [1.0 rgbt 65*<1, 1, 1,0*.25>]
        }          
        warp { turbulence .4*rand(SnowSeed) }
      }
    }
  }
  scale .02//.025
  finish { ambient 1 }
}   

#declare i = 0;
#while (i<10000/*50000*/)
  object {
    snowflake
    rotate 360*<rand(SnowSeed),rand(SnowSeed),rand(SnowSeed)>
    scale y*(1+.2*rand(SnowSeed))
    rotate 360*<rand(SnowSeed),rand(SnowSeed),rand(SnowSeed)>
    
    scale <.5, .5+.5*rand(SnowSeed), .5>
    rotate z*(30+30*rand(SnowSeed))
    
    //translate 50*(.5-<rand(S),rand(S),rand(S)>)
    #declare xrange = 4;
    #declare yrange = 8;
    translate <-.5*xrange, 0, -40>+<xrange, yrange, 10>/*<10, 10, 10>*/*<rand(SnowSeed),rand(SnowSeed),rand(SnowSeed)>
  }
  #declare i = i+1;
#end        
