// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "finish.inc"

/* 
global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}
*/

// ----------------------------------------

//plane {
//  y, -1
//  pigment { color rgb <0.7,0.5,0.3> }
//}

//#declare Sphere = function {pow(x,2) + pow(y,2) + pow(z,2)};

#declare tex_leaf = texture {pigment{GreenYellow}finish{Shiny ambient 0.3}};
#declare tex_branch = texture {pigment{DarkGreen}finish{Dull ambient 0.1}};
#declare tex_trunk = texture {pigment{Brown}finish{Dull ambient 0.1}};


#declare bush = function { f_sphere(x, y, z, 1.2) - f_noise3d(x * 4, y * 4, z * 4) * 2 };
//#declare bush = function { sqrt(pow(x,2) + pow(z,2)) + y - f_noise3d(x * 4, y * 4, z * 4) * 2 };

#declare b1 = isosurface {
    function { bush(x,y,z)}
    contained_by { sphere { <0,0,0>,6 } } 
    evaluate 200,2,1
    pigment {Green}   
    scale 0.5
};

#declare b2 = sphere {<0,0,0>,1};

#local Count = 2000; 
#declare R1 = seed(0);
#declare DV = <0,0,4>; 
#declare DV2 = <0,0,4>; 

#declare tree =union {
#while (Count != 0)
  #local Norm = <0,0,0>;
  #declare DV = vrotate(DV,<360*rand(R1),360*rand(R1),360*rand(R1)>);
  //#declare DV2 = vrotate(DV2,<0,360*rand(R1)>);
  //#declare DV2 = <DV2.x,8*rand(R1)*rand(R1)-4,DV2.z>;
  #local Berry = trace(b1,DV,-DV,Norm);
  #local Count = Count - 1;
  sphere {<0,0,0>, 0.05 scale <1,0.25,1> translate Berry texture{tex_leaf}}
  cylinder {<0,Berry.y-0.2,0>,Berry,0.005 texture{tex_branch}}     
#end 
   //pigment {Green}
   cylinder {<0,-1.3,0>,<0,0,0>,0.05 texture{tex_trunk}} 
   
}


//object {b1 pigment{Green}} 



