// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"  
#include "handy.inc" 
#include "shapes.inc"
#include "finish.inc"

#include "iso.pov" 
#include "prong.inc"


#declare RAD = on;


global_settings {
  assumed_gamma 1.0 
  
  // default radiosity
  #if(RAD)
     radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 5
      error_bound 1.8
      recursion_limit 3

      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2
    }
   #end

}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 Black]
      [0.7 Blue*0.5]
      [1 Black]
    }
  }
}


#if (RAD = off)
  light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>*0.2  // light's color
  translate <0, 100, -100>
}

#end

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-100, 100, -100>
}

//----------------------------
#declare tex_prong = texture {
   pigment{Yellow transmit 0.5} 
   finish {ambient 0.4}
};
#declare tex_marker = texture{
   pigment{Yellow}
   finish{ambient 0.7}
};
#declare tex_blgface = texture { 
      pigment {
         image_map { 
            jpeg "E:\graphics\maps\blgface01.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
            map_type 0       // 0=planar, 1=spherical, 2=cylindrical, 5=torus
            //interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
            once           // for no repetitive tiling
         }
         scale <25,25,25> 
      }
      finish {
         ambient 0.1
      }
};

// ----------------------------------------

#declare c_prong = union {
   object { prong 
      texture {
         pigment {Yellow}
         finish {Shiny ambient 0.4}
      }
      rotate <90,0,105>
      scale <5,10,7>
      translate <0,-0.05,0>
   }
   
   light_source {
     <0.55, 1, 0.0175>            // light's position (translated below)
     color rgb <1, 1, 0>  // light's color
     spotlight
     radius 15
     falloff 20
     tightness 10
     point_at <0.55, 0, 0.0175>

     //looks_like {
     //   sphere {<0.55,1,0.035/2>,0.05 texture {tex_marker}}
     //}
   }
   //sphere {<0.55,1,0.035/2>,0.05 texture{tex_marker}}

};                                               

#declare r_prong_border = Pipe(<0,-1,0>,<0,-0.05,0>,1.4,1.3501); //.125 
#declare r_prong = union {
   RingOf(c_prong, <-1.33,0,0>, <0,60,0>, 6) 
   cylinder{<0,-1,0>,<0,0.05,0>,1.35 texture {pigment{Gray75}finish{ambient 0.2}}}  
   object{r_prong_border texture {pigment{Gray50}finish{ambient 0.2}}} 
   //union{Pipe(<0,-1,0>,<0,0.05,0>,1.4,1.3501) texture {pigment{Gray50}finish{ambient 0.2}}}  
   scale 2 
   rotate <0,-15,0>
};

#declare build1 = union {
   box {<0.001,0.001,0.001>, <24.999,24.999,24.999> pigment{Black}} 
   union { Quad(<0,0,0>,<25,0,0>,<25,25,0>,<0,25,0>) texture {tex_blgface} }
   union { Quad(<0,0,0>,<0,0,25>,<0,25,25>,<0,25,0>) texture {tex_blgface rotate<0,-90,0>} }
   union { Quad(<25,0,0>,<25,0,25>,<25,25,25>,<25,25,0>) texture {tex_blgface rotate<0,-90,0>} }
   union { Quad(<0,0,25>,<25,0,25>,<25,25,25>,<0,25,25>) texture {tex_blgface} } // back face
};
#include "rail_post.inc"
#declare rail_post2 = object {rail_post scale<0.25,0.26,0.25>};
#declare rail_opening = cylinder{<0,0,0>,<0,0,2.9>,0.05 scale <1,3,1>};
#declare rails = //difference { // rails
   union{
     Pipe(<0,-1,0>,<0,-0.8,0>,2.7999,2.6) //wide bottom
     //Pipe(<0,-1,0>,<0,-0.7,0>,2.7999,2.7) //bottom
     //Pipe(<0,-0.7,0>,<0,-0.6,0>,2.77,2.73) //mid
     //Pipe(<0,-0.6,0>,<0,-0.4,0>,2.8,2.7) // top
     union{RingOf(rail_post2,<-2.7,0,0>,<0,5,0>,72) translate <0,-0.805,0>}
     Pipe(<0,-0.55,0>,<0,-0.45,0>,2.85,2.65) //wide top
     
   //}
   //union{RingOf(rail_opening,<0,0,0>,<0,5,0>,72)translate<0,-0.65,0>}
};

//#declare targ = cylinder { <0,-1,0>,<0,0.05,0>,5.6 
//  pigment {Red}
//  translate <-1.9494,0,5.4092>
//};   

plane {
  y, -1
  //pigment { brick color rgb <0.7,0.5,0.3> Black}
      texture {
       pigment {
         image_map { 
            jpeg "E:\graphics\maps\paved01.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
            map_type 0       // 0=planar, 1=spherical, 2=cylindrical, 5=torus
            //interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
            //once           // for no repetitive tiling
         }
         rotate <90,0,0>
         rotate <0,90,0>
         scale <35,1,100>
         translate <10,0,50> 
       }
       finish {
         ambient 0.1
       }
      }
}

  
object { r_prong  // lower terace
   translate <-0.5,-1,0>
}
object { r_prong  // middle terace
   translate <-1.9494,-0.75,5.4092>
}
object { r_prong  // top terace
   translate <2.0104,-0.5,9.3690>
}

difference { // rails
   union { 
     object {rails translate <-0.5,0,0>}
     object {rails translate <-1.9494,0.25,5.4092>}
     object {rails translate <2.0104,0.5,9.3690>}
   }
   box{<-1,-1,0>,<1,1,5> rotate <0,-15,0> translate<-0.5,0,0>}
   box{<-1,-1,0>,<1,1,5> rotate <0,45,0> translate<-1.9494,0.25,5.4092>}
   texture {
      pigment {White}
      finish {ambient 0.4}
   }
} 

// near steps
union {
   box{<-1,-0.9,0  >,<1,-0.8,0.6>}
   box{<-1,-0.9,0.2>,<1,-0.7,0.6>}
   box{<-1,-0.9,0.4>,<1,-0.6,0.6>}
   translate <0,0,2.5>
   rotate <0,-15,0>
   translate<-0.5,0,0>
   texture {
      pigment{White}
      finish {ambient 0.4}
   }
}

// far steps
union {
   box{<-1,-0.9,0  >,<1,-0.8,0.6>}
   box{<-1,-0.9,0.2>,<1,-0.7,0.6>}
   box{<-1,-0.9,0.4>,<1,-0.6,0.6>}
   translate <0,0,2.5>
   rotate <0,45,0>
   translate<-1.9494,0.25,5.4092>
   texture {
      pigment{White}
      finish {ambient 0.4}
   }
}




#declare tex_chair = texture{pigment {White}};
#include "spine_chair.inc"

#declare chair = object{spine_chair rotate <0,-90,0> scale 0.33};

union { RingOf(chair, <-1.33,0,0>, <0,60,0>, 6) rotate <0,-15,0> translate <-0.5,-0.9,0>}  
union { RingOf(chair, <-1.33,0,0>, <0,60,0>, 6) rotate <0,-15,0> translate <-1.9494,-0.65,5.4092>} 
union { RingOf(chair, <-1.33,0,0>, <0,60,0>, 6) rotate <0,-15,0> translate <2.0104,-0.4,9.3690>}  

 
union {
   LineOf(build1, <10,-1,-25>, <0,0,55> 20)
   LineOf(build1, <-10-25,-1,-25>, <0,0,55> 20)
   translate <0,0,-500>
}
  
  


object {tree scale 0.5 translate <2.5,-0.5,3>}  
object {tree scale 0.5 translate <2.5,-0.5,4>}  
object {tree scale 0.5 translate <2.5,-0.5,5>}  
object {tree scale 0.5 translate <1.5,-0.5,4>}  
object {tree scale 0.5 translate <0.5,-0.5,5>}  
object {tree scale 0.5 translate <1,0.25,5>}  
object {tree scale 0.5 translate <2,0.4,3>}  
object {tree scale 0.5 translate <3,0.5,6>}  

  
//sphere {<0,0,0>,0.05 pigment{Red}}  

//#local norm = <0,0,0>;

//#local hits = trace(targ, <-1.9494,0.01,5.4092>, vrotate(<0,0,1>, <0,45,0>),norm);

//sphere {hits,0.05 pigment{Orange} translate <-0.5,-0.9,0>}  

//#debug concat("X ",str(hits.x,5,4)," Y ",str(hits.y,5,4)," Z ",str(hits.z,5,4),"/n")


//object { c_prong rotate<0,45,0>} 

