// OldMaid.pov
// Rick Montgomery
// 21 Jan 2005
// Generates the image used in surprise.pov for the Old Maid card

#default { texture { pigment { color rgb < 1, 0, 0 > } finish { ambient 0.4 diffuse 0.6} } }

global_settings {
	ambient_light rgb <0.5, 0.5, 0.5>
}

background {color rgb <.5,1,.6>}

#declare RS=seed(17645);

#declare T_head=texture{
	pigment {
		color rgb <1,.85,.75>
	}
	finish {
		ambient .2
		diffuse .8
	}
	normal {
		wrinkles .2
		scale .03
	}
}

#declare T_hair=texture{
	pigment {
		color rgb .8
	}
	finish {
		ambient .2
		diffuse .8
	}
}


#declare Head=union{
	difference {
		sphere {
			0 1
			scale <.5,1,.5>
		}
		// eye sockets
		sphere {
			0 .07
			scale <2,1,1>
			translate <.15, .1, -.45>
		}
		sphere {
			0 .07
			scale <2,1,1>
			translate <-.15, .1, -.45>
		}
		texture {T_head}
	} // difference
	
	// nose
	sphere {
		0 .07
		scale <1,2,1>
		rotate 12*x
		translate <0,-.05,-.5>
		texture {T_head}
	}
	
	// eyeballs
	difference {
		sphere {0 .07
			texture {pigment {color rgb 1} finish {ambient 0.4 diffuse 0.6 specular 1}}
		} // sphere
		sphere {0 .03
			texture {pigment {color rgb <.6, .7, 1>}}
			translate -.07*z
		}
		translate <.15, .1, -.43>
	} // difference
	
	difference {
		sphere {0 .07
			texture {pigment {color rgb 1} finish {ambient 0.4 diffuse 0.6 specular 1}}
		} // sphere
		sphere {0 .03
			texture {pigment {color rgb <.6, .7, 1>}}
			translate -.07*z
		}
		translate <-.15, .1, -.43>
	} // difference
	
	// lips
	union {
		torus {.2 .02
		}
		torus {.2 .022
		translate <0,-.02,.005>
		}
		translate <0,-.3,-.28>
	} // union (lips)
} // union (head)


#declare glasses=union{
	torus {.1 .01 rotate 90*x translate .15*x}
	torus {.1 .01 rotate 90*x translate -.15*x}
	difference {
		torus {.1 .01 rotate 90*x}
		box {<-1,-1,-1> <-.05,1,1>}
		box {<.05,-1,-1> <1,1,1>}
		box {<-1,-1,-1> <1,0,1>}
		translate <0,-.045,0>
	} // difference (bridge)
	texture {pigment {color rgb <1,.6,0>} finish {ambient 0.2 diffuse 0.6 reflection 0.1 specular 1}}
} // union (glasses)

#declare HairLock=sphere {
	0 .15
	texture {T_hair}
}

#declare Hair=union {
	// locks of hair placed randomly around the top of the head
	#local I=0;
	#local N=800;
	#while (I<N)
		#local Az=2*pi*rand(RS);
		#local El=pi/6+pi/6*sin(Az)+pi/2*rand(RS);
		#local R=1+.2*rand(RS);
		#local X=R*cos(Az)*cos(El)/2;
		#local Y=R*sin(El);
		#local Z=-R*sin(Az)*cos(El)/2;
		object {HairLock translate <X,Y,Z>}
		#local I=I+1;
	#end
}

#declare TextOld=text {
	ttf "westwool.ttf",
	"OLD"
	0.1, <0.0, 0.0, 0.0>
}


#declare TextMaid=text {
	ttf "westwool.ttf",
	"MAID"
	0.1, <0.0, 0.0, 0.0>
}


object {Head}
object {Hair translate -.2*y}
object {glasses translate <0,.04,-.55>}
object {TextOld translate <-1,1.3,0>}
object {TextMaid translate <-1.2,-1.8,0>}

light_source {
	<5, 2, -5>
	rgb <1.0, 1.0, 1.0>
}

light_source {
	<-3,0,-12>
	rgb .5
}

camera {
	perspective 
	location <0,0,-4>
	up y right x*image_width/image_height
	look_at <0, 0.07, 0>
}
