// Persistence of Vision Ray Tracer Scene Description File
// File: tnw_lost.pov
// Vers: 3.6.1
// Desc: Out Of Place Entry 
// Date: 10.02.05 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 25.02.05 (dd.mm.yy)

//Required Files
// None

//Description
// A small, red sphere (or furry fellow), lost in geometric black and white space.

/*Commandline
+w1280 +h960 +am2 +a0.2 +r3
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#debug "\nBeginning of Out Of Place scene...\n\n"

//Not Included in ZIP, nor needed in this distribution
//#include "sc2hair.inc"

#default{
  finish{
    ambient 0
  }
}
global_settings{
  assumed_gamma 1
}

camera{
  location <8,21,-45>
  //up y*1.33 right x
  look_at <13,15,0>
}

sky_sphere{
  pigment{
    gradient y
    color_map{
      [0 rgb 1]
      [.5 rgb .6]
      [.8 rgb 2]
      [1 rgb 2]
    }
    scale 2 translate -1
  }
}

fog{
  fog_type 2
  fog_offset 0
  fog_alt 25
  distance 230
  color rgb 0
}

light_source{
  <0,200,0> rgb .5
  parallel point_at <0,0,0>
  }

light_source{
  <300,200,-200> rgb 1.75
  parallel point_at <0,0,0>
  area_light x*20,y*20,16,16 orient circular adaptive 2
  }

light_source{
  <-100,20,-400> rgb .25
  parallel point_at <0,0,0>
  shadowless
  }

plane{
  y,0
  pigment{
    hexagon
    color rgb .7
    color rgb .4
    color rgb 1
    }
  finish{
    reflection{0,.6 falloff 2}
  }
}

#macro Beveled_Box(Corner_1,Corner_2,Bevel_Distance)
  #local _C1 = <min(Corner_1.x,Corner_2.x),min(Corner_1.y,Corner_2.y),min(Corner_1.z,Corner_2.z)>;
  #local _C2 = <max(Corner_1.x,Corner_2.x),max(Corner_1.y,Corner_2.y),max(Corner_1.z,Corner_2.z)>;
  #local _B=Bevel_Distance;
  mesh2{
  vertex_vectors{
  24,
  //The six faces' vertices
  //Top
  <_C1.x,_C2.y,_C1.z>+< 1, 0, 1>*_B,
  <_C2.x,_C2.y,_C1.z>+<-1, 0, 1>*_B,
  <_C2.x,_C2.y,_C2.z>+<-1, 0,-1>*_B,
  <_C1.x,_C2.y,_C2.z>+< 1, 0,-1>*_B,
  //Bottom
  <_C1.x,_C1.y,_C1.z>+< 1, 0, 1>*_B,
  <_C2.x,_C1.y,_C1.z>+<-1, 0, 1>*_B,
  <_C2.x,_C1.y,_C2.z>+<-1, 0,-1>*_B,
  <_C1.x,_C1.y,_C2.z>+< 1, 0,-1>*_B,
  //Right
  <_C2.x,_C1.y,_C1.z>+< 0, 1, 1>*_B,
  <_C2.x,_C1.y,_C2.z>+< 0, 1,-1>*_B,
  <_C2.x,_C2.y,_C2.z>+< 0,-1,-1>*_B,
  <_C2.x,_C2.y,_C1.z>+< 0,-1, 1>*_B,
  //Left
  <_C1.x,_C1.y,_C1.z>+< 0, 1, 1>*_B,
  <_C1.x,_C1.y,_C2.z>+< 0, 1,-1>*_B,
  <_C1.x,_C2.y,_C2.z>+< 0,-1,-1>*_B,
  <_C1.x,_C2.y,_C1.z>+< 0,-1, 1>*_B,
  //Front
  <_C1.x,_C1.y,_C1.z>+< 1, 1, 0>*_B,
  <_C2.x,_C1.y,_C1.z>+<-1, 1, 0>*_B,
  <_C2.x,_C2.y,_C1.z>+<-1,-1, 0>*_B,
  <_C1.x,_C2.y,_C1.z>+< 1,-1, 0>*_B,
  //Rear
  <_C1.x,_C1.y,_C2.z>+< 1, 1, 0>*_B,
  <_C2.x,_C1.y,_C2.z>+<-1, 1, 0>*_B,
  <_C2.x,_C2.y,_C2.z>+<-1,-1, 0>*_B,
  <_C1.x,_C2.y,_C2.z>+< 1,-1, 0>*_B
  }
  texture_list{
    3,
    texture{Face_Texture},
    texture{Corner_Texture},
    texture{Bevel_Texture}
  }
  face_indices{
    44,
    //Top
    <0,1,2>,0,<2,3,0>,0,
    //Bottom
    <4,5,6>,0,<6,7,4>,0,
    //Right
    <8,9,10>,0,<10,11,8>,0,
    //Left
    <12,13,14>,0,<14,15,12>,0,
    //Front
    <16,17,18>,0,<18,19,16>,0,
    //Rear
    <20,21,22>,0,<22,23,20>,0,
    //Bevel
      //Top corners
      <0,15,19>,1,<1,18,11>,1,
      <2,10,22>,1,<3,23,14>,1,
      //Conx between top corners
      <0,1,18>,2,<18,19,0>,2,
      <1,2,11>,2,<10,11,2>,2,
      <2,3,22>,2,<22,23,3>,2,
      <3,0,14>,2,<14,15,0>,2,
      //Conx between top and bottom corners
      <15,19,12>,2,<12,16,19>,2,
      <18,11,17>,2,<17,8,11>,2,
      <10,22,9>,2,<9,21,22>,2,
      <23,14,20>,2,<20,13,14>,2,
      //Conx between bottom corners
      <16,17,4>,2,<4,5,17>,2,
      <8,9,5>,2,<5,6,9>,2,
      <20,21,6>,2,<6,7,20>,2,
      <12,13,7>,2,<7,4,12>,2,
      //Bottom corners
      <16,4,12>,1,<17,5,8>,1,
      <9,6,21>,1,<20,13,7>,1
    }
  }
#end

#declare Corner_Texture=texture{pigment{rgb 0}}
#declare Bevel_Texture=texture{pigment{rgb 0}}

#declare Fieldsize = 550;

#declare Amount=15000;
#declare R=seed(030683);

#debug concat("Placing ",str(Amount,0,0)," large beveled boxes...\n")

#declare A=0;
#while (A<Amount)
  #declare Face_Texture=
    texture{
      pigment{
        checker
        color rgb .75+.2*rand(R)
        color rgb .4+.2*rand(R)
        scale .3+1.9*rand(R)
        rotate <360*rand(R),360*rand(R),360*rand(R)>
      }
      finish{
        ambient 0
        specular 24 roughness .001
        reflection{0,.2 falloff 2}
      }
    }

  object{
    Beveled_Box(<-1-1*rand(R),0,-1-1*rand(R)>,<1+1*rand(R),1+(7+150*A/Amount)*rand(R),1+1*rand(R)>,.1+.2*rand(R))
    rotate y*360*rand(R)
    translate vrotate(<1,0,0>,y*(360/.618*A+2*rand(R))) * (sqrt(A/(Amount-1))*Fieldsize+10)
  }
#declare A=A+1;
#end
#debug "Done!\n\n"

#declare Fieldsize = 100;
#declare Amount=5500;
#debug concat("Placing ",str(Amount,0,0)," large beveled boxes...\n")

#declare Face_Texture=texture{pigment{rgb .86}      finish{
        ambient 0
        specular 24 roughness .001
        reflection{0,.2 falloff 2}
      }
}

#declare A=0;
#while (A<Amount)
  object{
    Beveled_Box(<-.2-.2*rand(R),0,-.2-.2*rand(R)>,<.2+.2*rand(R),.2+(.8+3*A/Amount)*rand(R),.2+.2*rand(R)>,.01+.02*rand(R))
    rotate y*360*rand(R)
    translate vrotate(<1,0,0>,y*(360/.618*A+2*rand(R))) * (sqrt(A/(Amount-1))*Fieldsize+7)
  }
#declare A=A+1;
#end
#debug "Done!\n\n"

/* Furry Fellow commented out, because the mesh is quite large
#macro Modify_IHairSample(Position,Normal,Length,Possible_Lengths)
  #declare Length = Possible_Lengths.u+Position.y/4*(Possible_Lengths.v-Possible_Lengths.u);
#end

#declare Material0 = texture{pigment {color rgb <0.819608, 0.819608, 0.819608>}}
#declare Furbase = texture{pigment{rgb .01}}
#declare Fingernails = texture{pigment{rgb <1, 0.717647, 0.717647>}finish{specular .8 roughness .01}}
#declare Skin = texture{pigment{rgb <1, 0.717647, 0.717647>}finish{ambient x*.05}}

#debug "Loading mesh2...\n"
#include "fellow.pov"
#debug "Done!\n\n"

#declare Furry=
union{
  object{FurryFellow}
  //Sc2Hair_OnTheFly("sit.smp",8,15,<.1,.05>,<.5,1.35>,"sit.hrs")
  Sc2Hair_UseSaved("sit.smp","sit.hrs")
  pigment{rgb x}
  scale <1,1,-1>
}

object{Furry
  scale 1.5
  rotate y*18
}
*/

sphere{y*4,4 pigment{rgb x}}
