// BEGIN File labelFF.pov
//
// Copyright 2005 Windell Oskay
// ( windell (at) oskay.net )
//
// I claim copyright solely for the purpose of being able to claim 
// that *I too* have the right to use the contents of this scene.  
//
// So... please let me know if you reuse any part of this file.
//
// This file is a support file to aquarium.pov, 
// used to generate labelFF1.png, labelFF2.png, 
// the image maps for the label on the can of fish food.
//
// Run as an animation for two frames to generate the two files.
//


camera {   orthographic
angle 30
   location -10*z 
   look_at 0  }
   
#default {finish {ambient 1 diffuse 0}}
   

#declare titleColor = x;
#declare bgColor = x+y;

background {color rgb bgColor}


#declare ds = 
triangle {
  <-0.2,  0.5, 0>,  
  < 0.2,  0.5, 0>,  
  < 0,  -0.5,  0>  
}

#declare hs = 
object {ds rotate 90*z scale 0.75}

#declare Ht =
union {
object {ds translate -0.25*x}
object {ds translate 0.25*x}
object {hs}
    }
    
#declare At =
union {
object {ds rotate -20*z translate -0.15*x}
object {ds rotate 20*z translate 0.15*x}
object {hs}
    }
    
#declare Pt =
union {
object {ds translate -0.1*x}
object {ds scale 0.75 rotate 50*z translate <0.12,0.25,0>}
object {ds scale 0.75 rotate -50*z translate 0.05*x}
    }    

#declare It =
union {
object {ds translate -0.05*x}
object {hs translate 0.4*y}
object {hs translate -0.3*y}
    }    

#declare Ft =
union {
object {ds translate -0.2*x}
object {hs translate 0.4*y}
object {hs translate 0.1*y}
    }    

#declare St =
union {
object {ds scale 0.75 rotate -50*z translate <-0.15,0.25,0>}
object {ds scale 0.75 rotate 50*z }
object {ds scale 0.75 rotate -50*z translate -0.25*y}
    }    

#declare title = union {
object{Ht  translate -1.9*x}
object{At  translate -1*x}
object{Pt  translate -0.25*x}
object{Pt  translate 0.4*x}
object{It  translate 1.3*x}
object{Ft  translate 2.5*x}
object{It  translate 3.3*x}
object{St  translate 4.0*x}
object{Ht  translate 4.8*x}

pigment{rgb titleColor}
scale <0.2,0.4,1>}



#if (frame_number=1)
union {
object {title translate <-0.25,0.4,0>} 

sphere { <0,-0.25,0>, 0.45		//red spot
pigment{rgb titleColor}
scale <1,1,0.001>
}

union {				//Fish on red spot
triangle {
  <-0.25,  0.15, 0>, < 0.05,  0, 0>,  < -0.15,  0,  0>  }
triangle {
  <-0.25,  -0.15, 0>, < 0.05,  0, 0>,  < -0.15,  0,  0>  }
triangle {
  <0.4,  0, 0>, < 0.0,  0, 0>,  < 0.2,  0.1,  0>  }
triangle {
  <0.4,  0, 0>, < 0.0,  0, 0>,  < 0.2,  -0.1,  0>  }

pigment{rgb bgColor}
translate <-0.05,-0.25,-0.2>
}

sphere { <0.2,-0.12,-1>, 0.03
pigment{rgb bgColor}
scale <1,1,0.001>}

sphere { <0.16,-0.04,-1>, 0.04
pigment{rgb bgColor}
scale <1,1,0.001>}

sphere { <0.2,0.07,-1>, 0.05
pigment{rgb bgColor}
scale <1,1,0.001>}

scale 2.75
}
#end // if frame number = 1


box{ <-0.05,-10,-0.1> <0.05, 10, 0.1>		//Divider line
pigment{rgb titleColor}
translate -2.65*x}

box{ <-0.05,-10,-0.1> <0.05, 10, 0.1>		//Divider line
pigment{rgb titleColor}
translate 2.65*x}

box{ <-10,-0.02,-0.1> <10, 0.02, 0.1>		//Top Stripe
pigment{rgb titleColor}
translate 2*y}

box{ <-10,-0.02,-0.1> <10, 0.02, 0.1>		//Bottom Stripe
pigment{rgb titleColor}
translate -2*y}


#if (frame_number=2)
union {
object {title translate <-0.3,0.4,0>}

union{
text { ttf "cyrvetic.ttf", "HAPPI FISH is the favorite of fish", 0.1, 
 0 }

text { ttf "cyrvetic.ttf", "lovers (and by that we mean pet", 0.1, 
 0 translate -0.9*y}
 
text { ttf "cyrvetic.ttf", "goldfish owners, NOT seafood fans)", 0.1, 
 0 translate -1.8*y}
 
text { ttf "cyrvetic.ttf", "everywhere. Our fish food is made", 0.1, 
 0 translate -0.9*3*y}
 
text { ttf "cyrvetic.ttf", "from the finest ground up, dried...", 0.1, 
 0 translate -0.9*4*y}
 
text { ttf "cyrvetic.ttf", "um... fish.  By the way, if you're", 0.1, 
 0 translate -0.9*5*y}
 
text { ttf "cyrvetic.ttf", "reading this, you need to get out", 0.1, 
 0 translate -0.9*6*y}
 
text { ttf "cyrvetic.ttf", "more often and stop reading other", 0.1, 
 0 translate -0.9*7*y}
 
text { ttf "cyrvetic.ttf", "people's code.  Really, now!", 0.1, 
 0 translate -0.9*8*y}
 
pigment{rgb titleColor}
scale 0.1
translate <-0.75,0.1,0>
}
scale 2.75
}

#end //if frame_number = 2

// END File labelFF.pov