
/*
**                                              Hand.inc
**                                              ========
**
** This file defines a hand and provides two routines:
**      InitHand which sets the default position of the hand and
**      MakeHand which defines the hand object.
*/

#macro InitHand()
#declare pointer_curl = 0.1;
#declare middle_curl = 0.1;
#declare ring_curl = 0.1;
#declare pinky_curl = 0.1;
#declare thumb_curl = 0.5;
#declare thumb_rotation = .1;
#declare thumb_base_curl = thumb_curl;
#end

#macro MakeHand()
#declare hand = object{
        union{
                sphere{<0,0,1> 1
                scale<.5,1,1>
                }
// thumb
                union{
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .4
                                    <0,.75,0> .25
                        }
                        
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .25,
                                    <0,.5,0> .25
                                    rotate<thumb_curl*90,0,0>
                                    translate<0,.75,0>
                        }
                rotate<thumb_base_curl*90,0,0>
                rotate<0,thumb_rotation*90,-10>
                translate<.1,.6,.7>            
                }                    
 
 // pointer
                union{
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .3
                                    <0,0,1> .2
                        }
                        
                        union{
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.5> .2
                                }
                                
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.5> .2
                                    rotate<0,pointer_curl*90,0>
                                    translate<0,0,.5>
                                }
                        rotate<0,pointer_curl*90,0>
                        translate<0,0,1>
                        }
                        
                rotate<0,pointer_curl*30,0>
                translate<0,.6,1.5>            
                }                    
 
 // middle
                union{
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .3
                                    <0,0,1> .2
                        }
                        
                        union{
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.7> .2
                                }
                                
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.5> .2
                                    rotate<0,middle_curl*90,0>
                                    translate<0,0,.7>
                                }
                        rotate<0,middle_curl*90,0>
                        translate<0,0,1>
                        }
                rotate<0,middle_curl*30,0>
                translate<0,.1,1.5>            
                }                    
 // ring
                union{
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .3
                                    <0,0,1> .2
                        }
                        
                        union{
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.5> .2
                                }
                                
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .2,
                                    <0,0,.5> .2
                                    rotate<0,ring_curl*90,0>
                                    translate<0,0,.5>
                                }
                        rotate<0,ring_curl*90,0>
                        translate<0,0,1>
                        }
                rotate<0,ring_curl*30,0>
                translate<0,-.37,1.3>            
                }                    

// pinky
                union{
                        sphere_sweep{linear_spline 2
                                    <0,0,0> .2
                                    <0,0,.75> .15
                        }
                        
                        union{
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .15,
                                    <0,0,.5> .15
                                }
                                
                                sphere_sweep{linear_spline 2
                                    <0,0,0> .15,
                                    <0,0,.5> .15
                                    rotate<0,pinky_curl*90,0>
                                    translate<0,0,.5>
                                }
                        rotate<0,pinky_curl*90,0>
                        translate<0,0,.75>
                        }
                rotate<0,pinky_curl*30,0>
                translate<0,-.75,1.0>            
                }                    
              
//                pigment {White}
        }
}
#end              

