// Author: Darwin Gregory
// Date:   April 2005
// Purpose: Entry into IRTC for March-April 2005

#include "colors.inc"
#include "cat.inc"      // Cat head

camera {
        perspective //keyword is facultative in this case
        location <1,1,80>
        look_at <-3,4,0>
        angle 35
        blur_samples 100 //add samples if you got a fast computer
        aperture 2
        focal_point <0,0,0>
        }

light_source {<70,100,100> White*2}
light_source {<1,1,80> Gray40}

// Cat Tail
   #declare ikn_p1 = <-1,-2,0>; // Startpoint of neck
   #declare ikn_z1 = y;         // Forward vector at startpoint
   #declare ikn_y1 = z;         // Up vector at startpoint

   #declare ikn_p2 = <+1,+2,0>; // Endpoint of neck
   #declare ikn_z2 = y;         // Forward vector at endpoint
   #declare ikn_y2 = z;         // Up vector at endpoint
   
   #declare ikn_twist = 0;      // Attempted twisting.
   
   #declare ikn_radius1 = 0.3;  // Radius at startpoint
   #declare ikn_radius2 = 0.25;  // Radius at endpoint
   
   #declare ikn_length = 4.8;   // Length of neck
   #declare ikn_links = 200;    // Number of links in neck
   
   #declare TailTexture =
   texture {
      pigment {
        radial
        color_map{
          [1 color rgb 0]
          [0.5 color Catbrown]
          [1 color rgb 0]
          }
        frequency 15
        turbulence 0.4
        rotate<80,0,0>
      }

   }


// STIFFNESS VALUES FOR TAIL:
   #declare ikn_stiffness1 = .4; // Relative stiffnes at startpoint
   #declare ikn_stiffness2 = .25; // Relative stiffnes at endpoint
   
// INCLUDE IKN.INC:
   #include "ikn.inc"
   
// CREATE TAIL:
   #declare Tail =
   union {
      #declare C = 0;
      #while (C<=ikn_links-1)
         
         #declare T = C/(ikn_links-1);
         
         sphere {
            0, 1
            texture {
               TailTexture
               translate -z*T*ikn_length/(ikn_radius1/2+ikn_radius2/2)
            }
            scale ikn_r[C]
            transform ikn_transform[C]
         }
         
         #declare C = C+1;
      #end
   }
                                      

sky_sphere {pigment {rgb <0.8,0.8,0.9>}}

//Porch

box {
  <15, -2.5, 3>
  < -50,  -15,  90>
   texture {
      pigment {
        color Gray40
      }            
      finish {
        ambient 0.3
      }

   }
}

// Corner Post
box {
  <15, -2.5, 3>
  <11,  35,  7>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}

// Horizontal supports

box {
  <15, 6, 3>
  <-35,  10,  5>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}

box {
  <15, 16, 3>
  <-35,  20,  5>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}

box {
  <15, 6, 3>
  <17,  10,  36>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}


box {
  <15, 16, 3>
  <17,  20,  36>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}

// Corner Post
box {
  <15, -2.5, 36>
  <11,  35,  40>
   texture {
      pigment { color White }            
      finish { ambient 0.3 }
   }
}

// cat behind porch

object {CatHead
   translate <-1, 0, -1>
   rotate <0, 30, 0>
   scale <3, 3, 3>
}

object {Tail
   translate <-2, 3, -3>
   rotate <0, 45, 45>
   scale <3, 3, 3>
}

