// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
// general math functions and macros
// 
#include "math.inc"

#declare Cat_BrickA = pigment { 
   bozo
   pigment_map {
     [0.00 colour rgb <70,69,74>/225]
     [0.40 colour rgb <94,100,98>/225]
     [0.60 colour rgb <114,123,122>/255]
     [1.00 colour rgb <159,169,161>/225]
    }
  scale 10  
  }

#declare Cat_MortarB = pigment { 
   bozo
   pigment_map {
     [0.00 colour rgb <70,69,74>/225*.25]
     [0.40 colour rgb <94,100,98>/225*.25]
     [0.60 colour rgb <114,123,122>/255*.25]
     [1.00 colour rgb <159,169,161>/225*.25]
    }
  scale 10  
  }
#declare Cat_MortarA = pigment { 
   bozo
   pigment_map {
     [0.00 colour rgb <70,69,74>/225*.75]
     [0.40 colour rgb <94,100,98>/225*.75]
     [0.60 colour rgb <114,123,122>/255*.75]
     [1.00 colour rgb <159,169,161>/225*.75]
    }
  scale 10  
  }

//low Quality rock
#declare CatStone1 = superellipsoid{<.1,.1> scale <1,1,.5>*.65 pigment{Cat_BrickA scale .1} normal{bumps.5 scale .05}}
#ifdef (FCS) #undef FCS #end
#declare FCS=function{pigment{
  granite                       
  turbulence 0.25
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 1
  }
}

  #declare Fns = function {f_hetero_mf(x,y,z,1.1, 2.05, 10, 0.5, .5,3)}
  #declare WD = .125;

#macro Make_StoneWall(Wwidth,Wheight,Wseed,Wcap,HQual,WWriteFile)
  #if (WWriteFile) #write(filehandle,"union{\n") #else union{ #end
   #local TT = 1; #local TT2 = 1;
   #while (TT<Wheight)
    #while (TT2<Wwidth)
     #local rndTT = rand(seed(TT*TT2*Wseed));
     #if(WWriteFile)
      #switch(int(4*rndTT+1))
       #case (1) #write(filehandle,"#local BrickM = Brick6;\n") #break
       #case (2) #write(filehandle,"#local BrickM = Brick7;\n") #break
       #case (3) #write(filehandle,"#local BrickM = Brick3;\n") #break
       #case (4) #write(filehandle,"#local BrickM = Brick4;\n") #break
       #case (5) #write(filehandle,"#local BrickM = Brick5;\n") #break
       #else #write(filehandle,"#local BrickM = Brick3;\n")
      #end 
      #switch(int(7*rand(seed(TT*rndTT*Wseed))+1))
       #case (1) #write(filehandle,"#local ScaleM = < 1, 1, 1>;\n") #break
       #case (2) #write(filehandle,"#local ScaleM = <-1, 1, 1>;\n") #break
       #case (3) #write(filehandle,"#local ScaleM = < 1,-1, 1>;\n") #break
       #case (4) #write(filehandle,"#local ScaleM = < 1, 1,-1>;\n") #break
       #case (5) #write(filehandle,"#local ScaleM = <-1,-1, 1>;\n") #break
       #case (6) #write(filehandle,"#local ScaleM = < 1,-1,-1>;\n") #break
       #case (7) #write(filehandle,"#local ScaleM = <-1, 1,-1>;\n") #break
       #case (8) #write(filehandle,"#local ScaleM = <-1,-1,-1>;\n") #break
       #else #write(filehandle,"#local ScaleM = < 1, 1, 1>;\n")
      #end
      #write(filehandle,"#local CatStone2 = object {\n")
       #write(filehandle,"BrickM\n")
       #write(filehandle,"scale<.8,.8,.7> scale ScaleM\n")
      #write(filehandle,"}\n")
      #write(filehandle,"#declare Cat_BrickHA = pigment { bozo\n")
       #write(filehandle,"pigment_map {\n")
        #write(filehandle,"[0.00 colour rgb <70,69,74>/225*(1+.3*",rndTT,")]")
        #write(filehandle,"[0.40 colour rgb <94,100,98>/225*(1.1+.3*",rndTT,")]")
        #write(filehandle,"[0.60 colour rgb <114,123,122>/255*(1+.3*",rndTT,")]")
        #write(filehandle,"[1.00 colour rgb <159,169,161>/225*(1+.3*",rndTT,")]")
       #write(filehandle,"}\n")
       #write(filehandle,"turbulence 1 scale 1\n") 
      #write(filehandle,"}\n")
     #else
      #switch(int(3*rndTT+1))
       #case (1) #local BrickM = 0; #break
       #case (2) #local BrickM = 90; #break
       #case (3) #local BrickM = 180; #break
       #case (4) #local BrickM = -90; #break
       #else #local BrickM = 0;
      #end 
      #switch(int(7*rand(seed(TT*rndTT*Wseed))+1))
       #case (1) #local ScaleM = < 1, 1, 1>; #break
       #case (2) #local ScaleM = <-1, 1, 1>; #break
       #case (3) #local ScaleM = < 1,-1, 1>; #break
       #case (4) #local ScaleM = < 1, 1,-1>; #break
       #case (5) #local ScaleM = <-1,-1, 1>; #break
       #case (6) #local ScaleM = < 1,-1,-1>; #break
       #case (7) #local ScaleM = <-1, 1,-1>; #break
       #case (8) #local ScaleM = <-1,-1,-1>; #break
       #else #local ScaleM = < 1, 1, 1>;
      #end
      #local CatStone2 = object {
       brickred
       rotate x*BrickM scale <.8,.8,.7>*.6 scale ScaleM 
      }
     #declare Cat_BrickHA = pigment { 
      bozo
/*      pigment_map {
       [0.00 colour rgb <64,44,35>/225*(.8+.3*rndTT)]
       [0.40 colour rgb <123,82,52>/225*(.8+.3*rndTT)]
       [0.60 colour rgb <126,100,64>/255*(.8+.3*rndTT)]
       [1.00 colour rgb <149,116,47>/225*(.8+.3*rndTT)]
*/      pigment_map {
       [0.00 colour rgb <64,54,45>/225*(1+.3*rndTT)]
//       [0.20 colour rgb <123,102,82>/225*(1.1+.3*rndTT)]
       [0.20 colour rgb <220,220,220>/225*(1+.1*rndTT)]
       [0.80 colour rgb <126,110,84>/255*(1+.3*rndTT)]
       [1.00 colour rgb <149,136,87>/225*(1+.3*rndTT)]
      }
      turbulence 1 scale 1 
     }
     #end
     #if(WWriteFile)
      #if (HQual) #write(filehandle,"#declare CatStoneF = CatStone2;\n") #else #write(filehandle,"#declare CatStoneF = CatStone1;\n") #end 
     #else
      #if (HQual) #declare CatStoneF = CatStone2; #else #declare CatStoneF = CatStone1; #end 
     #end
     #local Ostt = (odd(TT) ? 0 : 1.2+.2*rndTT);
     #if(WWriteFile)
      #write(filehandle,"object{CatStoneF translate <",Ostt,"+1.4*(",TT2,"-1),1.4*(",TT,"-1),0> pigment{Cat_BrickHA} normal { bumps 1 scale .05 } finish{ambient 0 diffuse 1}}\n") 
     #else
      object{CatStoneF translate <Ostt+3*(TT2-1),1.2*(TT-1),0> pigment{Cat_BrickHA} normal { bumps 1 scale .05 } finish{ambient 0 diffuse 1}} 
     #end
     #local TT2=TT2+1;
     #if (Wcap)
      #if (TT>Wheight-2)//(TT>Wwidth-1) 
       #if(WWriteFile)
        #write(filehandle,"object{CatStoneF rotate x*45 scale <1.25,.75,1> translate <",Ostt,"+1.4*(",TT2,"-1)-1.4,1.4*",Wheight,"-2,0> pigment{Cat_BrickHA} normal { bumps 1 scale .05 } finish{ambient 0 diffuse 1}}\n")
       #else
        object{CatStoneF rotate x*45 scale <1.25,.75,1> translate <Ostt+1.4*(TT2-1)-1.4,1.4*Wheight-2,0> pigment{Cat_BrickHA} normal { bumps 1 scale .05 } finish{ambient 0 diffuse 1}}
       #end
      #end
     #end
    #end
    #local TT=TT+1; #local TT2 = 1;
   #end


  #declare ffa =  isosurface { function{y-Fns(x*1.15,1,z)}
     contained_by { box {<0,-1,-3.25>,<3*(Wwidth-1.5),2,1.35*(Wheight-2)>} } 
     max_gradient 6
     threshold 0
    } 

   object{ffa texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}
     scale<1.05,.15,1.05>*.8  rotate x*-90   translate <0,2,-.3>}


  #if(WWriteFile)
   #write(filehandle,"translate x*-(",Wwidth,"*1.4-1.4-.7)/2\n")
  #else
   translate x*-(Wwidth*1.4-1.4-.7)/2 
  #end
  #if (WWriteFile) #write(filehandle," }") #else } #end


#end

