
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions   
/*
#include "hostextures.inc"

// perspective (default) camera
camera {
  location  <0.0, 0.0, -7.2>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}
                   
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}  
*/

#declare TextureBWall = texture{
    pigment{      
        gradient -z
        color_map {
          [0.0 color rgb<1,1,.9>*.7]
          [0.9 color rgb<1,1,.9>*.7]
          [0.905 color rgb<.8,1,.8>*.5]
          [1.0 color rgb<.8,1,.8>*.5]
        }
    scale 5 turbulence 1 
    }
    normal{bumps 1.5 scale .0005}
    finish{ambient 0 diffuse 1}
}
#declare TextureBWall2 = texture{
    pigment{      
        gradient -z
        color_map {
          [0.0 color rgb<1,1,1>*.7]
          [1.0 color rgb<1,1,1>*.5]
        }
    scale 5 turbulence 1 
    }
    normal{bumps 1.5 scale .01}
    finish{ambient 0 diffuse 1}
}

#declare Spl = function {
   spline {
     natural_spline
      -1, <-0.45, 0, 0>,
    -0.5, <-0.50, 0, 0>,
    0.05, < 0.0, 0, 0>,
     0.2, < 0.05, 0, 0>,
     0.3, < 0.20, 0, 0>,
       1, < 1.00, 0, 0>
   }
 }
#declare fn_Bi = function { z-.6 }
#declare fn_Bii = function { z+.4 }

#declare BW1 = isosurface {
  function { max(y - Spl(x).x,fn_Bi(x,y,z)) -f_crackle(x*10, y*20, z*25)*.1}
//  function { max(y - Spl(x).x - Spl(z).z,fn_Bi(x,y,z)) -f_crackle(x*10, y*20, z*25)*.1}
    contained_by { box {<-1.5,-1.5,-1>,<1,.5,1>} } 
    max_gradient 24
    threshold -.5
  } 
#declare BW2 = isosurface {
  function { max(y - Spl(x).x,fn_Bii(x,y,z))}// -f_crackle(x*10, y*20, z*25)*.1}
//  function { max(y - Spl(x).x - Spl(z).z,fn_Bi(x,y,z)) -f_crackle(x*10, y*20, z*25)*.1}
    contained_by { box {<-1.5,-1.5,-1>,<1,.5,1>} } 
    max_gradient 24
    threshold -.5
  } 

#declare BackWall = union{
 object{BW1 scale<1,1,-1> texture{TextureBWall}}
 object{BW2 scale<1,1,-1> texture{TextureBWall2} translate z*-1.02}
}

//object{BackWall rotate y*0}