/*
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions   
#include "hostextures.inc"

// perspective (default) camera
camera {
  location  <0.0, 0.0, -7.2>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}
                   
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 20, -20>
}  
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <20, -20, -20>
}  
*/


#declare Fc = function { sqrt(pow(x,2) + pow(z,2)) - 1 } 
#declare Fcyl = isosurface {
    function { Fc(x,y,z) - f_dents(x * 15, y * 2, z * 1) * .07}
    contained_by { box {<-1,-1,-1>,<1,10,1>} } 
    max_gradient 2
    threshold -.5
  } 

//***door***

#declare doororn = difference{
 box{<-.25,-.5,-.5><.25,.5,0> translate y*1}

 box{<-.25,-.6,-.5><.25,.6,-1> rotate y*45 translate y*1}
 box{<-.25,-.6,-.5><.25,.6,-1> rotate y*-45 translate y*1}
 //pigment{color rgb 1}
}

//object{doororn rotate y*180 scale .5 translate<-.15,.15,-0.1>}
#declare window = box{<-.15,1,-.0><.15,1.25,.025> 
  pigment{rgbf <1,1,.8,.8>}
  normal{ripples translate y*50 scale .00001}
  rotate z*45
}
// _o/
#declare partone = union{
  cylinder{<0,-1.00,0><0,-0.77,0>,.2 }
  cylinder{<0,-0.48,0><0,-0.27,0>,.2 }
  cylinder{<0, 0.02,0><0, 0.27,0>,.2 }
  cylinder{<0, 0.48,0><0, 0.75,0>,.2 } 
  sphere{0,.2 translate y*-1}
  difference{
   box{<-1,-1,0><-.1,1,.1>}
   sphere{0,.1 translate<-.6,-.5,0.015>}
   sphere{0,.1 translate<-.6,-.0,0.015>}
   sphere{0,.1 translate<-.6, .5,0.015>}
  }
  texture{TextureBrass} texture{TextureWall2 scale .001}
}

#declare parttwo = union{
 object{partone}
 object{partone scale<-1,-1,1> rotate y*45}
} 
#declare parttwo2 = union{
 object{partone}
 object{partone scale<-1,-1,1> rotate y*100}
} 

#declare WDoor = union{
 object{window translate<1,.2,0>}

 union{
  difference{
   box{<-.5,0,-.05><.5,2,.05>} 
   box{<-.35,1,-.5><.35,1.85,.5>}
   object{doororn rotate y*180 scale .6 translate<-.2,.0,-0.32>}
   object{doororn rotate y*180 scale .6 translate< .2,.0,-0.32>}
  }
 
  object{doororn scale .4 translate<-.2,.2,0.16>}
  object{doororn scale .4 translate< .2,.2,0.16>}

  object{Fcyl scale <-.075,.075,.1> translate< .35,1.08,0>}
  object{Fcyl scale <.075,.075,.1> translate<-.35,1.08,0>}
  object{Fcyl scale <.075,.075,.1> rotate z*-90 translate<-.35,1.85,0>}
  object{Fcyl scale <.075,.075,.1> rotate z*-90 translate<-.35,1.00,0>}

  object{Fcyl scale <.05,.045,.1> rotate z*-0 translate<-.0,0.95,0>}
  object{Fcyl scale <.05,.035,.1> rotate z*-90 translate<.01,1.4,0>}

  texture{T_Wood3 scale .1} texture{TextureDoor2 scale .25 translate<0,1.12,0>} texture{TextureWall2 scale .1}
  normal{wrinkles scale<.1,.1,1>}
  rotate y*0
 }
 object{parttwo scale.05 rotate y*160 translate<.52,.25,0>}
 object{parttwo2 scale.05 rotate y*40 translate<.51,1.75,0>}
}

//****

//***slab***

#declare hosslab = union{
 superellipsoid{<.25,.05> scale<2.01,.025,1.01>}
 object {Fcyl rotate z*90 scale <.36,.1,.1> translate <1.6,-.05,-1>}
 object {Fcyl rotate z*90 scale <.36,.1,.1> translate <1.6,-.05, 1>}
 object {Fcyl rotate x*90 scale <.1,.1,.18> translate <2,-.05, -.8>}
 object {Fcyl rotate x*90 scale <.1,.1,.18> translate <-2,-.05, -.8>}
 sphere{0,.06 translate<-2,-.05,-1>}
 sphere{0,.06 translate< 2,-.05,-1>}
 sphere{0,.06 translate<-2,-.05, 1>}
 sphere{0,.06 translate< 2,-.05, 1>}
 texture{T_Wood3 scale .1} texture{TextureWall2 scale .1}
 normal{wrinkles scale<.1,.1,1>*2}
 finish{specular 1.75 roughness 0.15 reflection .02 ambient 0 diffuse 1}
} 

#declare WDoorB = object{
 #declare bend_object = object{WDoor scale<.9,1,1>}
 #declare bend_angle = -20;
 #declare bend_direction = z;
 //#declare bend_smoothness = 50;
 #declare bend_start = .4;
 #declare bend_start = .8;

 #include "Bend.inc"
 rotate x*10
}

#declare Fnbl = function {f_hetero_mf(x,y,z,1.1, 2.05, 10, 0.1, 0,2)}
#declare WD = .125;

#declare ffbla =  isosurface { function{y-Fnbl(x*1.15,1,z)}
    contained_by { box {<-3.5,-(WD+.375),-3.5>,<3.5,-WD,3.5>} } 
    max_gradient 6
    threshold -0.5
  } 
#declare ffblb =  isosurface { function{y-Fnbl(x*1.15,1,z)}
    contained_by { box {<-3.5,-(WD+0.05),-3.5>,<3.5,-WD,3.5>} } 
    max_gradient 6
    threshold -0.5
  } 
#declare buildwall = union{
 object{ffbla texture{pigment{rgb .5} normal{bumps 2 scale .01} finish{ambient 0 diffuse 1}} translate y*-.1}
 object{ffblb texture{TextureWall pigment{turbulence 4} scale 2 translate z*-3} texture{pigment{rgbf .8}}}
         scale<1.05,.2,1.05>*.8  translate<0,0.04,1> 
} 

#declare bbwall = difference{
  union{
   object{buildwall rotate x*-90 scale .35 translate<0,-.5,-1>}
   object{buildwall rotate x*-90 rotate z*180 scale <.5,1,1>*.35 translate<-.5,1.5,-1>}
   box{<-1,-1.2,.1><0,1.2,.2> translate z*-1.095 texture{TextureWall pigment{turbulence 4} scale 1 translate z*-3} texture{TextureWall2} texture{pigment{rgbf .7} finish{ambient 0 diffuse 1}}}
  }
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate<-.5,1.4,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate<-.5,.5,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate<-.5,.5,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate< .0,.5,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate< .5,.5,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate<-.5,-.4,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate< .0,-.4,0>}
  box{<-.2,-.3,-2><.2,.3,2> pigment{rgb .5} translate< .5,-.4,0>}
}

#declare backbuilding = union{
 union{
  box{<-1,0,-1><1,.1,1> translate y*2}
  box{<-1,0,-1><1,.1,1> translate y*1}
  box{<-1,0,-1><1,.1,1> translate y*0}
  box{<-1,0,-1><1,.1,1> translate y*-1}
  box{<-.05,-1,-.05><.05,2.2,.05> translate < .8,0,-.8>}
  box{<-.05,-1,-.05><.05,2.2,.05> translate < .8,0, .8>}
  box{<-.05,-1,-.05><.05,2.2,.05> translate <-.8,0,-.8>}
  box{<-.05,-1,-.05><.05,2.2,.05> translate <-.8,0, .8>}
  texture{pigment{rgb <1,1,.9>*.7} normal{wrinkles 1.5 scale.1} finish{ambient 0 diffuse 1}}
 }
 object{bbwall}
 object{bbwall scale<-1,1,-1> translate z*1}
}

#declare rndTT = .5;
#macro pigmRubble(Bright,rndTT,pScale)
 #declare Cat_BrickA = pigment { 
   bozo
      pigment_map {
       [0.00 colour rgb <64,54,45>/225*(Bright+.3*rand(seed(rndTT)))]
       [0.20 colour rgb <220,220,220>/225*(Bright+.1*rand(seed(rndTT)))]
       [0.80 colour rgb <126,110,84>/255*(Bright+.3*rand(seed(rndTT)))]
       [1.00 colour rgb <149,136,87>/225*(Bright+.3*rand(seed(rndTT)))]
      }
      turbulence 1 scale pScale 
  }
#end

#include"rubble1.is2"
pigmRubble(1.5,123,.01)
#declare RubbleM1 = union{
 object{rubble1 scale<1,.5,1>
  texture{pigment{Cat_BrickA} normal{bumps 2.5 scale .001 }} texture{TextureWall2 scale .1}  
  rotate y*180 
 }
 object {rubble1 scale <1,.5,1> rotate y*90 texture{pigment{rgb 1} normal{bumps 2 scale .001 }}}
}
pigmRubble(1.4,3123,.01)
#declare RubbleM2 = union{
 object{rubble1 scale<1,.5,1>
  texture{pigment{Cat_BrickA} normal{bumps 2.5 scale .001 }} texture{TextureWall2 scale .1}  
  rotate y*180 
 }
 object {rubble1 scale <1,.5,1> rotate y*0 texture{pigment{rgb 1} normal{bumps 2 scale .001 }}}
}
pigmRubble(1.1,933,.01)
#declare RubbleM3 = union{
 object{rubble1 scale<1,.5,1>
  texture{pigment{Cat_BrickA} normal{bumps 2.5 scale .001 }} texture{TextureWall2 scale .1}  
  rotate y*180 
 }
 object {rubble1 scale <1,.5,1> rotate y*-90 texture{pigment{rgb 1} normal{bumps 2 scale .001 }}}
}

#declare FnWood = function{-f_superellipsoid(x,y,z,.1,.1)}
#include"woods.inc"
#declare T_Wood3c   =         
    texture { pigment { P_WoodGrain3A  color_map { M_Wood3A }} finish{ambient 0 diffuse 1} normal{bumps 1 scale .002}} 
    texture { pigment { P_WoodGrain3B  color_map { M_Wood3B }} finish{ambient 0 diffuse 1}}

#declare fA=function{pigment{P_WoodGrain2A scale 1 rotate y*90}}
#declare fB=function{pigment{P_WoodGrain2B scale 1 rotate y*90}}
#declare WoodBlock1 =  isosurface {function{FnWood(x,y*7,z*7)-fA(x,y,z).gray*2+fB(x/4,y,z).gray*2}
    contained_by { box {-2,2} } 
    max_gradient 20
    threshold 0
  } 
#local Rd = .15;
#declare rod1 = sphere_sweep {
    cubic_spline
    9,
    <-4,  0, 0>, Rd
    <-5,  5, -.5>, Rd
    <-3,  2, -.2>, Rd
    <-1, -0, -.3>, Rd
    < 3, -2, 0>, Rd
    < 5, -5, -.2>, Rd
    < 7, -8, -.1>, Rd
    < 7.5, -10, -.5>, Rd
    < 7, -15, 0>, Rd
    tolerance 0.1
    rotate z*-45
    scale .1  
  }
#declare rod2 = sphere_sweep {
    cubic_spline
    5,
    <-4,  0, 0>, Rd
    <-3,  2, -.2>, Rd
    <-1, -0, -.3>, Rd
    < 3, -2, 0>, Rd
    < 5, -5, -.2>, Rd
    tolerance 0.1
    
    scale .1  
  }

#declare FnCeil = function {f_hetero_mf(x,y,z,1.1, 2.05, 15, 0.0, .5,1)}
#local WD = -2;
#declare ffpc1 =  isosurface { function{y-FnCeil(x+1.5,1,z-2)}
//    contained_by { box {<-0,-(WD-.025),-1.2>,<1.5,-WD,0>} } 
    contained_by { box {<-1,-.125,-2>,<.8,-WD,.5>} } 
    max_gradient 6
    threshold -.5
  } 
#declare ffpc2 =  isosurface { function{y-FnCeil(x+1.5,1,z-2)+f_noise3d(x,y,z)/15}
    contained_by { box {<-1,-.125,-2>,<.8,0.2,.5>} } 
//    contained_by { box {<-1,-.125,-2>,<.8,-WD,.5>} } 
    max_gradient 6
    threshold -.5
  } 

#declare ceilingRubble_a = union{
  object{ffpc1 scale<1,.05,1>rotate x*-90 rotate z*180 rotate y*-90 scale 1 translate<.2,0,0>}                                                                 
  object{ffpc2 pigment{rgb .8} finish{ambient 0 diffuse 1} scale<1,1,1>rotate x*-90 rotate z*180 rotate y*-90 scale 1 translate<-.05,0,0>}                                                                 
  object{ffpc1 scale<-1,.05,1>rotate x*-90 rotate z*180 rotate y*90 scale 1 translate<-.2,0,0>}
  texture{TextureWall1 scale 10} texture{TextureWall2 scale 1}                                                                
  translate z*-.25 translate x*.2
 }

#declare ceilingRubble_b = union{
 union{
  object{rod1 translate <0,0,0>}
  object{rod1 scale <-1,1,1> translate <0,0,.25>}
  object{rod1 scale < 1,-1,1> translate <0,-.4,.50>}
  object{rod2 scale < 1,1,1> rotate z*-45 translate <-.1,-1.6,0>}
  texture{TextureIronRod} texture{TextureWall2 scale .5}
 }
 union{
  object{rod2 scale < 1,1,1> rotate z*-45 rotate x*90 translate <0,0,.25>}
  object{rod2 scale <-1,1,1> rotate z*-45 rotate x*90 rotate y*-80 translate <0,-.25,.25>}
  object{rod2 scale < 1.2,1,1> rotate z*-45 rotate x*90 translate <0,-.50,.25>}
  object{rod1 scale <-1,1,1> rotate x*-90 translate <-.1,.5,.25>}
  texture{TextureIronRod} texture{TextureWall2 scale .5}
 }

 union{
  object{rod1 scale < 1,1,1> rotate x*90 translate <.1,1.75,-.25>}
  object{rod2 scale <-1,1,1> rotate z*-45 rotate x*90 rotate y*-80 translate <.1,1.25,-.25>}
  object{rod2 scale < 1.2,1,1> rotate z*-45 rotate x*90 translate <.1,.50,-.25>}
  object{rod1 scale <-1,1,1> rotate x*-90 translate <0,.75,-.25>}
  texture{TextureIronRod} texture{TextureWall2 scale .5}
 }
}

#declare ceilingRubble = union{
 object{ceilingRubble_a} 
 object{ceilingRubble_b} 
}

#declare ceilingRubbleA = union{
 object{ceilingRubble_a scale<1.2,1,1>} 
 object{ceilingRubble_b} 
}

#local Fnr = function { f_sphere(x,y,z,1)-f_noise3d(x*1, y*1, z*1)*1 }
#declare ffry = isosurface { function{Fnr(x,y,z)+f_crackle(x*2, y*4, z*5)*.5}
    contained_by { box {-1.5,1.5} } 
    max_gradient 15
    threshold 0
} 

#declare ceilingRubble2 = union{
 object{ceilingRubbleA}
 object{ffry pigment{rgb .8} finish{ambient 0 diffuse 1} scale <1,1.25,1>*.15 translate<0,-1.3,0> }
}
 
#declare ceilingRubbleB = object{
 #declare bend_object = object{ceilingRubble2 scale<1,1,1> translate<.4,1.5,.5>}
 #declare bend_angle = -50;
 #declare bend_direction = x;
 #declare bend_smoothness = 1;
 #declare bend_start = .2;
 #declare bend_start = .8;

 #include "Bend.inc" 
 
#declare rubbleIron = union{
  object{rod1 scale <1,1,1> rotate x*-0 translate <0,0,0> texture{TextureIronRod} texture{TextureWall2 scale .5}}
  object{ffry texture{TextureBrick scale 1 rotate x*90} rotate x*-90 scale <1,1,1>*.15 translate<0,-1.3,0>}
}

// translate<-.4,-1.5,-.5>
}

//object{rubbleIron}
//object{ceilingRubbleB rotate y*45 }
//object{WoodBlock1  scale <-1,1,1> rotate<-30,30,0> texture{T_Wood5c rotate y*90} normal{bumps 5 scale 1.5} }


//object{RubbleM3}
//object{backbuilding scale <1,1.1,1>*.5}
//object{WDoor scale<.9,1,1>  }
//object{hosslab rotate x*-45}

