#include "stdinc.inc"
#include "shapesq.inc"

#include "sky.inc"
#include "my_textures.inc"

// rough scale: 1 pov unit = ~3m

do_sky(0.75)

global_settings
{
	max_trace_level 10
	ambient_light 1
}


light_source
{
	<325,200,-500> colour rgb 2
	parallel
	point_at 0
}

light_source
{
	<-100,200,-125> colour rgb 0.75
	parallel
	point_at 0
	shadowless
}

#declare blur_plane=
plane
{
	<0,1,0>, 0
	texture {layer_texture}
}

#declare plain_plane=
plane
{
	<0,1,0>, 0
	pigment
	{
		checker
		pigment {Green},
		pigment {Red}
		scale 5
	}
}

#macro std_sphere(rad,loc,tt)
sphere
{
	0, rad
	translate <0,rad,0>
	translate loc
	texture{tt}
}
#end

#macro std_cube(rad,loc)
superellipsoid
{
	<0.2, 0.2>
	scale rad
	rotate <0,17,0>
	translate <0,rad,0>
	translate loc
	texture{reftext}
}
#end

#macro
std_cone(rad,loc)
cone
{
	0, rad, <0,rad*2.5,0>, 0
	translate loc
	texture{reftext}
}
#end

#macro
std_cyl(rad,loc)
cylinder
{
	0, <0,rad*2,0>, rad
	translate loc
	texture{reftext}
}
#end

#local i=0;
#local j=0;
#while(i<1000)
#declare sx=f_snoise3d(i,20,j)*5000;
#declare sy=f_snoise3d(i,30,j)*10000;
#if(vlength(<sx,0,sy>)>125)
	std_sphere(10+f_snoise3d(i,50,j)*2,<sx,0,sy>,reftext)
#local i=i+1;
#end
#local j=j+1;
#end

std_cube(10,<-150,0,550>)

std_sphere(10,<-100,0,120>,reftext)
std_sphere(10,<110,0,25>,reftext)
std_sphere(10,<-55,0,-50>,reftext)

std_cone(12.5,<900,0,1100>)
std_cyl(12.5,<-100,0,2500>)

#declare br=30;

#declare base_sphere=
difference
{
	std_sphere(br,0,reftext)
	std_sphere(br-2,0,inttext)
}

#declare test_sphere=
intersection
{
	object{base_sphere}
	box{<-27,-5,-27> <27,40,27> rotate <0,30,0> texture{inttext}}
}

#declare hspl=
spline
{
	quadratic_spline
	0,	<1.25,0>
	35, <1,0>
	60, <2.5,0>
	75, <1.5,0>
	120, <1.15,0>
	135, <1.1,0>
	165, <1.25,0>
	180, <0.75,0>
	200, <1.5,0>
	220, <1.25,0>
	240, <1,0>
	300, <3.0,0>	// NW
	320, <1.6,0>
	360, <1.5,0>
}

#macro sphere_part(i,j,ji,jr,px,py)
intersection
{
	object{base_sphere} 
	intersection
	{
		cylinder{<0,i,0> <0,i+1,0> br+1}
		object
		{
			Wedge(360/ji)
			rotate <0,-180/ji,0>
		}
	}
	texture{inttext}
	translate <0,0,-jr>
	rotate <0,f_snoise3d(px*10,py*10,i)*4,0>
	translate <0,0,jr>
	translate <0,0,f_snoise3d(px*3,py*3,i/2)*clip((i-27)/3,0,1)*0.5>
	clipped_by{sphere{<0,i+0.5,jr-2>, 4}}
	bounded_by{clipped_by}
}
#end

#macro cen_part(i)
object
{
#declare jr=sqrt((30*30)-(i-30)*(i-30));
#switch(jr)
#range(0,10)
#declare ji=8;
#break
#range(10,20)
#declare ji=16;
#break
#range(25,28)
#declare ji=32;
#break
#range(28,30)
#declare ji=64;
#break
#end

#declare ang=360*j/ji;
#declare px=sin(ang);
#declare py=cos(ang);
	sphere_part(i,j,ji,jr,px,py)
	translate <0,-i,1.125>
	translate <0,0,-jr>
}
#end

#include "crane.inc"


#declare big_sphere=
union
{
#local i=25;
#while(i<(br*2))

#declare jr=sqrt((30*30)-(i-30)*(i-30));
#switch(jr)
#range(0,10)
#declare ji=8;
#break
#range(10,20)
#declare ji=16;
#break
#range(25,28)
#declare ji=32;
#break
#range(28,30)
#declare ji=64;
#break
#end

#local j=0;
#while(j<ji)
#declare ang=360*j/ji;
#declare px=sin(ang);
#declare py=cos(ang);
#if(hspl(ang).x>(i-22)/10)
object
{
	sphere_part(i,j,ji,jr,px,py)
	rotate <0,j*360/ji+mod(i,2)*180/ji,0>
}
#end
#local j=j+1;
#end

#local i=i+1;
#end

	intersection
	{
		object {base_sphere}
		cylinder {0,<0,br-5.001,0> br+1 texture{inttext}}
	}
}


#declare p=
array[13]
{
	<0,0,0>,		//0
	<3.5,0,2>,		//1
	<-0.5,0,3.4>,	//2
	<2.7,0,4.4>,	//3
	<-0.6,0,5.6>,	//4
	<-3.5,0,3.6>,	//5
	<-2.5,0,0.25>,	//6
	<-4,0,-1.2>,	//7
	<-2,0,-2>,		//8
	<-0.2,0,-3.4>,	//9
	<1.8,0,-1.5>,	//10
	<3.2,0,-3.4>,	//11
	<5.4,0,-1.1>,	//12
}

#declare np=14;

#declare po=
array[np]

#declare pr=
array[np]

#declare pp=
array[np][3]
{
	{p[0],p[1],p[2]},	//0
	{p[1],p[2],p[3]},	//1
	{p[2],p[3],p[4]},	//2
	{p[2],p[4],p[5]},	//3
	{p[2],p[5],p[6]},	//4
	{p[0],p[2],p[6]},	//5
	{p[0],p[6],p[8]},	//6
	{p[6],p[7],p[8]},	//7
	{p[0],p[8],p[9]},	//8
	{p[0],p[9],p[10]},	//9
	{p[9],p[10],p[11]},	//10
	{p[0],p[1],p[10]},	//11
	{p[1],p[10],p[12]},	//12
	{p[10],p[11],p[12]},//13
}

#declare ppat=
array[np][3]
{
	{1,3,2},		//0
	{-3,4,5},		//1
	{-4,6,7},		//2
	{-7,8,9},		//3
	{-9,10,11},		//4
	{-2,-11,12},	//5
	{-12,13,14},	//6
	{15,16,-13},	//7
	{-14,15,16},	//8
	{-16,17,18},	//9
	{-17,19,20},	//10
	{-1,21,-18},	//11
	{-21,22,23},	//12
	{-19,24,-22}	//13
}

#declare pt=
array[np][2]
{
	{<-4,0,1>,<0,0,0>},	//0
	{<-2,0,2>,<0,-0.5,0>},	//1
	{<-3,0,1>,<0,0.5,0>},	//2
	{<0,0,3>,<0,0,0>},	//3
	{<2,0,5>,<0,-1,0>},	//4
	{<-2,0,-10>,<0,0,0>},	//5
	{<2,0,-17>,<0,-1,0>},	//6
	{<4,0,3>,<0,0,0>},	//7
	{<10,0,-1>,<0,0,0>},	//8
	{<17,0,5>,<-1,-0.5,0>},	//9
	{<1,0,1>,<0,1,-1>},	//10
	{<0,0,15>,<0,0,0>},	//11
	{<4,0,-4>,<0,0,0>},	//12
	{<-2,1,-8>,<0,0,0>},	//13
}

#macro middle(px,py,pz)
	(px+py+pz)/3
#end

#declare f_edge=
function
{
	f_bozo(x/2,y,z)*0.2+f_bozo(x*4,y*4,z)*0.1+f_granite(x,y,z)*0.03+f_bozo(x/10,y/5,z/5)*0.5
}

#declare hfres=8;

#macro edge(pa,pb,pat)
intersection
{
	height_field
	{
	#declare len=vlength(pb-pa);

	#if(pat>0)
		function hfres,hfres*len {f_edge(x*4,y*len,pat)+0.1}
	#else
		function hfres,hfres*len {1-f_edge(x*4,(1-y)*len,0-pat)}
	#end
		smooth
	}
	box
	{
#declare d=(pat/10000);
		<d,-20,d> <1-d,1,1-d>
	}
	translate <0,-0.5,0>
	rotate <0,0,90>
	scale <17,4,len>
	rotate <0,degrees(atan2(pb.x-pa.x,pb.z-pa.z)),0>
	translate pa
	translate <0,-3.9,0>
	texture{layer_texture}
}
#end

#macro edge3(pa,pb,pc,patab,patbc,patca)
intersection
{
#declare center=middle(pa,pb,pc);

#declare objab=object{edge(pa,pb,patab)}
#if(inside(objab,center)=0)
#declare objab=object{edge(pb,pa,patab)}
#end

#declare objbc=object{edge(pb,pc,patbc)}
#if(inside(objbc,center)=0)
#declare objbc=object{edge(pc,pb,patbc)}
#end

#declare objca=object{edge(pc,pa,patca)}
#if(inside(objca,center)=0)
#declare objca=object{edge(pa,pc,patca)}
#end
	object{objbc}
	object{objca}
	object{objab}
}
#end

#declare cs=15;

#local i=0;
#while(i<np)
#declare po[i]=object{edge3(cs*pp[i][0],cs*pp[i][1],cs*pp[i][2],ppat[i][0],ppat[i][1],ppat[i][2])};
#local i=i+1;
#end

difference
{
	object{blur_plane}
#local i=0;
#while(i<np)
	object{po[i] scale 1.02}
#local i=i+1;
#end
}

plane
{
	<0,1,0>, -10
	texture {concrete_texture}
}

#local i=0;
#while(i<np)
#declare pr[i]=
intersection
{
	object{blur_plane}
#declare mid=middle(cs*pp[i][0],cs*pp[i][1],cs*pp[i][2]);
	object{po[i]}
	translate -mid
	rotate pt[i][0]
	translate pt[i][1]
	translate mid
}
object{pr[i]}
#local i=i+1;
#end

#local i=0;
#while(i<np)
#local i=i+1;
#end

object
{
#if(detail<1)
	test_sphere
#else
	big_sphere
#end
	rotate <-12,0,-5>
	translate <-2,-3,-4>
}

object
{
	crane1
	scale 1.5
	translate <-47,0,10>
}


object
{
	crane2
	scale 1.5
	rotate <0,160,0>
	rotate pt[12][0]
	translate <43,3,-5>
	
}

object
{
	crane3
	scale 1.5
	rotate pt[13][0]
	translate <35,2,-30>
}


#declare dnum=15;
#declare ditems=
array[dnum][2]
{
	{<10,167,43>,<1.0,100,-2.8>},
	{<10, 19,35>,<1.3,100,-2.4>},
	{<10,-20,31>,<1.36,100,-2.08>},
	{<10,130,50>,<1.5,100,-2.2>},
	{<10,231,40>,<1.6,100,-2.5>},
	{<10,290,40>,<2.0,100,-3>},
	{<10,188,51>,<2.5,100,-3.1>},
	{<9,180,55>,<0.5,100,-2>},
	{<9,131,32>,<0.0,100,-2.2>},
	{<9,235,36>,<0.7,100,-2.5>}
	{<9,270,59>,<-0.3,100,-3.1>},
	{<8,15,33>,<-0.7,100,-2.54>},
	{<8,66,37>,<-1,100,-2>},
	{<8,266,57>,<-1.6,100,-2.1>},
	{<8,340,39>,<-1.1,100,-2.3>},
}

#local i=0;
#while(i<dnum)
#declare di=trace(pr[ditems[i][0].x],ditems[i][1]*cs,<0,-1,0>);
object
{
	cen_part(ditems[i][0].z)
	rotate <0,ditems[i][0].y,0>
	rotate pt[ditems[i][0].x][0]
#if(ditems[i][0].y<0)
	translate di+<0,1,0>
#else
	translate di+<0,0,0>
#end
}
#local i=i+1;
#end

#local j=0;
#while (j<4)
#local i=j;
#while(i<(10-j))
object
{
	cen_part(38-j)
	rotate <0,f_snoise3d(i,0,j)*12,0>
	translate <0,0,-22+f_snoise3d(i,3,j)*2>
	rotate <0,80+10*(i+j/2.1),0>
	translate <-47,j,10>
}
#local i=i+1;
#end
#local j=j+1;
#end

#local i=0;
#while(i<75)
#declare xx=f_snoise3d(i,-2,30)*f_snoise3d(i,20,30)*340+15;
#declare zz=f_snoise3d(i,10,-2)*f_snoise3d(i,19,30)*250-15;
#local j=0;
#while(j<np)
#declare di=trace(pr[j],<xx,30,zz>,<0,-1,0>);
#if(vlength(di)>0)
object
{
	cen_part(55*f_bozo(i,6,6)+2)
	rotate <0,f_bozo(i,4,4)*360,0>
	rotate pt[j][0]
	translate di
}
#declare j=np+1;
#end
#if(j=(np-1))
object
{
	cen_part(55*f_bozo(i,6,6)+2)
	rotate <0,120+f_bozo(i,4,4)*360,0>
	translate <xx,0,zz-5>
}
#end
#local j=j+1;
#end
#local i=i+1;
#end

camera
{
	location <-12,60,-130>
	look_at <10,30,0>
	right<image_width/image_height,0,0>

#if(detail=2)
	focal_point <0,30,0>
	aperture 0.5
	blur_samples 2048
	variance 1/2048
#end
}

text
{
	ttf "timrom.ttf" "Copyright (c) 2005 Bernard Hatt" ,0.01,0
	rotate <0,0,2>
	scale 3
	translate <-60,87,0>
	pigment {rgbt <1,1,1,0.95>}
}

text
{
	ttf "povlogo.ttf" "P", 0.01,0
	scale 20
	translate <180,1,150>
	pigment {rgbf <1.0,1.0,0.1,0.55>}
	no_image
	no_shadow
}
