// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "functions.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

#declare Radiosity=on;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 350                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      normal on                   // take surface normals into account [off]
      media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}

// ----------------------------------------

camera {
  location  <0,8, -23>
  //direction 1.5*z
  //right     x*image_width/image_height
  look_at   <0, 8,  0.0>
}

// sun ---------------------------------------------------------------
light_source{<100,5000,-100> color DimGray 
        // photon block for a light source

}
// And here the fast Sky...

#declare Clouds =
union {
   plane {
      y, 260
      texture {
         finish {ambient 0 diffuse 0.7}
         pigment {
            bozo turbulence 1.00 translate 200*y
            color_map {
               [0.5, rgb 1 transmit 1.0]
               [1.0, rgb 1 transmit 0.6]
            }
            scale 0.125
         }
         scale 1500
      }
   }
   plane {y, 200}
   plane {y, 220}
   plane {y, 240}
   texture {
      finish {ambient 0 diffuse 0.7}
      pigment {
         bozo turbulence 0.35 translate 300*y
         color_map {
            [0.5, rgb 1 transmit 1.0]
            [0.8, rgb 1 transmit 0.5]
         }
         scale 10 warp {turbulence 0.7} scale 1/10
         scale 0.125
      }
      scale 2500
   }
   texture {
      finish {ambient 0 diffuse 0.5}
      pigment {
         bozo turbulence 0.35 translate 400*y
         color_map {
            [0.5, rgb 1 transmit 1.0]
            [0.8, rgb 1 transmit 0.4]
         }
         scale 10 warp {turbulence 0.7} scale 1/10
         scale 0.125
      }
      scale 2500
   }
   hollow double_illuminate
   scale 1/200
}

object {Clouds scale 300} // distance above ground (y=0) to lowest parts of clouds
fog {
  fog_type   1
  distance   3000
  color      rgb 1 // gray
}

background {
   color <0.25,0.35,0.80> // color at horizon
}

// ground ------------------------------------------------------------
plane {<0,1,0>, 0     pigment {rgb <.1,.2,.1> }}


box { <-600, -1, -100>, <600,.4, 100> material{M_Watx}}
//rain

#declare Min_factor= 0.6;
 
#declare F=function{pigment{
  marble 
  turbulence 0.7
  color_map { [0 rgb 1] [1 rgb 0] }
  scale <.0003,.01,.0003>
 rotate z*5 }
}


difference{
isosurface {
        function { F(x,y,z).red - 0.5 }
        max_gradient 0.3
        contained_by{       
                box { 
                        <-1, -1, -1>, <1, 1, 1> 
                }
        }
                scale <600,100,100>
                translate <0,0,0>
}
height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "rain.png"     // the file name to read
                scale <90,45,55>
                translate <-45,-11,35>
        }

hollow
material{M_Raindrop}
//pigment{quick_color green 1 // low-quality quick-render color   }
}


fog {
  fog_type   2
  distance   100
  color      rgb 1 // gray
  fog_offset 0.1
  fog_alt    0.1
  turbulence 0.8
}
#include "../objects/bus_shelter_pov.inc"


//splashing water on surfaces-------------------------------------------------/
#declare Fn=function{pigment{
  crackle 
  turbulence 0.1
  color_map { [0 rgb 1] [1 rgb 0] }
  scale <.01,0.3,.01>
  }
}
//building 
 

height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "rain.png"     // the file name to read
                scale <90,10,55>
                rotate <180,90,0>
                translate <-45,-2,35>
//        }

//hollow
material{M_Raindrop}
//pigment{quick_color green 1 // low-quality quick-render color   }
}


//parapet_wall
isosurface {
        function { Fn(x,y,z).red - 0.5 }
        max_gradient 5.5
        contained_by{       
                box { 
                        <-1, -1, -1>, <1, 1, 1> 
                }
        }
        scale <200,1,1.3>
        translate <0,21,100>
        texture {pigment {rgbf <1,1,1,.5>} finish {ambient 2 specular 1}}
} 


//ball
difference{
isosurface {
        function { Fn(x,y,z).red - 0.5 }
        max_gradient 5.5
        contained_by{       
                box { 
                        <-1, -1, -1>, <1, 1, 1> 
                }
        }
  scale 3 
  translate <3,0,0>  
} 

height_field {
  jpeg               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "drips.jpg"     // the file name to read
  smooth       // smooth surface normal
  water_level .05 // truncate/clip below N (0.0 ... 1.0)
  scale 2 
  rotate x*180
  translate <3,0,0>  
        texture {pigment {rgbf 0.4} finish {ambient 2 specular 1}}
}
} 

sphere { <6, 1, 0>, 2.5 texture {Candy_Cane normal {dents 3 scale 4} finish {specular 0.2}}}// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1> 

 


difference{
box { <-100, -1, -100>, <100,20, 100> 
}
box { <-99, -1.1, -99>, <99,21, 99> }
    texture {
      pigment {
         Irregular_Bricks_Ptrn (0.1, 1, 0.5, 0.5)
         color_map {
            [0.01, rgb 0.9]
            [0.01, rgb 0.6]
         }
      }
      normal {
         Irregular_Bricks_Ptrn (0.1, 1, 0.5, 0.5) 2
      }
   scale 4}

}     



//Assembled object that is contained in garden_seat_pov.inc
#include "../objects/rained_out_pov.inc"
object{
      Poseray_scene_object            
      rotate <180,0,180>
      scale 42
      translate <-8,-.5,70>
      }
     
//==================================================
#include "../objects/bus_shelter_pov.inc"
object{
      Poseray_scene_object            
      rotate <90,0,180>
      scale <17,20,16>
      translate <0,-.5,70>
      }



// SET HAIR OPTIONS FOR EACH FRAME
   #include "pcmhair.mcr"

   #declare hair_length = .3;
   #declare hair_radius = .2;
   #declare hair_thickness = .005;
   #declare hair_rotation = <-30, 5, 0>;
   #declare hairs_per_patch = 15;
   #declare hair_patch_size = .5;
   #declare hair_objects_per_unit = 75;
   #declare hair_texture = texture {
      normal {bumps .7 scale <.05, 1, .05>}
      finish {phong .8 phong_size 15}}
   #declare hair_pattern_pigment = pigment {bozo color_map {[0 rgb <.5, .5, .1>] [1 rgb <.1, .4, 0>]} scale .01}
   #declare apply_hair_materials_to_mesh = true;
   #break

// CREATE CURRENT FRAME USING OPTIONS SET
  object{
         read_mesh ("../objects/lawn_pov.pcm")
      scale <30,3,30> translate <0,0,40>  }