#macro Car( col )

#local CAR_WIDTH = 1.6;
#local CAR_LENGTH= 4.0;
#local CAR_HEIGHT= 1.4;


#local Mcar =
material{
 texture{
  pigment{ color rgb col }
  finish{
  diffuse 0.6
  ambient 0.1
  specular 0.4
  roughness 0.01
  reflection 0.5
  }
  }
 
}

#local Mwheel =
material{
 texture{
  pigment{ color rgb 0.2 }
  }
}


// removable stuff
// ***************************************************

/*
light_source{ <-200,500,-200> color rgb 2 }
camera{ perspective location <-6,5,10> look_at <0,0.5,0> angle 20}
plane{ y 0 pigment{ color rgb 1 } }
*/


// ***************************************************


#local Oside=


difference{

 box{ <0 , 0.2 , -CAR_LENGTH/2> <CAR_WIDTH/2 , CAR_HEIGHT , CAR_LENGTH/2> }

 plane{ y 0.05 rotate z*60 translate <CAR_WIDTH/2 , 0.2 , 0> } // the bottom sill
 plane{ y 0.2 rotate z*110 translate <CAR_WIDTH/2 , CAR_HEIGHT , 0> } // the window slant


 intersection{  // the front cut-out
  plane{ -y 0 rotate x*10  translate <0 , CAR_HEIGHT*0.65 , CAR_LENGTH*0.2> }
  plane{ -y 0 rotate x*35  translate <0 , CAR_HEIGHT*0.65 , CAR_LENGTH*0.2> }
 }

 intersection{  // the back cut-out
  plane{ -y 0 rotate x*0   translate <0 , CAR_HEIGHT*0.65 ,-CAR_LENGTH*0.3> }
  plane{ -y 0 rotate x*-70 translate <0 , CAR_HEIGHT*0.65 ,-CAR_LENGTH*0.3> }
 }

 // the wheel cut-outs
 
 cylinder{ <-CAR_WIDTH/2-0.01 , 0.2 , CAR_LENGTH*0.35>  <-CAR_WIDTH/2+0.5  , 0.2 , CAR_LENGTH*0.35> 0.45 }
 cylinder{ < CAR_WIDTH/2+0.01 , 0.2 , CAR_LENGTH*0.35>  < CAR_WIDTH/2-0.5  , 0.2 , CAR_LENGTH*0.35> 0.45 }
 
 cylinder{ <-CAR_WIDTH/2-0.01 , 0.2 , -CAR_LENGTH*0.35>  <-CAR_WIDTH/2+0.5  , 0.2 , -CAR_LENGTH*0.35> 0.45 }
 cylinder{ < CAR_WIDTH/2+0.01 , 0.2 , -CAR_LENGTH*0.35>  < CAR_WIDTH/2-0.5  , 0.2 , -CAR_LENGTH*0.35> 0.45 }
 


 material{Mcar}
 
}



union{

// the wheels

union{
 cylinder{ <-CAR_WIDTH/2-0.01 , 0.3 , CAR_LENGTH*0.35>  <-CAR_WIDTH/2+0.5  , 0.3 , CAR_LENGTH*0.35> 0.3 }
 cylinder{ < CAR_WIDTH/2+0.01 , 0.3 , CAR_LENGTH*0.35>  < CAR_WIDTH/2-0.5  , 0.3 , CAR_LENGTH*0.35> 0.3 }
 
 cylinder{ <-CAR_WIDTH/2-0.01 , 0.3 , -CAR_LENGTH*0.35>  <-CAR_WIDTH/2+0.5  , 0.3 , -CAR_LENGTH*0.35> 0.3 }
 cylinder{ < CAR_WIDTH/2+0.01 , 0.3 , -CAR_LENGTH*0.35>  < CAR_WIDTH/2-0.5  , 0.3 , -CAR_LENGTH*0.35> 0.3 }

 material{ Mwheel}
}



merge{
 object{ Oside }
 object{ Oside scale <-1,1,1> }
}

} 
    
#end