#macro Splash( centre , nPart , frames )

// centre: center of splash
// nPart:  number of particles
// frames: number of simulation frames


//---------------------------------------------------------------------
// first off create an array of data
//---------------------------------------------------------------------
#local point = array[nPart];
#local vel   = array[nPart];
#local rad   = array[nPart];

#declare R1 = seed(14521);


#local n=0;
#while(n<nPart)

 #local LAT = radians( rand(R1) * 45  );
 #local LON = radians( rand(R1) * 360 );
 #local SPD = rand(R1) * 14 + rand(R1)*6 + rand(R1)*4;
 
 #local A = radians( rand(R1) * 360 );
 #local D = rand(R1) * 10;
 
 
 
 #local point[n] = centre + D*<2*sin(A),0,cos(A)>;
 #local vel[n]   = SPD*<sin(LAT)*cos(LON),cos(LAT),2*sin(LAT)*sin(LON)>;
 #local rad[n]      = 0.05*(rand(R1)*14 + 2);
  

#local n=n+1;
#end



//---------------------------------------------------------------------
// do the simulation
//---------------------------------------------------------------------

#local F=0;
#while(F < frames )

 #local n=0;
 #while(n<nPart)

 #local vel[n] = vel[n] - 9.81*y*0.05;
 #local point[n] = point[n] + vel[n]*0.1;



 #local n=n+1;
 #end


#local F=F+1;
#end


//---------------------------------------------------------------------
// draw the image
//---------------------------------------------------------------------
blob{

#local n=0;
#while(n<nPart)

 sphere{ point[n]             , rad[n]*3    , rad[n]*3        } 
 sphere{ point[n]-vel[n]*0.05 , rad[n]*1.5     , rad[n]*1.5        } 
 sphere{ point[n]-vel[n]*0.10 , rad[n]       , rad[n]          } 
 

#local n=n+1;
#end

 threshold 3
 
 }

#end

