#include "Shapes.inc"
#include "TowerText.inc"
#include "Steps.inc"

#declare DoorHeight = 7;
#declare DoorWidth  = 3.7;
#declare DoorShift  = 1;

#declare DoorBlankHalf =
  
  intersection{
    union{   
     
     #declare X = 200;
     box{ <0,-1,-X> <DoorWidth+.1,DoorHeight,X> }
     cylinder{<0,DoorHeight,-X><0,DoorHeight,X>DoorWidth+.1}  
     translate -x*DoorShift
    }
    
    box{<0,-1,-3*X><DoorWidth,DoorHeight+DoorWidth,3*X>}
  }
  
#declare DoorBlank =

intersection{
  union{
    object{DoorBlankHalf translate -0.001*x}
    object{DoorBlankHalf rotate 180*y translate 0.001*x}
  }
  box{<-100,-100,-100><100,100,0>} 
  texture{StoneTex}
}


    
  

#macro leftDoorArch(Angle, Radius, R)

union{

  #declare A = 0;
  
  #declare done = false; 
  
  #while ( done = false )
  
    #declare w = (1+rand(R)/3)*1.2;
    #declare a = (1+rand(R)/2)* 30;
    #declare d = (1+rand(R)/2)*1;
    
    #if ( (A + a) > Angle )
      #declare a = Angle - A;
      #declare done = true;
    #end
    
    #declare theta = 90-A-a/2;
    
    object{ lumpySegment(a,Radius, w, d, .2, 1, R) rotate theta*z translate <Radius*sin(radians(Angle)), WindowHeight, -TowerRad-0.2> rotate 13.5*sin(radians(Angle))*y  }
    
    #declare A = A + a + 3;
   
  #end  
}

#end //of arch      
    
#macro rightDoorArch(Angle, Radius, R)

union{

  #declare A = 0;
  
  #declare done = false; 
  
  #while ( done = false )
  
    #declare w = (1+rand(R)/4)*1.3;
    #declare a = (1+rand(R)/2)* 30;
    #declare d = (1+rand(R)/2)*1;
    
    #if ( (A + a) > Angle )
      #declare a = Angle - A;
      #declare done = true;
    #end
    
    #declare theta = 90-A-a/2;
    
    object{ lumpySegment(a,Radius, w, d, .2, 1, R) rotate -theta*z translate <-Radius*sin(radians(Angle)), WindowHeight, -TowerRad-0.2> rotate -13.5*sin(radians(Angle))*y  }
    
    #declare A = A + a + 3;
   
  #end  
}

#end //of arch      
    

#macro leftDoorPillar(R)
intersection{
union{
  
  #declare H = .5;
  #declare height = 20;
  
  #declare done = false;
  
  
  #while (done = false)
    
    #declare w = (1+rand(R)/3)*1.25;
    #declare h = (1+rand(R)/3)*1.5;
    #declare d = (1+rand(R)/3)*1;
    
    
    #if ( (H + h) > height )    
       #declare h = height - H;
       #declare done = true;       
    #end
    
    object{ 
      lumpyBox(w,h,d, 0.125, 0.025, 3*rand(R)) 
      translate <-w/2, -h/2, TowerRad + TowerInset +3>
      rotate H*x 
      translate <0, DoorHeight, -TowerRad - 2*TowerInset -2.85>
      rotate 14.25*y
    }
    
    #declare H = H + 2.6*h;
  
  #end 
  
  
  texture{StoneTex}
}
box{<-100,0,-100><100,100,100>}
}

#end//leftDoorPillar

#macro rightDoorPillar(R)

intersection{
union{
  
  #declare H = 0.5;
  
  #declare done = false;
  
  #while (done = false)
    
    #declare w = (1+rand(R)/3)*1.25;
    #declare h = (1+rand(R)/3)*1.5;
    #declare d = (1+rand(R)/3)*1;
    
    
    #if ( (H + h) > height )    
       #declare h = height - H;
       #declare done = true;       
    #end
    
    object{ 
      lumpyBox(w,h,d, 0.125, 0.025, 3*rand(R)) 
      translate <w/2, -h/2, TowerRad + TowerInset + 3>
      rotate H*x 
      translate <0, DoorHeight, -TowerRad - 2*TowerInset -2.85>
      rotate -14.25*y
    }
    
    #declare H = H + 2.6*h;
  
  #end 
  
  
  texture{StoneTex}
}
box{<-100,0,-100><100,100,100>}
}

#end //rightDoorPillar

#macro Door(R) 

difference{
 union{
    
   
   #declare FrameWidth = 1;

   #declare w = 0.5;
   #declare H = DoorHeight+DoorWidth;
   
   
   #declare X1 = w/2+.0;
   
   #while (X1 <= DoorWidth/2+w)                
      object{lumpyBox(w,H,1,.1,.1,R) translate < X1, H/2, -TowerRad +2>} 
      sphere{<0,0,0>.1  translate < X1, 6, -TowerRad + 1.5> pigment{Black}}
      sphere{<0,0,0>.1  translate <-X1, 6, -TowerRad + 1.5> pigment{Black}}
      sphere{<0,0,0>.1  translate < X1, 1.5, -TowerRad + 1.5> pigment{Black}}
      sphere{<0,0,0>.1  translate <-X1, 1.5, -TowerRad + 1.5> pigment{Black}}
      object{lumpyBox(w,H,1,.1,.1,R) translate <-X1, H/2, -TowerRad +2>}
     #declare X1 = X1 + w;
   #end
   
   object{ lumpyBox(1,1.2,1,.1,.05,R)  scale <1,1,0.1> translate <1.6, 4, -TowerRad + 1.45>     texture{
      pigment{rgb<0.1,0.1,0.1>*.5} 
      finish{phong 1}
      normal{bumps bump_size .25 scale 0.005}
    }
   }

   object{frame(DoorHeight-StepHeight, .3, .21, DoorWidth, 2.5) translate (-TowerRad +1) *z }
   
   
   texture{WoodTex}
 }
 
 union{
   cylinder{<0,0,-30><0,0,30> .17 }
   box{<-.07,0,-30><0.07,-.4,30>}
   translate<1.47,4.1,0>
   pigment{Black}
 }
   translate StepHeight*y
   
}

#end //Door

