#include "functions.inc"

//macro draws box width, height, depth, corner radius, lumpiness, randomizer centred on origin
#macro lumpyBox(w,h,d,r,L,R)


  #if (highDef) 
    
    #declare X = 5;
    
    isosurface{  
       function{f_rounded_box(
          x+L*f_noise3d(0,              X*(R + y)/h,   X*(R + z)/d), 
          y+L*f_noise3d(X*(R + x)/w,    0,             X*(R + z)/d), 
          z+L*f_noise3d(X*(R + x)/w,    X*(R + y)/h,             0),
          r,w/2,h/2,d/2)}  
       max_gradient 1.3
       contained_by{ box{<-w,-h,-d><w,h,d>}}
    }

  #else
  
    box{<-w/2,-h/2,-d/2><w/2,h/2,d/2>}

  #end


#end //of macro box       
                              
//macro draws segment angle, inner radius, width, depth, cornerRadius lumpiness, randomiser arc centre at origin                                
#macro lumpySegment(a,r, w, d,rad, L,R)   

  #if (highDef)  
    union{

      object{lumpyBox(rad, w, d, rad, 0, R) translate<0, r+w/2, d/2> rotate -a/2*z }   
      object{lumpyBox(rad, w, d, rad, 0, R) translate<0, r+w/2, d/2> rotate  a/2*z }   
          
      difference{ 
       union{
         difference{   
           cylinder{<0,0, rad><0,0,d-rad>r+w}      
           cylinder{<0,0,-100><0,0,100>r}
         }
          difference{   
           cylinder{<0,0, 0><0,0,d>r - rad+w}      
           cylinder{<0,0,-100><0,0,100>r + rad}
         } 
         torus{r   +rad,rad rotate 90*x  translate    rad*z}
         torus{r+w -rad,rad rotate 90*x  translate    rad*z}
       }
       union{
         box{<-100,-100,-100><100,0,100>}
         box{<0,-100,-100>< 100,100,100> rotate  -a/2*z}
         box{<0,-100,-100><-100,100,100> rotate a/2*z}
       }
      }
    }
  #else
    difference{   
       cylinder{<0,0,0><0,0,d>r+w}      
       union{
         cylinder{<0,0,-100><0,0,100>r}
         box{<-100,-100,-100><100,0,100>}
         box{<0,-100,-100>< 100,100,100> rotate  -a/2*z}
         box{<0,-100,-100><-100,100,100> rotate a/2*z}
       }
    }
  #end  
  
#end //of lumpy segment                                                             

//draws a horizontal curved box
#macro lumpySill(Radius, w,h,d,r,L,R)

  #if (highDef) 
    #declare X = 5;
    
    isosurface{  
       function{f_rounded_box(
          x+                    L*f_noise3d(0,              X*(R + y)/h,   X*(R + z)/d), 
          y+                    L*f_noise3d(X*(R + x)/w,    0,             X*(R + z)/d), 
          z - x*tan(x/Radius)/2+L*f_noise3d(X*(R + x)/w,    X*(R + y)/h,             0),
          r,w/2,h/2,d/2)}  
       max_gradient 2  
       all_intersections
       contained_by{ box{<-w,-h,-d><w,h,d>}}
    }

  #else
  
    box{<-w/2,-h/2,-d/2><w/2,h/2,d/2>}

  #end
   
#end

//draws half box pos ZY plane x-lumpy only
#macro XlumpyBox(w,h,d,r,L,R)     

    
    #declare X = 5;
    
    isosurface{  
       function{f_rounded_box(
          x+x*L*f_noise3d(0, X*(R + y)/h,   X*(R + z)/d), 
          y+x*L*f_noise3d(X*(R + x)/w,    0,             X*(R + z)/d), 
          z+x*L*f_noise3d(X*(R + x)/w,    X*(R + y)/h,             0),
          r,w/2,h/2,d/2)}
            
       max_gradient 1.3
       contained_by{ box{<0,-h,-d><w,h,d>}}
    }

   
#end

#macro frame(h, w, r, rad, Offset)

union{
   
   union{
     box     {<0,     0, r> <2*w,   h,   w>}
     box     {<0,     0, 0> <2*w-r, h, w-r>}
     cylinder{<2*w-r, 0, r> <2*w-r, h,   r>  r }
     
     intersection{
       
       union{
         difference{
           cylinder{<0,0,r><0,0,  w>rad+w}
           cylinder{<0,0,0><0,0,w+1>rad-w}
         }
       
         difference{
           cylinder{<0,0, 0><0,0,  w>rad+w}
           cylinder{<0,0,-1><0,0,w+1>rad-w+r}
         }
       
       
         torus{rad+r-w, r rotate 90*x translate r*z }
       }
      
       box{<0,0,-w><-rad-w,rad+w,w>}
       
       translate<rad+w,h,0>
     } 
  
     translate -Offset*x 
  }
  

   union{
     box     {<0,      0, r> <-2*w,   h,   w>}
     box     {<0,      0, 0> <-2*w+r, h, w-r>}
     cylinder{<-2*w+r, 0, r> <-2*w+r, h,   r>  r }
     
     intersection{
       
       union{
         difference{
           cylinder{<0,0,r><0,0,  w>rad+w}
           cylinder{<0,0,0><0,0,w+1>rad-w}
         }
       
         difference{
           cylinder{<0,0, 0><0,0,  w>rad+w}
           cylinder{<0,0,-1><0,0,w+1>rad-w+r}
         }
       
       
         torus{rad+r-w, r rotate 90*x translate r*z }
       }
      
       box{<0,0,-w><rad+w,rad+w,w>}
       
       translate<-rad-w,h,0>
     } 
  
     translate Offset*x 
  }
  
}
         
#end  

#macro TowerBlanker(Height, Rad,N1,N2,N3,N4, N5, N6)

#declare stretch = 2;  
isosurface{  
  
  function { sqrt(pow(
            x  + N1*f_noise3d(0,    N2*y,  N2*z)  
#if (highDef) 
            +N3*f_noise3d(0,    N4*y,  N4*z)             
            -N5*f_noise3d(0, N6*y,  z) 
#end
            ,2) + pow(
            z  + N1*f_noise3d(N2*x, N2*y,     0)  
#if (highDef) 
            +N3*f_noise3d(N4*x, N4*y,     0) 
            -N5*f_noise3d(x, N6*y,  0) 
#end
            ,2)) - y } 
#if (highDef)                     
  max_gradient 28    
  all_intersections
#else
  max_gradient 5
#end
  contained_by{ sphere{<0,0,0>Rad}}  
  scale <Rad, Height, Rad>
  
  texture{StoneTex}
}
#end   