#declare StepHeight = 0.6;
#declare StepDepth = 2.5;

#macro DoorSteps1(R)   

   #declare StepLength = 0.5;
   union{
      object{lumpyBox(         1.6,StepHeight/3,4,.05,.0125,R)   translate <                0, 0, -TowerRad +2> }
      object{lumpyBox(  StepLength,StepHeight/3,4,.05,.0125,R)   translate <-0.8-StepLength/2, 0, -TowerRad +2> } 
      object{lumpyBox(  StepLength,StepHeight/3,4,.05,.0125,R)   translate < 0.8+StepLength/2, 0, -TowerRad +2> } 
      scale <2,3,1>
      translate <0, StepHeight/4, 0>    
      texture{StepTex}
   }
     
#end   

#macro DoorSteps2(R)   

   #declare StepLength = 0.5;
   union{
      object{lumpyBox(  1.3,StepHeight/3,4,.05,.0125,R)   translate <-1.3/2, 0, -TowerRad +2> } 
      object{lumpyBox(  1.3,StepHeight/3,4,.05,.0125,R)   translate <+1.3/2, 0, -TowerRad +2> } 
      scale <2,3,1>
      translate <0, StepHeight/4, 0>    
      texture{StepTex}
   }
     
#end

#macro Curb(R, cw)

  #declare cd = .75 + rand(R)/3;
   
  object{lumpyBox(cd,3,cw,.15,.025,R) translate<-cd/2,-.5,-cw/2-TowerRad > texture{StepTex}} 
  
  
#end
  