

 
#macro stone(R, Scale1)
object{
    #declare w = (1+20*rand(R));
    #declare h = (1+10*rand(R)); 
    #declare d = (1+10*rand(R));
    #declare Scale = rand(R);
    #declare Scale = Scale * Scale/2;
    
  #if (highDef) 
    
    #declare r =  rand(R)*8;
    #declare XN = rand(R)*5;
    #declare YN = rand(R)*3;
    #declare ZN = rand(R)*3;
    
    #declare X = rand(R);
    isosurface{  
       function{f_rounded_box(
          x+XN*f_noise3d(   0, X*y, X*z), 
          y+YN*f_noise3d( X*x,   0, X*z), 
          z+ZN*f_noise3d( X*x, X*y,   0), 
          r,w/2,h/2,d/2)}  
       max_gradient 1.3
       contained_by{ box{<-w,-h,-d><w,h,d>}}
    }

  #else
  
    box{<-w/2,-h/2,-d/2><w/2,h/2,d/2>}

  #end
  scale Scale*Scale1/3
  rotate <rand(R)*360,rand(R)*360,rand(R)*360>
}

#end //of macro stone
       
#declare S = seed(1); 

union{ 

    #declare N = 0;
    #while (N<1000)
        #declare P = rand(S)*rand(S);
        #declare P = P/2 + P*P/2;
        object{stone(rand(S), P) 
        #declare X = 6*P + (0.5-rand(S))*1;
        #declare Y = 11 + (1-P*P)*30 - 2*rand(S);
        translate <X,Y,0> 
        #declare Angle = 90*rand(S); 
        rotate Angle*y 
        translate <5,0,-8>
        }    
      #declare N = N + 1;
    #end

  
  texture{StoneTex}
}

//sphere{<5,35,-8> 1   rotate -10*y pigment{Red}}