#include "shapes.inc"
#include "TowerText.inc"
#include "glass.inc"

#declare WindowHeight = 4;
#declare WindowWidth  = 2;
#declare WindowShift  = .6;


#declare WindowBlankHalf =
  
  intersection{
    union{   
     
     #declare X = 200;
     box{ <0,-0.2,-X> <WindowWidth,WindowHeight,X> }
     cylinder{<0,WindowHeight,-X><0,WindowHeight,X>WindowWidth}  
     translate -x*WindowShift
    }
    
    box{<0,-0.2,-3*X><WindowWidth,WindowHeight+WindowWidth,3*X>}
  }
  
#declare WindowBlank =

intersection{
  union{
    object{WindowBlankHalf translate -0.001*x}
    object{WindowBlankHalf rotate 180*y translate 0.001*x}
  }
  box{<-100,-100,-100><100,100,0>} 
  texture{StoneTex}
}

//Pillar of random stones origin = bottom,front,left corner
//Height and Random Variable
#macro pillar(height, R)

union{
  
  #declare H = 0;   
  #declare h = 0;
  
  #declare done = false;

  #while (done = false)
    
    #declare w = (1+rand(R)/2)*0.75;
    #declare h = (1+rand(R)/2)*0.77;
    #declare d = (1+rand(R)/2)*0.5;
    
    
    #if ( (H + h) > height )    
       #declare h = height - H;
       #declare done = true;       
    #end
    
    object{ lumpyBox(w,h,d, 0.125, 0.05, 3*rand(R)) translate<w/2, H + h/2, d/2>}
    
    #declare H = H + h + .1;
  
  #end
    
}

#end //pillar 


#macro leftArch(Angle, Radius, R)

union{

  #declare A = 0;
  
  #declare done = false; 
  
  #while ( done = false )
  
    #declare w = (1+rand(R)/2)*0.7;
    #declare a = (1+rand(R)/2)* 25;
    #declare d = (1+rand(R)/2)*0.75;
    
    #if ( (A + a) > Angle )
      #declare a = Angle - A;
      #declare done = true;
    #end
    
    #declare theta = 90-A-a/2;
    
    object{ lumpySegment(a,Radius, w, d, .1, 1, R) rotate theta*z translate <Radius*sin(radians(Angle)), WindowHeight, -TowerRad - rand(R)*.1> rotate 7*sin(radians(Angle))*y  }
    
    #declare A = A + a + 4;
   
  #end  
}

#end //of arch      


#macro rightArch(Angle, Radius, RadR)

union{

  #declare A = 0;
  
  #declare done = false; 
  
  #while ( done = false )
  
    #declare w = (1+rand(R)/2)*0.6;
    #declare a = (1+rand(R)/2)* 20;
    #declare d = (1+rand(R)/2)*0.75;
    
    #if ( (A + a) > Angle )
      #declare a = Angle - A;
      #declare done = true;
    #end
    
    #declare theta = 90-A-a/2;
    
    object{ lumpySegment(a,Radius, w, d, .1, 1, R) rotate -theta*z translate <-Radius*sin(radians(Angle)), WindowHeight, -TowerRad-rand(R)*.1> rotate -7*sin(radians(Angle))*y  }
    
    #declare A = A + a + 4;
   
  #end  
  
}

#end //of arch      
      
 
#declare trap =

   difference{
   
       box{<-1,-1,-10><1,1,10> rotate 45*z}
       box{<-200,-200,-200><200,0,200>}
       
       scale <1/1.414,1,1>
   }
#declare bit =

   intersection{
   
       box{<-1,-1,-.1><1,1,.1> rotate 45*z}
       box{<-2,-2,-2><2,0,2>}
       
       scale <1/1.414,1,1>  
       texture{T_Glass1} 
   }
   

#macro brokenBits(R)

union{
  #declare N = 0;
  #while (N<30)
     object{bit rotate 90*rand(R)*z scale <.2+.6*rand(R), .2+.2*rand(R), 1> rotate 13*(.5-rand(R))*x rotate 90*rand(R)*z translate<-4*(.5-rand(R)),8*(0.5-rand(R)),-11>} 
     #declare N = N + 1;
  #end
}

#end      
  
#macro Window(R, broken)
  
union{
  union{
       object{frame(WindowHeight, .2, .1, WindowWidth, 1.5)  }
       
       object{lumpyBox(.3,4,.2,.1,0.01,R) translate<0, 2 ,0.1>}
       #declare WN = 0;
       #while (WN < 5)
          object{lumpyBox(3,.3,.2,.1,0.01,R) translate<0, .2 + WN,0.1> texture{WoodTex rotate 90*z}}
         #declare WN = WN + 1.25;
       #end
       
       translate (-TowerRad +0.5) *z
       texture{WoodTex}
  }
  union{
    object{pillar(WindowHeight, R)              translate < .2,             -.1, -TowerRad -0.1> rotate -7*y }   
    object{pillar(WindowHeight, R) rotate 180*z translate <-.2, WindowHeight-.1, -TowerRad -0.1> rotate 7*y  } 
    
    object{  leftArch(55,WindowWidth,R) translate<0.05,0,-0.1>}
    object{ rightArch(55,WindowWidth,R) translate<0.05,0,-0.1>}
    
    object{ lumpySegment(70, .5, .75, 1, .1, 2, R) translate<0,5.35,-TowerRad-.2>}
    object{ lumpySill(TowerRad,WindowWidth + 3.25,1.2,1,.25,.1,R) translate<0,-.6,0.475-TowerRad-.1> }
    
    texture{StoneTex}
  }

#if ( broken ) 
  
  brokenBits(seed(1))
  
  intersection{  
     box{<-1.5,0,-.1><1.5,6,0.1> translate (-TowerRad+0.75)*z texture{T_Glass1}} 
     
     union{
        #declare N = 0;
        #while ( N < 4 )
           object{trap  scale <.3 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(-90)*z translate <-1.25,N,0> }
           #declare N = N + .25+.5*rand(R);
        #end 
        
        #declare N = 0;        
        #while ( N < 90 )
           object{trap  scale <.3 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(-90)*z translate <-1.25,0,0> rotate -N*z translate <0,4+N/90,0> }
           #declare N = N + 60*rand(R);
        #end 
        
        #declare N = 0;        
        #while ( N < 4 )
           object{trap  scale <.3 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(90)*z translate <1.25,N,0> }
           #declare N = N + .25+.5*rand(R);
        #end
        
        #declare N = 0;
        #while ( N < 90 )
           object{trap  scale <.3 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(90)*z translate <1.25,0,0> rotate N*z translate <0,4+N/90,0> }
           #declare N = N + 60*rand(R);
        #end


        #declare N = 0;        
        #while ( N < 4 )
           object{trap  scale <.2 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(90)*z translate <0,N,0> }
           #declare N = N + .75+.5*rand(R);
        #end
        
        #declare N = 0;        
        #while ( N < 4 )
           object{trap  scale <.2 + .5 * rand(R), .1 + .4*rand(R), 1> rotate (.8+.4*rand(R))*(-90)*z translate <0,N,0> }
           #declare N = N + .75+.5*rand(R);
        #end
     }
  }
#else
  box{<-1.5,0,-.1><1.5,6,0.1> translate (-TowerRad+0.75)*z texture{T_Glass1}} 
#end
}
  
#end //window 
