//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//  Macro for seven segment displays  //
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//

#declare Space=.25;
#declare Tall=3;
#declare Wide=.5;
#declare Thick=.3;
#declare Top_Piece=
prism {
  linear_spline
  -Thick/2, Thick/2, 5
  <Space,0>,<Wide+Space,-Wide>,<Tall-Wide-Space,-Wide>,<Tall-Space,0>,<Space,0>          
} /**/ 
#declare Side_Piece=
prism {
  linear_spline
  -Thick/2, Thick/2, 5
  <0,Space>,<Wide,Wide/2+Space>,<Wide,Tall-Wide*3/2-Space>,<0,Tall-Wide/2-Space>,<0,Space>          
}
#declare Cntr_Piece=
prism {
  linear_spline
  -Thick/2, Thick/2, 7
  <Space,0>,<Wide+Space,Wide/2>,<Tall-Wide-Space,Wide/2>,<Tall-Space,0>,<Tall-Wide-Space,-Wide/2>,<Wide+Space,-Wide/2>,<Space,0> 
}

#declare p_On=
pigment{color rgb <1.5,0,0>}
#declare p_Off=
pigment{color rgb <0.752941,0,0>/4}


#macro Svn_Seg(num)
union{
  object{Side_Piece rotate 180*x
    #if(num=0 | num=2 | num=6 | num=8)      
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //lower left    1
  object{Side_Piece
    #if(num=0 | num=4 | num=5 | num=6 | num=8 | num=9)      
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //upper left    2
  object{Top_Piece translate z*(Tall-Wide/2)
    #if(num=0 | num=2 | num=3 | num=5 | num=6 | num=7 | num=8 | num=9)      
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //top   3
  object{Side_Piece rotate x*180 rotate z*180 translate x*Tall
    #if(num=0 | num=1 | num=3 | num=4 | num=5 | num=6 | num=7 | num=8 | num=9)     
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //lower right     4
  object{Side_Piece rotate z*180 translate x*Tall
    #if(num=0 | num=1 | num=2 | num=3 | num=4 | num=7 | num=8 | num=9)     
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } // upper right   5
  object{Top_Piece rotate x*180 translate -z*(Tall-Wide/2)
    #if(num=0 | num=2 | num=3 | num=5 | num=6 | num=8 | num=9)     
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //bottom  6
  object{Cntr_Piece
    #if(num=2 | num=3 | num=4 | num=5 | num=6 | num=8 | num=9)      
      pigment{p_On}
    #else pigment{p_Off}
    #end      
  } //center 7   /**/
  translate <-Tall/2,Thick/2,0>
}
#end

