sky_sphere {                         //Starfield
  pigment {
    dents
    color_map {
      [0.00 rgb 0 ]
      [0.41 rgb 0 ]
      [0.50 rgb 2 ]
      [0.59 rgb 0 ]
      [1.00 rgb 0 ]
    }     
    scale .0005
  }
}

camera {
  location <5,59.5,-90>
  look_at <50,100,0>
  angle 60
}

/*camera {
  location z*-200
  look_at 0
}*/          

#declare earth = sphere {            //Citylights
  0, 100 hollow
  pigment {
    image_map {
      png "europe_night_lights.png"
    }
    scale .1
    warp { spherical }
  } 
  finish { diffuse .5 ambient 2 }
  rotate y*270
  rotate x*-1
}

object { earth }

sphere {                             //Clouds
  0, 100.0003 hollow
  pigment {
    image_map {
      png "clouds.png"
    }
    scale .1
    warp { spherical }
  }                   
  finish { ambient .4 }
  rotate <-90,0,0>
}     
sphere {                             //This is just a filter above the surface  
  0, 100.0004 hollow                 //so that it fits better to the color of the atmosphere
                                     //In addition the impacts get different colors
  pigment {
    bozo
    pigment_map {
      [0.0 rgbt <.05,.15,.2,.5>]
      [0.5 rgbt <.25,.15,.2,.5>]
      [1.0 rgbt <.05,.15,.2,.5>]
    }
    scale 10
  }
                     
  finish { ambient .4 }
}     

sphere {                             //atmosphere
  0, 1
  pigment { rgbt 1 }
  hollow
  interior {
    media {
      emission .5
      density {
        spherical
        density_map {
          [0.0 rgb 0]
          [0.4 rgb <.1,.125,.15>]
          [0.8 rgb 0]
          [1.0 rgb 0]
        }
      }
    }
  }      
  scale 102
}                        

//Placing the impacts

#include "rand.inc"  
#declare S = seed(0);
#declare T = seed(23);
#declare U = seed(17);
  #include "math.inc"                              

  #declare loc = trace(earth, <5,59.5,-90>, <50,45,100>);   //The point where the cameravector hits 
                                                            //the surface of the planet (= <13.6422, 67.2779, -72.7116>) 
#declare nuke = sphere {
  0, 1
  pigment { rgbt 1 }
  hollow
  interior {
    media {
      emission 6
      density {
        spherical
        density_map {
          [1.0 rgb <1,1,.5>]
          [0.2 rgb <1,1,.5>]
          [0.0 rgb <1,1,.5>]
        }  
      }
    }
  }
  scale <1.5,.5/*.75*/,1.5> 
  no_shadow
} 
  
#macro placenuke()

  #declare vrand = <rand(S),rand(S),rand(S)>;
  
  light_source {
    <13.6422, 67.2779, -72.7116>//(=trace(earth, <5,59.5,-90>, <50,45,100>)=loc) 
    rgb <50,50,25>*2
    scale 1.0005
    rotate x*2 
    rotate -10+20*vrand
    rotate x*-5
  }  
  object {
    nuke
    scale .2+.2*rand(T)
    scale y*.6
    scale .5
    translate y*.1
    rotate x*90
    rotate <VAngleD(loc.x, y), VAngleD(loc.y, y), VAngleD(loc.z, y)>
    
    translate loc
    
    rotate x*2 
    rotate -10+20*vrand
    rotate x*-5
  }                
   
#end  

#declare i=0;
#while(i<15)    
  placenuke()
  #declare i=i+1;
#end

object {         //This is just another impact not produced by the macro
  nuke
  scale .2+.2*rand(T)
  scale y*.6
  scale .5
  translate y*.1
  rotate x*90
  rotate <VAngleD(loc.x, y), VAngleD(loc.y, y), VAngleD(loc.z, y)>
  
  translate loc
    
  rotate x*2 
}

light_source {
  trace(earth, <5,59.5,-90>, <50,45,100>) 
  rgb <50,50,25>
  scale 1.0005
  rotate x*2
}