///////////////////////////////////////
//
//  explorers.inc
//  Copyright R.P. Stolk. march.2005
//
//  aliens
//
/////////////////////////////////////// 


#ifndef(render_all)  

 #include "metals.inc" 
 
 #include "materials.inc"

  camera {location <400,200,-1000> direction 2*z look_at <175,0,0>  angle 37}      // normal      
  light_source {<5000 ,5000,5000> rgb <1.0, 1.0, 0.95>*1} 
  light_source {<0 ,5000,0> rgb <1.0, 1.0, 0.95>*0.5} 
  
 plane { y, -57 pigment{rgb <0.5,0.5,0.5> }}
  
  
 sky_sphere {
  pigment {            // Blue fade
    gradient <0,1,0>
    color_map {
    [0 color rgb <0,0,40/255>]
    [1 color rgb <0,0,40/255>]
    }
  }
  
   pigment {          // Clouds
    spotted
    turbulence 0.01
     octaves 6
     omega 0.007
     lambda 20
     color_map {
     [0.0 color rgbt <0.7,  0.7,60/255,  1>]
     [0.2 color rgbt <  0,    0,80/255,0.5>]
     [0.4 color rgbt <  0,0/255,   0.4,0.5>]
     [1.0 color rgbt <  0,    0,     0,0.5>]
     }
      scale <0.3,0.1,0.3>
   }
 } 

#end



//box{<500,0,-500>,<-500,300,500> pigment { rgbt 1 } hollow interior
//   { media
//     { scattering { 0.1, 0.05 }
//     }
//   }
// }

//cone {<0,0,0>,0<400,0,0>,50 pigment { rgbt 1 } hollow  interior
//    { media
//     { scattering { 1, 0.05 }
//     }
//   }
//}

// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object

//media {    // atmospheric media sample
//  intervals 1
//  scattering { 3, rgb 0.03 }
//  samples 1, 10
//  confidence 0.009999
//  variance 1/1000
// ratio 0.9
//}

// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object





//--------------------------------------------------
//|                   plane                        |
//--------------------------------------------------

#declare vessel_ruw =
 union{
  sphere  {< 0,0,0>,100 scale<1,0.25,1>}
  cylinder{< 0,0,0>,< 15,0,0>,100 scale<1,0.25,1>}
  cone    {< 15,0,0>,100,< 400,0,0>,0 scale<1,0.25,1>}
//  box     {< 0,3,40>,< 200,0,-40> rotate z*-15}
  
 }
 
#declare vessel =
 difference{
  object{ vessel_ruw  material{grijs_glimmend}}  
  object{ vessel_ruw scale 0.99 material{grijs_glimmend}}  
  box     {< 0,5,40>,< 200,-19,-40> }


}    
//  box     {< 0,-52,50>,< 300,-200,-50>material{metal_licht_glad} }

//  light_source {<0 ,0,0> rgb <0, 1.0, 0>*0.5} 


#declare landings_poot =
 union{  
  cylinder{< 0,0,0>,< 10,-54,0>,2 rotate z*-20}
  sphere  {< 0,0,0>,10 scale<1,0.25,1> translate< -8,-54,0> }
 }
 
 
 
#declare motor =
 difference{  
  cone    {< 175,0,0>,45,< 275,0,0>,60 scale<1,0.25,1>}
  cone    {< 175,0,0>,40,< 280,0,0>,55 scale<1,0.25,1>}
}
#declare media_motor =
union{                                                       
cone {< 175,0,0>,40,< 275,0,0>,55 scale<1,0.25,1> pigment { rgbt <1,1,1,1> } hollow  
  interior
    { media
     { emission 1
      density
     { cylindrical rotate z*-90  density_map 
     { [0   rgb <0,0,1  >]
       [1   rgb <0,0,0  >]
     }
    }
   }
  }
 }
}

#declare media_straal =
cone {< 0,0,0>,55,<0,175,0>,25
  pigment{
    rgbt <0,0,0,1>
  }
  hollow  
  interior{
    media{
      emission rgb <0,0,1>*0.05
      density{
        radial scale 55
      }
      density{
        function{-y} scale 20
      }
    }
  }
  rotate -z*90
  translate < 275,0,0>
  scale <1,0.25,1> 
}
                                                        
#declare media_lamp =
cone {<0,0,0>,0,<0,250,0>,50
  pigment{ 
    rgbt <0,0,0,1>
  }
  hollow  
  interior{
    media{
      emission rgb <0,0,1>*0.025
      density{
        radial scale 50
      }
      density{
        planar scale 250
      }
    }
  }
  rotate z*90
}
                                                        
#declare media_lampen =
union{                                                       
 object {media_lamp translate <-50,15, 60>}
 object {media_lamp translate <-50,15,-60>}
}

#declare ship =
 union{
  object{ landings_poot translate<  0,0,-50> material{grijs_glimmend}}  
  object{ landings_poot translate<  0,0, 50> material{grijs_glimmend}}  
  object{ landings_poot rotate y*180 translate<300,0,  0> material{grijs_glimmend}}  
  object{ motor         material{grijs_glimmend}}  
  object{ vessel     material{grijs_glimmend}}  
  object{ vessel_ruw scale 0.5 rotate z*-2  translate<25,20,0>  material{glas_rood}}  
  object{ media_lampen }  
  object{ media_motor  }  
  box     {< 0,3,40>,< 200,0,-40> rotate z*-15 material{grijs_glimmend}}
  sphere  {<0,0,0>,5 scale<2,1,1> translate<-50,15,-60>material{grijs_glimmend}}
  sphere  {<0,0,0>,5 scale<2,1,1> translate<-50,15, 60>material{grijs_glimmend}}
  
 }
 
#declare ship_vlieg =
 union{
  object{ motor         material{grijs_glimmend}}  
  object{ vessel       material{grijs_glimmend}}  
  object{ vessel_ruw scale 0.5 rotate z*-2  translate<25,20,0>  material{glas_rood}}  
  object{ media_lampen }  
  object{ media_straal }  
  sphere  {<0,0,0>,5 scale<2,1,1> translate<-50,15,-60>material{grijs_glimmend}}
  sphere  {<0,0,0>,5 scale<2,1,1> translate<-50,15, 60>material{grijs_glimmend}}
  
}

//--------------------------------------------------
//|                   car                          |
//--------------------------------------------------


#declare vehicel_ruw =
 union{
  box     {<-100, 0,50>,< 100,50,-50> }
  cylinder{<-100,25,50>,<-100,25,-50>,25 }
  cylinder{< 100,25,50>,< 100,25,-50>,25 }
 }
 
#declare vehicel =
 difference{ 
  object  { vehicel_ruw  }
  cylinder{<  0,0,51>,<  0,0,25>,30 }
  cylinder{< 75,0,51>,< 75,0,25>,30 }
  cylinder{<-75,0,51>,<-75,0,25>,30 }
  
  cylinder{<  0,0,-51>,<  0,0,-25>,30 }
  cylinder{< 75,0,-51>,< 75,0,-25>,30 }
  cylinder{<-75,0,-51>,<-75,0,-25>,30 }
  }
  
  
#declare rolkooi =
 union{
  cylinder{<75, 25,-40>,< 50,100,-40>,7 }
  cylinder{<75, 25, 40>,< 50,100, 40>,7 }
  cylinder{<50,100,-40>,< 50,100, 40>,7 }

  cylinder{<-75, 25, 40>,<-50,125, 40>,7 }
  cylinder{<-75, 25,-40>,<-50,125,-40>,7 }
  cylinder{<-50,125, 40>,<-50,125,-40>,7 }

  cylinder{<-50,125, 40>,< 50,100, 40>,7 }
  cylinder{<-50,125,-40>,< 50,100,-40>,7 }
  
  sphere  {<-50,125,-40>,7    }
  sphere  {<-50,125, 40>,7    }
  sphere  {< 50,100,-40>,7    }
  sphere  {< 50,100, 40>,7    }

  }

#declare band =
 union{
  cylinder{<0,0,-20>,<0,0,20>,25 material{zwart}}
  cylinder{<0,0,-21>,<0,0,21>,15 material{grijs}}
  }

#declare media_lamp_jeep =
cone {<0,0,0>,0,<0,150,0>,20
  pigment{ 
    rgbt <0,0,0,1>
  }
  hollow  
  interior{
    media{
      emission rgb <0,0,1>*0.025
      density{
        radial scale 20
      }
      density{
        planar scale 150
      }
    }
  }
  rotate -z*90
}

#declare media_lamp_jeep_2 =
cone {<0,0,0>,0,<0,450,0>,50
  pigment{ 
    rgbt <0,0,0,1>
  }
  hollow  
  interior{
    media{
      emission rgb <0,0,1>*0.05
      density{
        radial scale 50
      }
      density{
        planar scale 450
      }
    }
  }
  rotate -z*100
}







  
#declare jeep =
 union{
  object{ vehicel   material{grijs_glimmend}}  
  object{ rolkooi   material{grijs_glimmend}}  
  object{ band translate <  0,0,-50>  }  
  object{ band translate <  0,0, 50>  }  
  object{ band translate < 75,0,-50>  }  
  object{ band translate < 75,0, 50>  }  
  object{ band translate <-75,0,-50>  }  
  object{ band translate <-75,0, 50>  }  
  object{ media_lamp_jeep   translate <100, 25, 40>  }  
  object{ media_lamp_jeep   translate <100, 25,-40>  }  
  object{ media_lamp_jeep_2 translate <  0,120,-30>  }  
  object{ media_lamp_jeep_2 translate <  0,120, 30>  }  
} 
 
 


 
#ifndef(render_all)  
   object{ ship }  
   object{ ship_vlieg }  
   object{ jeep }  
#end
 
 
 
//////////////////


/*
  box     {< 0,-52,50>,< 300,-200,-50>
  texture{
   material_map{
       "text.png"   
//     BITMAP_TYPE "bitmap.ext"
//     [BITMAP_MODS...] TEXTURE... [TRANSFORMATIONS...]
       png
    }    
//     map_type Type | once | interpolate Type
     scale<100,100,100>
 }
}

*/