///////////////////////////////////////
//
//  materials.inc
//  Copyright R.P. Stolk. feb. 2003
//
//  veelgebruikte materialen
//
///////////////////////////////////////  
#include "colors.inc"

#include "metals.inc"
#include "woods.inc"
#include "golds.inc"
#include "stones1.inc"
 
#declare material_krater =
material{
  texture {
    pigment { color rgb < 150/255 , 150/255 , 150/255 >}
    normal {
      gradient y
      frequency 5
      turbulence .8
      normal_map {
        [0.00 granite]
        [0.25 spotted turbulence .75]
        [0.50 marble turbulence .7]
        [0.75 bozo turbulence .65]
        [1.00 granite]
      } 
      scale 400
    }
    finish{
      phong       0.0
      ambient     0.1
      diffuse     0.6
      reflection  0.0
    } 
  }
} 
 
 
#declare rood =
material{
  texture {
    pigment { color rgb < 230/255 , 0/255 , 0/255 >}
    finish  {
      phong       0.1
      ambient     0.1
      diffuse     0.7
      reflection  0.0
    }
  }
}
                 
#declare blauw =
material{
texture {
      pigment { color rgb < 0/255 , 0/255 , 200/255>}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.0
         } 
}}                 

#declare geel =
material{
texture {
      pigment { color rgb < 230/255 , 230/255 , 0/255 >}
      finish  {
            phong       0.0  //0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.1  //0.1
         }
}}                 
#declare zwart =
material{
texture {
      pigment { color rgb < 0/255 , 0/255 , 0/255>}
      finish  {
            phong       0.3
            ambient     0.1
            diffuse     0.7
            reflection  0.1
         }
}}                 

#declare dashboard_zwart =
material{
texture {
      pigment { color rgb < 50/255 , 50/255 , 50/255 >}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0
         }
}}                 

       





#declare glas =
material{
texture {
      pigment { color rgbf < 220/255 , 220/255 , 255/255 , 0.9>}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.1
         }
}}                 

#declare glas_rood =
material{
texture {
      pigment { color rgbf < 200/255 , 0/255 , 0/255 , 0.9>}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.1
         }
}}                 
#declare glas_orange =
material{
texture {
      pigment { color rgbf < 255/255 , 174/255 , 70/255 , 0.9>}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.1
         }
}}                 

#declare bruin =
material{
texture {
      pigment { color rgb < 185/255 , 92/255 , 0/255 >}
      finish  {
            phong       0.1
            ambient     0.1
            diffuse     0.7
            reflection  0.0
         }
}}                 

#declare dino_groen =
material{
texture {
      pigment { color rgb < 105/255 , 77/255 , 22/255 >}
      finish  {
            phong       0.01
            ambient     0.1
            diffuse     0.8
            reflection  0.01
         }
}}                 
#declare wit =
material{
texture {
      pigment { color rgb < 225/255 , 225/255 , 225/255 >}
      finish  {
            phong       0.0
            ambient     0.1
            diffuse     0.8
            reflection  0.0
         }
}}                 
#declare snoer_geel =
material{
texture {
      pigment { color rgb < 196/255 , 196/255 , 0/255 >}
      finish  {
            phong       0.01
            ambient     0.1
            diffuse     0.8
            reflection  0.01
         }
}}
#declare snoer_rood =
material{
texture {
      pigment { color rgb < 150/255 , 0/255 , 0/255 >}
      finish  {
            phong       0.01
            ambient     0.1
            diffuse     0.8
            reflection  0.01
         }
}}
#declare snoer_groen =
material{
texture {
      pigment { color rgb < 0/255 , 113/255 , 0/255 >}
      finish  {
            phong       0.01
            ambient     0.1
            diffuse     0.8
            reflection  0.01
         }
}}
#declare snoer_blauw =
material{
texture {
      pigment { color rgb < 0/255 , 0/255 , 113/255 >}
      finish  {
            phong       0.01
            ambient     0.1
            diffuse     0.8
            reflection  0.01
         }

}}
#declare rood_koper=
material {
  texture { T_Copper_4D   

    
  }   
}   
#declare goud=
material {
  texture { T_Gold_5D
    
  }  
}

#declare chroom=
material {
  texture { T_Chrome_4E
    
  }  
} 
#declare metal_licht_glad=
material {
  texture { T_Chrome_5A
  }  
} 

#declare metal_donker=
material {
  texture { T_Chrome_3A
    normal {  crackle 0.75 scale 0.3 }       // sterkte, grote
  }  
} 

#declare material_maan=
material{
  texture {
    pigment { color rgb <1,1,1>*0.1 }
    finish  {
      phong       0.0
      ambient     0.0
      diffuse     0.6
      reflection  0.0
    }
  }
} 


#declare metal_licht=
material {
  texture { T_Chrome_5A
    normal {  crackle 0.75 scale 0.3 }       // sterkte, grote
  }  
} 

#declare material_wood =
material{
  texture { T_Wood19
    finish { specular 0.50 roughness 0.1 ambient 0.25 }
    translate  x*10
    rotate <3, 90-3, 3>
    scale 100
  }
}

#declare material_silver =
material{
  texture { T_Silver_3E
    finish { specular 0.50 roughness 0.1 ambient 0.25 }
    translate  x*10
    rotate <3, 90-3, 3>
    scale 100
  }
}

#declare grijs_glimmend =
material{
texture {T_Chrome_5A
//      pigment { color rgb < 200/255 , 200/255 , 200/255>}
//      finish  {
//            phong       0.0
//            ambient     0.5
//            diffuse     0.5
//           reflection   0.3
//  }     
      finish  {
        ambient 0.1
        diffuse 0.5
        phong 1
      }
  }
 }          

#declare grijs =
material{
texture {
     pigment { color rgb < 128/255 , 128/255 , 128/255>}
     finish  {
           phong       0.1
           ambient     0.5
           diffuse     0.5
          reflection   0.0
 }     
  }
 }          

//////////////////////////////////////////////
//#declare roest=
// material {
//  texture{
//   pigment { rgb < 0.5, 0.5, 0.5> }
//   normal {  crackle 0.75 scale 0.3 }       // sterkte, grote
//  }  
// } 

#declare roest = 
texture {
  pigment{
    rgb < 0.5, 0, 0>
  }
  normal {
    crackle 1
    scale 1
  }
}

#declare T_Chrome_roelof =
texture {
  pigment {
    P_Chrome1
  }
  finish {
    ambient 0.35
    brilliance 2
    diffuse 0.4
    metallic
    specular 0.80
    roughness 1/20
    //reflection 0.1
    reflection  0.0
  }
}

#declare metal_roest =
texture {
  granite
  texture_map {                  
    [0.0 T_Chrome_roelof ]
    [0.4 T_Chrome_roelof ]
    [1.0 roest ]
  }
  frequency 1
  scale <40,15,40>
}


#declare metal_roest_2 =
texture {
  granite
  texture_map {                  
    [0.0 T_Chrome_roelof ]
    [0.4 T_Chrome_roelof ]
    [1.0 roest ]
  }
  frequency 1
  scale <80,35,80>
  scale 0.01
}

#declare doorzichtig =
texture{ 
  pigment { color rgbt <1,1,1,1>}
}      
      
#declare vorm_verwoest =
texture{
  granite
  texture_map {
//      bozo
//      turbulence 5//0.65
//      octaves 6
//      omega 0.7
//      lambda 2
//      color_map {
    [0.0 metal_roest   scale 0.01]
    [0.399 metal_roest scale 0.01]
    [0.4 doorzichtig]
    [1.0 doorzichtig]
  } 
  scale 250
}

//%%%%%%%%%%%%%%%%%%%%%%%%%% kleuren: %%%%%%%%%%%%%%%%%%%%%%%%%%%%%



global_settings { // radiosity (global illumination) settings
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.005          // end pretrace at this size
    count  50                    // higher -> higher quality (1..1600) [35]
    error_bound 0.1               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
  }
}

    








                      