///////////////////////////////////////
//
//  omgeving.inc
//  Copyright R.P. Stolk.march. 2005
//
//  omgeving
//
///////////////////////////////////////   


//--------------------------------------------------
//|                 declclare                      |
//--------------------------------------------------


#include "functions.inc"
#declare naar_midden = function { sqrt(pow(x,2) + pow(z,2)) }; // afstand tot midden (pytagoras) + y

#declare parabool = function { y - pow(naar_midden(x,y,z),2)*0.5 + 0.5 }; // parabool, scaal y=1/2, 0.5 naar beneden

#declare punt = function { y - ( (1/(naar_midden(x,y,z)+0.001)) ) + 0.2 }; // 1/.. functie, 0.2 naar beneden
// +0.001 om 1/0 te voorkomen :-)




//--------------------------------------------------
//|                   height_field                 |
//--------------------------------------------------
#declare bergen =
union{
height_field  {  
png "meteor2.png"  smooth                                         
   water_level 0.0

/*  
   finish {
      crand 0.025         // dither  - not used often, but this image needs it.
      ambient 0.2         // Very dark shadows
      diffuse 0.8         // Whiten the whites
      phong 0.75          // Fairly shiny
      phong_size 100.0    // with tight highlights
      specular 1.0
      roughness 0.0000005
   }
*/   
   scale <10000, 750, 10000>
   translate <-300, 0, -275>
 }
}             
//--------------------------------------------------
//|                   height_field                 |
//--------------------------------------------------
#declare bergen_2 =
union{
height_field  {  
png "meteor3.png"  smooth                                         
   water_level 0.0

/*  
   finish {
      crand 0.025         // dither  - not used often, but this image needs it.
      ambient 0.2         // Very dark shadows
      diffuse 0.8         // Whiten the whites
      phong 0.75          // Fairly shiny
      phong_size 100.0    // with tight highlights
      specular 1.0
      roughness 0.0000005
   }
*/   
//   translate <-0.5, -0.6, -0.5>
   scale <10000, 250, 10000>
 //
//   translate <-0.5, -0.6, -0.5>
  // scale <10, 3, 10>
 }
}             
//--------------------------------------------------
//|                   krater                       |
//--------------------------------------------------
#declare krater_9 =
union{
  object{
    isosurface {
      function { max(punt(x,y,z), parabool(x,y,z)) + f_noise3d (x*2, y*4, z*2)*0.2} 
      max_gradient 1.8
      contained_by { box { <-3,-1,-3>,<3,2,3> } }
    }
  
scale<1500/3,1250/3,1500/3>
translate<2000,-25,7000>  
 } 
 material{material_krater}}

//--------------------------------------------------
//|                  grond                         |
//--------------------------------------------------
#declare grond =
object{
  isosurface {
    function {(y)+ f_noise3d (x*5, y*2, z*2)*0.2} 
    max_gradient 1.5
    contained_by { box { <-3,-3*0.2,-3>,<3,3*0.2,3> } }
  }
  scale<4000/3,1000/3,3000/3>
  translate<4000,50,6000>
}


///////////////////////////////////
#if (bergen_on_off=on)  
  object{bergen   material{material_krater}}
  object{bergen_2 material{material_krater}}
#end


#if (heuvels_on_off=on) 
  object{krater_9}
  object{grond material{material_krater}}
#end

//--------------------------------------------------
//|                   lucht                        |
//--------------------------------------------------


sphere{<0,0,0>,1          
  pigment {          // Clouds
    bozo
    turbulence 1
    octaves 6
    omega 0.7
    lambda 2
    color_map {
    [0.0 color rgbt <0.75, 0.75, 0.75, 0.25>]
    [0.2 color rgbt <0.55, 0.55, 0.55, 0.25>]
    [0.4 color rgbt <0.55, 0.55, 0.55, 1>]
    [1.0 color rgbt <1, 1, 1,1>]
    }
    scale <19/30,5/30,19/30>
    
   }
   rotate y*-10   hollow 
   
   scale 100000
 } 


//--------------------------------------------------
//|                   rotsen                       |
//--------------------------------------------------

/*
#declare rots = box { <-100, 0, -100>,<100, 500, 100> scale 5} 

#declare rotsen=20;


#declare R1 = seed(12345);

// x van -4000 tot +4000
// z van -3000 tot +3000
#declare r=0;

#while (r < rotsen)
  #declare start= <(rand(R1)*6000)-4000, 1000, (rand(R1)*4000)-3000>;
  //#declare start= <3000,25,5500>;
  #declare Norm = <0,0,0>;
  #declare snijpunt = trace ( grond, start, -y, Norm ); 
  //#if (vlength(Norm)!=0) 
    object{ rots translate snijpunt translate <4000,200,3000>}
  //#end
  #declare r=r+1;
#end
*/


//--------------------------------------------------
//|                   maan                         |
//--------------------------------------------------

#declare PMoonMare =
pigment {
  wrinkles
  turbulence 0.2
  scale 0.5
  color_map { [0 rgb 1] [1 rgb 0] }
}

#declare PMoonCraters =
pigment {
  granite
  scale 0.2
  color_map{
    [0 rgb 1]
    [1 rgb 0]
  }
}

#declare TMoon =
texture{
  pigment {
    average
    pigment_map{
      [0.85 PMoonMare]
      [0.15 PMoonCraters]
    }
  }
  finish {ambient 0.001 diffuse 0.9}
  scale 2
}

#declare Sphere  = function{sqrt(pow(x,2) + pow(y,2) + pow(z,2)) -1}
#declare FCraters= function{pigment{PMoonCraters}}
#declare FMare   = function{pigment{PMoonMare   }}

light_group {
//sphere{< 360000,50000,1200000>,50000 material{material_maan}}
  object{
    isosurface {
    function { Sphere(x,y,z) + (1-FCraters(x/3,y/3,z/3).x)*0.005 + (1-FMare(x/3,y/3,z/3).x)*0.02 }
      max_gradient 1.5
      bounded_by{sphere{0,1.2}}
    }
    texture {TMoon}
    scale 40000
    translate < 360000,50000,1200000>
  }
  light_source {< 360000-1000000,50000+100000,1200000-150000>, rgb <1,1,1> }
  global_lights off
}

