///////////////////////////////////////
//
//  ruines.inc
//  Copyright R.P. Stolk. march.2005
//
//  gebouwen
//
///////////////////////////////////////   


//      3_
//   2/   \4
//  1|     |5
//   8\ _ /6
//      7

//--------------------------------------------------
//|                 main_house                     |
//--------------------------------------------------


#declare huis_skelet_onder =
 union{
  box {<-2,0,-2>,<2,100,2> translate<47.5,0,    0>}             //3
  box {<-2,0,-2>,<2,100,2> translate<   0,0,-47.5>}             //5
  box {<-2,0,-2>,<2,100,2> translate<47.5,0,    0> rotate y* 45}//2
  box {<-2,0,-2>,<2,100,2> translate<47.5,0,    0> rotate y*-45}//4
  box {<-2,0,-2>,<2,100,2> translate<   0,0,-47.5> rotate y* 45}//6
 
 
   
  prism {
    linear_sweep
    linear_spline
     -2, // sweep the following shape from here ...
      2, // ... up through here
     5, // the number of points making up the shape ...
    <2,0>, <-2,0>, <-2,75>, <0,65>, <2,70>
    rotate x*-90 translate<0,0,47.5>                 
    } //1

  prism {
    linear_sweep
    linear_spline
     -2, // sweep the following shape from here ...
      2, // ... up through here
     8, // the number of points making up the shape ...
    <2,0>, <-2,0>, <-2,35>, <0,30>, <2,33>,
    <2,28>, <1,23>, <2,15>
    rotate x*-90 rotate y*90 translate<-47.5,0,0>                 
    } //7

  prism {
    linear_sweep
    linear_spline
     -2, // sweep the following shape from here ...
      2, // ... up through here
     4, // the number of points making up the shape ...
    <2,0>, <-2,0>, <-2,45>, <2,60>
    rotate x*-90 translate<0,0,47.5> rotate y*-45                
    } //8
} 



#declare huis_buitenkant_onder =
difference{
  cylinder { <0, 0,0>, <0,100,0>, 50 }
  cylinder { <0,-1,0>, <0,101,0>, 49.5 }
 // no_shadow 
  texture {
    image_pattern { png "mask.png" use_color interpolate 2 map_type 2 once}
    texture_map {
      [0 pigment { transmit 1 } ]
      [1  metal_roest_2]//color rgb < 100/255 , 100/255 , 100/255>}]
    }
    scale 100
  }
  rotate y*225
}



#declare huis_boven =
 difference{  
  cylinder {<  0,100,   0>,<   0,104,  0>, 50 }
  cylinder {<  0, 99,   0>,<   0,105,  0>, 45 }
  box      {<-10, 99,-100>,<-100,105,100>     }
  
}





#declare huis_skelet_boven_ruw1 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,51> }
 }
    
#declare huis_skelet_boven_ruw2 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,51> rotate y*45}
 }
               
#declare huis_skelet_boven_ruw3 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,51> rotate y*90}
 }
               
#declare huis_skelet_boven_ruw4 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,51> rotate y*135}
 }
               
#declare huis_skelet_boven_ruw5 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,51> rotate y*180}
 }
                                
#declare huis_skelet_boven_ruw6 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,15> rotate y*225}
 }
               
#declare huis_skelet_boven_ruw7 =
 intersection{                  
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,20> rotate y*270}
 }
               
#declare huis_skelet_boven_ruw8 =
 intersection{
  sphere{< 0,100,0>,50}
  box   {<-2,100,0>,<2,151,25> rotate y*315}
 } 
 
 
 
              
#declare huis_skelet_boven_ruw =
 union{           
  object{ huis_skelet_boven_ruw1 }
  object{ huis_skelet_boven_ruw2 }
  object{ huis_skelet_boven_ruw3 }
  object{ huis_skelet_boven_ruw4 }
  object{ huis_skelet_boven_ruw5 }
  object{ huis_skelet_boven_ruw6 }
  object{ huis_skelet_boven_ruw7 }
  object{ huis_skelet_boven_ruw8 }
}


#declare huis_skelet_boven =
 difference{
  object  {huis_skelet_boven_ruw}
  sphere  {<0,100, 0>,45 }
}





#declare huis =
 union{
  object  {huis_skelet_onder rotate y*-45 texture{metal_roest}}
  object  {huis_buitenkant_onder }
  object  {huis_skelet_boven }
  object  {huis_boven }

}
#if (huizen = on)
  object  {huis translate<525,750,875> texture{metal_roest}}
#end

//--------------------------------------------------
//|                   houses                       |
//--------------------------------------------------


#declare loods =
 union{
  sphere  {<0,100, 0>,100                    }
  box     {<-200, 0,-100>,<200,100,100>     }
 } 


#declare villa =
 union{
  box     {<-200, 0,-100>,<200,100,100>      }
  cylinder{<  0,100,  0>,<   0,300,  0>, 50 }
  sphere  {<0,300, 0>,75                    }
}

#declare bol =
 union{
  sphere  {<0,0, 0>,100                    }

}

#declare buis =
 union{
  cylinder  {< -200,0,0>,< 200,0,0>, 100 }       

}


 
object{loods  scale 0.5 translate<1500,-10,4000> texture{vorm_verwoest}}
object{loods  scale 0.5 rotate y*45 translate<2000,-10,4500> texture{vorm_verwoest}}

object{loods  scale 0.5 rotate y*45 translate<4500,-10,7000> texture{vorm_verwoest}}
object{loods  scale 0.5 rotate y*45 translate<4000,-10,5500> texture{vorm_verwoest}}


object{villa  scale 0.5 rotate y*130 translate<2000,-10,4000> texture{vorm_verwoest}}
object{villa  scale 0.5 rotate y*70  translate<1000,-10,4000> texture{vorm_verwoest}}

object{villa  scale 0.5 rotate y*70  translate<4000,-10,7500> texture{vorm_verwoest}}
object{villa  scale 0.5 rotate y*70  translate<3750,-10,6000> texture{vorm_verwoest}}

object{bol  scale 0.5 translate<1500,-10,3500> texture{vorm_verwoest}}
object{bol  scale 0.5 translate<1000,-10,3500> texture{vorm_verwoest}}
object{bol  scale 0.5 translate<1250,-10,3500> texture{vorm_verwoest}}

object{bol  scale 0.5 translate<2750,-5,4900> texture{vorm_verwoest}}

object{buis  scale 0.5 rotate y*90 translate<1250,0,4500> texture{vorm_verwoest}}
object{buis  scale 0.5 translate<2000,0,3500> texture{vorm_verwoest}}

object{buis  scale 0.5 translate<3500,0,6250> texture{vorm_verwoest}}



//--------------------------------------------------
//|                   stuff                        |
//--------------------------------------------------

///////bank/////




















