// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1

#include "colors.inc"
#include "functions.inc"
#include "textures.inc"	// Standard Texture definitions
#include "SKIES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODS.INC"
#include "GLASS.INC"  


global_settings
{
  assumed_gamma 1.0 
  ambient_light rgb <1.5, 1.5, 2.2>
  max_trace_level 20 //20
}

sky_sphere
{
S_Cloud4
}

fog
{
  fog_type   2
  distance   200 
  fog_offset 0
  fog_alt    4
  color      rgb <0.5, 0.5, 1>
  turbulence 1.5
}


camera
{
  location  <0.0, 1.7, 0.0>
  direction z
  right     4/3*x
  look_at   <0.0, 0.0,  50.0>
}


light_source
{
  0*x
  color rgb< 1.5, 1.5, 1.2>
  translate <-30000, 10000, 5000>
}


#declare isosmoke1 = isosurface {
  function { f_sphere(x, y, z, 1) - f_noise3d(x, y, z) - f_noise3d(3*x, 3*y, 3*z)} 
  threshold 0  
  max_gradient 50
  contained_by{sphere{<0,0,0> 5}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{absorption 2.5 density{color rgb 0.2}}}
  hollow
}
#declare isosmoke2 = isosurface {
  function { f_sphere(x, y, z, 1) - f_noise3d(x, y, z) - f_noise3d(3*x, 3*y, 3*z)} 
  threshold 0  
  max_gradient 50
  contained_by{sphere{<0,0,0> 5}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{absorption 1.0 density{color rgb 0.2}}}
  hollow
}
#declare isosmoke3 = isosurface {
  function { f_sphere(x, y, z, 1) - f_noise3d(x, y, z) - f_noise3d(3*x, 3*y, 3*z)} 
  threshold 0  
  max_gradient 50
  contained_by{sphere{<0,0,0> 5}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{absorption 0.5 density{color rgb 0.2}}}
  hollow
}

#declare rust = texture{
        pigment{granite 
              color_map {
                      [0.0, 0.7   color rgb <0., 0.0, 0.>
                                      color rgb <0.3, 0.2, 0.1>]
                      [0.7, 0.9   color rgb <0.5, 0.3, 0.2>
                                      color rgb <0.6, 0.3, 0.2> ]
                      [0.9, 1.0 color rgb <0.7, 0.4, 0.4>
                                      color rgb <0.7, 0.4, 0.4>]
              }
        }
        normal{bumps 0.1 scale 0.001}
        scale 0.05        
}
#declare wetrust = texture{
        pigment{granite 
              color_map {
                      [0.0, 0.7   color rgb <0., 0.0, 0.>
                                      color rgb <0.1, 0.05, 0.02>]
                      [0.7, 0.9   color rgb <0.2, 0.1, 0.05>
                                      color rgb <0.25, 0.15, 0.1> ]
                      [0.9, 1.0 color rgb <0.3, 0.2, 0.2>
                                      color rgb <0.3, 0.2, 0.2>]
              }
        }
        normal{bumps 0.1 scale 0.001}
        scale 0.05        
}

#declare peelredpaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.6   color rgb <1, 0.3, 0.3>
                                      color rgb <1, 0.3, 0.3>]
                      [0.6, 1   color rgbt <0, 0, 0, 1>
                                      color rgbt <0, 0, 0, 1> ]
              }
              scale 8
        }
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare peelwhitepaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.8   color rgb <1, 1, 1>
                                      color rgb <1, 1, 1>]
                      [0.8, 1   color rgbt <0, 0, 0, 1>
                                      color rgbt <0, 0, 0, 1> ]
              }
              scale 8
        }
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare peelbluepaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.8   color rgb <0.3, 0.3, 1>
                                      color rgb <0.3, 0.3, 1>]
                      [0.8, 1   color rgbt <0, 0, 0, 1>
                                      color rgbt <0, 0, 0, 1> ]
              }
              scale 8
        }
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare shitredpaint = texture{
        pigment{bozo 
              color_map {
                      [0.0, 0.6   color rgb <1, 0.3, 0.3>
                                      color rgb <1, 0.3, 0.3>]
                      [0.6, 0.7   color rgb <1, 0.3, 0.3>
                                      color rgb <1, 1, 1> ]
                      [0.7, 1.0   color rgb <1, 1, 1>
                                      color rgb <1, 1, 1> ]
              } 
              turbulence 0.8
              scale 1
        }
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare wholeredpaint = texture{
        pigment{color rgb <1, 0.3, 0.3>}
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare wholebluepaint = texture{
        pigment{color rgb <0.3, 0.3, 1>}
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare wholegreenpaint = texture{
        pigment{color rgb <0.3, 1, 0.3>}
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare wholewhitepaint = texture{
        pigment{color rgb <1, 1, 1>}
        normal{bumps 0.2 scale 0.001}
        scale 0.3        
}
#declare F_BlindGlass =
finish {
    ambient 0.1
    diffuse 0.8
    reflection 0.25
    specular 1
    roughness 0.001
}

#declare T_BlindGlass =
texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
    finish { F_BlindGlass }
}

#declare clamp = union{
        union{
                box{<-0.25, 0, -0.1> <0.25, 0.01, 0.1>}
                cylinder{<-0.12, 0, 0><-0.12, 0.2, 0> 0.1}
                cylinder{<0.12, 0, 0><0.12, 0.2, 0> 0.1}
                cylinder{<-0.12, 0.2, 0><-0.12, 0.22, 0> 0.11}
                cylinder{<0.12, 0.2, 0><0.12, 0.22, 0> 0.11}
                texture{peelredpaint}
        }
        union{
                box{<-0.249, 0, -0.999> <0.249, 0.099, 0.999>}
                cylinder{<-0.12, 0, 0><-0.12, 0.2, 0> 0.099}
                cylinder{<0.12, 0, 0><0.12, 0.2, 0> 0.099}
                cylinder{<-0.12, 0.2, 0><-0.12, 0.219, 0> 0.109}
                cylinder{<0.12, 0.2, 0><0.12, 0.219, 0> 0.109}
                texture{rust}
        }
}

#declare boat = union{
        difference{//rusty body
                union{
                        sphere{<0, 0, 0> 10 scale <0.5, 1, 1>}
                        cylinder{<-0.1, 0, 0> <0.1, 0, 0> 10.3}
                }
                sphere{<0, 0, 0> 9.9 scale <0.5, 1, 1>}
                box{<-6, 0, -20> <6, 20, 3>}
                box{<-6, 3, -20> <6, 20, 20>}
                cylinder{<-6, -0.5, -8> <6, -0.5, -8> 0.3}
                cylinder{<-6, -0.5, -6> <6, -0.5, -6> 0.3}
                cylinder{<-6, -0.5, -4> <6, -0.5, -4> 0.3}
                cylinder{<-6, -0.5, -2> <6, -0.5, -2> 0.3}
                cylinder{<-6, -0.5, 0> <6, -0.5, 0> 0.3}
                cylinder{<-6, -0.5, 2> <6, -0.5, 2> 0.3}
                cylinder{<-6, 2.5, 4> <6, 2.5, 4> 0.3}
                cylinder{<-6, 2.5, 6> <6, 2.5, 6> 0.3}
                cylinder{<-6, 2.5, 8> <6, 2.5, 8> 0.3}
                texture{rust}
        }
        difference{//white paint
                union{
                        sphere{<0, 0, 0> 10.001 scale <0.5, 1, 1>}
                        cylinder{<-0.101, 0, 0> <0.101, 0, 0> 10.301}
                }
                sphere{<0, 0, 0> 9.8999 scale <0.5, 1, 1>}
                box{<-6, 0.001, -20> <6, 20, 3>}
                box{<-6, 3.001, -20> <6, 20, 20>}
                box{<-6, -1, -20> <6, -20, 20>}
                cylinder{<-6, -0.5, -8> <6, -0.5, -8> 0.3}
                cylinder{<-6, -0.5, -6> <6, -0.5, -6> 0.3}
                cylinder{<-6, -0.5, -4> <6, -0.5, -4> 0.3}
                cylinder{<-6, -0.5, -2> <6, -0.5, -2> 0.3}
                cylinder{<-6, -0.5, 0> <6, -0.5, 0> 0.3}
                cylinder{<-6, -0.5, 2> <6, -0.5, 2> 0.3}
                cylinder{<-6, 2.5, 4> <6, 2.5, 4> 0.3}
                cylinder{<-6, 2.5, 6> <6, 2.5, 6> 0.3}
                cylinder{<-6, 2.5, 8> <6, 2.5, 8> 0.3}
                texture{peelwhitepaint}
        }
        difference{//red underwater paint
                union{
                        sphere{<0, 0, 0> 10.001 scale <0.5, 1, 1>}
                        cylinder{<-0.101, 0, 0> <0.101, 0, 0> 10.301}
                }
                sphere{<0, 0, 0> 9.8999 scale <0.5, 1, 1>}
                box{<-6, -1, -20> <6, 20, 20>}
                texture{peelredpaint}
        }
        difference{//decks
                union{
                        box{<-6, -1, -20><6, -0.99, 20> texture{peelwhitepaint}}
                        box{<-6, 1.99, 3.1> <6, 2, 20> texture{peelwhitepaint}}
                        box{<-6, -1.01, 3.2> <6, 2, 3.21> texture{peelwhitepaint}}
                        box{<-5.999, -1.001, -20><5.999, -0.999, 20> texture{rust}}
                        box{<-5.999, 1.991, 3.101> <5.999, 1.999, 20> texture{rust}}
                        box{<-5.999, -1.01, 3.201> <5.999, 1.999, 3.209> texture{rust}}
                }
                difference{
                        box{<-100, -100, -100> <100, 100, 100>}
                        sphere{<0, 0, 0> 9.8999 scale <0.5, 1, 1>}
                        texture{wholewhitepaint}
                }
        }
        difference{//porthole frames
                union{
                        cylinder{<-6, -0.5, -8> <6, -0.5, -8> 0.4}
                        cylinder{<-6, -0.5, -6> <6, -0.5, -6> 0.4}
                        cylinder{<-6, -0.5, -4> <6, -0.5, -4> 0.4}
                        cylinder{<-6, -0.5, -2> <6, -0.5, -2> 0.4}
                        cylinder{<-6, -0.5, 0> <6, -0.5, 0> 0.4}
                        cylinder{<-6, -0.5, 2> <6, -0.5, 2> 0.4}
                        cylinder{<-6, 2.5, 4> <6, 2.5, 4> 0.4}
                        cylinder{<-6, 2.5, 6> <6, 2.5, 6> 0.4}
                        cylinder{<-6, 2.5, 8> <6, 2.5, 8> 0.4}
                }
                union{
                        cylinder{<-6, -0.5, -8> <6, -0.5, -8> 0.3}
                        cylinder{<-6, -0.5, -6> <6, -0.5, -6> 0.3}
                        cylinder{<-6, -0.5, -4> <6, -0.5, -4> 0.3}
                        cylinder{<-6, -0.5, -2> <6, -0.5, -2> 0.3}
                        cylinder{<-6, -0.5, 0> <6, -0.5, 0> 0.3}
                        cylinder{<-6, -0.5, 2> <6, -0.5, 2> 0.3}
                        cylinder{<-6, 2.5, 4> <6, 2.5, 4> 0.3}
                        cylinder{<-6, 2.5, 6> <6, 2.5, 6> 0.3}
                        cylinder{<-6, 2.5, 8> <6, 2.5, 8> 0.3}
                }
                difference{
                        box{<-100, -100, -100> <100, 100, 100>}
                        sphere{<0, 0, 0> 10.02 scale <0.5, 1, 1>}
                }
                sphere{<0, 0, 0> 9.89 scale <0.5, 1, 1>}
                texture{wholewhitepaint}
        }
        torus{10 0.3 scale <0.5, 0.2, 1> texture{rust}}
        torus{10 0.301 scale <0.5, 0.2, 1> texture{peelwhitepaint}}
        //stern reeling
        torus{9.9 0.02 scale <0.5, 1, 1> translate<0, 1, 0> texture{wholewhitepaint}}
        torus{9.9 0.02 scale <0.5, 1, 1> translate<0, 0.5, 0> texture{wholewhitepaint}}
        union{
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*140}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*150}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*160}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*170}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*180}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*190}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*200}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*210}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*220}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*230}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*240}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*250}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*260}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*270}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*280}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*290}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*300}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*310}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*320}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*330}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*340}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*350}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*0}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*10}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*20}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*30}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*40}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*50}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*60}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*70}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*80}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*90}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*100}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*110}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*120}
                cylinder{<9.9, 0, 0> <9.9, 1, 0> 0.02 rotate y*130}
                scale <0.5, 1, 1>
                texture{wholewhitepaint}
        }
        //bow reeling
        difference{
                union{
                        torus{9.9 0.02 scale <0.5, 1, 1> translate<0, 4, 0>}
                        torus{9.9 0.02 scale <0.49, 0.99, 0.99> translate<0, 3.5, 0>}
                }
                box{<-6, 0, -20> <6, 20, 3>}
                texture{wholewhitepaint}                
        }
        union{
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*200}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*210}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*220}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*230}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*240}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*250}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*260}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*270}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*280}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*290}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*300}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*310}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*320}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*330}
                cylinder{<9.5, 0, 0> <9.9, 1, 0> 0.02 rotate y*340}
                scale <0.5, 1, 1>
                texture{wholewhitepaint}
                translate y*3
        }
        union{//deck house
                difference{
                        union{
                                box{<-3, -1, 0> <3, 6, 4> texture{peelwhitepaint}}
                                box{<-3.5, 4, 0> <3.5, 6, 4.5> texture{peelwhitepaint}}
                                box{<-3.1, -1, 2.55> <3.1, 4, 2.6> texture{peelwhitepaint}}   
                                box{<-3.6, 3.9, 2.55> <3.6, 6.1, 2.6> texture{peelwhitepaint}}
                                box{<-3.1, 2, -4> <3.1, 2.1, 4.1> texture{peelwhitepaint}}
                                   
                                box{<-2.999, -1, 0.001> <2.999, 5.999, 3.999> texture{rust}}
                                box{<-3.499, 4.001, 0.001> <3.499, 5.999, 4.499> texture{rust}}
                                box{<-3.099, -1, 2.549> <3.099, 3.999, 2.599> texture{rust}}   
                                box{<-3.599, 3.899, 2.549> <3.599, 6.099, 2.599> texture{rust}}
                                box{<-3.099, 2.099, -3.999> <3.099, 2.099, 4.099> texture{rust}}   
                        }
                        union{
                                box{<-2.99, -9.99, 0.01> <2.99, 5.99, 3.99>}
                                box{<-3.49, 4.01, 0.02> <3.49, 5.99, 4.49>}
                                
                                superellipsoid{ <0.5, 0.5> scale<10, 0.5, 0.25> translate<0, 5, 1>}
                                superellipsoid{ <0.5, 0.5> scale<10, 0.5, 0.25> translate<0, 5, 2>}
                                superellipsoid{ <0.5, 0.5> scale<10, 0.5, 0.25> translate<0, 5, 3>}
                                superellipsoid{ <0.5, 0.5> scale<10, 0.5, 0.25> translate<0, 5, 4>}
                                superellipsoid{ <0.5, 0.5> scale<0.25, 0.5, 10> translate<0, 5, 2>}
                                superellipsoid{ <0.5, 0.5> scale<0.25, 0.5, 10> translate<-1, 5, 2>}
                                superellipsoid{ <0.5, 0.5> scale<0.25, 0.5, 10> translate<1, 5, 2>}
                                superellipsoid{ <0.5, 0.5> scale<0.25, 0.5, 10> translate<-2, 5, 2>}
                                superellipsoid{ <0.5, 0.5> scale<0.25, 0.5, 10> translate<2, 5, 2>}
                                texture{wholewhitepaint}
                        }
                }
                difference{
                        union{
                                box{<-2.99, -1, 0.01> <2.99, 5.99, 3.99>}
                                box{<-3.49, 4.01, 0.01> <3.49, 5.99, 4.49>}
                        }
                        union{
                                box{<-2.98, -9.98, 0.02> <2.98, 5.98, 3.98>}
                                box{<-3.48, 4.02, 0.02> <3.48, 5.98, 4.48>}
                        }
                        texture{T_BlindGlass}
                }
                light_source{
                        0*x
                        color rgb <1, 1, 0>
                        translate <0, 3, 2>
                        fade_power 2
                }
                //larboard position light
                difference{
                        box{<-3.7, 4.89, 0> <-3.5, 5.1, 0.3>}
                        box{<-3.71, 4.9, 0.01> <-3.51, 5.11, 0.31>} 
                        texture{wholeredpaint}
                }
                light_source{
                        0*x
                        color rgb <1, 0, 0>
                        translate <-3.6, 5, 0.1>
                        looks_like {sphere{<0, 0, 0> 0.1 texture{pigment {color rgbt<3,0,0,0.6>}}}}
                        fade_power 2
                        fade_distance 1
                }
                //starboard position light
                difference{
                        box{<3.7, 4.89, 0> <3.5, 5.1, 0.3>}
                        box{<3.71, 4.9, 0.01> <3.51, 5.11, 0.31>} 
                        texture{wholegreenpaint}
                }
                light_source{
                        0*x
                        color rgb <0, 1, 0>
                        translate <3.6, 5, 0.1>
                        looks_like {sphere{<0, 0, 0> 0.1 texture{pigment {color rgbt<0,3,0,0.6>}}}}
                        fade_power 2
                        fade_distance 1
                }
                //top reeling
                sphere{<-3.4, 7, 0.1> 0.02 texture{wholewhitepaint}}
                sphere{<-3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                sphere{<3.4, 7, 0.1> 0.02 texture{wholewhitepaint}}
                sphere{<3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3.4, 7, 0.1> <-3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3.4, 7, 3.9> <3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 7, 3.9> <3.4, 7, 0.1> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 7, 0.1> <-3.4, 7, 0.1> 0.02 texture{wholewhitepaint}} 
                cylinder{<-3.4, 6.5, 0.1> <-3.4, 6.5, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3.4, 6.5, 3.9> <3.4, 6.5, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 6.5, 3.9> <3.4, 6.5, 0.1> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 6.5, 0.1> <-3.4, 6.5, 0.1> 0.02 texture{wholewhitepaint}} 
                cylinder{<-3.4, 6, 0.1> <-3.4, 7, 0.1> 0.02 texture{wholewhitepaint}}
                cylinder{<0, 6, 0.1> <0, 7, 0.1> 0.02 texture{wholewhitepaint}}
                cylinder{<-3.4, 6, 3.9> <-3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<0, 6, 3.9> <0, 7, 3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 6, 0.1> <3.4, 7, 0.1> 0.02 texture{wholewhitepaint}}
                cylinder{<3.4, 6, 3.9> <3.4, 7, 3.9> 0.02 texture{wholewhitepaint}}
                //mast
                cylinder{<0, -1, -0.2> <0, 11, -0.2> 0.1 texture{peelwhitepaint}}
                cylinder{<-1, 9, -0.2> <1, 9, -0.2> 0.1 texture{peelwhitepaint}}
                cylinder{<0, -1, -0.2> <0, 11, -0.2> 0.099 texture{rust}}
                cylinder{<-1, 9, -0.2> <1, 9, -0.2> 0.099 texture{rust}}
                cylinder{<-0.8, 8.7, -0.2> <-0.79, 8.7, -0.2> 0.2 texture{wholewhitepaint}}
                cylinder{<0.8, 8.7, -0.2> <0.79, 8.7, -0.2> 0.2 texture{wholewhitepaint}}
                cylinder{<-0.795, 8.7, -0.4> <-0.795, -1, -0.4> 0.02 texture{wholewhitepaint}}
                cylinder{<-0.795, 8.7, 0> <-0.795, -1, 0> 0.02 texture{wholewhitepaint}} 
                cylinder{<-0.8, 9, -0.2> <-0.8, 8.7, -0.2> 0.02 texture{wholewhitepaint}}
                cylinder{<-0.79, 9, -0.2> <-0.79, 8.7, -0.2> 0.02 texture{wholewhitepaint}}
                cylinder{<0.8, 9, -0.2> <0.8, 8.7, -0.2> 0.02 texture{wholewhitepaint}}
                cylinder{<0.79, 9, -0.2> <0.79, 8.7, -0.2> 0.02 texture{wholewhitepaint}}
                cylinder{<0.795, 8.7, -0.4> <0.795, -1, -0.4> 0.02 texture{wholewhitepaint}}
                cylinder{<0.795, 8.7, 0> <0.795, -1, 0> 0.02 texture{wholewhitepaint}}
                cylinder{<0, 7.89, 0> <0, 7.9, 0> 0.2  texture{wholewhitepaint}}
                light_source{
                        0*x
                        color rgb <1, 1, 1>
                        translate <0, 8, 0>
                        looks_like {sphere{<0, 0, 0> 0.1 texture{pigment {color rgbt<3,3,3,0.6>}}}}
                        fade_power 2
                        fade_distance 1
                }
                cylinder{<0, 8.1, 0> <0, 8.11, 0> 0.2  texture{wholewhitepaint}}
                //stack
                difference{
                        union{
                                cylinder{<0, -1, -1.5> <0, 7, -2> 1 scale <1, 1, 2> texture{peelbluepaint}}
                                cylinder{<0, -1, -1.5> <0, 7, -2> 0.999 scale <1, 1, 2> texture{rust}}
                        }
                        cylinder{<0, -1, -1.5> <0, 7, -2> 0.9 scale <1, 1, 2> texture{pigment{color rgb <0, 0, 0>}}}
                }
                torus{1 0.05 translate<0, 7, -2> scale<1, 1, 2>  texture{wholebluepaint}}
                torus{1 0.05 translate<0, 2.1, -1.75> scale<1, 1, 2> texture{wholebluepaint}}
                torus{1 0.05 translate<0, -1, -1.5> scale<1, 1, 2> texture{wholebluepaint}}
                object{isosmoke1 translate <0, 8, -5>}
                object{isosmoke2 scale<2, 1, 3> rotate y*100 translate <0, 9, -15>}
                object{isosmoke3 scale<3, 1, 4> rotate y*200 translate <0, 9, -30>}
                //stack deck reeling
                sphere{<-3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                sphere{<3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 3, 0> <-3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3, 3, 0> <3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 3, -3.9> <3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 2.5, 0> <-3, 2.5, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3, 2.5, 0> <3, 2.5, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 2.5, -3.9> <3, 2.5, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 2, -3.9> <-3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<3, 2, -3.9> <3, 3, -3.9> 0.02 texture{wholewhitepaint}}
                cylinder{<-3, 2, -2> <-3, 3, -2> 0.02 texture{wholewhitepaint}}
                cylinder{<3, 2, -2> <3, 3, -2> 0.02 texture{wholewhitepaint}}
        }
        object{clamp rotate <0, -10, 0> translate <-2, -1, -4>}
        object{clamp rotate <0, 10, 0> translate <2, -1, -4>}
        object{clamp rotate <0, -20, 0> translate <-1.5, -1, -6>}
        object{clamp rotate <0, 20, 0> translate <1.5, -1, -6>}        
}                                               

#declare Fgranite = function { 
    pigment { granite color_map { [0 rgb 1] [1 rgb 0] }}
} 

#declare isowaves = isosurface {
  function{y - Fgranite(x,0,z).gray - 0.01*Fgranite(100*x, 0, 100*(z+0.1)).gray - 0.001*Fgranite(1000*x, 0, 1000*z).gray - 0.0001*Fgranite(10000*x, 0, 10000*z).gray} 
  threshold 0  
  max_gradient 500 //500
  texture{ 
        pigment{
                agate
                color_map {
                        [0.0, 0.01   color rgb <1.5, 1.5, 1.5>
                                        color rgb <1.5, 1.5, 1.5>]
                        [0.01, 0.05   color rgbf <0.7, 0.7, 0.7, 0.1>
                                        color rgbf <0.1, 0.2, 0.1, 0.1> ]
                        [0.05, 1.0    color rgbf <0.1, 0.2, 0.1, 0.1>
                                        color rgbf <0.0, 0.1, 0.0, 0.1>]
                }
                turbulence 5
                scale 0.05
        
        } 
        finish{reflection 0.1}
  }
}

#declare isospray = isosurface {
  function { f_sphere(x, y, z, 1) - f_noise3d(x, y, z) - 2*f_noise3d(3*x, 3*y, 3*z) - f_noise3d(10*x, 10*y, 10*z) - f_noise3d(100*x, 100*y, 100*z) - f_noise3d(1000*x, 1000*y, 1000*z)} 
  threshold 0  
  max_gradient 50
  contained_by{sphere{<0,0,0> 200}}
  texture{pigment{White} finish{reflection 0.8}}
}

#declare foam = object{ isospray scale<0.3, 0.15, 0.3>} 
#declare bigfoam = union{object{foam scale 2}}


#declare spike = union{
        cylinder{<0, -1, 0> <2, 0, 0> 0.2}
        torus{0.2, 0.02 scale <1.21, 1, 1> rotate z*90 translate <0.8, -0.60, 0>} 
        texture{shitredpaint}
}

#declare lighthouse1 = union{
        cylinder{<0,-10,0><0,0.5,0> 0.8 texture{wetrust}}
        difference{
                cylinder{<0,0.5,0><0,5,0> 0.8 texture{rust}}
                text {
                ttf "arial.ttf", "Henze 2005", 2, 0 
                scale <0.3, 0.6, 0.3>  
                rotate <90, 0, -90>
                translate <1, 2.2, 0>
                texture { rust }
                }
        }
        cylinder{<0,2,0><0,3,0> 0.81 texture{peelredpaint}}
        cylinder{<0,3,0><0,5,0> 0.81 texture{wholeredpaint}}
        object{spike translate <0, 4.5, 0>}
        object{spike rotate y*90 translate <0, 4.5, 0>}
        object{spike rotate y*180 translate <0, 4.5, 0>}
        object{spike rotate y*270 translate <0, 4.5, 0>}
        torus{ 2, 0.2 translate <0, 4.5, 0> texture{shitredpaint}}

        difference{
                sphere{<0, 0, 0>, 0.8}
                cylinder{<0, -1, 0> <0, 0, 0> 1}
                texture{shitredpaint}
                translate <0, 6, 0>
        }
        difference{
                cylinder{<0, 5, 0> <0, 6, 0> 0.7}
                cylinder{<0, 4.5, 0> <0, 6.5, 0> 0.5}
                texture{T_BlindGlass}
        }
        union{
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*0}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*20}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*40}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*60}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*80}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*100}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*120}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*140}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*160}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*180}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*200}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*220}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*240}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*260}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*280}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*300}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*320}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*340}
        texture{wholeredpaint}
        }
        cylinder{<0, 5.9, 0> <0, 6, 0> 0.5 pigment{White}}
        light_source{
              0*x
              color rgb <10, 10, 1>
              translate <0, 5.5, 0>
              looks_like {cylinder{<0, -0.9, 0> <0, 0.9, 0> 0.4 texture{pigment {color rgbt<10,10,1,0.8>}}}}
              fade_power 2
              fade_distance 2
        }        

}
#declare lighthouse2 = union{
        cylinder{<0,-10,0><0,0.5,0> 0.8 texture{wetrust}}
        cylinder{<0,0.5,0><0,5,0> 0.8 texture{rust}}
        cylinder{<0,1,0><0,3,0> 0.81 texture{peelredpaint}}
        cylinder{<0,3,0><0,5,0> 0.81 texture{wholeredpaint}}
        object{spike translate <0, 4.5, 0>}
        object{spike rotate y*90 translate <0, 4.5, 0>}
        object{spike rotate y*180 translate <0, 4.5, 0>}
        object{spike rotate y*270 translate <0, 4.5, 0>}
        torus{ 2, 0.2 translate <0, 4.5, 0> texture{shitredpaint}}

        difference{
                sphere{<0, 0, 0>, 0.8}
                cylinder{<0, -1, 0> <0, 0, 0> 1}
                texture{shitredpaint}
                translate <0, 6, 0>
        }
        difference{
                cylinder{<0, 5, 0> <0, 6, 0> 0.7}
                cylinder{<0, 4.5, 0> <0, 6.5, 0> 0.5}
                texture{T_BlindGlass}
        }
        union{
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*0}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*20}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*40}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*60}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*80}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*100}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*120}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*140}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*160}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*180}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*200}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*220}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*240}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*260}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*280}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*300}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*320}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*340}
        texture{wholeredpaint}
        }
        cylinder{<0, 5.9, 0> <0, 6, 0> 0.5 pigment{White}}
        light_source{
              0*x
              color rgb <10, 10, 1>
              translate <0, 5.5, 0>
              looks_like {cylinder{<0, -0.9, 0> <0, 0.9, 0> 0.4 texture{pigment {color rgbt<10,10,1,0.8>}}}}
              fade_power 2
              fade_distance 2
        }        

}
#declare lighthouse3 = union{
        cylinder{<0,-10,0><0,0.5,0> 0.8 texture{wetrust}}
        cylinder{<0,0.5,0><0,5,0> 0.8 texture{rust}}
        cylinder{<0,2,0><0,3,0> 0.81 texture{peelredpaint}}
        cylinder{<0,3,0><0,5,0> 0.81 texture{wholeredpaint}}
        object{spike translate <0, 4.5, 0>}
        object{spike rotate y*90 translate <0, 4.5, 0>}
        object{spike rotate y*180 translate <0, 4.5, 0>}
        object{spike rotate y*270 translate <0, 4.5, 0>}
        torus{ 2, 0.2 translate <0, 4.5, 0> texture{shitredpaint}}

        difference{
                sphere{<0, 0, 0>, 0.8}
                cylinder{<0, -1, 0> <0, 0, 0> 1}
                texture{shitredpaint}
                translate <0, 6, 0>
        }
        difference{
                cylinder{<0, 5, 0> <0, 6, 0> 0.7}
                cylinder{<0, 4.5, 0> <0, 6.5, 0> 0.5}
                texture{T_BlindGlass}
        }
        union{
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*0}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*20}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*40}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*60}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*80}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*100}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*120}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*140}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*160}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*180}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*200}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*220}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*240}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*260}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*280}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*300}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*320}
        cylinder{<0, 5, 0> <0, 6, 0> 0.05 translate<0.75, 0, 0> rotate y*340}
        texture{wholeredpaint}
        }
        cylinder{<0, 5.9, 0> <0, 6, 0> 0.5 pigment{White}}
}

union{
        julia_fractal { <-0.083,0.0,-0.83,-0.025> quaternion cube  max_iteration 8 precision 60 
                                scale <15, 2.5, 20>
                        texture{pigment {agate turbulence 5
                        color_map {
                          [0.0, 0.8 color rgb<0, 0, 0>
                            color rgb<0.1, 0.1, 0.1> ]
                          [0.8, 1.0 color rgb<0.5, 0.5, 0.5>
                            color rgb<0.6, 0.6, 0.6> ]
                        }
                        scale 1
                        } normal {bumps 2 scale 0.1}
                        }
               rotate z*90 
               scale 10
        }
        //light_source{
        //      0*x
        //      color rgb <10, 10, 1>
        //      translate <0, 121, -7>
        //      looks_like {sphere{<0, 0, 0> 1 texture{pigment {color rgb<10,10,1>}}}}
        //      fade_power 2
        //      fade_distance 40
        //}        
        translate <50, 0, 500>
}
object{bigfoam scale 20 rotate <0, 180, 0> translate<40,-10,500>}
julia_fractal { <-0.2,0.1,-0.80,-0.025> quaternion cube  max_iteration 8 precision 60 
                                scale <15, 2.5, 20>
                        texture{pigment {agate turbulence 5
                        color_map {
                          [0.0, 0.8 color rgb<0, 0, 0>
                            color rgb<0.1, 0.1, 0.1> ]
                          [0.8, 1.0 color rgb<0.5, 0.5, 0.5>
                            color rgb<0.6, 0.6, 0.6> ]
                        }
                        scale 1
                        } normal {bumps 2 scale 0.1}
                        }
               rotate z*90 
               scale 10
               translate <200, 0, 300>
}
object{bigfoam scale 20 rotate <0, 90, 0> translate<180,-15,300>}


object{lighthouse1          //1
        rotate y*130
        translate <5, 0, 15>
}
object{foam rotate <0, 0, 10> translate<4.4,-1.2,15>}

object{lighthouse2              //2
        translate <-15, 0, 55>
}
object{foam rotate <0, 0, 10> translate<-15.6,0.4,55>}
object{lighthouse3
        rotate y*180
        translate <-35, 0, 95>
}

declare floatingstuff = union{
        object{isowaves  scale <1000, 8, 1000> translate<0, -4, 900>}
        object{boat rotate <-5, 40, 5> translate<0, 0, 50>}
        object{bigfoam translate <6, -1.7, 55>}
        object{bigfoam translate <5, -1.7, 52>}
        object{bigfoam translate <-6, -1.7, 45>}
        object{bigfoam translate <-5, -1.7, 48>}
}

object{floatingstuff rotate <0, 0, -10>}
