//  An attractive view
//
//  by Teemu Tommola 2005
//
//  Persistence of Vision Raytracer V3.5
//  World definition file.
//

           



//
// INCLUDE FILES
//

#include "FieldMagnitude2.inc"
#include "FieldDirection2.inc"
#include "math.inc"
#include "rand.inc"

 



//
// GLOBAL SETTINGS
//

global_settings {
  radiosity {}
  adc_bailout .003922
  ambient_light <1,1,1>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <.247059,.176471,.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0,0,0> }





//
// CAMERAS
//

#declare Camera1 = camera {
  location  <-49,223,42.51>
  sky       <0,0,1>
  up        <0,0,1>
  right     <2,0,0>
  angle     35
  look_at   <11,0,4> // 9,0,9
}

#declare Camera2 = camera {
  location  <0,0,500>
  sky       <0,0,1>
  up        <0,0,1>
  right     <2,0,0>
  angle     35
  look_at   <0,0,0>
}





//
// LIGHTS
//

light_source {
  <-35,15,50>
  color rgb <1,.97,.5>*1.3
  media_interaction off
}

light_source {
  <15,10,30>
  color rgb <1,.97,.5>*1.2
  media_interaction off
}

light_source {
  <-210,1070,50>
  color rgb <1,.97,.5>*.05
  media_interaction off
}





//
// TEXTURES AND MATERIALS
//

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

#declare MapImage = texture {      
  pigment {
    image_map {
      sys "diagram3.bmp"
      once
      interpolate 4
    }
  }
  normal { wrinkles .1 }
  finish { ambient 0.1 diffuse .6 specular 0.1 roughness 0.1 }
  scale <2,2,1>
  translate <-1,-1,0>
}

#declare DGray = texture {      
  pigment { color rgb <.644444,.555556,.555556> }      
  normal { wrinkles ,.3 }      
  finish {
    ambient .2
    phong .4
    phong_size 5.0
    roughness .9
    reflection {
      .1, .1
      falloff  1.0
      exponent 1.0
      metallic 2.0
    }
  }
}

#declare Bright_Bronze = texture {      
  pigment { color rgb <.2,.28,.36> }      
  finish {
    ambient .7
    diffuse .65
    brilliance 1.5
    specular .85
    roughness .01
    reflection {
      .2, .2
      falloff  1.0
      exponent 1.0
      metallic 2.0
    }
  }
}

#declare Thin_Glass = texture {      
  pigment { color rgbf <1.0, 1.0, 1.0, .99999> }      
  finish {
    ambient 0
    diffuse 0
    phong 1.0
    specular 1.0
    roughness .001
    reflection {
      .1,.1
      falloff  1.0
      exponent 1.0
      metallic 0
    }
  }
}


#declare WrinkleGray = texture {      
  pigment { color rgb <.45, .4, .4> }      
  normal { wrinkles, .3 }      
  finish {
    ambient .2
    diffuse .7
    phong .5
    phong_size 10.0
    roughness .9
    reflection {
      .05,.05
      falloff  1.0
      exponent 1.0
      metallic 2.0
    }
  }
}

#declare body_texture = texture {      
  pigment { color rgb <.31,.318,.231> }      
  finish {
    ambient .3
    diffuse .5
    phong .7
    phong_size 20.0
  }
}

#declare ChromeTexture2 = texture {      
  pigment { color rgb <0.698, 0.698, 0.698> }      
  finish {
    ambient 0.3
    brilliance 1.004
    phong_size 1.0
    roughness 0.001
    reflection {
      0.3 , 0.3
      falloff  1.0
      exponent 1.0
      metallic 0
    }
  }
}


#declare Mustuainen = texture {      
  pigment { color rgb <0.0, 0.0, 0.0> }      
  finish {
    ambient 0.1
    phong 0.85
    phong_size 25.0
    specular 0.01
    reflection {
      0.2 , 0.2
      falloff  1.0
      exponent 1.0
      metallic 0
    }
  }
}


#declare Valkuainen = material{   
  texture {      
    pigment {
      crackle form <-1.0, 1.0, 0.0>
      color_map {
        [ 0.0     rgbft <1.0, 0.8958, 0.8958, 0.3, 0.0> ]
        [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
      }
      ramp_wave
    }      
    finish {
      ambient 0.1
      phong 0.2
      phong_size 15.0
    }
  }   
  interior {
    fade_distance 1.0
    fade_power 2.0
  }
}


#declare MaaAines = pigment {
  agate
  agate_turb 1.0
  pigment_map {  
    [0.0 color rgb <1.0, 0.9375, 0.0729>*.9]
    [1.0 color rgb <0.864567, 0.666667, 0.1354>*1]
  }
}


#declare MaaAines2 = texture {  
  pigment { MaaAines }
  scale 2
  normal { bumps .2 }
  scale .5
}


#declare MaaAines3 = texture {
  pigment { MaaAines }
  normal {
    gradient y
    frequency 3
    turbulence .5
    normal_map {
      [0.00 granite]
      [0.25 spotted turbulence .35]
      [0.50 marble turbulence .5]
      [0.75 bozo turbulence .25]
      [1.00 granite]
    }
    scale <1.5,1.5,.7>
  }
}


#declare Dull_Bronze = texture {      
  pigment { color rgb <.514286,.4,.285714> }      
  normal { wrinkles ,.1 }      
  finish {
    ambient 0.15
    diffuse 0.65
    specular 0.5
    roughness 0.01
    reflection {
      0.05 , 0.05
      falloff  1.0
      exponent 1.0
      metallic 5.0
    }
  }
}

#declare Red = texture {
  pigment { color rgb <0.8, 0.2, 0.2> }
  finish { ambient 0.2 diffuse 0.5 }
}
  
#declare Black = texture {
  pigment { color rgb 0 }
  finish { ambient 0.2 diffuse 0.5 }
}





//
// MESHES
//

// Iron

#declare Iron = mesh {
  triangle { <-2,0,0>,<3,0,0>,<-1,0,3> }
  triangle { <-2,0,0>,<0,50,0>,<3,0,0> }
  triangle { <-2,0,0>,<0,50,0>,<-1,0,3>}
  triangle { <3,0,0>,<0,50,0>,<-1,0,3> }

  texture {
    pigment { color rgb <.1, .1, .1> }
    normal { bumps 0.1 }
    finish { ambient .1 phong .1 phong_size 40 }
  }  
  
  scale .02
}


// Map

#declare Map = mesh {
  triangle { <0,0,0>,<10,0,0>,<0,20,-1.5> }
  triangle { <10,0,0>,<10,20,-2>,<0,20,-1.5> }
  triangle { <0,20,-1.5>,<10,20,-2>,<0,40,0> }
  triangle { <10,20,-2>,<10,40,0>,<0,40,0> }
  triangle { <10,0,0>,<19,0,4>,<10,20,-2> }
  triangle { <19,0,4>,<19,20,4>,<10,20,-2> }
  triangle { <10,20,-2>,<19,20,4>,<10,40,0> }
  triangle { <19,20,4>,<19,40,4>,<10,40,0> }
  triangle { <28,0,1>,<19,0,4>,<28,20,0> }
  triangle { <19,0,4>,<19,20,4>,<28,20,0> }
  triangle { <28,20,0>,<19,20,4>,<28,40,1> }
  triangle { <19,20,4>,<19,40,4>,<28,40,1> }
  triangle { <28,0,1>,<34,0,9>,<28,20,0> }
  triangle { <34,0,9>,<34,20,9>,<28,20,0> }
  triangle { <28,20,0>,<34,20,9>,<28,40,1> }
  triangle { <34,20,9>,<34,40,9>,<28,40,1> }
  triangle { <42,0,4>,<34,0,9>,<42,20,2.5> }
  triangle { <34,0,9>,<34,20,9>,<42,20,2.5> }
  triangle { <42,20,2.5>,<34,20,9>,<42,40,4> }
  triangle { <34,20,9>,<34,40,9>,<42,40,4> }
  triangle { <42,0,4>,<52,0,4>,<42,20,2.5> }
  triangle { <52,0,4>,<52,20,2>,<42,20,2.5> }
  triangle { <42,20,2.5>,<52,20,2>,<42,40,4> }
  triangle { <52,20,2>,<52,40,4>,<42,40,4> }

  triangle { <0,0,0>,<0,0,-.1>,<10,0,-.1>}
  triangle { <0,0,0>,<10,0,0>,<10,0,-.1>}
  triangle { <10,0,0>,<10,0,-.1>,<19,0,3.9>}
  triangle { <10,0,0>,<19,0,4>,<19,0,3.9>}
  triangle { <19,0,4>,<19,0,3.9>,<28,0,0.9>}
  triangle { <19,0,4>,<28,0,1>,<28,0,0.9>}
  triangle { <28,0,1>,<28,0,0.9>,<34,0,8.9>}
  triangle { <28,0,1>,<34,0,9>,<34,0,8.9>}
  triangle { <34,0,9>,<34,0,8.9>,<42,0,3.9>}
  triangle { <34,0,9>,<42,0,4>,<42,0,3.9>}
  triangle { <42,0,4>,<34,0,3.9>,<52,0,3.9>}
  triangle { <42,0,4>,<52,0,4>,<52,0,3.9>}
  
  triangle { <52,0,4>,<52,0,3.9>,<52,20,1.9>}
  triangle { <52,0,4>,<52,20,2>,<52,20,1.9>}
  triangle { <52,20,2>,<52,20,1.9>,<52,40,3.9>}
  triangle { <52,20,2>,<52,40,4>,<52,40,3.9>}

  triangle { <0,40,0>,<0,40,-.1>,<10,40,-.1>}
  triangle { <0,40,0>,<10,40,0>,<10,40,-.1>}
  triangle { <10,40,0>,<10,40,-.1>,<19,40,3.9>}
  triangle { <10,40,0>,<19,40,4>,<19,40,3.9>}
  triangle { <19,40,4>,<19,40,3.9>,<28,40,0.9>}
  triangle { <19,40,4>,<28,40,1>,<28,40,0.9>}
  triangle { <28,40,1>,<28,40,0.9>,<34,40,8.9>}
  triangle { <28,40,1>,<34,40,9>,<34,40,8.9>}
  triangle { <34,40,9>,<34,40,8.9>,<42,40,3.9>}
  triangle { <34,40,9>,<42,40,4>,<42,40,3.9>}
  triangle { <42,40,4>,<34,40,3.9>,<52,40,3.9>}
  triangle { <42,40,4>,<52,40,4>,<52,40,3.9>}
  
  triangle { <0,40,0>,<0,40,-.1>,<0,20,-1.6>}
  triangle { <0,40,0>,<0,20,-1.5>,<0,20,-1.6>}
  triangle { <0,20,-1.5>,<0,20,-1.6>,<0,0,-.1>}
  triangle { <0,20,-1.5>,<0,0,0>,<0,0,-.1>}
  
  triangle { <0,0,-.1>,<10,0,-.1>,<0,20,-1.6> }
  triangle { <10,0,-.1>,<10,20,-2.1>,<0,20,-1.6> }
  triangle { <0,20,-1.6>,<10,20,-2.1>,<0,40,-.1> }
  triangle { <10,20,-2.1>,<10,40,-.1>,<0,40,-.1> }
  triangle { <10,0,-.1>,<19,0,3.9>,<10,20,-2.1> }
  triangle { <19,0,3.9>,<19,20,3.9>,<10,20,-2.1> }
  triangle { <10,20,-2.1>,<19,20,3.9>,<10,40,-.1> }
  triangle { <19,20,3.9>,<19,40,3.9>,<10,40,-.1> }
  triangle { <28,0,.9>,<19,0,3.9>,<28,20,-.1> }
  triangle { <19,0,3.9>,<19,20,3.9>,<28,20,-.1> }
  triangle { <28,20,-.1>,<19,20,3.9>,<28,40,0.9> }
  triangle { <19,20,3.9>,<19,40,3.9>,<28,40,0.9> }
  triangle { <28,0,0.9>,<34,0,8.9>,<28,20,-.1> }
  triangle { <34,0,8.9>,<34,20,8.9>,<28,20,-.1> }
  triangle { <28,20,-.1>,<34,20,8.9>,<28,40,0.9> }
  triangle { <34,20,8.9>,<34,40,8.9>,<28,40,0.9> }
  triangle { <42,0,3.9>,<34,0,8.9>,<42,20,2.4> }
  triangle { <34,0,8.9>,<34,20,8.9>,<42,20,2.4> }
  triangle { <42,20,2.4>,<34,20,8.9>,<42,40,3.9> }
  triangle { <34,20,8.9>,<34,40,8.9>,<42,40,3.9> }
  triangle { <42,0,3.9>,<52,0,3.9>,<42,20,2.4> }
  triangle { <52,0,3.9>,<52,20,1.9>,<42,20,2.4> }
  triangle { <42,20,2.4>,<52,20,1.9>,<42,40,3.9> }
  triangle { <52,20,1.9>,<52,40,3.9>,<42,40,3.9> }
    
  translate <-26,-20,0>
  
  texture { MapImage scale <20,26,.01> rotate z*90 }
  scale <1.088,1,1>
}





//
// OBJECTS
//

// Compass

#declare CompassBoard = merge {
  difference {
    box { <-30,-45,0>, <30,45,2> }
    box { <-8,-8,1.5>, <8,8,2.5> translate <-15,28,0> }
  }
  difference {
    sphere { 0, 50 }
    box { <-60,-60,-60>, <60,60,49.5> }
    translate <-15,28,-47>
  }
}


#declare CompassNeedle = union {
  box { <-16,-1,0>, <0,1,.5> texture { Red } }
  box { <0,-1,0>, <16,1,.5> }
  box { <-13,-.6,.45>, <-14.8,.6,.55> pigment { color rgb <.8,.9,.8> } }
  cylinder { <0,0,-.01>, <0,0,.6>, 3 }  

  texture { Black }
}


#declare CompassNumbers = array[18] 
  { "0", "20", "40", "60", "80", "100", "120", "140", "160", "180", "200", "220", "240", "260", "280", "300", "320", "340" }  
 
 
#declare CompassDisc = union {
  object { CompassNeedle rotate z*30 translate z*7 }

  difference {
    cylinder { <0,0,0>, <0,0,2>, 29.5 }
    cylinder { <0,0,-1>, <0,0,3>, 20 }
    texture { pigment { color rgb .1 } }
  }

  #declare Index1=0;
  #while (Index1<18)
    
    text {
      ttf "LSANS.ttf" CompassNumbers[Index1] .1, 0
      pigment { color rgb .8 }
      
      scale 3
      #switch (Index1)
        #case (0)
          translate <-.45,25,3.1>
        #break
        #range (1,4)
          translate <-1.35,25,3.1>
        #break
        #else
          translate <-2.25,25,3.1>
      #end
      rotate z*(Index1*-20)
    }
    
  #declare Index1 = Index1 + 1;
  #end
    
  union {
    #declare Index1=0;
    #while (Index1<8)
      box { <-1,-4,2.5>, <1,4,7.5> translate x*20 rotate z*(Index1*45) }
    #declare Index1 = Index1 + 1;
    #end

    texture { pigment { color rgb .1 } }
  }
  cylinder { <0,0,1>, <0,0,8>, 20 }
  box { <-2,18,7.95>, <-1.5,7,8.05> texture { Red } }
  box { <2,18,7.95>, <1.5,7,8.05> texture { Red } }

  rotate z*69
}  


#declare Compass = union {
  object { CompassBoard }
  object { CompassDisc translate <0,-13,2.01> }
  box { <-.5,20,1.95>, <.5,35,2.05> texture { Red } }

  texture {
    pigment { color rgbf <.8,.8,.8,.95> }
    finish { ambient .01 diffuse .3 phong .3 phong_size 50 reflection .15 }
  }
}
      
 
    
// Bar magnet

#declare BarMagnet = union {
  box {
    <-4,-20,-3>, <4,0,3>
    pigment { color rgb <.8,.3,.3> }
  }
  box {
    <-4.01,-.01,-3.01>, <4.01,20,3.01>
    pigment { color rgb <.3,.3,.8> }
  }
  
  texture { finish { ambient .2 diffuse .5 } }
}

   
   
// Cable splines for the solenoid cables

#declare CableSpline1 =
  spline {
    natural_spline
    -.25, vrotate(<-30,0,0>, <0,0,1>)
    0.00, <-25,0,-5>
    0.20, <10,-3,-3>
    0.40, <50,7,-5>
    0.60, <110,12,-5>
    0.80, <140,13,-5>
    1.00, <250,20,-10>
    1.25, <270,20,-30>
  } 
  
#declare CableSpline2 =
  spline {
    natural_spline
    -.25, vrotate(<-20,0,0>, <0,0,99>)
    0.00, vrotate(<-25,0,-5>, <0,0,100>)
    0.20, <15,-25,-4>
    0.40, <50,3,-5>
    0.60, <110,10,-5>
    0.80, <140,11,-5>
    1.00, <250,18,-10>
    1.25, <270,18,-30>
  }


// Solenoid cables for the curved solenoid

#declare SolenoidCable1 = union {
  #declare Parts = 180;
  #declare Index1 = 0;
  #while(Index1<1)
    
    cylinder {
      CableSpline1(Index1), CableSpline1(Index1+(1/Parts)), 1
    }
  #declare Index1 = Index1 + (1/Parts);
  #end

  texture {
    pigment { color rgb <.5,.8,.6> }
    finish { ambient .2 diffuse .5 phong .7 phong_size 10 }
  } 

}

#declare SolenoidCable2 = union {
  #declare Parts = 180;
  #declare Index1 = 0;
  #while(Index1<1)
    
    cylinder {
      CableSpline2(Index1), CableSpline2(Index1+(1/Parts)), 1
    }
  #declare Index1 = Index1 + (1/Parts);
  #end

  texture {
    pigment { color rgb <.5,.8,.6> }
    finish { ambient .2 diffuse .5 phong .7 phong_size 10 }
  } 

}


// Spline for the curved solenoid

#declare SolenoidSpline =
  spline {
    natural_spline
    -.25, vrotate(<-20,0,0>, <0,0,-1>)
    0.00, vrotate(<-25,0,-5>, <0,0,0>)
    0.25, vrotate(<-30,0,0>, <0,0,1>)
    0.50, vrotate(<-25,0,5>, <0,0,2>)
    0.75, vrotate(<-20,0,0>, <0,0,3>)
    1.00, vrotate(<-25,0,-5>, <0,0,4>)
    1.25, vrotate(<-30,0,0>, <0,0,5>)
    1.50, vrotate(<-25,0,5>, <0,0,6>)
  }


// Curved solenoid

#declare CurvedSolenoid = union {
  #declare Index1 = 0;
  #while(Index1<25)
  
    #declare Parts = 180;
    #declare Index2 = 0;
    #while(Index2<1)
                                                  
        cylinder {
          SolenoidSpline(Index2), SolenoidSpline(Index2+(1/Parts)), .9
          rotate z*(Index1*4)
        }
        cylinder {
          SolenoidSpline(Index2+(.5/Parts)), SolenoidSpline(Index2+(1.5/Parts)), .9
          translate y*.001
          rotate z*(Index1*4)
        }

      #declare Index2 = Index2 + (1/Parts);
    #end

    #declare Index1 = Index1 + 1;
  #end
  
  object { SolenoidCable1 }
  object { SolenoidCable2 }

  texture {
    pigment { color rgb <.8, .6, .4> }
    finish { ambient .2 diffuse .3 phong .5 phong_size 10 reflection .1 metallic }
  }
}


         
         
// Iron filings

#declare IronFilings = union {

#declare Index1 = 0;
#while(Index1 <= 199)

   #declare Index2 = 0;
   #while(Index2 <= 139)
     #if ((Index1>49.5)*(Index1<150)*(Index2>19.5)*(Index2<120))
      
      #if (((RRand(0,1,RdmB)*sqrt(pow(Index1-49.5,2)+pow(Index2-19.5,2)))
        /sqrt((Magnitude[int(Index1)-50][int(Index2)-20]))        
        <25)*(sqrt(pow(Index1-99.5,2)+pow(Index2-69.5,2))<40)) 
      
      object { Iron
        rotate <0,0,degrees(Direction[int(Index1)-50][int(Index2)-20])
        +(SRand(RdmA)*5)/(Magnitude[int(Index1)-50][int(Index2)-20])
        >
        translate <Index1/2-50, Index2/2-35, 0>
        translate <RRand(-.25,.25,RdmC), RRand(-.25,.25,RdmD), 0>
      }
      
      #else
        #if ((RRand(0,1,RdmB)*sqrt(pow(Index1-99.5,2)+pow(Index2-69.5,2)))
        /sqrt((Magnitude[int(Index1)-50][int(Index2)-20]))        
        <10)
      
        object { Iron
          rotate <0,0,degrees(Direction[int(Index1)-50][int(Index2)-20])
          +(SRand(RdmA)*5)/(Magnitude[int(Index1)-50][int(Index2)-20])
          >
          translate <Index1/2-50, Index2/2-35, 0>
          translate <RRand(-.25,.25,RdmC), RRand(-.25,.25,RdmD), 0>
        }
        #end
      
      #end
     
     #else
     
        #if (RRand(0,1,RdmC)*sqrt(pow(Index1-99.5,2)+pow(Index2-69.5,2))<1)
      
          object { Iron
            rotate <0,0,(RRand(0,359,RdmD))>
            translate <Index1/2-50, Index2/2-35, 0>    
            translate <RRand(-.25,.25,RdmC), RRand(-.25,.25,RdmD), 0>
          }
          
        #end
        
     #end
     
      #declare Index2 = Index2 + 1;
   #end

   #declare Index1 = Index1 + 1;
#end

}







         


//
// THE ROBOTS (Partly modelled in Moray)
//

#declare Innerglow_Bright = light_source {
  <0.0, 0.0, 0.0>
//  color rgb <1.000, 0.986, 0.757>*1.0000
  color rgb <0.500, 0.500, 1.500>*0.8000
  fade_distance  5.0
  fade_power 1.0
  translate  4.83*z
}

#declare Innerglow_Normal = light_source {
  <0.0, 0.0, 0.0>
//  color rgb <1.000, 0.986, 0.757>*1.0000
//  color rgb <0.500, 0.500, 1.500>*0.4000
  color rgb <1,.97,.5>*0.5000
  fade_distance  5.0
  fade_power 1.0
  translate  4.83*z
}

#declare RoboSpotStick = difference {
  cylinder {
    <0,0,0>, <0,0,1.2>, .2
    texture { DGray }
    translate <0,-.1,0>
  }
  cone {
    <0,0,0>,.1
    <0,0,2>, 1
    rotate x*-90
    translate z*1
  }
  scale .75
  rotate z*180 
  texture { DGray }
}

#declare RoboSpotNormal = union {
  difference {
    cone {
      <0,0,0>, .2
      <0,0,2>, 1
    }
    cone {
      <0,0,.1>, 0
      <0,0,2.1>, .99
    texture { Bright_Bronze }
    }
    texture { DGray }
    
    rotate x*-90
  }
  
  light_source {
    <0,2,0>, color rgb 3 spotlight
    radius 25
    falloff 25
    tightness 10
    point_at <0,40,0>
    fade_distance 10
    fade_power 5.0
    media_interaction on
    looks_like {
      sphere {
        <0,0,0>, .3
        no_shadow
        texture {
          pigment { rgb <1,.97,5> }
          finish { ambient 1 }
        }
      }
    }
  }  
  light_source {
    <0,1,0>, color rgb 4
  media_interaction on
  fade_distance  1.5
  fade_power 25.0
  }

  scale .75
  rotate z*180
}

#declare RoboSpotDim = union {
  difference {
    cone {
      <0,0,0>, .2
      <0,0,2>, 1
    }
    cone {
      <0,0,.1>, 0
      <0,0,2.1>, .99
    texture { Bright_Bronze }
    }
    texture { DGray }
    
    rotate x*-90
  }
  
  light_source {
    <0,2,0>, color rgb .5 spotlight
    radius 74
    falloff 90
    tightness 10
    point_at <0,10,0>
    fade_distance 10
    fade_power 5.0
    media_interaction off
    looks_like {
      sphere {
        <0,0,0>, .3
        no_shadow
        texture {
          pigment { rgb <1,.97,5> }
          finish { ambient 1 }
        }
      }
    }
  }  
  scale .75
  rotate z*180
}

#declare RoboSpotWide = union {
  difference {
    cone {
      <0,0,0>, .2
      <0,0,2>, 1
    }
    cone {
      <0,0,.1>, 0
      <0,0,2.1>, .99
    texture { Bright_Bronze }
    }
    texture { DGray }
    
    rotate x*-90
  }
  
  light_source {
    <0,2,0>, color rgb 3 spotlight
    radius 20
    falloff 30
    tightness 10
    point_at <0,10,0>
    fade_distance 10
    fade_power 5.0
    media_interaction off
    looks_like {
      sphere {
        <0,0,0>, .3
        no_shadow
        texture {
          pigment { rgb <1,.97,5> }
          finish { ambient 1 }
        }
      }
    }
  }  

  scale .75
  rotate z*180
}

#declare RoboSpotGlow = sphere { // media to get some glow in front of the spotlight
  <0,40,0>, 40
  hollow
  pigment { rgbf 1 }
  interior {
    media {
      scattering
      {
         4 ,  rgb <.03,.03,.03>
         extinction .5
      }
      density {
        wood   
        scale .3
        warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
        scale .3
      }
    }
  }
  scale .75
  rotate z*180
}

/*
#declare RoboSpotGlow = cone { // the glow in front of the spotlight
  <0,0,1>, 2
  <0,50,1>, 80
  hollow
  pigment { rgbf 1 }
  interior {
    media {
      scattering
      {
         4 ,  rgb <1,.1,.1>
         extinction 0.0
      }
      density {
        wood   
        scale 3
        warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
        scale 3
      }
    }
  }
  scale .75
  rotate z*180
}
*/

#declare GyroCompassNeedle = union {
  box {
    <-16,-1,0>, <0,1,.5>
    texture { ChromeTexture2 }
  }
  box { <0,-1,0>, <16,1,.5> }
  box {
    <-13,-.6,.45>, <-14.8,.6,.55>
    texture { Black }
  }
  cylinder { <0,0,-.01>, <0,0,.6>, 3 }  

  texture { Black }
}

#declare GyroCompassNumbers = array[18] 
  { "0", "20", "40", "60", "80", "100", "120", "140", "160", "180", "200", "220", "240", "260", "280", "300", "320", "340" }  

#declare GyroCompassDisc = union {
  object { GyroCompassNeedle translate z*2.7 }
  difference {
    cylinder { <0,0,0>, <0,0,2>, 29.5 }
    cylinder { <0,0,-1>, <0,0,3>, 20 }
  texture { Dull_Bronze }    
  }

  #declare Index1=0;
  #while (Index1<18)
    
    text {
      ttf "LSANS.ttf" GyroCompassNumbers[Index1] .1, 0
  texture { Black }
      
      scale 3
      #switch (Index1)
        #case (0)
          translate <-.45,25,1.8>
        #break
        #range (1,4)
          translate <-1.35,25,1.8>
        #break
        #else
          translate <-2.25,25,1.8>
      #end
      rotate z*((Index1*-20)+90)
    }
    
  #declare Index1 = Index1 + 1;
  #end
    
  union {
    #declare Index1=0;
    #while (Index1<8)
      box { <-1,-4,-.15>, <1,4,3.5> translate x*20 rotate z*(Index1*45) }
    #declare Index1 = Index1 + 1;
    #end
    texture { Black }
  }
  
  cylinder { <0,0,-1>, <0,0,3>, 20 }

  texture { Dull_Bronze }
      
  translate z*-4.5
}  
                      

#declare InnerFrame = difference {
  cylinder { <0,0,-1>, <0,0,1>, 31.5 }
  cylinder { <0,0,-2>, <0,0,2>, 30 }
}
#declare MiddleFrame = difference {
  cylinder { <0,0,-1>, <0,0,1>, 33.5 }
  cylinder { <0,0,-2>, <0,0,2>, 32 }
}
#declare OuterFrame = difference {
  cylinder { <0,0,-1>, <0,0,1>, 35.5 }
  cylinder { <0,0,-2>, <0,0,2>, 34 }
}
#declare SpinAxis = cylinder {
  <0,0,-33>, <0,0,33>, .8
}
#declare GyroCompassGlass = difference {
  sphere { <0,0,0>, 35 }
  sphere { <0,0,0>, 34.5 }
  texture {
    pigment { color rgbf <.8,.8,.8,.95> }
    finish { ambient .01 diffuse .3 phong .1 phong_size 30 reflection .1 }
  }
}


#declare GyroCompass = union {
  object { GyroCompassGlass }
  object { OuterFrame }
  union {
    object { MiddleFrame rotate x*90 }
    union {
      object { InnerFrame rotate y*90 }
//      object { SpinAxis }
      object { GyroCompassDisc }
      light_source {
        <0, 0, 10.0>
        color rgb <1,.97,.5>*2
        fade_distance  1.0
        fade_power 10.0
      }
      light_source {
        <0, 0, -10.0>
        color rgb <0.500, 0.500, 1.500>*2
        fade_distance  1.0
        fade_power 10.0
      }
      sphere { // media to get some glow inside the head
        <0,0,0>, 34.49
        hollow
        pigment { rgbf 1 }
        interior {
          media {
            scattering {
              4 ,  rgb <.07,.07,.07>
              extinction .1
            }
            density {
              wood   
              scale .5
              warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
              scale .5
            }
          }
        }
      }
      rotate z*-15
    }
  rotate x*18
  }
  rotate z*50
  texture { Dull_Bronze }
}



// ********  REFERENCED OBJECTS  *******

#declare RoboKansiLevyUlko = intersection {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.51>
    translate  -0.38*y
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.1>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.0, 0.55, -0.59>
  }
  translate  0.0*y
}

#declare RoboKansiLevySisus = intersection {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.51>
    translate  -0.38*y
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.0, 0.55, -0.59>
  }
  scale 0.95
  translate  0.0*y
}

#declare RoboKansiLevy = difference {
  object { RoboKansiLevyUlko }
  object { RoboKansiLevySisus }
}

#declare Rengas = intersection {
  torus { // Torus001
    1.3, 0.7  rotate -x*90
    scale <0.55, 0.55, 0.9>
    rotate -90.0*y
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.4>
    rotate 90.0*y
    translate  -0.7*x
  }
  texture {
    body_texture
  }
}

#declare Poelykapseli = lathe {
  linear_spline
  13  // control points
  <0.0, -1.0>,
  <0.3, -1.0>,
  <0.3, -0.9>,
  <0.8, -0.9>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.8, 0.9>,
  <0.3, 0.9>,
  <0.3, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>
  rotate <90,0,90>
  texture {
    ChromeTexture2
  }
  scale 0.5
  rotate -90.0*y
}

#declare Pyoerae = union {
  object { Rengas }
  object { Poelykapseli }
}

#declare Pyoeraekotelo = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -0.549223, -1.436101>, <-2.000000, -1.763975, -1.497473>, <-1.000000, -1.904912, -1.497473>, <-0.006137, -2.010614, -1.497473>, 
      <-3.015393, -0.516408, -1.430267>, <-2.000000, -0.921325, -0.012274>, <-1.000000, -0.968304, 0.270036>, <0.000000, -1.003538, 0.497112>, 
      <-3.015393, -0.483592, -1.430267>, <-2.000000, -0.078675, -0.012274>, <-1.000000, -0.031696, 0.270036>, <0.000000, 0.003538, 0.497112>, 
      <-3.000000, -0.450777, -1.436101>, <-2.000000, 0.763975, -1.497473>, <-1.000000, 0.904912, -1.497473>, <-0.006137, 1.010614, -1.497473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006137, -2.010614, -1.497473>, <0.987726, -2.116317, -1.497473>, <2.024549, -2.257468, -1.497473>, <2.987726, -0.985075, -1.374729>, 
      <0.000000, -1.003538, 0.497112>, <1.000000, -1.038772, 0.724188>, <2.024549, -1.085823, 0.994224>, <3.085972, -0.661692, -1.276445>, 
      <0.000000, 0.003538, 0.497112>, <1.000000, 0.038772, 0.724188>, <2.024549, 0.085823, 0.994224>, <3.085972, -0.338308, -1.276445>, 
      <-0.006137, 1.010614, -1.497473>, <0.987726, 1.116317, -1.497473>, <2.024549, 1.257468, -1.497473>, <2.987726, -0.014925, -1.374729>
    }
  }
  texture {
    WrinkleGray
  }
  scale <1.2, 0.8, 1.2>
  rotate -90.0*z
  translate  <0.4, 1.2, 1.5>
}

#declare Jousituskotelo = union {
  object { Pyoeraekotelo }
  object { // Takapyoerae -> Pyr
    Pyoerae
    // Takapyoerae does not inherit transformations, so do 
    // inverse transformations of Pyoerae
    // Now write the regular transformations of Takapyoerae
    scale 0.6
    translate  <0.0, 2.5, -0.4>
  }
}

#declare Jalkaterae = union {
  object { Pyoerae }
  object { Jousituskotelo }
  rotate -180.0*z
  translate  0.7*y
}

#declare Saeaeri = merge {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    translate  <0.501, 0.5, 11.0>
  }
  box { // Saeaeriluu
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 4.8>
    translate  <0.0, 0.5, 6.3>
  }
  texture {
    Dull_Bronze
  }
}

#declare Jalka = union {
  object { Jalkaterae }
  object { Saeaeri }
  // All transformations fixed
  translate  <-5.51, 0.0, -11.1>
}

#declare RoboKansiLevyUlko1 = intersection {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.51>
    translate  -0.38*y
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.1>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.0, 0.55, -0.59>
  }
  translate  0.0*y
}

#declare RoboKansiLevySisus1 = intersection {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.51>
    translate  -0.38*y
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.0, 0.55, -0.59>
  }
  scale 0.95
  translate  0.0*y
}

#declare RoboKansiLevy3 = difference {
  object { RoboKansiLevyUlko1 }
  object { RoboKansiLevySisus1 }
}

#declare Rengas1 = intersection {
  torus { // Torus002
    1.3, 0.7  rotate -x*90
    scale <0.55, 0.55, 0.9>
    rotate -90.0*y
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.4>
    rotate 90.0*y
    translate  -0.7*x
  }
  texture {
    body_texture
  }
}

#declare Poelykapseli1 = lathe {
  linear_spline
  13  // control points
  <0.0, -1.0>,
  <0.3, -1.0>,
  <0.3, -0.9>,
  <0.8, -0.9>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.8, 0.9>,
  <0.3, 0.9>,
  <0.3, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>,
  <0.0, 1.0>
  rotate <90,0,90>
  texture {
    ChromeTexture2
  }
  scale 0.5
  rotate -90.0*y
}

#declare Pyoerae1 = union {
  object { Rengas1 }
  object { Poelykapseli1 }
}

#declare Pyoeraekotelo1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -0.549223, -1.436101>, <-2.000000, -1.763975, -1.497473>, <-1.000000, -1.904912, -1.497473>, <-0.006137, -2.010614, -1.497473>, 
      <-3.015393, -0.516408, -1.430267>, <-2.000000, -0.921325, -0.012274>, <-1.000000, -0.968304, 0.270036>, <0.000000, -1.003538, 0.497112>, 
      <-3.015393, -0.483592, -1.430267>, <-2.000000, -0.078675, -0.012274>, <-1.000000, -0.031696, 0.270036>, <0.000000, 0.003538, 0.497112>, 
      <-3.000000, -0.450777, -1.436101>, <-2.000000, 0.763975, -1.497473>, <-1.000000, 0.904912, -1.497473>, <-0.006137, 1.010614, -1.497473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.006137, -2.010614, -1.497473>, <0.987726, -2.116317, -1.497473>, <2.024549, -2.257468, -1.497473>, <2.987726, -0.985075, -1.374729>, 
      <0.000000, -1.003538, 0.497112>, <1.000000, -1.038772, 0.724188>, <2.024549, -1.085823, 0.994224>, <3.085972, -0.661692, -1.276445>, 
      <0.000000, 0.003538, 0.497112>, <1.000000, 0.038772, 0.724188>, <2.024549, 0.085823, 0.994224>, <3.085972, -0.338308, -1.276445>, 
      <-0.006137, 1.010614, -1.497473>, <0.987726, 1.116317, -1.497473>, <2.024549, 1.257468, -1.497473>, <2.987726, -0.014925, -1.374729>
    }
  }
  texture {
    WrinkleGray
  }
  scale <1.2, 0.8, 1.2>
  rotate -90.0*z
  translate  <0.4, 1.2, 1.5>
}

#declare Jousituskotelo1 = union {
  object { Pyoeraekotelo1 }
  object { // Takapyoerae1 -> Pyr1
    Pyoerae1
    // Takapyoerae1 does not inherit transformations, so do 
    // inverse transformations of Pyoerae1
    // Now write the regular transformations of Takapyoerae1
    scale 0.6
    translate  <0.0, 2.5, -0.4>
  }
}

#declare Jalkaterae1 = union {
  object { Pyoerae1 }
  object { Jousituskotelo1 }
  rotate -180.0*z
  translate  0.7*y
}

#declare Saeaeri1 = merge {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    translate  <0.501, 0.5, 11.0>
  }
  box { // Saeaeriluu1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 4.8>
    translate  <0.0, 0.5, 6.3>
  }
  texture {
    Dull_Bronze
  }
}

#declare Jalka3 = union {
  object { Jalkaterae1 }
  object { Saeaeri1 }
  // All transformations fixed
  translate  <-5.51, 0.0, -11.1>
}


// ********  OBJECTS  *******


#declare RoboLaatikkoUlko = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  texture {
    DGray
    // Transform to parent space
  }
}

#declare RoboLaatikkoSisus = intersection {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  scale 0.95
  texture {
    Bright_Bronze
    // Transform to parent space
  }
}

#declare RoboLaatikko = difference {
  object { RoboLaatikkoUlko }
  object { RoboLaatikkoSisus }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.02, 0.45>
    translate  -0.29*y
    texture {
      Bright_Bronze
      // Transform to parent space
    }
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
}

#declare RoboKansiLasi = intersection {
  object { // RoboKansiLevy1 -> RoboKansiLevy
    RoboKansiLevy
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.32, 0.1, 0.36>
    translate  -0.38*y
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
  texture {
    Thin_Glass
    // Transform to parent space
  }
}

#declare RoboKansiKehys = difference {
  object { RoboKansiLevy }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.32, 0.1, 0.36>
    translate  -0.38*y
  }
  texture {
    WrinkleGray
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
}

#declare RoboKansi = union {
  object { RoboKansiLasi }
  object { RoboKansiKehys }
  // Scaling fixed
  // Rot Z limited (-150.0 to   0.0)
  // Translation fixed
}

#declare RoboVartalo = union {
  object { RoboLaatikko }
  object { RoboKansi }
  object { Innerglow_Bright translate <4.5,3,-13>}
  // All transformations fixed
  translate  <-4.5, -2.7, 15.0>
}

#declare VasenJalka = union {
  object { // Jalka1 -> Jalka
    Jalka
    translate  11.02*x
  }
  // Scaling fixed
  // Rot X limited (-90.0 to   30.0)
  // Translation fixed
}

#declare OikeaJalka = union {
  object { Jalka }
  // Scaling fixed
  // Rot X limited (-90.0 to   30.0)
  // Translation fixed
}

#declare Kaula = intersection {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 4.5
    translate  <0.02, 0.0, -3.0>
  }
  texture {
    ChromeTexture2
  }
}

#declare Paeae = union {
  object { Kaula }
  object { GyroCompass scale .1 translate z*4.8}
//  object { VasenSilmae }
//  object { Oikea_Silmae }
  // Scaling fixed
  // Translation fixed
  rotate 20.0*z
  translate  11.51*z
}
#declare Kyynaervarsi = merge {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*y
    translate  0.3*x
  }
  box { // Kyynaerluu
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.5, 4.0>
    translate  -4.0*z
  }
  texture {
    Dull_Bronze
  }
}
#declare Sormet = difference {
  torus { // Torus003
    1.0, 0.2  rotate -x*90
    rotate -90.0*y
    translate  -1.0*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
    translate  -2.0*z
  }
  texture {
    WrinkleGray
  }
  // Scaling fixed
  // Rot X limited (-110.0 to   110.0)
  // Rot Y limited (-75.0 to   75.0)
  // Translation fixed
  rotate <-30.0, 0.0, -0.0>
  translate  -7.5*z
}
#declare Kyynaer = union {
  object { Kyynaervarsi }
  object { Sormet }
//  object { Compass scale .04 rotate <70,180,0> translate <0,-1.1,-10.5> }
  object { Compass scale .04 rotate <-60,0,180> translate <0,-1.5,-10.5> }
  // Scaling fixed
  // Rot X limited (-170.0 to   -10.0)
  // Translation fixed
  rotate -80.164787*x
}
#declare Vasen_kaesi = union {
  object { Kyynaer }
  texture {
    Dull_Bronze
  }
  rotate <0.0, -0.0, -15.0>
  translate  <5.0, -0.9, 6.0>
}
#declare Kyynaervarsi1 = merge {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*y
    translate  0.3*x
  }
  box { // Kyynaerluu1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.5, 4.0>
    translate  -4.0*z
  }
  texture {
    Dull_Bronze
  }
}
#declare Sormet1 = difference {
  torus { // Torus004
    1.0, 0.2  rotate -x*90
    rotate -90.0*y
    translate  -1.0*z
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
    translate  -2.0*z
  }
  texture {
    WrinkleGray
  }
  // Scaling fixed
  // Rot X limited (-110.0 to   110.0)
  // Rot Y limited (-75.0 to   75.0)
  // Translation fixed
  rotate <-40.0, -75.0, -0.0>
  translate  -7.5*z
}
#declare Kyynaer1 = union {
  object { Kyynaervarsi1 }
  object { Sormet1 }
  // Scaling fixed
  // Rot X limited (-170.0 to   -10.0)
  // Translation fixed
  rotate -10.0*x
}
#declare Oikea_kaesi = union {
  object { Kyynaer1 }
  texture {
    Dull_Bronze
  }
  // All transformations fixed
  rotate <0.0, -0.0, -5.0>
  translate  <-5.0, -0.9, 6.0>
}






#declare RoboLaatikkoUlko1 = intersection {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  texture {
    DGray
    // Transform to parent space
  }
}
#declare RoboLaatikkoSisus1 = intersection {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <0.5, 0.0, -0.6>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.2>
    translate  <-0.5, 0.0, -0.61>
  }
  scale 0.95
  texture {
    Bright_Bronze
    // Transform to parent space
  }
}
#declare RoboLaatikko1 = difference {
  object { RoboLaatikkoUlko1 }
  object { RoboLaatikkoSisus1 }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.02, 0.45>
    translate  -0.29*y
    texture {
      Bright_Bronze
      // Transform to parent space
    }
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
}
#declare RoboKansiLasi1 = intersection {
  object { // RoboKansiLevy2 -> RoboKansiLevy3
    RoboKansiLevy3
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.32, 0.1, 0.36>
    translate  -0.38*y
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
  texture {
    Thin_Glass
    // Transform to parent space
  }
}
#declare RoboKansiKehys1 = difference {
  object { RoboKansiLevy3 }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.32, 0.1, 0.36>
    translate  -0.38*y
  }
  texture {
    WrinkleGray
  }
  // All transformations fixed
  scale <10.0, 10.0, 15.0>
  translate  <4.5, 3.0, -11.0>
}
#declare RoboKansi1 = union {
  object { RoboKansiLasi1 }
  object { RoboKansiKehys1 }
  // Scaling fixed
  // Rot Z limited (-150.0 to   0.0)
  // Translation fixed
}
#declare RoboVartalo1 = union {
  object { RoboLaatikko1 }
  object { RoboKansi1 }
  object { Innerglow_Normal translate <4.5,3,-11>}
  // All transformations fixed
  translate  <-4.5, -2.7, 15.0>
}
#declare VasenJalka1 = union {
  object { // Jalka2 -> Jalka3
    Jalka3
    translate  11.02*x
  }
  // Scaling fixed
  // Rot X limited (-90.0 to   30.0)
  // Translation fixed
}
#declare OikeaJalka1 = union {
  object { Jalka3 }
  // Scaling fixed
  // Rot X limited (-90.0 to   30.0)
  // Translation fixed
}
#declare Kaula1 = intersection {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.5>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 4.5
    translate  <0.02, 0.0, -3.0>
  }
  texture {
    ChromeTexture2
  }
}

#declare Paeae1 = union {
  object { Kaula1 }
  object { GyroCompass scale .1 translate z*4.8}
//  object { VasenSilmae1 }
//  object { Oikea_Silmae1 }
  // Scaling fixed
  // Translation fixed
  rotate 20.0*z
  translate  11.51*z
}
#declare Kyynaervarsi2 = merge {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*y
    translate  0.3*x
  }
  box { // Kyynaerluu2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.5, 4.0>
    translate  -4.0*z
  }
  texture {
    Dull_Bronze
  }
}
#declare Sormet2 = difference {
  torus { // Torus005
    1.0, 0.2  rotate -x*90
    rotate -90.0*y
    translate  -1.0*z
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
    translate  -2.0*z
  }
  texture {
    WrinkleGray
  }
  // Scaling fixed
  // Rot X limited (-110.0 to   110.0)
  // Rot Y limited (-75.0 to   75.0)
  // Translation fixed
  rotate <20.0, 75.0, -0.0>
  translate  -7.5*z
}
#declare Kyynaer2 = union {
  object { Kyynaervarsi2 }
  object { Sormet2 }
  // Scaling fixed
  // Rot X limited (-170.0 to   -10.0)
  // Translation fixed
  rotate -75*x
}
#declare Vasen_kaesi1 = union {
  object { Kyynaer2 }
  texture {
    Dull_Bronze
  }
  rotate <0.0, -0.0, 10.0>
  translate  <5.0, -0.9, 6.0>
}
#declare Kyynaervarsi3 = merge {
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*y
    translate  0.3*x
  }
  box { // Kyynaerluu3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.5, 4.0>
    translate  -4.0*z
  }
  texture {
    Dull_Bronze
  }
}
#declare Sormet3 = difference {
  torus { // Torus006
    1.0, 0.2  rotate -x*90
    rotate -90.0*y
    translate  -1.0*z
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.5>
    translate  -2.0*z
  }
  texture {
    WrinkleGray
  }
  // Scaling fixed
  // Rot X limited (-110.0 to   110.0)
  // Rot Y limited (-75.0 to   75.0)
  // Translation fixed
  rotate <-10.0, -75.0, -10.0>
  translate  -7.5*z
}
#declare Kyynaer3 = union {
  object { Kyynaervarsi3 }
  object { Sormet3 }
  // Scaling fixed
  // Rot X limited (-170.0 to   -10.0)
  // Translation fixed
  rotate -80*x
}
#declare Oikea_kaesi1 = union {
  object { Kyynaer3 }
  texture {
    Dull_Bronze
  }
  // All transformations fixed
  rotate <0.0, -0.0, 0.0>
  translate  <-5.0, -0.9, 6.0>
}

#declare KyynaerX = union {
  object { Kyynaervarsi }
  object { Sormet }
  // Scaling fixed
  // Rot X limited (-170.0 to   -10.0)
  // Translation fixed
  rotate -80.164787*x
}

#declare Vasen_kaesiX = union {
  object { KyynaerX }
  texture {
    Dull_Bronze
  }
  rotate <0.0, 0.0, 0.0>
  translate  <5.0, -0.9, 6.0>
}

#declare Robo1 = union {
  object { RoboVartalo1 }
  object { VasenJalka }
  object { OikeaJalka }
  object { Paeae }
  object { Vasen_kaesi }
  object { Oikea_kaesi }
  object { RoboSpotStick translate <4,-3.5,10.5>}
  object { RoboSpotWide rotate <33,0,12> translate <4,-3.5,11.5>}
  translate z*12.2
  scale .2
}

#declare Robo2 = union {
  object { RoboVartalo1 }
  object { VasenJalka1 }
  object { OikeaJalka1 }
  object { Paeae1 }
  object { Vasen_kaesi1 }
  object { Oikea_kaesi1 }
  object { RoboSpotStick translate <-4,-3.5,10.5>}
  object { RoboSpotDim rotate <42,0,30> translate <-4,-3.5,11.5>}

  translate z*12.2
  scale .2
}

#declare Robo3 = union {
  object { RoboVartalo }
  object { VasenJalka }
  object { OikeaJalka }
  object { Paeae }
  object { Vasen_kaesiX }
  object { Oikea_kaesi }
  object { RoboSpotStick translate <4,-3.5,10.5>}
  object { RoboSpotNormal rotate <20,0,-30> translate <-4,-2.5,11.5> }
  object { RoboSpotGlow rotate <20,0,-30> translate <-4,-2.5,11.5> }

  translate z*12.2
  scale .4
}




//
// THE LANDSCAPE
//

#declare Ground = plane {
  z,0
  hollow
  pigment { MaaAines }
}

#declare HillsFar = height_field {
  png "crater2.png"
  smooth
  water_level .5
  hollow
}

#declare HillsNear = height_field {
  png "crater3.png"
  smooth
  water_level .5
  hollow
}

#declare Cloud = sphere {
  <0,0,0>, 1
  hollow
  rotate z*20
  
  material {
    texture {
      pigment { rgbf 1 }
    }
    interior {
      media {
        emission .75
        density {
          wood
          color_map {
            [0.0 rgb <1,.97,.7>*0]
            [0.92 rgb <1,.97,.7>*.01]
            [0.96 rgb <1,.97,.7>*.04]
            [1.0 rgb <1,.97,.7>*.1]
          }
          scale 10
          warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
          scale .1
          warp { turbulence <2,2,2> octaves 3 lambda 1.5 omega 0.3 }
        }
        density {
          spherical
        }
      }
    }
  }
}

#declare Landscape = union {
  object { Ground }
  object { HillsFar rotate x*-90 rotate z*-45 scale <500,500,80> translate <-330,-20,67> texture { MaaAines2 } }
  object { HillsNear rotate x*-90 rotate z*-6 scale <500,500,81> translate <-270,-250,68> texture { MaaAines3 } }
  object { Cloud rotate z*30 scale <200,100,12>*.7 translate <40,-320,15>}
}

    
    


//
// THE OBJECTS
//

#declare Objects = union {
  union { 
    object { IronFilings scale 2 rotate z*90 }
    object { CurvedSolenoid scale .5 rotate z*10 translate <7,11,3> }
    object { BarMagnet scale .5 rotate z*175 translate <-20,-12,0> }
    scale 1.4
    translate <5,-15,0>
  }
  
  union {
    object { Robo1 }
    rotate z*60 translate <-49,207,35>
  }
  
  union {
    object { Robo2 }
    object { Map scale .05 rotate <-5,60,90> translate <0,-1.7,3.4> }  
    rotate z*-45 translate <-44,214,37>
  }
  
  object { Robo3 rotate z*205 translate <-24.5,99,1> }
}



// THE MAIN CONTROLS

camera { Camera1 }
object { Landscape }
object { Objects }