//==============================================================================
// Persistence of Vision Ray Tracer Scene Description File
//------------------------------------------------------------------------------
// File        : 12_Catenoids.pov
// Version     : 3.6
// Description : July-August, 2005 IRTC Entry
// Date        : 08/11/2005
// Author      : Robert W. McGregor
//==============================================================================
    
#version 3.6;
default { pigment { rgb 0.5 } finish { ambient 0 diffuse 0.7 }}

//------------------------------------------------------------------------------
// Globals
//------------------------------------------------------------------------------

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "functions.inc"
#include "rand.inc"

#declare Soft_Shadows = 1;
#declare Use_Radiosity = 5;  // 0=No Radiosity, 1=Load, 2=Save, 3=Quick-n-Dirty, 4=Rad_OutdoorLight, 5=Average of 3 & 4                                                
#declare Rad_Brightness = 1;  
#declare Gamma_Level = 1.75;  
#declare Trace_Level = 5;  
#include "rwm_rad.inc"

#declare R = seed(10);
#declare R1 = seed(R);
     
//------------------------------------------------------------------------------
// Camera & lights
//------------------------------------------------------------------------------

background {rgb 0.5}

camera { 
   location <0, 0, -25>
   look_at   <0, 0.25, 0>
   right     x*image_width/image_height
   angle 30
}                     

#declare Sunlight = White*0.9 + Gold*0.2 + SkyBlue*0.1;

light_source { <50, 50, -25>
   color Sunlight
   #if (Soft_Shadows) 
      area_light <10, 0, 0>, <0, 0, 10>, 8, 8
      adaptive 2
      jitter
      orient
      circular 
   #end
}

//------------------------------------------------------------------------------
// Materials
//------------------------------------------------------------------------------
 
#declare N_Dented1 = normal {
   bumps 
   turbulence 0
   normal_map {
      [0.00 dents 1.5 scale 0.3]
      [0.5 dents 1 scale 0.15]
      [0.55 dents 0.125 scale 0.012]
      [0.6 dents 1.25 scale 0.15]
      [1.0 dents 1 scale 0.5]
   }             
}

#declare N_Dented2 = normal {
   bumps 
   turbulence 0
   normal_map {
      [0.0 dents 0.25 scale 1]
      [0.3 dents 1 scale 0.1]
      [0.35 dents 0.125 scale 0.01]
      [0.75 dents 1.25 scale 0.1]
      [1.0 dents 0.1 scale 1]
   }
   scale 0.75             
}

#declare N_Dented3 = normal {
   bumps 
   turbulence 0
   normal_map {
      [0.0 dents 0.125 scale 0.8]
      [0.3 dents 0.1 scale 0.12]
      [0.4 bumps 0.25 scale 0.1]
      [0.5 dents 0.125 scale 0.01]
      [1.0 dents 0.1 scale 1.2]
   }
   scale 0.5             
}

#declare N_Hammered = normal {    
   agate 
   turbulence 0.2
   normal_map { 
      [0.00 N_Dented1]
      [0.33 N_Dented2]
      [0.66 N_Dented3]
      [1.00 N_Dented2]
   }
}

#declare M_Wall = 
material {
   texture {
      normal { 
         average
         normal_map {
         [1 bumps 0.075 scale 0.75]
         [1 granite 0.235 scale 4]
         [0.5 granite 0.235 scale 1]
         [0.5 granite 0.235  scale 0.3]
         [0.5 granite 0.4 scale 0.1]
         [0.25 granite 0.65 scale 0.01]
         }
         scale 0.5
      }
      pigment {rgb 1.25}
   }
}

#declare M_Catenoid = 
material {
   texture { 
      pigment { 
         wood 
         color_map { 
            [0.0 P_Brass3]
            [0.5 P_Brass4]
            [1.0 P_Brass5]
         }        
         turbulence 0.5
         scale 3
      }
      normal { 
         average 
         normal_map { 
            [1 bumps 0.24 scale <0.21, 0.21, 1>]
            [0.5 dents 0.15 scale 0.1]
         }
         scale 0.125
      }
      finish { specular 0.75 reflection { 0.1, 0.5 } metallic }
      //finish { F_MetalC }
   }
   texture { 
      normal { 
         average 
         normal_map { 
            [1 bumps 0.4 scale <0.1, 0.1, 1>]
            [1 dents 1 scale 0.1]
         }
         scale 0.125
      }
      pigment { 
         bozo 
         color_map { 
            [0.0 rgb 0 transmit 0.5]
            [0.5 rgbt 1]
         }
         scale 5
         warp { turbulence 2 }
         scale 1/5
      }
   }
}

#declare M_Wood = 
material {
   texture { 
      pigment { 
         wood 
         color_map { 
           [ 0.0000 rgb <0.8431, 0.5961, 0.3020>*0.75 ]
           [ 0.1000 rgb <0.8627, 0.6275, 0.3451>*0.75 ]
           [ 0.2000 rgb <0.8980, 0.6784, 0.4196>*0.75 ]
           [ 0.3000 rgb <0.8980, 0.6784, 0.4314>*0.75 ]
           [ 0.4000 rgb <0.8980, 0.6824, 0.4275>*0.75 ]
           [ 0.5000 rgb <0.8941, 0.6902, 0.4314>*0.75 ]
           [ 0.5500 rgb <0.6500, 0.4000, 0.2000>*0.75 ]
           [ 0.6000 rgb <0.9059, 0.7059, 0.4471>*0.75 ]
           [ 0.7000 rgb <0.8941, 0.7059, 0.4627>*0.75 ]
           [ 0.8000 rgb <0.9059, 0.7294, 0.4941>*0.75 ]
           [ 0.9000 rgb <0.8980, 0.7059, 0.4706>*0.75 ]
           [ 1.0000 rgb <0.9098, 0.7294, 0.4980>*0.75 ]
         }
         turbulence 0.5
         scale <1,1,20>
      }
      finish { 
         diffuse 0.95
         brilliance 1.2
         specular 0.2
         roughness 0.2
      }
   }
   texture { 
      normal { 
         average 
         normal_map { 
            [1 bumps 0.4 scale <0.1, 0.1, 1>]
            [1 dents 1 scale 0.1]
         }
         scale 0.125
      }
      pigment { 
         bozo 
         color_map { 
            [0.0 rgb 0 transmit 0.75]
            [0.5 rgbt 1]
         }
         warp { turbulence 2 }
         //rotate z*90
         scale 1/10           
      }
   }
}

#declare M_Nail = material {
   texture { 
      pigment { P_Chrome1 }
      normal { N_Hammered scale 0.2 } 
      finish { F_MetalD } 
   }
}
       
//------------------------------------------------------------------------------
// Catenoid Minimal Surface
/*
   x = c cosh(v/c) cos(u)
   y = c cosh(v/c) sin(u)
   z = v
   
   0 <= u <= 2pi
   -1 <= v <= 1
*/
//------------------------------------------------------------------------------

#include "param.inc"

#macro Catenoid()
   #local c = 1.0;
   #local fx = function(u,v) { c*cosh(v/c)*cos(u) }
   #local fy = function(u,v) { c*cosh(v/c)*sin(u) }
   #local fz = function(u,v) { v }
   Parametric ( 
      fx, fy, fz
      <0, -1>, <2*pi, 1>, 
      100, 100, 
      "Catenoid.inc"
   ) 
#end

//------------------------------------------------------------------------------
//  Wall
//------------------------------------------------------------------------------ 

#declare Wall = plane {z, 0.125 material {M_Wall scale 20} translate <-3, -2, 0>}

//------------------------------------------------------------------------------
//  Wood Plank
//------------------------------------------------------------------------------ 

#declare Plank=
isosurface  { 
   function { pow(x, 10)+pow(y*5, 10)-(1-f_noise3d(x*20,y*10,z)*0.6) }
   contained_by { box { -<1,1/5,50>, <1,1/5,50> } }
   max_gradient 50
   material {M_Wood}
}
 
//------------------------------------------------------------------------------
//  Nail
//------------------------------------------------------------------------------ 

#declare Nail = 
union {
   cylinder { -3*x, 3*x, 0.1 } 
   superellipsoid { <0.5, 1.0>
      scale x*0.2
      scale 0.5
      pigment { P_Chrome4 }
      normal {
         average
         normal_map {
            [2 N_Hammered scale 0.2]
            [1 ripples 3 scale 0.03 rotate -x*rand(R1) rotate z*360*rand(R1)]
            [0.5 ripples 3 scale 0.025 rotate -x*rand(R1) rotate z*360*rand(R1)]
         }
      }
      finish {specular 0.8 metallic}
      translate x*3
   }
   rotate y*90
}

//------------------------------------------------------------------------------ 
//  Twine
//------------------------------------------------------------------------------ 

#include "spline_macros.inc"

#local MySpline = 
array[5] {
   <0, 0.75, 0>, 
   <0, 0.375*5, 0>, 
   <0, 0, 0>, 
   <0, -0.375*5, 0>, 
   <0, -0.75*5, 0>
}
#declare ObjectSpline = create_spline (MySpline, create_cubic_spline + spline_sampling (on))
create_spline_object (ObjectSpline, spline_steps (200*5))

#declare S = 
object { blob_spline (ObjectSpline, spline_radius (<0.01, 0.04>)
   + blob_stretch_factor (4)
   + spline_total_twist (20*360))
}

#declare Twine = union {
   union { S pigment {rgb 1}}
   union { S rotate y*120 pigment {rgb 0.9}}
   union { S rotate y*240 pigment {rgb 0.95}}
   normal {N_Hammered scale 0.2}
   scale 1.25
}

//------------------------------------------------------------------------------
//  Macro: CutTwine()
//------------------------------------------------------------------------------ 
    
#macro CutTwine(i)
   #local scaleXZ = 0.675;
   union {
   #switch (i)
      #case (1)
         #local Box = box {-2.5, 2.5}
         difference { object { Twine } object { Box translate y*1} scale 1.5 scale <scaleXZ, 1, scaleXZ>}
         #break
      #case (2)
         #local Box = box {-2.5, 2.5}
         difference { object { Twine } object { Box translate y*2} scale 1.5 scale <scaleXZ, 1, scaleXZ>}
         #break
      #case (3)
         #local Box = box {-2.5, 2.5}
         difference { object { Twine } object { Box translate y*3} scale 1.5 scale <scaleXZ, 1, scaleXZ>}
         #break
      #case (4)
         #local Box = box {-2.5, 2.5}
         difference { object { Twine } object { Box translate y*4} scale 1.5 scale <scaleXZ, 1, scaleXZ>}
         #break
      #case (5)
         object { Twine scale 1.5 scale <scaleXZ, 1, scaleXZ>}
         #break
   #end
   }
#end
  
//------------------------------------------------------------------------------
//  Assemble the Scene
//------------------------------------------------------------------------------ 

object { Nail scale 0.15 translate <-5, 4, 0.2+RRand(0, 0.07, R)>}
object { Nail scale 0.15 translate <-2.5, 4, 0.2+RRand(0, 0.07, R)>}
object { Nail scale 0.15 translate <0, 4, 0.2+RRand(0, 0.07, R)>}
object { Nail scale 0.15 translate <2.5, 4, 0.2+RRand(0, 0.07, R)>}
object { Nail scale 0.15 translate <5, 4, 0.2+RRand(0, 0.07, R)>}

#local DistZ = array[5];
#local DistZ[0] = -0.1-RRand(0, 0.05, R);
#local DistZ[1] = -0.1-RRand(0, 0.05, R);
#local DistZ[2] = -0.1-RRand(0, 0.05, R);
#local DistZ[3] = -0.1-RRand(0, 0.05, R);
#local DistZ[4] = -0.1-RRand(0, 0.05, R);

object {CutTwine(1) translate <-5, 6.3, DistZ[0]> }
object {CutTwine(1) rotate y*360*rand(R1) translate <-2.5, 6.25, DistZ[1]> }
object {CutTwine(2) rotate y*360*rand(R1) translate <0, 4.8, DistZ[2]> }
object {CutTwine(3) rotate y*360*rand(R1) translate <2.5, 3.3, DistZ[3]> }
object {CutTwine(5) rotate y*360*rand(R1) translate <5, 0.5, DistZ[4]> }

object { Catenoid() material {M_Catenoid scale 0.4} rotate y*rand(R)*360 scale 0.2 translate <-5, 3.125, DistZ[0]>}  
                                                                    
object { Catenoid() material {M_Catenoid scale 0.31} rotate y*rand(R)*360 scale 0.2 translate <-2.5, 3, DistZ[1]>}
                                                                    
object { Catenoid() material {M_Catenoid scale 0.35} rotate y*rand(R)*360 scale 0.2 translate <0, 3, DistZ[2]>}
object { Catenoid() material {M_Catenoid scale 0.36} rotate y*rand(R)*360 scale 0.2 translate <0, 1.75, DistZ[2]>} 
                                                                    
object { Catenoid() material {M_Catenoid scale 0.38} rotate y*rand(R)*360 scale 0.2 translate <2.5, 3, DistZ[3]>}
object { Catenoid() material {M_Catenoid scale 0.32} rotate y*rand(R)*360 scale 0.2 translate <2.5, 1.75, DistZ[3]>}
object { Catenoid() material {M_Catenoid scale 0.33} rotate y*rand(R)*360 scale 0.2 translate <2.5, 0.25, DistZ[3]>}
                                                                    
object { Catenoid() material {M_Catenoid scale 0.37} rotate y*rand(R)*360 scale 0.2 translate <5, 2.8, DistZ[4]>}
object { Catenoid() material {M_Catenoid scale 0.34} rotate y*rand(R)*360 scale 0.2 translate <5, 1.25, DistZ[4]>}
object { Catenoid() material {M_Catenoid scale 0.38} rotate y*rand(R)*360 scale 0.2 translate <5, 0.125, DistZ[4]>}
object { Catenoid() material {M_Catenoid scale 0.32} rotate y*rand(R)*360 scale 0.2 translate <5, -1.25, DistZ[4]>}
object { Catenoid() material {M_Catenoid scale 0.33} rotate y*rand(R)*360 scale 0.2 translate <5, -2.6, DistZ[4]>}

object { Wall translate z*0.1}
object { Plank rotate y*90 rotate x*90 scale <0.35, 0.4, 0.4> translate y*4}


