//------------------------------------------------------------------------------
// Radiosity Save/Load include file
//
// Declare variables Use_Radiosity, Rad_File, Trace_Level, and Gamma_Level before 
// including this file:
//
// #declare Use_Radiosity = 1;  // 0=No Radiosity, 1=Load, 2=Save                                                
// #declare Rad_File = "MyScene.rad";
// #declare Trace_Level = 10;
// #declare Gamma_Level = 1.5;
//------------------------------------------------------------------------------

global_settings { 

#ifndef (Trace_Level)
   max_trace_level 5
#else
   max_trace_level Trace_Level
#end  
 
#ifndef (Gamma_Level)
   assumed_gamma 1.0
#else
   assumed_gamma Gamma_Level
#end   
 
#if (Use_Radiosity)
radiosity{ 
   normal on
   #ifndef (Rad_Brightness)
      brightness 1.0
   #else
      brightness Rad_Brightness 
   #end
   
   #ifndef (Rad_File)
      #declare Rad_File = "";
   #end
   
   #ifndef (Rad_Bounce)
      recursion_limit 1
   #else
      recursion_limit Rad_Bounce
   #end 
   
   // save settings: modified Outdoor settings from rad_def.inc
   #switch (Use_Radiosity)
      #case (1)  // load settings  
         pretrace_start 1 pretrace_end 1 
         load_file Rad_File 
         error_bound 0.1    // it's important to specify the same value used to save data
         always_sample off  // no more samples: specially useful with focal blur 
         #break
         
      #case (2) 
         pretrace_start 0.08
         pretrace_end   0.01
         count 250
         nearest_count 10
         error_bound 0.1
         low_error_factor 0.9
         gray_threshold 0
         minimum_reuse 0.015
         adc_bailout 0.01/2
         save_file Rad_File
         #break
      
      #case (3)
         /* Quick-n-Dirty */ 
         #break
         
      #case (4) // High quality
         pretrace_start 0.08
         pretrace_end   0.01
         count 250
         nearest_count 5
         error_bound 0.25
         low_error_factor 0.75
         gray_threshold 0
         minimum_reuse 0.015
         adc_bailout 0.01/2
         #break

      #case (5) // Medium quality
         pretrace_start 0.08
         pretrace_end   0.025
         count 142
         nearest_count 5
         error_bound 1.025
         low_error_factor 0.6
         gray_threshold 0
         minimum_reuse 0.015
         adc_bailout 0.01
         #break
   #end
   }
#end
}
