//======================================
// Dans le cadre d'une image
//     "minimaliste"
// Le minimalisme POVien :
// une sphre sur un sol rflchissant !
//
// topic IRTC Aot 2005
//
// Helen - Juillet/Aot 2005
//=======================================


#include "colors.inc"
#include "couleurs.inc"
#include "textures.inc"
#include "functions.inc"

global_settings
{ 
	ambient_light 1.5 
}

// --- Est-ce utile ???

global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end 0.04
    count 35
    
    nearest_count 5
    error_bound 1.8
    recursion_limit 3
    low_error_factor 0.5
    gray_threshold 0.0
    minimum_reuse 0.015
    brightness 0.55//0.5
    
    adc_bailout 0.01/2
  }
}


camera	// plus prs
{
        location <0,8,-20>
        look_at <0,0,0> 
	angle 40   
}

light_source
{
        <-500,500,-500> Gold*1.5  
	
}

//*********************************************************
// Le sol, qui est une texture
// pas facile  modifier
// si ce n'est au niveau de la reflection
//*********************************************************

// Hex_Tiles_Ptrn() authors: Ron Parker and Juha Nieminen
#macro Hex_Tiles_Ptrn()
    #local G =
    pigment {gradient x
        color_map {[0 rgb 1][1 rgb 0]}
        scale sqrt(3)/2+0.01//.001
    }
    #local B =
    pigment {radial
        pigment_map {
            #local I = 0;
            #while(I<6)
                [I/6 G rotate(30+60*I)*y]
                [(I+1)/6 G rotate(30+60*I)*y]
                #local I = I + 1;
            #end
        }
    }
    pigment_pattern {
        #local T2 = sqrt(3)/2;
        radial
        pigment_map {
            [0   B translate < 0.5,0,-T2>]
            [1/3 B translate < 0.5,0,-T2>]
            [1/3 B translate <-1.0,0,  0>]
            [2/3 B translate <-1.0,0,  0>]
            [2/3 B translate < 0.5,0, T2>]
            [1   B translate < 0.5,0, T2>]
        }
        translate x
        warp {repeat 1.5*x flip x}
        warp {repeat.5*sqrt(3)*z flip z}
    }
#end

// donc, le sol...

plane 
{
      	<0, 1, 0>, 0
  pigment {Hex_Tiles_Ptrn()}
  finish {reflection 0.5}
}

//*********************
// Boule  facette
// une isosurface
//*********************

#declare P=pigment{
  crackle
  metric 0
  solid
  color_map { [0 rgb <1,0.65,0>] [1 rgb <0.7,0.13,0.13>] }//1-0
  scale 0.1
}

#declare F1 = function{pigment {P}}
isosurface {
        function {  x*x + y*y +z*z -1 +F1(x,y,z).red*0.2 }
        max_gradient 25
        accuracy 0.01
        contained_by{sphere {0,1}}
        pigment {P}
        finish {Phong_Glossy}
        finish {ambient 0.3}
		scale 2 
		translate <0,2,-2>
}

//=======================================
// END OF FILE
// Plus minimaliste, tu meurs ?
//=======================================
