
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : Checkers.pov
 Version     : 3.6 / MegaPOV 1.0
 Description : Infinity box, first built in 2001
               
 Date        : June 2005
 Author      : Thomas A. M. de Groot
 E-mail      : t.degroot@inter.nl.net
 
 Copyright (C) 2005. All rights reserved. Free for non-commercial uses
**********************************************************************************/

#include "rad_def.inc"

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

background { color rgb <0.1, 0.3, 0.8> }


global_settings {
  assumed_gamma 1.0
  ambient_light 0
  max_trace_level 100 // increase for increasing the depth of the infinity box (best >100)
  radiosity {Rad_Settings (Radiosity_OutdoorLight, on, off)}
}


camera {
  location  <0.0, 40.0, -40.0>
  look_at   <-4.0, 5.0,  0.0>
  right     x*image_width/image_height
}

#declare InnerLight_01 =
 light_source {
  <0.7, 0.8, -0.65>
  color rgb <1.0, 1.0, 0.0> // yellow
  fade_distance  5.0
  fade_power 1.0
  scale 1
 }

#declare InnerLight_02 =
 light_source {
  <-0.75, -0.65, 0.85>
  color rgb <1.0, 0.0, 0.0> // red
  fade_distance  50.0
  fade_power 1.0
  scale 1
 }

// include here the object you want reflected:
#include "checkered_uvmeshsphere.inc"


//
// ********  TEXTURES  *******
//

// for the outside texture of the box, use:
#declare Glass_1 = 
      texture {      
         pigment {
            color rgbft <1.0, 1.0, 1.0, 1.0, 1.0>
         }      
         finish {
            ambient 0.8
            diffuse 0.0
            phong 0.3
            phong_size 90.0
            reflection 0.0
         }
      }

// for the interior_texture of the box, use this...
#declare Chrome_Metal_3 = 
      texture {      
         pigment {
            color rgb <0.0, 0.0, 0.0>
         }      
         finish {
            ambient 0.01
            diffuse 0.0
            brilliance 20.0
            phong 1.0
            phong_size 90.0
            specular 1.0
            roughness 0.0004
            reflection 1
         }
      }

// ... or this
#declare ReflectiveCheckersTex = 
      texture {
         checker
            texture {            
               pigment {
                  color rgb <0.66, 0.66, 0.66>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  reflection {
                     0.5 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
            texture {            
               pigment {
                  color rgb <0.33, 0.33, 0.33>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  reflection {
                     0.9 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
         scale  0.3
         rotate    <-10.0, -10.0, -10.0>
      }

// texture of the frame:
#declare TdG_RustedMetal2 = 
   material  
   {   
      texture
      {
         bozo
         texture_map
         {
            [0.0   
               pigment
               {
                  color rgb <0.71, 0.65, 0.26>
               }               
               finish
               {
                  ambient 0.2
                  diffuse 0.7
                  brilliance 6.0
                  phong 0.75
                  phong_size 80.0
                  reflection 0.25
               }
            ]
            [0.39  
               pigment
               {
                  color rgb <0.71, 0.65, 0.26>
               }               
               finish
               {
                  ambient 0.2
                  diffuse 0.7
                  brilliance 6.0
                  phong 0.75
                  phong_size 80.0
                  reflection 0.25
               }
            ]
            [0.4   
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]
                     [ 0.4     rgbft <0.7, 0.13, 0.0, 0.0, 0.0> ]
                     [ 0.5     rgbft <0.69, 0.41, 0.08, 0.0, 0.0> ]
                     [ 0.6     rgbft <0.49, 0.31, 0.28, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]
                  }
               }               
               finish
               {
                  ambient 0.2
                  diffuse 0.4
               }
            ]
            [1.0   
               pigment
               {
                  granite
                  color_map
                  {
                     [ 0.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]
                     [ 0.4     rgbft <0.7, 0.13, 0.0, 0.0, 0.0> ]
                     [ 0.5     rgbft <0.69, 0.41, 0.08, 0.0, 0.0> ]
                     [ 0.6     rgbft <0.49, 0.31, 0.28, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]
                  }
               }               
               finish
               {
                  ambient 0.2
                  diffuse 0.4
               }
            ]

         }
         warp
         {
            turbulence <3.0, 2.0, 1.0>

         }
      }
      scale 0.2
   }

//
// ********  OBJECTS  *******
//

// a frame around the cubes:
#declare Frame =
union {
 cylinder {
  -1*z,  1*z,  0.01
  material { TdG_RustedMetal2 }
  translate <-1,-1,0>
 }

 cylinder {
  -1*z,  1*z,  0.01
  material { TdG_RustedMetal2 }
  translate <1,-1,0>
 }

 cylinder {
  -1*z,  1*z,  0.01
  material { TdG_RustedMetal2 }
  translate <-1,1,0>
 }

 cylinder {
  -1*z,  1*z,  0.01
  material { TdG_RustedMetal2 }
  translate <1,1,0>
 }

 cylinder {
  -1*x,  1*x,  0.01
  material { TdG_RustedMetal2 }
  translate <0,-1,-1>
 }

 cylinder {
  -1*x,  1*x,  0.01
  material { TdG_RustedMetal2 }
  translate <0,-1,1>
 }

 cylinder {
  -1*x,  1*x,  0.01
  material { TdG_RustedMetal2 }
  translate <0,1,-1>
 }

 cylinder {
  -1*x,  1*x,  0.01
  material { TdG_RustedMetal2 }
  translate <0,1,1>
 }

 cylinder {
  -1*y,  1*y,  0.01
  material { TdG_RustedMetal2 }
  translate <-1,0,-1>
 }

 cylinder {
  -1*y,  1*y,  0.01
  material { TdG_RustedMetal2 }
  translate <-1,0,1>
 }

 cylinder {
  -1*y,  1*y,  0.01
  material { TdG_RustedMetal2 }
  translate <1,0,-1>
 }

 cylinder {
  -1*y,  1*y,  0.01
  material { TdG_RustedMetal2 }
  translate <1,0,1>
 }
}

// The inner Infinity Box:
#declare InfinityBox_01 =
union {
 box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  texture { Glass_1 }
  interior_texture { ReflectiveCheckersTex }
  //interior_texture { Chrome_Metal_3 }
  //interior { ior 1.5 }
  hollow
  scale <1.0, 1.0, 1.0>
 }

 //object {Frame}

 object {CheckeredSphere
   scale 0.3
   rotate <3, 5, 10>
   translate <-0.2, -0.1, 0.0>
   no_shadow
 }
 
 object {InnerLight_01}
}

// The outer Infinity Box:
#declare InfinityBox_02 =
union {
 box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  texture { Glass_1 }
  interior_texture { ReflectiveCheckersTex }
  //interior_texture { Chrome_Metal_3 }
  //interior { ior 1.5 }
  hollow
  scale <1.0, 1.0, 1.0>
 }

 //object {Frame}
 
 object {InnerLight_02}
}


// now make them visible:
object {InfinityBox_01
   scale 10
   rotate <-9, 25, 5>
   translate <0, 0, 0>
   no_shadow
}

object {InfinityBox_02
   scale 50
   rotate <9, -25, -5>
   translate <0, 0, 0>
}

