#declare s=seed(35) ;
#include "shapes.inc"

// ---------------- //
// --- Textures --- //
// ---------------- //

#declare P_WoodGrain12A =
pigment {
    bozo
    turbulence 0.04
    lambda 2.5
    omega 0.1
    octaves 7
    scale <0.5, 0.05, 0.05>
}
#declare P_WoodGrain12B =
pigment {
    wood
    turbulence <0.1, 0.04, 1>
    scale <0.15, 0.5, 1>
    rotate x*2
}
#declare coefNA=2.1 ;
#declare CNA1=rgb <0.21, 0.11, 0.08>*coefNA ;
#declare CNA2=rgb <0.22, 0.12, 0.09>*coefNA ;
#declare CNA3=rgb <0.23, 0.13, 0.09>*coefNA ;
#declare CNA4=rgb <0.23, 0.12, 0.10>*coefNA ;
#declare M_Wood12A = 
color_map {
    [0.000, 0.256 color CNA1 
                  color CNA2]
    [0.256, 0.393 color CNA2
                  color CNA3]
    [0.393, 0.581 color CNA3
                  color CNA1]
    [0.581, 0.726 color CNA1
                  color CNA4]
    [0.726, 0.983 color CNA4
                  color CNA2]
    [0.983, 1.000 color CNA2
                  color CNA1]
}
#declare coefNB=.4;
#declare transN=.7 ;
#declare CNB1t=rgbt <0.545*coefNB, 0.349*coefNB, 0.247*coefNB, 1.000> ;
#declare CNB1=rgbt <0.545*coefNB, 0.349*coefNB, 0.247*coefNB, transN> ;
#declare CNB2t=rgbt <0.450*coefNB, 0.350*coefNB, 0.320*coefNB, 1.000> ;
#declare CNB2=rgbt <0.450*coefNB, 0.350*coefNB, 0.320*coefNB, transN> ;
#declare M_Wood12B = 
color_map {
    [0.000, 0.139 color CNB1t
                  color CNB2]
    [0.139, 0.148 color CNB2
                  color CNB2]
    [0.148, 0.287 color CNB2
                  color CNB1t]
    [0.287, 0.443 color CNB1t
                  color CNB1t]
    [0.443, 0.626 color CNB1t
                  color CNB2]
    [0.626, 0.635 color CNB2
                  color CNB2]
    [0.635, 0.843 color CNB2
                  color CNB1t]
    [0.843, 1.000 color CNB1t
                  color CNB1t]
}
#declare T_Plateau_noir = 
    texture {
      pigment{ P_WoodGrain12A color_map { M_Wood12A }}
      finish {ambient .3 diffuse .7}
      rotate 90*y
    } 
    texture {
      pigment{ P_WoodGrain12B color_map { M_Wood12B }}
      finish {ambient .3 diffuse .7}
      rotate 90*y  
    }


#declare T_Pion_noir = texture {
  pigment {
    wood    
    turbulence <0.1, 0.04, 1>
    scale <0.1, 0.2, 1>
    rotate x*4
    rotate y*rand(s)*360
    color_map {
      [.00 rgb <.12,.10,.08>]
      [.20 rgb <.16,.14,.12>]
      [1.0 rgb <.16,.15,.14>]
    }
  }
  finish {ambient .3 diffuse .7}
}

#declare M_Wood19A =
color_map {
    [0.00 color rgb <0.85, 0.82, 0.75>]
    [0.40 color rgb <.95, 0.93, 0.8> ]
    [0.60 color rgb <.95, 0.93, 0.8> ]
    [1.00 color rgb <0.85, 0.84, 0.75>]
}
#declare P_WoodGrain19A =
pigment {
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.065
    omega 0.45
    lambda 2.3
    color_map { M_Wood19A }
    rotate x*4
}

#declare T_Plateau_blanc =
    texture {
      pigment{ P_WoodGrain19A color_map { M_Wood19A }}
      finish {ambient .3 diffuse .7}  
      translate <2,0,2>
  }
#declare T_Pion_blanc = texture {
  pigment {
    wood    
    turbulence <0.1, 0.04, 1>
    scale <0.1, 0.2, 1>
    rotate x*4
    rotate y*rand(s)*360
    color_map {
      [.00 rgb <.91,.89,.84>]
      [.40 rgb <.92,.90,.86>]
      [1.0 rgb <.93,.91,.87>]
    }
  }
  finish {ambient .3 diffuse .7}
}

// ----------------- //
// --- Gomtrie --- //
// ----------------- //
#declare ep_plat=.25 ;
#declare ra_pion=.35 ;
#declare ep_pion=.24 ;
#declare er_pion=.012 ;
#declare la_marg=.6 ;
#declare es_plat=.003 ;

#declare Pion = Round_Cylinder(
  <0,ep_plat,0>,<0,ep_plat+ep_pion,0>,ra_pion,er_pion,no)
#declare Pion_blanc = object {
  Pion
  texture {T_Pion_blanc}
}
#declare Pion_noir = object {
  Pion
  texture {T_Pion_noir}
}

#declare Bord = intersection {
    box {<-la_marg,0,-la_marg> <4+la_marg,ep_plat,0>}
    plane {-x 0 rotate 45*y}
    plane {x 0 rotate -45*y translate 4*x}

  texture {T_Plateau_noir translate <rand(s),rand(s),rand(s)>*10}
}
#declare Plateau = union {
  object {Bord translate <0,es_plat/10,-rand(s)*es_plat>}
  object {Bord translate -rand(s)*es_plat*z 
    translate <-2,0,-2> rotate 90*y translate <2,es_plat/10,2>}
  object {Bord translate -rand(s)*es_plat*z 
    translate <-2,0,-2> rotate 180*y translate <2,es_plat/10,2>}
  object {Bord translate -rand(s)*es_plat*z 
    translate <-2,0,-2> rotate 270*y translate <2,es_plat/10,2>}
  box {<-es_plat,0,-es_plat> <4+es_plat,ep_plat/2,4+es_plat>
    texture {T_Plateau_noir}} 
  #declare idp=0 ;
  #declare jdp=0 ;
  #declare could=0 ;
  #while(jdp<4)#while(idp<4)
    box {
      <idp+es_plat,ep_plat/2,jdp+es_plat> 
      <idp+1-es_plat,ep_plat,jdp+1-es_plat> 
      
      texture {
        #if(could=0)T_Plateau_noir rotate 90*y#else T_Plateau_blanc#end
        translate <rand(s),rand(s),rand(s)>*1
      }
      translate <rand(s),rand(s),rand(s)>*es_plat
    }
    #declare idp=idp+1 ;
    #declare could=1-could ;
  #end
    #declare jdp=jdp+1 ;
    #declare idp=0 ;
    #declare could=1-could;
  #end
}

// ------------- //
// --- Scne --- //
// ------------- //

#declare Dames = union {
object {Plateau}
object {Pion_blanc 
  translate <.5,0,.5>+<rand(s),rand(s),rand(s)>*er_pion}
object {Pion_blanc 
  translate <2.5,0,.5>+<rand(s),rand(s),rand(s)>*er_pion}
object {Pion_noir 
  translate <1.5,0,3.5>+<rand(s),rand(s),rand(s)>*er_pion}
object {Pion_noir 
  translate <3.5,0,3.5>+<rand(s),rand(s),rand(s)>*er_pion}

translate <-2,0,-2>
}

/*
light_source {<3,8,1> rgb 1}

camera {location <2,5,-1> look_at <2,0,2>}

background {<1,1,1>}
  */
    


