// ------------------- //
// --- Bourrinisme --- //
// ------------------- //

#declare s = seed(2) ;
#declare rd=seed(3) ;

// ------------- //
// --- Goban --- //
// ------------- //

// -- Texture -- //

#declare C_Bois1 = <.7,.6,.3>*1.1 ;
#declare C_Bois2 = <.6,.45,.2>*1.1 ;


#declare T_Goban = texture {
  pigment {
    wood
    ramp_wave
    turbulence .02
    lambda 1.2
    scale .4
    translate <-2,-.3,0>
    color_map {
      [0 color rgb C_Bois1]
      [.5 color rgb C_Bois1]
      [.8 color rgb (C_Bois1+C_Bois2)/2]
      [.9 color rgb C_Bois2]
      [1 color rgb C_Bois1]
      
    }
  }
  finish {ambient .3 diffuse .6 specular .1 roughness 2} 
}

#declare T_Gravure = texture {
  pigment {color rgbf <.05,.05,.05,.9>}
  finish {ambient .3 diffuse .6 specular .1 roughness .1}
}

// -- Gomtrie -- //

#declare Ligne = cylinder {
  <-.016,0,0> <4.016,0,0> 1
  scale <1,.0001,.016>

  texture {T_Gravure}
}
#declare Point = sphere {
  0 1
  scale <.09,.0001,.09>
  
  texture {T_Gravure}
}


#declare Goban = union {
  box {
    <-.5,0,-.5> <4.5,-.3,4.5> 
    texture {T_Goban}
  }
  
  #declare l = 0 ;
  #while(l<5)
    object {Ligne translate l*z}
    #declare l = l + 1 ;
  #end
  #declare c = 0 ;
  #while(c<5)
    object {Ligne rotate -90*y translate c*x}
    #declare c = c + 1 ;
  #end

  object{Point translate <2,0,2>}
}

// --------------- //
// --- Pierres --- //
// --------------- //

// -- Textures -- //

#declare T_PierreNoire = texture {
  pigment {color rgb <.06,.06,.062>}
  finish {
    ambient .1 diffuse .6 
    specular .6 roughness .25
    crand .06
  }
}

#declare C_PierreBlanche = <.98,.98,.99> ;
#declare rds = seed(0) ;
#declare BA = .5 ;

#macro T_PierreBlanche(a1,a2)
texture {
  pigment {
    wood
    turbulence .03
    octaves 4
    lambda 1.7
    scale .24
    translate <-.8-rand(rd),rand(rd),.03*rand(rd)>
    color_map {
      [0 color rgb C_PierreBlanche]
      [.4 color rgb C_PierreBlanche]
      [.498 color rgb C_PierreBlanche*.95-<.03,.05,0>]
      [.502 color rgb C_PierreBlanche*.95-<.03,.05,0>]
      [.6 color rgb C_PierreBlanche]
      [1 color rgb C_PierreBlanche]
    }
    rotate a1*z
    rotate a2*y
  }
  finish {
    ambient .3 
    diffuse .7 
    specular .1 roughness .4
    reflection .03
  }
}#end
 
#declare H_Pierre = .2 ;  
#declare Pierre = sphere {
  0 1
  scale <.45,H_Pierre,.45>
}

#declare PierreNoire = object {
  Pierre
  texture {T_PierreNoire}
}
#macro PierreBlanche(a1,a2)
object {
  Pierre
  T_PierreBlanche(a1,a2)
}#end

// -------------- //
// --- Partie --- //
// -------------- //

#macro Partie(PierresN,PierresB,alea)
union {
  object{Goban}
  #declare nN=dimension_size(PierresN,1) ;
  #declare nB=dimension_size(PierresB,1) ;
  
  #declare i=0 ;
  #while(i<nN)
    #if(PierresN[i][2] = 1)
      object {PierreNoire translate <PierresN[i][0]-1+alea*rand(rds),H_Pierre,PierresN[i][1]-1+alea*rand(rds)>}
    #end
    #declare i=i+1 ;
  #end

  #declare j=0 ;
  #while(j<nB)
    #if(PierresB[j][2] = 1)
      object {PierreBlanche(-rand(rd)*5,rand(rd)*360) translate <PierresB[j][0]-1+alea*rand(rds),H_Pierre,PierresB[j][1]-1>+alea*rand(rds)}
    #end
    #declare j=j+1 ;
  #end
}
#end

// ------------- //
// --- Scne --- //
// ------------- //

#include "Partie.txt"
#declare Go = object {
  Partie(PartieN,PartieB,.01)
  translate <-2,.3,-2>
}  

/*
background {<1,1,1>}
camera {location <4,6,-4> look_at <1.5,-2,3>}
light_source {<8,15,-2> color rgb .4}
light_source {<8,-5,-20> color rgb .4}

global_settings {
  radiosity {
    count 200
    pretrace_end .002
  }
}
*/

