#include "shapes.inc"

// ---------------- //
// --- Textures --- //
// ---------------- //

#declare T_Gravures = texture {
  pigment {rgb .08}
  finish {ambient .3 diffuse .7 specular .1 roughness .2}
}

#declare T_Pion_blanc = texture {
  pigment {rgb .99}
  finish {ambient .3 diffuse .7 specular .15 roughness .1}
}

#declare T_Pion_noir = texture {
  pigment {rgb .01}
  finish {ambient .3 diffuse .7 specular .6 roughness .04}
}
  
#declare T_Plateau = texture {
  pigment {rgb <.25,.9,.5>*.9}
  finish {
    ambient .3
    diffuse .7
    crand .2
  }
}

#declare T_Bord = texture {
  pigment {rgb .09}
  finish {
    ambient .3 diffuse .7 
    specular .6 roughness .2
    crand .07
  }
}
  

// ----------------- //
// --- Gomtrie --- //
// ----------------- //

#declare Ligne = cylinder {
  <0,0,0> <4,0,0> 1
  scale <1,.0001,.02>
  
  texture {T_Gravures}
}
#declare Point = sphere {
  0 1
  scale <.08,.0001,.08>
  
  texture {T_Gravures}
}

#declare Plateau = union {
  intersection {
    difference {
      height_field {
        png "profile.png"
        smooth
      
        scale <5,.4,5>
        translate <-.5,0,-.5>
      }
      box {<0,.2,0> <4,1,4>}
    }
    Round_Box(<-.5,-1,-.5>,<4.5,1,4.5>,.1,no)
    box {<-.5,-.04,-.5> <4.5,1,4.5>}

    translate .04*y
    
    texture {T_Bord}
  }
  union {
    box {
      <0,0,0> <4,-.2,4>
      texture {T_Plateau}
    }
    union {
      #declare into=0;
      #declare jnto=0;
      #while(into<5)
        object {Ligne translate into*z}
        #declare into=into+1;
      #end
      #while(jnto<5)
        object {Ligne rotate -90*y translate jnto*x}
        #declare jnto=jnto+1;
      #end
      object {Point translate <1,0,1>}
      object {Point translate <3,0,1>}
      object {Point translate <1,0,3>}
      object {Point translate <3,0,3>}
    }
    translate .35*y
  }
}

#declare ecpion=.01 ;
#declare eppion=.18 ;
#declare erpion=.05 ;
#declare Pion_blanc = union {
  union {
    intersection {
      Round_Cylinder(<0,0,0>,<0,eppion/2,0>,.45,erpion,no)
      cylinder {<0,-1,0> <0,(eppion-ecpion)/2,0> 1}
    }
    cylinder {<0,eppion/2-ecpion,0> <0,eppion/2+2*ecpion,0> .43}
    
    texture {T_Pion_noir}
  }
  intersection {
    Round_Cylinder(<0,eppion/2,0>,<0,eppion,0>,.45,erpion,no)
    cylinder {<0,(eppion+ecpion)/2,0> <0,1,0> 1}
  
    texture {T_Pion_blanc}
  }
}
#declare Pion_noir = object {
  Pion_blanc
  rotate 180*x
  translate eppion*y
}

// ------------- //
// --- Scne --- //
// ------------- //

#declare Othello = union {
object {Plateau}
union {
  object {Pion_blanc translate <1.5,0,1.5>}
  object {Pion_blanc translate <2.5,0,2.5>}
  object {Pion_noir translate <2.5,0,1.5>}
  object {Pion_noir translate <1.5,0,2.5>}

  translate .36*y
}

translate <-2,0,-2>
}

/*

light_source {<-3,8,2> color rgb .2}

camera {location <2,5,-3> look_at <2.2,.5,1>}

global_settings {
  radiosity {
    count 200
    pretrace_end .02
    recursion_limit 1
  }
}

background {<1,1,1>}
*/