camera { 
	orthographic
	right x*image_width/image_height
	location <0, 0, -1.5>
	look_at 0
}

light_source {<2, 5, -5> color rgb 2 }

#declare Plane = union {
	triangle{<-0.5, -0.5, 0>, <-0.5, 0.5, 0>, <0.5, 0.5, 0>}
	triangle{<-0.5, -0.5, 0>, <0.5, -0.5, 0>, <0.5, 0.5, 0>}
}



#declare C1 = <0.5, 0.2, 0.8>;
#declare C2 = <0.4, 0, 0.5>;
#declare C3 = <0.3, 0.2, 0.7>;

// house
#declare C4 = <0.5, 0.2, 0.6>;
#declare C5 = <0.3, 0.2, 0.6>;
#declare C6 = <0, 0, 0.6>;

#declare Fin = finish{diffuse 0.8 phong 0.7};

#declare k = 1.7;

#declare Back = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C1*k color rgb C1*k]
			[1/3 (1/3)*2 color rgb C2*k color rgb C2*k]
			[(1/3)*2 1 color rgb C3*k color rgb C3*k]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare k = 1;

#declare BackDark = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C1*k color rgb C1*k]
			[1/3 (1/3)*2 color rgb C2*k color rgb C2*k]
			[(1/3)*2 1 color rgb C3*k color rgb C3*k]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare k = 0.85;

#declare House = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C4*k color rgb C4*k]
			[1/3 (1/3)*2 color rgb C5*k color rgb C5*k]
			[(1/3)*2 1 color rgb C6*k color rgb C6*k]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare k = 0.9;

#declare HouseLight = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C4*k color rgb C4*k]
			[1/3 (1/3)*2 color rgb C5*k color rgb C5*k]
			[(1/3)*2 1 color rgb C6*k color rgb C6*k]
		}
		scale 0.01
	}
	finish {Fin}
}

object{
	Plane
	translate<0, 0, 0.0003>
	
	texture{Back}           
}

object{
	Plane
	translate <0.5, 0.5, 0>
	scale<0.7, 0.85, 1>
	translate<-0.5, -0.5, -0.0002>
	
	texture{House}            
	no_shadow
} 

object{
	Plane
	translate <-0.5, 0.5, 0>
	scale<0.8, 0.6, 1>
	translate<0.5, -0.5, -0.0001>
	
	texture{BackDark}            
	no_shadow
}

// windows

#declare Window = object{
	Plane
	translate <0.5, -0.5, 0>
	scale<0.1, 0.2, 1>
	
	no_shadow
} 

object{
	Window 
    pigment{color rgb<1, 0.8, 0.9>}
	finish{Fin}
    
	translate<-0.1, 0.15, -0.0003>
}

object{
	Window 
	pigment{color rgb<1, 0.9, 0.8>}
	finish{Fin}
	
	translate<-0.3, 0.15, -0.0003>
}

object{
	Window
	pigment{color rgb<0.9, 0.9, 1>}
	finish{Fin} 
	
	translate<-0.1, -0.15, -0.0003>
}
 